// Copyright 2000-2021 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface PhpIntermediateTypeProvider extends PhpTypeProvider4 {
  static boolean providerExists(@NotNull String sig) {
    return ContainerUtil.exists(EP_NAME.getExtensions(),
                                provider -> provider instanceof PhpIntermediateTypeProvider && isProviderApplicable(provider, sig)) ||
           ContainerUtil.exists(PhpKeyTypeProvider.EP_NAME.getExtensions(), provider -> isProviderApplicable(provider, sig));
  }

  static boolean isProviderApplicable(PhpTypeProvider4 provider, @NotNull String sig) {
    return StringUtil.startsWithChar(sig, '#') && provider.getKey() == sig.charAt(1);
  }
}
