// Copyright 2000-2025 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.stubs

import com.intellij.psi.StubBasedPsiElement
import com.intellij.psi.stubs.IStubElementType
import com.intellij.psi.stubs.StubElement

interface PhpStubBasedPsiElement<T : StubElement<*>?> : StubBasedPsiElement<T?> {
  @Deprecated("", replaceWith = ReplaceWith("getIElementType()"))
  override fun getElementType(): IStubElementType<*, *>? {
    throw UnsupportedOperationException()
  }
}