// Copyright 2000-2021 JetBrains s.r.o.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.visitors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.*;
import org.jetbrains.annotations.NotNull;

public abstract class PhpElementVisitor extends PsiElementVisitor {

  public PhpElementVisitor apply(PsiElement element) {
    if (element!=null) element.accept(this);
    return this;
  }

  public static final PhpElementVisitor EMPTY = new PhpElementVisitor() {
  };

  public void visitPhpElement(PhpPsiElement element) {
    visitElement(element);
  }

  public void visitPhpClass(PhpClass clazz) {
    visitPhpElement(clazz);
  }

  public void visitPhpMethod(Method method) {
    visitPhpElement(method);
  }

  public void visitPhpFunction(Function function) {
    visitPhpElement(function);
  }

  public void visitPhpNewExpression(NewExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpReturn(PhpReturn returnStatement) {
    visitPhpElement(returnStatement);
  }

  public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
    visitPhpElement(assignmentExpression);
  }

  public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
    visitPhpElement(multiassignmentExpression);
  }

  public void visitPhpUnaryExpression(UnaryExpression expr) {
    visitPhpElement(expr);
  }

  public void visitPhpForeach(ForeachStatement foreach) {
    visitPhpElement(foreach);
  }

  public void visitPhpCatch(Catch phpCatch) {
    visitPhpElement(phpCatch);
  }

  public void visitPhpFinally(Finally element) {
    visitPhpElement(element);
  }

  public void visitPhpParameterList(ParameterList list) {
    visitPhpElement(list);
  }

  public void visitPhpParameter(Parameter parameter) {
    visitPhpElement(parameter);
  }

  public void visitPhpReturnType(PhpReturnType returnType) {
    visitPhpTypeDeclaration(returnType);
  }

  public void visitPhpVariable(Variable variable) {
    visitPhpElement(variable);
  }

  @Override
  public void visitElement(@NotNull PsiElement element) {
  }

  public void visitPhpFile(PhpFile PhpFile) {
    visitFile(PhpFile);
  }

  public void visitPhpIf(If ifStatement) {
    visitPhpElement(ifStatement);
  }

  public void visitPhpClassReference(ClassReference classReference) {
    visitPhpElement(classReference);
  }

  public void visitPhpMethodReference(MethodReference reference) {
    visitPhpElement(reference);
  }

  public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
    visitPhpElement(constantReference);
  }

  public void visitPhpFieldReference(FieldReference fieldReference) {
    visitPhpElement(fieldReference);
  }

  public void visitPhpField(Field field) {
    visitPhpElement(field);
  }

  public void visitPhpFunctionCall(FunctionReference reference) {
    visitPhpElement(reference);
  }

  public void visitPhpClone(PhpClone clone) {
    visitPhpElement(clone);
  }
  
  public void visitPhpCallableFunction(PhpCallableFunction reference) {
    visitPhpElement(reference);
  }

  public void visitPhpCallableMethod(PhpCallableMethod reference) {
    visitPhpElement(reference);
  }

  public void visitPhpTry(Try tryStatement) {
    visitPhpElement(tryStatement);
  }

  public void visitPhpElseIf(ElseIf elseIfStatement) {
    visitPhpElement(elseIfStatement);
  }

  public void visitPhpElse(Else elseStatement) {
    visitPhpElement(elseStatement);
  }

  public void visitPhpFor(For forStatement) {
    visitPhpElement(forStatement);
  }

  public void visitPhpInclude(Include include) {
    visitPhpElement(include);
  }

  public void visitPhpConstant(Constant constant) {
    visitPhpElement(constant);
  }

  public void visitPhpConstantReference(ConstantReference reference) {
    visitPhpElement(reference);
  }

  public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpExpression(PhpExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpNamespace(PhpNamespace namespace) {
    visitPhpElement(namespace);
  }

  public void visitPhpBinaryExpression(BinaryExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpPipeExpression(PipeExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpTernaryExpression(TernaryExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpUse(PhpUse expression) {
    visitPhpElement(expression);
  }

  public void visitPhpWhile(While whileStatement) {
    visitPhpElement(whileStatement);
  }

  public void visitPhpGlobal(Global globalStatement) {
    visitPhpElement(globalStatement);
  }

  public void visitPhpDocVariable(PhpDocVariable expression) {
    visitPhpElement(expression);
  }

  public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpDoWhile(DoWhile doWhileStatement) {
    visitPhpElement(doWhileStatement);
  }


  public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
    visitPhpElement(expression);
  }

  public void visitPhpStatement(Statement statement){
    visitPhpElement(statement);
  }

  public void visitPhpGroupStatement(GroupStatement groupStatement){
    visitPhpElement(groupStatement);
  }

  public void visitPhpContinue(PhpContinue continueStatement){
    visitPhpElement(continueStatement);
  }

  public void visitPhpBreak(PhpBreak breakStatement){
    visitPhpElement(breakStatement);
  }

  public void visitPhpSwitch(PhpSwitch switchStatement){
    visitPhpElement(switchStatement);
  }

  /**
   * @deprecated please, use {@link #visitPhpThrowExpression(PhpThrowExpression)} instead
   */
  @Deprecated
  public void visitPhpThrow(PhpThrow throwStatement) {
    visitPhpElement(throwStatement);
  }

  public void visitPhpModifierList(PhpModifierList modifierList){
    visitPhpElement(modifierList);
  }

  public void visitPhpIsset(PhpIsset issetExpression){
    visitPhpElement(issetExpression);
  }

  public void visitPhpEmpty(PhpEmpty emptyExpression){
    visitPhpElement(emptyExpression);
  }

  public void visitPhpUnset(PhpUnset unsetStatement){
    visitPhpElement(unsetStatement);
  }

  public void visitPhpExit(PhpExit exitExpression){
    visitPhpElement(exitExpression);
  }

  public void visitPhpExpressionCodeFragment(PhpExpressionCodeFragment expressionCodeFragment){
    visitPhpElement(expressionCodeFragment);
  }

  public void visitPhpNamespaceReference(PhpNamespaceReference reference) {
    visitPhpElement(reference);
  }

  public void visitPhpUseList(PhpUseList useList){
    visitPhpElement(useList);
  }

  public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
    visitPhpElement(staticStatement);
  }

  public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
    visitPhpElement(echoStatement);
  }
  
  public void visitPhpArrayIndex(ArrayIndex arrayIndex){
    visitPhpElement(arrayIndex);
  }

  public void visitPhpPrint(PhpPrintExpression printExpression) {
    visitPhpElement(printExpression);
  }

  public void visitPhpDocType(PhpDocType type) {
    visitPhpElement(type);
  }

  public void visitPhpTraitUseRule(PhpTraitUseRule type) {
    visitPhpElement(type);
  }

  public void visitPhpGoto(PhpGoto element) {
    visitPhpElement(element);
  }

  public void visitPhpGotoLabel(PhpGotoLabel label) {
    visitPhpElement(label);
  }

  public void visitPhpYield(PhpYield element) {
    visitPhpElement(element);
  }

  public void visitPhpEval(PhpEval element) {
    visitPhpElement(element);   
  }

  public void visitPhpDocTag(PhpDocTag tag) {
    visitPhpElement(tag);
  }

  public void visitPhpDocParamTag(PhpDocParamTag tag) {
    visitPhpDocTag(tag);
  }

  public void visitPhpCase(PhpCase phpCase) {
    visitPhpElement(phpCase);
  }

  public void visitPhpArrayHashElement(ArrayHashElement arrayHashElement) {
    visitPhpElement(arrayHashElement);
  }

  public void visitPhpTypeDeclaration(PhpTypeDeclaration typeDeclaration) {
    visitPhpElement(typeDeclaration);
  }

  public void visitPhpFieldTypeDeclaration(PhpFieldType fieldTypeDeclaration) {
    visitPhpTypeDeclaration(fieldTypeDeclaration);
  }

  public void visitPhpClassConstantTypeDeclaration(PhpClassConstantType classConstantTypeDeclaration) {
    visitPhpTypeDeclaration(classConstantTypeDeclaration);
  }

  public void visitPhpParameterTypeDeclaration(PhpParameterType parameterTypeDeclaration) {
    visitPhpTypeDeclaration(parameterTypeDeclaration);
  }

  public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
    visitPhpElement(matchExpression);
  }

  public void visitPhpAttribute(PhpAttribute attribute) {
    visitPhpElement(attribute);
  }

  public void visitPhpAttributesList(PhpAttributesList attributesList) {
    visitPhpElement(attributesList);
  }

  public void visitPhpClassFieldsList(PhpClassFieldsList classFieldsList) {
    visitPhpElement(classFieldsList);
  }

  public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
    visitPhpElement(throwExpression);
  }

  public void visitPhpEnumCase(PhpEnumCase enumCase) {
    visitPhpElement(enumCase);
  }
}
