<?php /** @noinspection ALL */

namespace LaravelIdea\BladeLoops;

class _BladeLoop {
    /** @var int The index of the current loop iteration (starts at 0). */
    public $index;

    /** @var int The current loop iteration (starts at 1). */
    public $iteration;

    /** @var int|null The iteration remaining in the loop. */
    public $remaining;

    /** @var int The total number of items in the array being iterated. */
    public $count;

    /** @var boolean Whether this is the first iteration through the loop. */
    public $first;

    /** @var boolean Whether this is the last iteration through the loop. */
    public $last;

    /** @var int The nesting level of the current loop. */
    public $depth;

    /** @var _BLadeLoop|null When in a nested loop, the parent's loop variable. */
    public $parent;
}

class _BladeLoop58 {
    /** @var int The index of the current loop iteration (starts at 0). */
    public $index;

    /** @var int The current loop iteration (starts at 1). */
    public $iteration;

    /** @var int|null The iteration remaining in the loop. */
    public $remaining;

    /** @var int The total number of items in the array being iterated. */
    public $count;

    /** @var boolean Whether this is the first iteration through the loop. */
    public $first;

    /** @var boolean Whether this is the last iteration through the loop. */
    public $last;

    /** @var int The nesting level of the current loop. */
    public $depth;

    /** @var boolean Whether this is an even iteration through the loop. */
    public $even;

    /** @var boolean Whether this is an odd iteration through the loop. */
    public $odd;

    /** @var _BLadeLoop58|null When in a nested loop, the parent's loop variable. */
    public $parent;
}
