/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.DeprecationUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HighlightInfoType {
    @NonNls
    public static final String UNUSED_SYMBOL_SHORT_NAME = "unused";
    public static final HighlightInfoType ERROR = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES);
    public static final HighlightInfoType WARNING = new HighlightInfoTypeImpl(HighlightSeverity.WARNING, CodeInsightColors.WARNINGS_ATTRIBUTES);
    @Deprecated
    public static final HighlightInfoType INFO = new HighlightInfoTypeImpl(HighlightSeverity.INFO, CodeInsightColors.INFO_ATTRIBUTES);
    public static final HighlightInfoType WEAK_WARNING = new HighlightInfoTypeImpl(HighlightSeverity.WEAK_WARNING, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
    public static final HighlightInfoType INFORMATION = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightInfoType PENDING_REFERENCE = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightInfoType TEXT_ATTRIBUTES = new HighlightInfoTypeImpl(HighlightSeverity.TEXT_ATTRIBUTES, CodeInsightColors.CONSIDERATION_ATTRIBUTES);
    public static final HighlightInfoType WRONG_REF = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
    public static final HighlightInfoType GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER = new HighlightInfoTypeImpl(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING);
    public static final HighlightInfoType UNUSED_SYMBOL = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.findOrRegister((String)"unused", (String)HighlightInfoType.getUnusedSymbolDisplayName(), (String)"unused"), CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
    public static final HighlightInfoType DEPRECATED = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.findOrRegister((String)"Deprecation", (String)DeprecationUtil.getDeprecationDisplayName(), (String)"deprecation"), CodeInsightColors.DEPRECATED_ATTRIBUTES);
    public static final HighlightInfoType MARKED_FOR_REMOVAL = new HighlightInfoTypeSeverityByKey(HighlightDisplayKey.findOrRegister((String)"MarkedForRemoval", (String)DeprecationUtil.getForRemovalDisplayName(), (String)"removal"), CodeInsightColors.MARKED_FOR_REMOVAL_ATTRIBUTES);
    public static final HighlightSeverity SYMBOL_TYPE_SEVERITY = new HighlightSeverity("SYMBOL_TYPE_SEVERITY", HighlightSeverity.INFORMATION.myVal - 2);
    public static final HighlightInfoType TODO = new HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
    public static final HighlightInfoType UNHANDLED_EXCEPTION = new HighlightInfoTypeImpl(HighlightSeverity.ERROR, CodeInsightColors.ERRORS_ATTRIBUTES);
    public static final HighlightSeverity INJECTED_FRAGMENT_SYNTAX_SEVERITY = new HighlightSeverity("INJECTED_FRAGMENT_SYNTAX", HighlightInfoType.SYMBOL_TYPE_SEVERITY.myVal - 2);
    public static final HighlightSeverity INJECTED_FRAGMENT_SEVERITY = new HighlightSeverity("INJECTED_FRAGMENT", HighlightInfoType.SYMBOL_TYPE_SEVERITY.myVal - 1);
    public static final HighlightInfoType INJECTED_LANGUAGE_FRAGMENT = new HighlightInfoTypeImpl(INJECTED_FRAGMENT_SYNTAX_SEVERITY, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightInfoType INJECTED_LANGUAGE_BACKGROUND = new HighlightInfoTypeImpl(INJECTED_FRAGMENT_SEVERITY, CodeInsightColors.INFORMATION_ATTRIBUTES);
    public static final HighlightInfoType POSSIBLE_PROBLEM = new HighlightInfoTypeImpl(SYMBOL_TYPE_SEVERITY, HighlighterColors.NO_HIGHLIGHTING);
    public static final HighlightSeverity ELEMENT_UNDER_CARET_SEVERITY = new HighlightSeverity("ELEMENT_UNDER_CARET", HighlightSeverity.ERROR.myVal + 1);
    public static final HighlightInfoType ELEMENT_UNDER_CARET_READ = new HighlightInfoTypeImpl(ELEMENT_UNDER_CARET_SEVERITY, EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES);
    public static final HighlightInfoType ELEMENT_UNDER_CARET_WRITE = new HighlightInfoTypeImpl(ELEMENT_UNDER_CARET_SEVERITY, EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES);
    public static final HighlightInfoType ELEMENT_UNDER_CARET_STRUCTURAL = new HighlightInfoTypeImpl(ELEMENT_UNDER_CARET_SEVERITY, CodeInsightColors.MATCHED_BRACE_ATTRIBUTES);
    public static final HighlightSeverity HIGHLIGHTED_REFERENCE_SEVERITY = new HighlightSeverity("HIGHLIGHTED_REFERENCE", HighlightInfoType.SYMBOL_TYPE_SEVERITY.myVal - 1);
    public static final Set<HighlightInfoType> VISIBLE_IF_FOLDED = Set.of(ELEMENT_UNDER_CARET_READ, ELEMENT_UNDER_CARET_WRITE, WARNING, ERROR, WRONG_REF);

    @NotNull
    public HighlightSeverity getSeverity(@Nullable PsiElement var1);

    @NotNull
    public TextAttributesKey getAttributesKey();

    default public boolean isInspectionHighlightInfoType() {
        return false;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public static String getUnusedSymbolDisplayName() {
        return AnalysisBundle.message((String)"inspection.dead.code.display.name", (Object[])new Object[0]);
    }

    public static class HighlightInfoTypeImpl
    implements HighlightInfoType {
        private final HighlightSeverity mySeverity;
        private final TextAttributesKey attributeKey;

        HighlightInfoTypeImpl(@NotNull Element element) {
            if (element == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(0);
            }
            this.mySeverity = new HighlightSeverity(element);
            this.attributeKey = new TextAttributesKey(element);
        }

        public HighlightInfoTypeImpl(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey attributesKey) {
            if (severity == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(1);
            }
            if (attributesKey == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(2);
            }
            this.mySeverity = severity;
            this.attributeKey = attributesKey;
        }

        public HighlightInfoTypeImpl(@NotNull HighlightSeverity severity, @NotNull TextAttributesKey attributesKey, boolean needsUpdateOnTyping) {
            if (severity == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(3);
            }
            if (attributesKey == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(4);
            }
            this.mySeverity = severity;
            this.attributeKey = attributesKey;
        }

        public boolean isApplicableToInspections() {
            return true;
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity(@Nullable PsiElement psiElement) {
            HighlightSeverity highlightSeverity = this.mySeverity;
            if (highlightSeverity == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(5);
            }
            return highlightSeverity;
        }

        @Override
        @NotNull
        public TextAttributesKey getAttributesKey() {
            TextAttributesKey textAttributesKey = this.attributeKey;
            if (textAttributesKey == null) {
                HighlightInfoTypeImpl.$$$reportNull$$$0(6);
            }
            return textAttributesKey;
        }

        public String toString() {
            return "HighlightInfoTypeImpl[severity=" + this.mySeverity.getName() + ", key=" + String.valueOf(this.attributeKey) + "]";
        }

        public void writeExternal(Element element) {
            try {
                this.mySeverity.writeExternal(element);
            }
            catch (WriteExternalException e) {
                throw new RuntimeException(e);
            }
            this.attributeKey.writeExternal(element);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HighlightInfoTypeImpl)) {
                return false;
            }
            HighlightInfoTypeImpl that = (HighlightInfoTypeImpl)o;
            if (!Comparing.equal((Object)this.attributeKey, (Object)that.attributeKey)) {
                return false;
            }
            return this.mySeverity.equals((Object)that.mySeverity);
        }

        public int hashCode() {
            int result = this.mySeverity.hashCode();
            result = 29 * result + this.attributeKey.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributesKey";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static final class HighlightInfoTypeSeverityByKey
    implements HighlightInfoType {
        private final TextAttributesKey attributeKey;
        private final HighlightDisplayKey myToolKey;

        public HighlightInfoTypeSeverityByKey(@NotNull HighlightDisplayKey severityKey, @NotNull TextAttributesKey attributesKey) {
            if (severityKey == null) {
                HighlightInfoTypeSeverityByKey.$$$reportNull$$$0(0);
            }
            if (attributesKey == null) {
                HighlightInfoTypeSeverityByKey.$$$reportNull$$$0(1);
            }
            this.myToolKey = severityKey;
            this.attributeKey = attributesKey;
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity(PsiElement psiElement) {
            InspectionProfileImpl profile = psiElement == null ? InspectionProfileManager.getInstance().getCurrentProfile() : InspectionProjectProfileManager.getInstance(psiElement.getProject()).getCurrentProfile();
            HighlightSeverity highlightSeverity = profile.getErrorLevel(this.myToolKey, psiElement).getSeverity();
            if (highlightSeverity == null) {
                HighlightInfoTypeSeverityByKey.$$$reportNull$$$0(2);
            }
            return highlightSeverity;
        }

        @Override
        @NotNull
        public TextAttributesKey getAttributesKey() {
            TextAttributesKey textAttributesKey = this.attributeKey;
            if (textAttributesKey == null) {
                HighlightInfoTypeSeverityByKey.$$$reportNull$$$0(3);
            }
            return textAttributesKey;
        }

        public String toString() {
            return "HighlightInfoTypeSeverityByKey[severity=" + String.valueOf(this.myToolKey) + ", key=" + String.valueOf(this.attributeKey) + "]";
        }

        public HighlightDisplayKey getSeverityKey() {
            return this.myToolKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severityKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributesKey";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeSeverityByKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeSeverityByKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @FunctionalInterface
    public static interface Iconable {
        @NotNull
        public Icon getIcon();
    }
}

