/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.codeInsight.template.impl.VariableNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class TemplateBase
extends Template {
    @NotNull
    private String myString;
    @Nullable
    private Throwable myBuildingTemplateTrace;
    private String myTemplateText;
    private final List<Segment> mySegments;
    private boolean toParseSegments;
    private boolean myParsed;

    protected TemplateBase(@NotNull String string) {
        if (string == null) {
            TemplateBase.$$$reportNull$$$0(0);
        }
        this.toParseSegments = true;
        this.myParsed = false;
        this.mySegments = Collections.synchronizedList(new SmartList());
        this.myString = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsed() {
        List<Segment> list = this.mySegments;
        synchronized (list) {
            return this.myParsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseSegments() {
        StringBuilder buffer;
        if (!this.toParseSegments) {
            return;
        }
        String templateRawText = this.myString;
        List<Segment> list = this.mySegments;
        synchronized (list) {
            IElementType tokenType;
            if (this.myParsed) {
                return;
            }
            buffer = new StringBuilder(templateRawText.length());
            TemplateTextLexer lexer = new TemplateTextLexer();
            lexer.start(templateRawText);
            while ((tokenType = lexer.getTokenType()) != null) {
                int start = lexer.getTokenStart();
                int end = lexer.getTokenEnd();
                String token = templateRawText.substring(start, end);
                if (tokenType == TemplateTokenType.VARIABLE) {
                    String name = token.substring(1, token.length() - 1);
                    Segment segment = new Segment(name, buffer.length());
                    this.mySegments.add(segment);
                } else if (tokenType == TemplateTokenType.ESCAPE_DOLLAR) {
                    buffer.append("$");
                } else {
                    buffer.append(token);
                }
                lexer.advance();
            }
            this.myParsed = true;
        }
        this.myTemplateText = buffer.toString();
    }

    protected List<Segment> getSegments() {
        return this.mySegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSegments() {
        List<Segment> list = this.mySegments;
        synchronized (list) {
            this.mySegments.clear();
            this.myParsed = false;
        }
    }

    protected boolean isToParseSegments() {
        return this.toParseSegments;
    }

    protected void setToParseSegments(boolean toParseSegments) {
        this.toParseSegments = toParseSegments;
    }

    @Override
    @NotNull
    public String getString() {
        this.parseSegments();
        String string = this.myString;
        if (string == null) {
            TemplateBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected String string() {
        return this.myString;
    }

    public void setString(@NotNull String string) {
        if (string == null) {
            TemplateBase.$$$reportNull$$$0(2);
        }
        this.myString = StringUtil.convertLineSeparators((String)string);
        this.clearSegments();
        this.toParseSegments = true;
        this.myBuildingTemplateTrace = new Throwable();
    }

    @Override
    @NotNull
    public String getTemplateText() {
        this.parseSegments();
        String string = this.myTemplateText;
        if (string == null) {
            TemplateBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected String templateText() {
        return this.myTemplateText;
    }

    protected void setTemplateText(String templateText) {
        this.myTemplateText = templateText;
    }

    protected void setBuildingTemplateTrace(@Nullable Throwable buildingTemplateTrace) {
        this.myBuildingTemplateTrace = buildingTemplateTrace;
    }

    @Nullable
    Throwable getBuildingTemplateTrace() {
        return this.myBuildingTemplateTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getVariableSegmentNumber(String variableName) {
        this.parseSegments();
        List<Segment> list = this.mySegments;
        synchronized (list) {
            for (int i = 0; i < this.mySegments.size(); ++i) {
                if (!this.mySegments.get((int)i).name.equals(variableName)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void addTextSegment(@NotNull String text) {
        if (text == null) {
            TemplateBase.$$$reportNull$$$0(4);
        }
        text = StringUtil.convertLineSeparators((String)text);
        this.myTemplateText = this.myTemplateText + text;
    }

    @Override
    public void addVariableSegment(@NotNull String name) {
        if (name == null) {
            TemplateBase.$$$reportNull$$$0(5);
        }
        this.mySegments.add(new Segment(name, this.myTemplateText.length()));
    }

    @Override
    @NotNull
    public String getSegmentName(int i) {
        this.parseSegments();
        String string = this.mySegments.get((int)i).name;
        if (string == null) {
            TemplateBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public int getSegmentOffset(int i) {
        this.parseSegments();
        return this.mySegments.get((int)i).offset;
    }

    @Override
    public int getSegmentsCount() {
        this.parseSegments();
        return this.mySegments.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelectionTemplate() {
        this.parseSegments();
        List<Segment> list = this.mySegments;
        synchronized (list) {
            for (Segment v2 : this.mySegments) {
                if (!"SELECTION".equals(v2.name)) continue;
                return true;
            }
        }
        return ContainerUtil.exists(this.getVariables(), v -> TemplateBase.containsSelection(v.getExpression()) || TemplateBase.containsSelection(v.getDefaultValueExpression()));
    }

    private static boolean containsSelection(Expression expression) {
        if (expression instanceof VariableNode) {
            VariableNode variableNode = (VariableNode)expression;
            return "SELECTION".equals(variableNode.getName());
        }
        if (expression instanceof MacroCallNode) {
            MacroCallNode macroCallNode = (MacroCallNode)expression;
            return ContainerUtil.exists((Object[])macroCallNode.getParameters(), TemplateBase::containsSelection);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegmentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTextSegment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addVariableSegment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6 -> new IllegalStateException(string);
        };
    }

    protected static final class Segment {
        @NotNull
        public final String name;
        public final int offset;

        private Segment(@NotNull String name, int offset) {
            if (name == null) {
                Segment.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.offset = offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/impl/TemplateBase$Segment", "<init>"));
        }
    }
}

