/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Verifier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProblemDescriptorUtil {
    public static final int NONE = 0;
    static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_TREE_END = 4;
    @NonNls
    public static final String LOC_REFERENCE = "#loc";
    @NonNls
    public static final String REF_REFERENCE = "#ref";
    public static final Couple<String> XML_CODE_MARKER = Couple.of((Object)"<xml-code>", (Object)"</xml-code>");

    @NotNull
    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement psiElement) {
        TextRange textRange;
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(0);
        }
        if (descriptor instanceof ProblemDescriptorBase) {
            ProblemDescriptorBase base = (ProblemDescriptorBase)descriptor;
            textRange = base.getTextRange();
        } else {
            textRange = null;
        }
        TextRange range = textRange;
        return ProblemDescriptorUtil.extractHighlightedText(range, psiElement);
    }

    @NotNull
    public static String sanitizeIllegalXmlChars(@NotNull String text) {
        if (text == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(1);
        }
        if (Verifier.checkCharacterData((String)text) == null) {
            String string = text;
            if (string == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = text.codePoints().map(cp -> Verifier.isXMLCharacter((int)cp) ? cp : 63).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String extractHighlightedText(@Nullable TextRange range, @Nullable PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        PsiFile file = psiElement.getContainingFile();
        if (file == null) {
            return "";
        }
        Document doc = file.getViewProvider().getDocument();
        if (doc == null) {
            return "";
        }
        CharSequence fileText = doc.getImmutableCharSequence();
        TextRange elementRange = psiElement.getTextRange();
        CharSequence elementSequence = elementRange == null ? psiElement.getText() : fileText.subSequence(elementRange.getStartOffset(), elementRange.getEndOffset());
        CharSequence ref = elementSequence;
        if (range != null && elementRange != null && (range = range.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && elementSequence.length() > range.getLength()) {
            ref = elementSequence.subSequence(range.getStartOffset(), range.getEndOffset());
        }
        String result = StringUtil.first((CharSequence)ref, (int)100, (boolean)true).toString();
        String string = StringUtil.collapseWhiteSpace((CharSequence)result);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element, boolean appendLineNumber) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(5);
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, appendLineNumber ? 1 : 0);
    }

    @NotNull
    @InspectionMessage
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element, @FlagConstant int flags) {
        String message;
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(6);
        }
        if ((message = descriptor.getDescriptionTemplate()) == null) {
            return "";
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, flags, message);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static ProblemPresentation renderDescriptor(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element, @FlagConstant int flags) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(7);
        }
        @InspectionMessage NotNullLazyValue descTemplate = NotNullLazyValue.volatileLazy(() -> StringUtil.notNullize((String)descriptor.getDescriptionTemplate()));
        @InspectionMessage NotNullLazyValue tooltipTemplate = NotNullLazyValue.volatileLazy(() -> {
            String string;
            if (descriptor instanceof ProblemDescriptor) {
                ProblemDescriptor problemDescriptor = (ProblemDescriptor)descriptor;
                string = StringUtil.notNullize((String)problemDescriptor.getTooltipTemplate());
            } else {
                string = (String)descTemplate.getValue();
            }
            return string;
        });
        final @InspectionMessage NotNullLazyValue description = NotNullLazyValue.volatileLazy(() -> ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, flags, (String)descTemplate.getValue()));
        final @NlsContexts.Tooltip NotNullLazyValue tooltip = NotNullLazyValue.volatileLazy(() -> {
            String template = (String)tooltipTemplate.getValue();
            return template.equals(descTemplate.getValue()) ? (String)description.getValue() : ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, flags, template);
        });
        return new ProblemPresentation(){

            @Override
            @NotNull
            public String getDescription() {
                String string = (String)description.getValue();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getTooltip() {
                String string = (String)tooltip.getValue();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInspection/ProblemDescriptorUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDescription";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTooltip";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NlsContexts.Tooltip
    @NotNull
    @InspectionMessage
    private static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element, @FlagConstant int flags, @InspectionMessage String template) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(8);
        }
        String message = template;
        if ((flags & 1) != 0 && descriptor instanceof ProblemDescriptor) {
            int lineNumber;
            ProblemDescriptor problemDescriptor = (ProblemDescriptor)descriptor;
            if (!message.contains(REF_REFERENCE) && message.contains(LOC_REFERENCE) && (lineNumber = problemDescriptor.getLineNumber()) >= 0) {
                message = StringUtil.replace((String)message, (String)LOC_REFERENCE, (String)("(" + AnalysisBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0]) + " " + (lineNumber + 1) + ")"));
            }
        }
        message = ProblemDescriptorUtil.unescapeTags(message);
        message = ProblemDescriptorUtil.removeLocReference(message);
        if ((flags & 4) != 0) {
            int endIndex;
            if (XmlStringUtil.isWrappedInHtml((String)message)) {
                message = StringUtil.removeHtmlTags((String)message, (boolean)true).replace('\n', ' ');
            }
            if ((endIndex = message.indexOf("#treeend")) > 0) {
                message = message.substring(0, endIndex);
            }
        }
        if (message.contains(REF_REFERENCE)) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor, element);
            message = StringUtil.replace((String)message, (String)REF_REFERENCE, (String)ref);
        }
        message = StringUtil.replace((String)message, (String)"#end", (String)"");
        message = StringUtil.replace((String)message, (String)"#treeend", (String)"");
        String string = message.trim();
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String removeLocReference(@NotNull String message) {
        if (message == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(10);
        }
        message = StringUtil.replace((String)message, (String)"#loc ", (String)"");
        message = StringUtil.replace((String)message, (String)" #loc", (String)"");
        String string = message = StringUtil.replace((String)message, (String)LOC_REFERENCE, (String)"");
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeTags(@NotNull String message) {
        if (message == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(12);
        }
        if (!XmlStringUtil.isWrappedInHtml((String)message)) {
            message = StringUtil.replace((String)message, (String)"<code>", (String)"'");
            message = StringUtil.replace((String)message, (String)"</code>", (String)"'");
        }
        String string = message = message.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message) : (!XmlStringUtil.isWrappedInHtml((String)message) ? StringUtil.unescapeXmlEntities((String)message) : message);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String unescapeXmlCode(@NotNull String message) {
        if (message == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(14);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : StringUtil.split((String)message, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.first))) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings.addAll(StringUtil.split((String)string, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.second), (boolean)false));
                continue;
            }
            strings.add(string);
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder.append(string.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder.append(StringUtil.unescapeXmlEntities((String)string));
        }
        String string = builder.toString();
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(16);
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, false);
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (problemDescriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(17);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(18);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(19);
        }
        return ProblemDescriptorUtil.getHighlightInfoType(problemDescriptor.getHighlightType(), severity, severityRegistrar);
    }

    @NotNull
    public static HighlightInfoType getHighlightInfoType(@NotNull ProblemHighlightType highlightType, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (highlightType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(20);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(21);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(22);
        }
        HighlightInfoType highlightInfoType = switch (highlightType) {
            default -> throw new MatchException(null, null);
            case ProblemHighlightType.GENERIC_ERROR_OR_WARNING -> severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            case ProblemHighlightType.LIKE_DEPRECATED -> new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
            case ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL -> new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.MARKED_FOR_REMOVAL.getAttributesKey());
            case ProblemHighlightType.LIKE_UNKNOWN_SYMBOL -> {
                if (severity == HighlightSeverity.ERROR) {
                    yield new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                }
                if (severity == HighlightSeverity.WARNING) {
                    yield new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                }
                yield severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case ProblemHighlightType.LIKE_UNUSED_SYMBOL -> new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
            case ProblemHighlightType.INFO -> HighlightInfoType.INFO;
            case ProblemHighlightType.WEAK_WARNING -> HighlightInfoType.WEAK_WARNING;
            case ProblemHighlightType.WARNING -> HighlightInfoType.WARNING;
            case ProblemHighlightType.ERROR -> HighlightInfoType.WRONG_REF;
            case ProblemHighlightType.GENERIC_ERROR -> HighlightInfoType.ERROR;
            case ProblemHighlightType.INFORMATION -> HighlightInfoType.INFORMATION;
            case ProblemHighlightType.POSSIBLE_PROBLEM -> HighlightInfoType.POSSIBLE_PROBLEM;
        };
        if (highlightInfoType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(23);
        }
        return highlightInfoType;
    }

    public static ProblemDescriptor @NotNull [] convertToProblemDescriptors(@NotNull List<? extends Annotation> annotations, @NotNull PsiFile file) {
        if (annotations == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(24);
        }
        if (file == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(25);
        }
        if (annotations.isEmpty()) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(26);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(annotations.size());
        for (Annotation annotation : annotations) {
            LocalQuickFix[] quickFixes;
            boolean isAfterEndOfLine;
            String message;
            int endOffset;
            int startOffset;
            HighlightSeverity severity = annotation.getSeverity();
            ProblemDescriptor descriptor = ProblemDescriptorUtil.convertToDescriptor(file, severity, startOffset = annotation.getStartOffset(), endOffset = annotation.getEndOffset(), message = StringUtil.notNullize((String)annotation.getMessage()), isAfterEndOfLine = annotation.isAfterEndOfLine(), quickFixes = ProblemDescriptorUtil.toLocalQuickFixes(annotation.getQuickFixes()));
            if (descriptor == null) continue;
            problems.add(descriptor);
        }
        ProblemDescriptor[] problemDescriptorArray = problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(27);
        }
        return problemDescriptorArray;
    }

    private static ProblemDescriptor convertToDescriptor(@NotNull PsiFile file, @NotNull HighlightSeverity severity, int startOffset, int endOffset, @NotNull @InspectionMessage String message, boolean isAfterEndOfLine, @NotNull @NotNull LocalQuickFix @NotNull [] quickFixes) {
        PsiElement startElement;
        PsiElement endElement;
        if (file == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(28);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(29);
        }
        if (message == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(30);
        }
        if (quickFixes == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(31);
        }
        if (severity == HighlightSeverity.INFORMATION || startOffset == endOffset && !isAfterEndOfLine) {
            return null;
        }
        if (startOffset == endOffset) {
            startElement = endElement = file.findElementAt(endOffset - 1);
        } else {
            startElement = file.findElementAt(startOffset);
            endElement = file.findElementAt(endOffset - 1);
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        TextRange rangeInElement = ProblemDescriptorUtil.getRangeInElement(startElement, startOffset, endElement, endOffset);
        ProblemHighlightType highlightType = HighlightInfo.convertSeverityToProblemHighlight(severity);
        return new ProblemDescriptorBase(startElement, endElement, message, quickFixes, highlightType, isAfterEndOfLine, rangeInElement, true, false);
    }

    @Nullable
    private static TextRange getRangeInElement(@NotNull PsiElement startElement, int startOffset, PsiElement endElement, int endOffset) {
        if (startElement == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(32);
        }
        if (startElement != endElement) {
            return null;
        }
        TextRange elementTextRange = startElement.getTextRange();
        if (elementTextRange.getStartOffset() == startOffset && elementTextRange.getEndOffset() == endOffset) {
            return null;
        }
        return new TextRange(startOffset - elementTextRange.getStartOffset(), endOffset - elementTextRange.getStartOffset());
    }

    @NotNull
    private static @NotNull LocalQuickFix @NotNull [] toLocalQuickFixes(@Nullable List<Annotation.QuickFixInfo> fixInfos) {
        if (fixInfos == null || fixInfos.isEmpty()) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(33);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ContainerUtil.map2Array(fixInfos, LocalQuickFix.class, Annotation.QuickFixInfo::getLocalQuickFix);
        if (localQuickFixArray == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(34);
        }
        return localQuickFixArray;
    }

    public static ProblemDescriptor toProblemDescriptor(@NotNull PsiFile file, @NotNull HighlightInfo info) {
        if (file == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(35);
        }
        if (info == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(36);
        }
        ArrayList quickFixes = new ArrayList();
        info.findRegisteredQuickFix((descriptor, range) -> {
            LocalQuickFix localFix;
            LocalQuickFix fix;
            IntentionAction intention = descriptor.getAction();
            LocalQuickFix localQuickFix = fix = intention instanceof LocalQuickFix ? (localFix = (LocalQuickFix)intention) : QuickFixWrapper.unwrap((CommonIntentionAction)intention);
            if (fix != null) {
                quickFixes.add(fix);
            }
            return null;
        });
        return ProblemDescriptorUtil.convertToDescriptor(file, info.getSeverity(), info.getStartOffset(), info.getEndOffset(), info.getDescription(), info.isAfterEndOfLine(), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 11, 13, 15, 23, 26, 27, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 18: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 25: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeIllegalXmlChars";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHighlightedText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDescriptionMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLocReference";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeTags";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeXmlCode";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfoType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToProblemDescriptors";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractHighlightedText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeIllegalXmlChars";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 26: 
            case 27: 
            case 33: 
            case 34: {
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptionMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeLocReference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unescapeTags";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlCode";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "highlightTypeFromDescriptor";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "convertToDescriptor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "toProblemDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9, 11, 13, 15, 23, 26, 27, 33, 34 -> new IllegalStateException(string);
        };
    }

    public static interface ProblemPresentation {
        @NotNull
        @InspectionMessage
        public String getDescription();

        @NlsContexts.Tooltip
        @NotNull
        public String getTooltip();
    }

    static @interface FlagConstant {
    }
}

