/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.JsonInspectionsReportConverter;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JsonSingleFileInspectionsReportConverter
extends JsonInspectionsReportConverter {
    @Override
    public String getFormatName() {
        return "json-single-file";
    }

    @Override
    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<? extends File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        if (rawDataDirectoryPath == null) {
            JsonSingleFileInspectionsReportConverter.$$$reportNull$$$0(0);
        }
        if (tools == null) {
            JsonSingleFileInspectionsReportConverter.$$$reportNull$$$0(1);
        }
        if (inspectionsResults == null) {
            JsonSingleFileInspectionsReportConverter.$$$reportNull$$$0(2);
        }
        if (outputPath == null) {
            throw new InspectionsReportConverter.ConversionException("Output path isn't specified");
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(outputPath, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
             JsonWriter jsonWriter = gson.newJsonWriter((Writer)writer);){
            jsonWriter.beginObject();
            File patches = (File)ContainerUtil.find(inspectionsResults, file -> FileUtil.getNameWithoutExtension((File)file).equals("fixes"));
            if (patches != null) {
                Element patchesElement = JDOMUtil.load((File)patches);
                jsonWriter.name("patch").value(patchesElement.getTextTrim());
                jsonWriter.name("patchedFiles");
                jsonWriter.beginArray();
                for (Element element : patchesElement.getChildren("patchedFile")) {
                    jsonWriter.beginObject();
                    jsonWriter.name("path").value(element.getAttributeValue("path"));
                    jsonWriter.name("content").value(element.getTextTrim());
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.name("problems");
            jsonWriter.beginArray();
            HashSet<String> seenProblemIds = new HashSet<String>();
            for (File file2 : inspectionsResults) {
                if (FileUtil.getNameWithoutExtension((File)file2).equals(".descriptions")) continue;
                seenProblemIds.add(FileUtil.getNameWithoutExtension((File)file2));
                Element element = JDOMUtil.load((File)file2);
                for (Element problem : element.getChildren("problem")) {
                    JsonSingleFileInspectionsReportConverter.convertProblem(jsonWriter, problem);
                }
            }
            jsonWriter.endArray();
            File descriptionsFile = (File)ContainerUtil.find(inspectionsResults, file -> FileUtil.getNameWithoutExtension((File)file).equals(".descriptions"));
            if (descriptionsFile != null) {
                JsonSingleFileInspectionsReportConverter.convertDescriptionsContents(jsonWriter, JDOMUtil.load((File)descriptionsFile), id -> seenProblemIds.contains(id));
            }
            jsonWriter.endObject();
        }
        catch (IOException | JDOMException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot convert file: " + e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rawDataDirectoryPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "tools";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionsResults";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/ex/JsonSingleFileInspectionsReportConverter";
        objectArray[2] = "convert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

