/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdaterImpl;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class HighlighterRecycler {
    private final Long2ObjectMap<List<HighlightInfo>> incinerator = new Long2ObjectOpenHashMap();

    private HighlighterRecycler() {
    }

    synchronized void recycleHighlighter(@NotNull HighlightInfo info) {
        if (info == null) {
            HighlighterRecycler.$$$reportNull$$$0(0);
        }
        RangeHighlighterEx highlighter = info.getHighlighter();
        assert (!(info.isFromHighlightVisitor() || info.isFromAnnotator() || info.isFromInspection() || info.isInjectionRelated())) : info;
        assert (highlighter != null);
        if (UpdateHighlightersUtil.LOG.isDebugEnabled()) {
            UpdateHighlightersUtil.LOG.debug("recycleHighlighter " + String.valueOf(info) + HighlightInfoUpdaterImpl.currentProgressInfo());
        }
        long range = ((RangeMarkerImpl)highlighter).getScalarRange();
        ((List)this.incinerator.computeIfAbsent(range, __ -> new ArrayList())).add(info);
    }

    @Nullable
    synchronized RangeHighlighter pickupHighlighterFromGarbageBin(int startOffset, int endOffset, int layer, @Nullable String preferredDescription) {
        HighlightInfo info;
        int i;
        long range = TextRangeScalarUtil.toScalarRange((int)startOffset, (int)endOffset);
        List list = (List)this.incinerator.get(range);
        if (list == null) {
            return null;
        }
        int previousFound = -1;
        for (i = list.size() - 1; i >= 0; --i) {
            info = (HighlightInfo)list.get(i);
            RangeHighlighterEx highlighter = info.getHighlighter();
            if (!highlighter.isValid() || highlighter.getLayer() != layer) continue;
            if (Comparing.strEqual((String)info.getDescription(), (String)preferredDescription)) break;
            previousFound = i;
        }
        if (i == -1 && (i = previousFound) == -1) {
            return null;
        }
        info = (HighlightInfo)list.remove(i);
        if (list.isEmpty()) {
            this.incinerator.remove(range);
        }
        if (UpdateHighlightersUtil.LOG.isDebugEnabled()) {
            UpdateHighlightersUtil.LOG.debug("pickupHighlighterFromGarbageBin pickedup:" + String.valueOf(info) + HighlightInfoUpdaterImpl.currentProgressInfo());
        }
        return info.getHighlighter();
    }

    @NotNull
    private synchronized @Unmodifiable Collection<? extends HighlightInfo> forAllInGarbageBin() {
        List list = ContainerUtil.flatten((Iterable)this.incinerator.values());
        if (list == null) {
            HighlighterRecycler.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    RangeHighlighter pickupFileLevelRangeHighlighter(int fileTextLength, @Nullable String description) {
        return this.pickupHighlighterFromGarbageBin(0, fileTextLength, -4094, description);
    }

    static void runWithRecycler(@NotNull HighlightingSession session, @NotNull Consumer<? super HighlighterRecycler> consumer) {
        if (session == null) {
            HighlighterRecycler.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            HighlighterRecycler.$$$reportNull$$$0(3);
        }
        HighlighterRecycler recycler = new HighlighterRecycler();
        consumer.accept(recycler);
        for (HighlightInfo highlightInfo : recycler.forAllInGarbageBin()) {
            UpdateHighlightersUtil.disposeWithFileLevelIgnoreErrors(highlightInfo, session);
        }
    }

    synchronized boolean isEmpty() {
        return this.incinerator.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlighterRecycler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlighterRecycler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forAllInGarbageBin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recycleHighlighter";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runWithRecycler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

