/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.paths.PriorityReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferencesWrapper;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PsiDynaReference<T extends PsiElement>
extends PsiReferenceBase<T>
implements FileReferenceOwner,
PsiPolyVariantReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider,
PsiReferencesWrapper {
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private ResolveResult[] myCachedResult;

    public PsiDynaReference(T psiElement) {
        super(psiElement, true);
    }

    public void addReferences(Collection<? extends PsiReference> references) {
        this.myReferences.addAll(references);
    }

    public @Unmodifiable @NotNull List<PsiReference> getReferences() {
        List list = ContainerUtil.concat(this.myReferences, it -> {
            Collection<Object> collection;
            if (it instanceof PsiReferencesWrapper) {
                PsiReferencesWrapper wrapper = (PsiReferencesWrapper)it;
                collection = wrapper.getReferences();
            } else {
                collection = Collections.singleton(it);
            }
            return collection;
        });
        if (list == null) {
            PsiDynaReference.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void addReference(PsiReference reference) {
        this.myReferences.add(reference);
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    public boolean isSoft() {
        return ContainerUtil.and(this.myReferences, it -> it.isSoft());
    }

    @NotNull
    public String getCanonicalText() {
        PsiReference reference = this.chooseReference();
        String string = reference == null ? this.myReferences.get(0).getCanonicalText() : reference.getCanonicalText();
        if (string == null) {
            PsiDynaReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiReference reference;
        if (newElementName == null) {
            PsiDynaReference.$$$reportNull$$$0(2);
        }
        if ((reference = this.chooseReference()) != null) {
            return reference.handleElementRename(newElementName);
        }
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiDynaReference.$$$reportNull$$$0(3);
        }
        for (PsiReference reference : this.myReferences) {
            if (!(reference instanceof FileReference)) continue;
            return reference.bindToElement(element);
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiDynaReference.$$$reportNull$$$0(4);
        }
        for (PsiReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (this.myCachedResult == null) {
            this.myCachedResult = this.innerResolve(incompleteCode);
        }
        if (this.myCachedResult == null) {
            PsiDynaReference.$$$reportNull$$$0(5);
        }
        return this.myCachedResult;
    }

    protected ResolveResult[] innerResolve(boolean incompleteCode) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (PsiReference reference : this.myReferences) {
            if (reference instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference poly = (PsiPolyVariantReference)reference;
                for (ResolveResult rr : poly.multiResolve(incompleteCode)) {
                    if (!rr.isValidResult()) continue;
                    result.add(rr);
                }
                continue;
            }
            PsiElement resolved = reference.resolve();
            if (resolved == null) continue;
            result.add(new PsiElementResolveResult(resolved));
        }
        return result.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @Nullable
    private PsiReference chooseReference() {
        if (this.myReferences.isEmpty()) {
            return null;
        }
        ContainerUtil.sort(this.myReferences, (o1, o2) -> {
            int byPriority = Double.compare(PsiDynaReference.getPriority(o2), PsiDynaReference.getPriority(o1));
            if (byPriority != 0) {
                return byPriority;
            }
            int bySoftness = Boolean.compare(o2.isSoft(), o1.isSoft());
            if (bySoftness != 0) {
                return bySoftness;
            }
            return Boolean.compare(o2 instanceof FileReference, o1 instanceof FileReference);
        });
        return this.myReferences.get(0);
    }

    private static double getPriority(@NotNull PsiReference o1) {
        if (o1 == null) {
            PsiDynaReference.$$$reportNull$$$0(6);
        }
        if (o1 instanceof PriorityReference) {
            PriorityReference priority = (PriorityReference)o1;
            return priority.getPriority();
        }
        return 0.0;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string;
        PsiReference reference = this.chooseReference();
        if (reference instanceof EmptyResolveMessageProvider) {
            EmptyResolveMessageProvider empty = (EmptyResolveMessageProvider)reference;
            string = empty.getUnresolvedMessagePattern();
        } else {
            string = AnalysisBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[0]);
        }
        if (string == null) {
            PsiDynaReference.$$$reportNull$$$0(7);
        }
        return string;
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        ArrayList list = new ArrayList();
        for (PsiReference ref : this.myReferences) {
            if (!(ref instanceof LocalQuickFixProvider)) continue;
            LocalQuickFixProvider provider = (LocalQuickFixProvider)ref;
            ContainerUtil.addAll(list, (Object[])provider.getQuickFixes());
        }
        return list.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public String toString() {
        return "PsiDynaReference containing " + String.valueOf(this.myReferences);
    }

    public PsiFileReference getLastFileReference() {
        for (PsiReference reference : this.myReferences) {
            if (!(reference instanceof FileReferenceOwner)) continue;
            FileReferenceOwner owner = (FileReferenceOwner)reference;
            return owner.getLastFileReference();
        }
        return null;
    }

    public static PsiReference[] filterByOffset(PsiReference[] references, int offset) {
        return (PsiReference[])StreamEx.of((Object[])references).flatMap(ref -> {
            StreamEx streamEx;
            if (ref instanceof PsiDynaReference) {
                PsiDynaReference dyna = (PsiDynaReference)((Object)ref);
                streamEx = StreamEx.of(dyna.myReferences).filter(it -> it.getRangeInElement().contains(offset));
            } else {
                streamEx = StreamEx.of((Object)ref);
            }
            return streamEx;
        }).toArray((Object[])PsiReference.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/paths/PsiDynaReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/paths/PsiDynaReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

