/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.FileContextProvider;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSetParameters;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class FileReferenceSet
implements FileReferenceSetParameters {
    private static final Logger LOG = Logger.getInstance(FileReferenceSet.class);
    private static final FileType[] EMPTY_FILE_TYPES = new FileType[0];
    public static final CustomizableReferenceProvider.CustomizationKey<Function<PsiFile, Collection<PsiFileSystemItem>>> DEFAULT_PATH_EVALUATOR_OPTION = new CustomizableReferenceProvider.CustomizationKey(AnalysisBundle.message((String)"default.path.evaluator.option", (Object[])new Object[0]));
    public static final Function<PsiFile, Collection<PsiFileSystemItem>> ABSOLUTE_TOP_LEVEL = new AbsoluteTopLevelEvaluator();
    public static final Condition<PsiFileSystemItem> FILE_FILTER = item -> item instanceof PsiFile;
    public static final Condition<PsiFileSystemItem> DIRECTORY_FILTER = item -> item instanceof PsiDirectory;
    protected FileReference[] myReferences;
    private PsiElement myElement;
    private final int myStartInElement;
    private final boolean myCaseSensitive;
    private final String myPathStringNonTrimmed;
    private final String myPathString;
    private volatile Collection<PsiFileSystemItem> myDefaultContexts;
    private final boolean myEndingSlashNotAllowed;
    private boolean myEmptyPathAllowed;
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    private FileType @Nullable [] mySuitableFileTypes;

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType @Nullable [] suitableFileTypes) {
        if (str == null) {
            FileReferenceSet.$$$reportNull$$$0(0);
        }
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(1);
        }
        this(str, element, startInElement, provider, caseSensitive, endingSlashNotAllowed, suitableFileTypes, true);
    }

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType @Nullable [] suitableFileTypes, boolean init) {
        Map map;
        if (str == null) {
            FileReferenceSet.$$$reportNull$$$0(2);
        }
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(3);
        }
        this.myElement = element;
        this.myStartInElement = startInElement;
        this.myCaseSensitive = caseSensitive;
        this.myPathStringNonTrimmed = str;
        this.myPathString = str.trim();
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
        boolean bl = this.myEmptyPathAllowed = !endingSlashNotAllowed;
        if (provider instanceof CustomizableReferenceProvider) {
            CustomizableReferenceProvider custom = (CustomizableReferenceProvider)provider;
            map = custom.getOptions();
        } else {
            map = null;
        }
        this.myOptions = map;
        this.mySuitableFileTypes = suitableFileTypes;
        if (init) {
            this.reparse();
        }
    }

    protected String getNewAbsolutePath(PsiFileSystemItem root, String relativePath) {
        return this.absoluteUrlNeedsStartSlash() ? "/" + relativePath : relativePath;
    }

    public String getSeparatorString() {
        return "/";
    }

    protected int findSeparatorLength(@NotNull CharSequence sequence, int atOffset) {
        if (sequence == null) {
            FileReferenceSet.$$$reportNull$$$0(4);
        }
        return StringUtil.startsWith((CharSequence)sequence, (int)atOffset, (CharSequence)this.getSeparatorString()) ? this.getSeparatorString().length() : 0;
    }

    protected int findSeparatorOffset(@NotNull CharSequence sequence, int startingFrom) {
        if (sequence == null) {
            FileReferenceSet.$$$reportNull$$$0(5);
        }
        return StringUtil.indexOf((CharSequence)sequence, (CharSequence)this.getSeparatorString(), (int)startingFrom);
    }

    @Deprecated(forRemoval=true)
    protected Collection<PsiFileSystemItem> getExtraContexts() {
        return Collections.emptyList();
    }

    @NotNull
    public static FileReferenceSet createSet(@NotNull PsiElement element, final boolean soft, boolean endingSlashNotAllowed, final boolean urlEncoded) {
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(6);
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            text = helper.trimUrl(text);
        }
        return new FileReferenceSet(text, element, offset, null, true, endingSlashNotAllowed){

            @Override
            protected boolean isUrlEncoded() {
                return urlEncoded;
            }

            @Override
            protected boolean isSoft() {
                return soft;
            }
        };
    }

    public FileReferenceSet(String str, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider, boolean isCaseSensitive) {
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(7);
        }
        this(str, element, startInElement, provider, isCaseSensitive, true);
    }

    public FileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            FileReferenceSet.$$$reportNull$$$0(8);
        }
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(9);
        }
        this(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, null);
    }

    public FileReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(10);
        }
        this.myElement = element;
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        this.myStartInElement = range.getStartOffset();
        this.myPathStringNonTrimmed = range.substring(element.getText());
        this.myPathString = this.myPathStringNonTrimmed.trim();
        this.myEndingSlashNotAllowed = true;
        this.myCaseSensitive = false;
        this.reparse();
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            FileReferenceSet.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    void setElement(@NotNull PsiElement element) {
        if (element == null) {
            FileReferenceSet.$$$reportNull$$$0(12);
        }
        this.myElement = element;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isEndingSlashNotAllowed() {
        return this.myEndingSlashNotAllowed;
    }

    public int getStartInElement() {
        return this.myStartInElement;
    }

    @Nullable
    public FileReference createFileReference(TextRange range, int index, String text) {
        return new FileReference(this, range, index, text);
    }

    protected void reparse() {
        List<FileReference> referencesList = this.reparse(this.myPathStringNonTrimmed, this.myStartInElement);
        this.myReferences = referencesList.toArray(FileReference.EMPTY);
    }

    /*
     * Unable to fully structure code
     */
    protected List<FileReference> reparse(String str, int startInElement) {
        wsHead = 0;
        wsTail = 0;
        var9_5 = this.myElement;
        if (!(var9_5 instanceof PsiLanguageInjectionHost)) ** GOTO lbl-1000
        host = (PsiLanguageInjectionHost)var9_5;
        if (!StringUtil.startsWith((CharSequence)this.myElement.getText(), (int)startInElement, (CharSequence)str)) {
            escaper = host.createLiteralTextEscaper();
            valueRange = ElementManipulators.getValueTextRange((PsiElement)this.myElement);
            sb = new StringBuilder();
            escaper.decode(valueRange, sb);
            decoded = sb;
            wsHead += Math.max(0, startInElement - valueRange.getStartOffset());
        } else lbl-1000:
        // 2 sources

        {
            escaper = null;
            decoded = str;
            valueRange = TextRange.from((int)startInElement, (int)decoded.length());
        }
        referencesList = new ArrayList<FileReference>();
        for (i = wsHead; i < decoded.length() && Character.isWhitespace(decoded.charAt(i)); ++i) {
            ++wsHead;
        }
        for (i = decoded.length() - 1; i >= 0 && Character.isWhitespace(decoded.charAt(i)); --i) {
            ++wsTail;
        }
        index = 0;
        curSep = this.findSeparatorOffset(decoded, wsHead);
        v0 = sepLen = curSep >= wsHead ? this.findSeparatorLength(decoded, curSep) : 0;
        if (curSep >= 0 && decoded.length() == wsHead + sepLen + wsTail && (reference = this.createFileReference(r = TextRange.create((int)startInElement, (int)(FileReferenceSet.offset(curSep + Math.max(0, sepLen - 1), (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange) + 1)), index++, decoded.subSequence(curSep, curSep + sepLen).toString())) != null) {
            referencesList.add(reference);
        }
        curSep = curSep == wsHead ? curSep + sepLen : wsHead;
        sepLen = 0;
        while (curSep >= 0) {
            nextSep = this.findSeparatorOffset(decoded, curSep + sepLen);
            start = curSep + sepLen;
            endTrimmed = nextSep > 0 ? nextSep : Math.max(start, decoded.length() - wsTail);
            refText = index == 0 && nextSep < 0 && StringUtil.contains((CharSequence)decoded, (CharSequence)str) == false ? str : decoded.subSequence(start, endTrimmed).toString();
            refStart = FileReferenceSet.offset(start, (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange);
            if (refStart > (refEnd = FileReferenceSet.offset(endTrimmed, (LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, valueRange)) || refStart < 0) {
                FileReferenceSet.LOG.error("Invalid range: (" + refText + ", " + refEnd + "), escaper=" + String.valueOf(escaper) + "\ntext=" + refText + ", start=" + startInElement);
            }
            if ((reference = this.createFileReference(new TextRange(refStart, refEnd), index++, refText)) != null) {
                referencesList.add(reference);
            }
            sepLen = (curSep = nextSep) > 0 ? this.findSeparatorLength(decoded, curSep) : 0;
        }
        return referencesList;
    }

    private static int offset(int offset, LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper, TextRange valueRange) {
        return escaper == null ? offset + valueRange.getStartOffset() : escaper.getOffsetInHost(offset, valueRange);
    }

    public FileReference getReference(int index) {
        return this.myReferences[index];
    }

    public FileReference @NotNull [] getAllReferences() {
        if (this.myReferences == null) {
            FileReferenceSet.$$$reportNull$$$0(13);
        }
        return this.myReferences;
    }

    protected boolean isSoft() {
        return false;
    }

    protected boolean isUrlEncoded() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        Collection<PsiFileSystemItem> result = this.myDefaultContexts;
        if (result == null) {
            this.myDefaultContexts = result = this.computeDefaultContexts();
        }
        Collection<PsiFileSystemItem> collection = result;
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(15);
            }
            return list;
        }
        Collection<PsiFileSystemItem> contexts = this.getCustomizationContexts(file);
        if (contexts != null) {
            Collection<PsiFileSystemItem> collection = contexts;
            if (collection == null) {
                FileReferenceSet.$$$reportNull$$$0(16);
            }
            return collection;
        }
        if (this.isAbsolutePathReference()) {
            return FileReferenceSet.getAbsoluteTopLevelDirLocations(file);
        }
        return this.getContextByFile(file);
    }

    @Nullable
    protected PsiFile getContainingFile() {
        PsiFile cf = this.myElement.getContainingFile();
        PsiFile file = InjectedLanguageManager.getInstance((Project)cf.getProject()).getTopLevelFile((PsiElement)cf);
        if (file != null) {
            return file.getOriginalFile();
        }
        LOG.error("Invalid element: " + String.valueOf(this.myElement));
        return null;
    }

    @NotNull
    private Collection<PsiFileSystemItem> getContextByFile(@NotNull PsiFile file) {
        Collection<PsiFileSystemItem> folders;
        PsiElement context;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(17);
        }
        if ((context = file.getContext()) != null) {
            file = context.getContainingFile();
        }
        if ((folders = this.getIncludingFileContexts(file)) != null) {
            Collection<PsiFileSystemItem> collection = folders;
            if (collection == null) {
                FileReferenceSet.$$$reportNull$$$0(18);
            }
            return collection;
        }
        Collection<PsiFileSystemItem> collection = this.getContextByFileSystemItem((PsiFileSystemItem)file.getOriginalFile());
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getContextByFileSystemItem(@NotNull PsiFileSystemItem file) {
        VirtualFile virtualFile;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(20);
        }
        if ((virtualFile = file.getVirtualFile()) != null && FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null) {
            FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
            SmartList result = new SmartList();
            Project project = file.getProject();
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor((Collection)result);
            for (FileReferenceHelper helper : helpers) {
                if (helper.isMine(project, virtualFile) && (result.isEmpty() || !helper.isFallback()) && !helper.processContexts(this, virtualFile, false, (Processor<? super PsiFileSystemItem>)collector)) break;
            }
            if (!result.isEmpty()) {
                if (!ContainerUtil.exists((Iterable)result, el -> !(el instanceof FileReferenceResolver))) {
                    result.addAll(this.getParentDirectoryContext());
                }
                List<PsiFileSystemItem> list = result.stream().distinct().toList();
                if (list == null) {
                    FileReferenceSet.$$$reportNull$$$0(21);
                }
                return list;
            }
            Collection<PsiFileSystemItem> collection = this.getParentDirectoryContext();
            if (collection == null) {
                FileReferenceSet.$$$reportNull$$$0(22);
            }
            return collection;
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            FileReferenceSet.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Nullable
    private Collection<PsiFileSystemItem> getIncludingFileContexts(@NotNull PsiFile file) {
        FileContextProvider contextProvider;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(24);
        }
        if (this.useIncludingFileAsContext() && (contextProvider = FileContextProvider.getProvider((PsiFile)file)) != null) {
            Collection folders = contextProvider.getContextFolders(file);
            if (!folders.isEmpty()) {
                return folders;
            }
            PsiFile contextFile = contextProvider.getContextFile(file);
            if (contextFile != null && contextFile.getParent() != null) {
                return Collections.singletonList(contextFile.getParent());
            }
        }
        return null;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getParentDirectoryContext() {
        PsiFile file = this.getContainingFile();
        VirtualFile virtualFile = file == null ? null : file.getOriginalFile().getVirtualFile();
        VirtualFile parent = virtualFile == null ? null : virtualFile.getParent();
        PsiDirectory directory = parent == null ? null : file.getManager().findDirectory(parent);
        Collection<Object> collection = directory != null ? Collections.singleton(directory) : Collections.emptyList();
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(25);
        }
        return collection;
    }

    public @Unmodifiable Collection<FileTargetContext> getTargetContexts() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            return Collections.emptyList();
        }
        Collection<FileTargetContext> customizationContexts = this.getTargetCustomizationContexts(file);
        Collection<FileTargetContext> targetContexts = customizationContexts != null ? customizationContexts : this.getTargetContextByFile(file);
        return FileReferenceSet.filterLocalFsContexts(targetContexts);
    }

    private static @Unmodifiable Collection<FileTargetContext> filterLocalFsContexts(Collection<? extends FileTargetContext> contexts) {
        return ContainerUtil.filter(contexts, c -> {
            VirtualFile file = c.getFileSystemItem().getVirtualFile();
            return file != null && c.getFileSystemItem().isDirectory() && file.isInLocalFileSystem();
        });
    }

    @Nullable
    private Collection<PsiFileSystemItem> getCustomizationContexts(PsiFile file) {
        Collection roots;
        Function value;
        if (this.myOptions != null && (value = (Function)DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) != null && (roots = (Collection)value.fun((Object)file)) != null) {
            for (PsiFileSystemItem root : roots) {
                if (root != null) continue;
                LOG.error("Default path evaluator " + String.valueOf(value) + " produced a null root for " + String.valueOf(file));
            }
            return roots;
        }
        return null;
    }

    @Nullable
    private Collection<FileTargetContext> getTargetCustomizationContexts(@NotNull PsiFile file) {
        Function value;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(26);
        }
        if (this.myOptions != null && (value = (Function)DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.myOptions)) != null) {
            Collection<FileTargetContext> roots;
            if (value instanceof TargetContextEvaluator) {
                TargetContextEvaluator evaluator = (TargetContextEvaluator)value;
                roots = evaluator.getTargetContexts(this, file);
            } else {
                Collection items = (Collection)value.fun((Object)file);
                roots = items != null ? FileTargetContext.toTargetContexts(items) : Collections.emptyList();
            }
            return roots;
        }
        return null;
    }

    private @Unmodifiable @NotNull Collection<FileTargetContext> getTargetContextByFile(@NotNull PsiFile file) {
        PsiDirectory parent;
        boolean absolutePathReference;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(27);
        }
        if (!(absolutePathReference = this.isAbsolutePathReference())) {
            Collection<PsiFileSystemItem> folders;
            PsiElement context = file.getContext();
            if (context != null) {
                file = context.getContainingFile();
            }
            if ((folders = this.getIncludingFileContexts(file)) != null) {
                Collection<FileTargetContext> collection = FileTargetContext.toTargetContexts(folders);
                if (collection == null) {
                    FileReferenceSet.$$$reportNull$$$0(28);
                }
                return collection;
            }
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((parent = file.getParent()) == null ? file : parent));
        if (absolutePathReference && module == null) {
            List<FileTargetContext> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(29);
            }
            return list;
        }
        PsiFile originalFile = file.getOriginalFile();
        VirtualFile virtualFile = originalFile.getVirtualFile();
        if (virtualFile == null) {
            List<FileTargetContext> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(30);
            }
            return list;
        }
        LinkedHashSet<FileTargetContext> list = new LinkedHashSet<FileTargetContext>();
        Project project = originalFile.getProject();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(list);
        FileReferenceHelper[] helpers = FileReferenceHelperRegistrar.getHelpers();
        for (FileReferenceHelper helper : helpers) {
            if (helper.isMine(project, virtualFile) && (list.isEmpty() || !helper.isFallback()) && !helper.processTargetContexts(this, virtualFile, (Processor<? super FileTargetContext>)processor)) break;
        }
        if (!list.isEmpty()) {
            if (!ContainerUtil.exists(list, el -> !(el.getFileSystemItem() instanceof FileReferenceResolver))) {
                for (PsiFileSystemItem item : this.getParentDirectoryContext()) {
                    list.add(new FileTargetContext(item));
                }
            }
            LinkedHashSet<FileTargetContext> linkedHashSet = list;
            if (linkedHashSet == null) {
                FileReferenceSet.$$$reportNull$$$0(31);
            }
            return linkedHashSet;
        }
        Collection<FileTargetContext> collection = FileTargetContext.toTargetContexts(this.getParentDirectoryContext());
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getPathString() {
        String string = this.myPathString;
        if (string == null) {
            FileReferenceSet.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Override
    public boolean isAbsolutePathReference() {
        return this.myPathString.startsWith(this.getSeparatorString());
    }

    protected boolean useIncludingFileAsContext() {
        return true;
    }

    @Nullable
    public PsiFileSystemItem resolve() {
        FileReference lastReference = this.getLastReference();
        return lastReference == null ? null : lastReference.resolve();
    }

    @Nullable
    public FileReference getLastReference() {
        return this.myReferences == null || this.myReferences.length == 0 ? null : this.myReferences[this.myReferences.length - 1];
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getAbsoluteTopLevelDirLocations(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(34);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(35);
            }
            return list;
        }
        PsiDirectory parent = file.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(parent == null ? file : parent));
        if (module == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(36);
            }
            return list;
        }
        LinkedHashSet<PsiFileSystemItem> result = new LinkedHashSet<PsiFileSystemItem>();
        Project project = file.getProject();
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            if (!helper.isMine(project, virtualFile) || helper.isFallback() && !result.isEmpty()) continue;
            Collection<PsiFileSystemItem> roots = helper.getRoots(module, virtualFile);
            for (PsiFileSystemItem root : roots) {
                if (root == null) {
                    LOG.error("Helper " + String.valueOf(helper) + " produced a null root for " + String.valueOf(file));
                    continue;
                }
                result.add(root);
            }
        }
        return new ArrayList<PsiFileSystemItem>(result);
    }

    @NotNull
    private static Collection<FileTargetContext> getTargetAbsoluteTopLevelContexts(@NotNull FileReferenceSetParameters parameters, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (parameters == null) {
            FileReferenceSet.$$$reportNull$$$0(37);
        }
        if (file == null) {
            FileReferenceSet.$$$reportNull$$$0(38);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            List<FileTargetContext> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(39);
            }
            return list;
        }
        PsiDirectory parent = file.getParent();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(parent == null ? file : parent));
        if (module == null) {
            List<FileTargetContext> list = Collections.emptyList();
            if (list == null) {
                FileReferenceSet.$$$reportNull$$$0(40);
            }
            return list;
        }
        LinkedHashSet result = new LinkedHashSet();
        Project project = file.getProject();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(result);
        for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
            if (helper.isMine(project, virtualFile) && (!helper.isFallback() || result.isEmpty()) && !helper.processTargetContexts(parameters, virtualFile, (Processor<? super FileTargetContext>)processor)) break;
        }
        return new ArrayList<FileTargetContext>(result);
    }

    protected @Unmodifiable @NotNull Collection<PsiFileSystemItem> toFileSystemItems(VirtualFile ... files) {
        Collection<PsiFileSystemItem> collection = this.toFileSystemItems(Arrays.asList(files));
        if (collection == null) {
            FileReferenceSet.$$$reportNull$$$0(41);
        }
        return collection;
    }

    protected @Unmodifiable @NotNull Collection<PsiFileSystemItem> toFileSystemItems(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            FileReferenceSet.$$$reportNull$$$0(42);
        }
        PsiManager manager = this.getElement().getManager();
        List list = ContainerUtil.mapNotNull(files, file -> file != null && file.isValid() ? manager.findDirectory(file) : null);
        if (list == null) {
            FileReferenceSet.$$$reportNull$$$0(43);
        }
        return list;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return Conditions.alwaysTrue();
    }

    public <Option> void addCustomization(CustomizableReferenceProvider.CustomizationKey<Option> key, Option value) {
        if (this.myOptions == null) {
            this.myOptions = new HashMap<CustomizableReferenceProvider.CustomizationKey, Object>(5);
        }
        this.myOptions.put(key, value);
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return true;
    }

    public boolean absoluteUrlNeedsStartSlash() {
        return true;
    }

    public FileType @NotNull [] getSuitableFileTypes() {
        FileType[] fileTypeArray = this.mySuitableFileTypes == null ? EMPTY_FILE_TYPES : this.mySuitableFileTypes;
        if (fileTypeArray == null) {
            FileReferenceSet.$$$reportNull$$$0(44);
        }
        return fileTypeArray;
    }

    public boolean isEmptyPathAllowed() {
        return this.myEmptyPathAllowed;
    }

    public void setEmptyPathAllowed(boolean emptyPathAllowed) {
        this.myEmptyPathAllowed = emptyPathAllowed;
    }

    public boolean supportsExtendedCompletion() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13, 14, 15, 16, 18, 19, 21, 22, 23, 25, 28, 29, 30, 31, 32, 33, 35, 36, 39, 40, 41, 43, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet";
                break;
            }
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllReferences";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultContexts";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByFileSystemItem";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDirectoryContext";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetContextByFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathString";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteTopLevelDirLocations";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetAbsoluteTopLevelContexts";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileSystemItems";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSeparatorLength";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSeparatorOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSet";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContextByFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContextByFileSystemItem";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getIncludingFileContexts";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTargetCustomizationContexts";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTargetContextByFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAbsoluteTopLevelDirLocations";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTargetAbsoluteTopLevelContexts";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "toFileSystemItems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13, 14, 15, 16, 18, 19, 21, 22, 23, 25, 28, 29, 30, 31, 32, 33, 35, 36, 39, 40, 41, 43, 44 -> new IllegalStateException(string);
        };
    }

    public static interface TargetContextEvaluator {
        @NotNull
        public Collection<FileTargetContext> getTargetContexts(@NotNull FileReferenceSetParameters var1, @NotNull PsiFile var2);
    }

    private static class AbsoluteTopLevelEvaluator
    implements Function<PsiFile, Collection<PsiFileSystemItem>>,
    TargetContextEvaluator {
        private AbsoluteTopLevelEvaluator() {
        }

        @Override
        @NotNull
        public Collection<FileTargetContext> getTargetContexts(@NotNull FileReferenceSetParameters parameters, @NotNull PsiFile file) {
            if (parameters == null) {
                AbsoluteTopLevelEvaluator.$$$reportNull$$$0(0);
            }
            if (file == null) {
                AbsoluteTopLevelEvaluator.$$$reportNull$$$0(1);
            }
            Collection<FileTargetContext> collection = FileReferenceSet.getTargetAbsoluteTopLevelContexts(parameters, file);
            if (collection == null) {
                AbsoluteTopLevelEvaluator.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public Collection<PsiFileSystemItem> fun(PsiFile file) {
            return FileReferenceSet.getAbsoluteTopLevelDirLocations(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet$AbsoluteTopLevelEvaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet$AbsoluteTopLevelEvaluator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetContexts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTargetContexts";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

