/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.memory;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DfaMemoryState {
    @NotNull
    public DfaMemoryState createCopy();

    @NotNull
    public DfaMemoryState createClosureState();

    @NotNull
    public DfaValue pop();

    @NotNull
    public DfaValue peek();

    @Nullable
    public DfaValue getStackValue(int var1);

    public int getStackSize();

    public boolean isEmptyStack();

    public void push(@NotNull DfaValue var1);

    public void emptyStack();

    public void setVarValue(@NotNull DfaVariableValue var1, @NotNull DfaValue var2);

    @Nullable
    public RelationType getRelation(@NotNull DfaValue var1, @NotNull DfaValue var2);

    public boolean applyCondition(@NotNull DfaCondition var1);

    public boolean areEqual(@NotNull DfaValue var1, @NotNull DfaValue var2);

    public boolean applyContractCondition(@NotNull DfaCondition var1);

    public boolean meetDfType(@NotNull DfaValue var1, @NotNull DfType var2);

    public void setDfType(@NotNull DfaValue var1, @NotNull DfType var2);

    public void updateDfType(@NotNull DfaValue var1, @NotNull @NotNull UnaryOperator<@NotNull DfType> var2);

    @NotNull
    public DfType getDfType(@NotNull DfaValue var1);

    @NotNull
    public DfType getDfTypeIncludingDerived(@NotNull DfaValue var1);

    public void flushFieldsQualifiedBy(@NotNull Set<DfaValue> var1);

    public void flushFields();

    public void flushVariable(@NotNull DfaVariableValue var1);

    public void flushVariables(@NotNull @NotNull Predicate<? super @NotNull DfaVariableValue> var1);

    public void forgetVariables(@NotNull @NotNull Predicate<? super @NotNull DfaVariableValue> var1);

    public void markEphemeral();

    public boolean isEphemeral();

    public Object getMergeabilityKey();

    public void merge(@NotNull DfaMemoryState var1);

    public void afterMerge(@NotNull DfaMemoryState var1);

    @Nullable
    public DfaMemoryState tryJoinExactly(@NotNull DfaMemoryState var1);

    public boolean isSuperStateOf(@NotNull DfaMemoryState var1);

    public void widen();
}

