/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefFileImpl
extends RefElementImpl
implements RefFile {
    private final RefModule myRefModule = this.getRefManager().getRefModule(ModuleUtilCore.findModuleForFile((PsiFile)this.getPsiElement()));

    public RefFileImpl(PsiFile elem, RefManager manager) {
        super(elem, manager);
    }

    public PsiFile getPsiElement() {
        return (PsiFile)super.getPsiElement();
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefFileImpl.$$$reportNull$$$0(0);
        }
        ReadAction.run(() -> visitor.visitFile((RefFile)this));
    }

    @Override
    public String getExternalName() {
        PsiFile psiFile = this.getPsiElement();
        VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        return virtualFile != null ? virtualFile.getUrl() : this.getName();
    }

    @Override
    protected synchronized void initialize() {
        RefElement element;
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            return;
        }
        VirtualFile parentDirectory = vFile.getParent();
        if (parentDirectory == null) {
            return;
        }
        PsiDirectory psiDirectory = this.getRefManager().getPsiManager().findDirectory(parentDirectory);
        if (psiDirectory != null && (element = this.getRefManager().getReference((PsiElement)psiDirectory)) != null) {
            ((RefElementImpl)element).add(this);
        }
    }

    @Nullable
    static RefElement fileFromExternalName(RefManager manager, String fqName) {
        PsiFile psiFile;
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(PathMacroManager.getInstance((ComponentManager)manager.getProject()).expandPath(fqName));
        if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)manager.getProject()).findFile(virtualFile)) != null) {
            return manager.getReference((PsiElement)psiFile);
        }
        return null;
    }

    @Override
    public RefModule getModule() {
        return this.myRefModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefFileImpl", "accept"));
    }
}

