/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.FileElement;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInsight/completion/OffsetsInFile;", "", "file", "Lcom/intellij/psi/PsiFile;", "offsets", "Lcom/intellij/codeInsight/completion/OffsetMap;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInsight/completion/OffsetMap;)V", "(Lcom/intellij/psi/PsiFile;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffsets", "()Lcom/intellij/codeInsight/completion/OffsetMap;", "toTopLevelFile", "toInjectedIfAny", "offset", "", "copyWithReplacement", "startOffset", "endOffset", "replacement", "", "replaceInCopy", "Ljava/util/function/Supplier;", "fileCopy", "intellij.platform.analysis.impl"})
public final class OffsetsInFile {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final OffsetMap offsets;

    public OffsetsInFile(@NotNull PsiFile file, @NotNull OffsetMap offsets) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
        this.file = file;
        this.offsets = offsets;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final OffsetMap getOffsets() {
        return this.offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = file.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        this(file, new OffsetMap(document));
    }

    @NotNull
    public final OffsetsInFile toTopLevelFile() {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.file.getProject());
        PsiFile hostFile = manager.getTopLevelFile((PsiElement)this.file);
        if (Intrinsics.areEqual((Object)hostFile, (Object)this.file)) {
            return this;
        }
        Intrinsics.checkNotNull((Object)hostFile);
        Document document = hostFile.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        OffsetMap offsetMap = this.offsets.mapOffsets(document, arg_0 -> OffsetsInFile.toTopLevelFile$lambda$1(arg_0 -> OffsetsInFile.toTopLevelFile$lambda$0(manager, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"mapOffsets(...)");
        return new OffsetsInFile(hostFile, offsetMap);
    }

    @NotNull
    public final OffsetsInFile toInjectedIfAny(int offset) {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.file.getProject());
        PsiElement psiElement = manager.findInjectedElementAt(this.file, offset);
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return this;
        }
        PsiElement injected = psiElement;
        VirtualFile virtualFile = injected.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            DocumentWindow documentWindow = ((VirtualFileWindow)virtualFile).getDocumentWindow();
            Intrinsics.checkNotNullExpressionValue((Object)documentWindow, (String)"getDocumentWindow(...)");
            DocumentWindow documentWindow2 = documentWindow;
            OffsetMap offsetMap = this.offsets.mapOffsets((Document)documentWindow2, arg_0 -> OffsetsInFile.toInjectedIfAny$lambda$1(arg_0 -> OffsetsInFile.toInjectedIfAny$lambda$0(documentWindow2, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"mapOffsets(...)");
            return new OffsetsInFile((PsiFile)injected, offsetMap);
        }
        return this;
    }

    @NotNull
    public final OffsetsInFile copyWithReplacement(int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        PsiElement psiElement = this.file.copy();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
        OffsetsInFile offsetsInFile = this.replaceInCopy((PsiFile)psiElement, startOffset, endOffset, replacement).get();
        Intrinsics.checkNotNullExpressionValue((Object)offsetsInFile, (String)"get(...)");
        return offsetsInFile;
    }

    @NotNull
    public final Supplier<OffsetsInFile> replaceInCopy(@NotNull PsiFile fileCopy, int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        CharSequence charSequence = this.offsets.getDocument().getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence originalText = charSequence;
        DocumentImpl tempDocument = new DocumentImpl(originalText, StringsKt.contains$default((CharSequence)originalText, (char)'\r', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)replacement, (char)'\r', (boolean)false, (int)2, null), true);
        OffsetMap offsetMap = this.offsets.copyOffsets((Document)tempDocument);
        Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"copyOffsets(...)");
        OffsetMap tempMap = offsetMap;
        tempDocument.replaceString(startOffset, endOffset, (CharSequence)replacement);
        Document document = fileCopy.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document);
        Document copyDocument = document;
        FileASTNode fileASTNode = fileCopy.getNode();
        FileElement fileElement = fileASTNode instanceof FileElement ? (FileElement)fileASTNode : null;
        if (fileElement == null) {
            throw new IllegalStateException("Node is not a FileElement " + fileCopy.getClass().getName() + " / " + fileCopy.getFileType() + " / " + fileCopy.getNode());
        }
        FileElement node = fileElement;
        PomModel pomModel = PomManager.getModel((Project)this.file.getProject());
        Intrinsics.checkNotNull((Object)pomModel, (String)"null cannot be cast to non-null type com.intellij.pom.core.impl.PomModelImpl");
        Runnable applyPsiChange = ((PomModelImpl)pomModel).reparseFile(fileCopy, node, tempDocument.getImmutableCharSequence());
        return () -> OffsetsInFile.replaceInCopy$lambda$0(applyPsiChange, fileCopy, tempMap, copyDocument);
    }

    private static final Integer toTopLevelFile$lambda$0(InjectedLanguageManager $manager, OffsetsInFile this$0, Integer it) {
        PsiElement psiElement = (PsiElement)this$0.file;
        Intrinsics.checkNotNull((Object)it);
        return $manager.injectedToHost(psiElement, it.intValue());
    }

    private static final Integer toTopLevelFile$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer toInjectedIfAny$lambda$0(DocumentWindow $documentWindow, Integer it) {
        Intrinsics.checkNotNull((Object)it);
        return $documentWindow.hostToInjected(it.intValue());
    }

    private static final Integer toInjectedIfAny$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final OffsetsInFile replaceInCopy$lambda$0(Runnable $applyPsiChange, PsiFile $fileCopy, OffsetMap $tempMap, Document $copyDocument) {
        Runnable runnable = $applyPsiChange;
        if (runnable != null) {
            runnable.run();
        }
        OffsetMap offsetMap = $tempMap.copyOffsets($copyDocument);
        Intrinsics.checkNotNullExpressionValue((Object)offsetMap, (String)"copyOffsets(...)");
        return new OffsetsInFile($fileCopy, offsetMap);
    }
}

