/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefDirectoryImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import org.jdom.Element;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefManagerImpl
extends RefManager {
    public static final ExtensionPointName<RefGraphAnnotator> EP_NAME = ExtensionPointName.create((String)"com.intellij.refGraphAnnotator");
    private static final Logger LOG = Logger.getInstance(RefManagerImpl.class);
    private long myLastUsedMask;
    @NotNull
    private final Project myProject;
    private AnalysisScope myScope;
    private RefProject myRefProject;
    private final Set<VirtualFile> myUnprocessedFiles;
    private final boolean processExternalElements;
    private final ConcurrentHashMap<PsiAnchor, RefElement> myRefTable;
    private volatile List<RefElement> myCachedSortedRefs;
    private final ConcurrentMap<Module, RefModule> myModules;
    private final ProjectIterator myProjectIterator;
    private final AtomicBoolean myDeclarationsFound;
    private final PsiManager myPsiManager;
    private volatile boolean myIsInProcess;
    private volatile boolean myOfflineView;
    private final List<RefGraphAnnotator> myGraphAnnotators;
    private GlobalInspectionContext myContext;
    private final Map<Key<?>, RefManagerExtension<?>> myExtensions;
    private final Map<Language, RefManagerExtension<?>> myLanguageExtensions;
    private final Interner<String> myNameInterner;
    private final BlockingQueue<@NotNull Runnable> myTasks;
    private final AtomicInteger myTasksInFlight;
    private final ExecutorService myExecutor;
    private final CountDownLatch myLatch;

    public RefManagerImpl(@NotNull Project project, @Nullable AnalysisScope scope, @NotNull GlobalInspectionContext context) {
        if (project == null) {
            RefManagerImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RefManagerImpl.$$$reportNull$$$0(1);
        }
        this.myLastUsedMask = 0x8000000L;
        this.myUnprocessedFiles = VfsUtilCore.createCompactVirtualFileSet();
        this.processExternalElements = Registry.is((String)"batch.inspections.process.external.elements");
        this.myRefTable = new ConcurrentHashMap();
        this.myModules = new ConcurrentHashMap<Module, RefModule>();
        this.myProjectIterator = new ProjectIterator();
        this.myDeclarationsFound = new AtomicBoolean(false);
        this.myGraphAnnotators = ContainerUtil.createConcurrentList();
        this.myExtensions = new HashMap();
        this.myLanguageExtensions = new HashMap();
        this.myNameInterner = Interner.createStringInterner();
        this.myProject = project;
        this.myScope = scope;
        this.myContext = context;
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myRefProject = new RefProjectImpl(this);
        for (InspectionExtensionsFactory factory : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            RefManagerExtension extension = factory.createRefManagerExtension((RefManager)this);
            if (extension == null) continue;
            this.myExtensions.put(extension.getID(), extension);
            for (Language language : extension.getLanguages()) {
                this.myLanguageExtensions.put(language, extension);
            }
        }
        if (scope != null) {
            for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                this.getRefModule(module);
            }
        }
        if (Registry.is((String)"batch.inspections.process.project.usages.in.parallel")) {
            int setting = Registry.get((String)"batch.inspections.number.of.threads").asInteger();
            int threadsCount = setting > 0 ? setting : Runtime.getRuntime().availableProcessors() - 1;
            this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Reference Graph Executor", (int)Math.min(Math.max(threadsCount, 1), 10));
            this.myTasksInFlight = new AtomicInteger();
            this.myTasks = new LinkedBlockingQueue<Runnable>();
            this.myLatch = new CountDownLatch(1);
        } else {
            this.myExecutor = null;
            this.myTasksInFlight = null;
            this.myTasks = null;
            this.myLatch = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String internName(@NotNull String name) {
        if (name == null) {
            RefManagerImpl.$$$reportNull$$$0(2);
        }
        Interner<String> interner = this.myNameInterner;
        synchronized (interner) {
            return (String)this.myNameInterner.intern((Object)name);
        }
    }

    @NotNull
    public GlobalInspectionContext getContext() {
        GlobalInspectionContext globalInspectionContext = this.myContext;
        if (globalInspectionContext == null) {
            RefManagerImpl.$$$reportNull$$$0(3);
        }
        return globalInspectionContext;
    }

    public void iterate(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefManagerImpl.$$$reportNull$$$0(4);
        }
        for (RefElement refElement : this.getSortedElements()) {
            refElement.accept(visitor);
        }
        List filteredModules = ContainerUtil.filter(this.myModules.values(), refModule -> (Boolean)ReadAction.compute(() -> this.myScope.containsModule(refModule.getModule())));
        for (RefModule refModule2 : filteredModules) {
            refModule2.accept(visitor);
        }
        for (RefManagerExtension refManagerExtension : this.myExtensions.values()) {
            refManagerExtension.iterate(visitor);
        }
    }

    public void cleanup() {
        this.myScope = null;
        this.myRefProject = null;
        this.myRefTable.clear();
        this.myCachedSortedRefs = null;
        this.myModules.clear();
        this.myContext = null;
        this.myGraphAnnotators.clear();
        for (RefManagerExtension<?> extension : this.myExtensions.values()) {
            extension.cleanup();
        }
        this.myExtensions.clear();
        this.myLanguageExtensions.clear();
    }

    @Nullable
    public AnalysisScope getScope() {
        return this.myScope;
    }

    void fireNodeInitialized(RefElement refElement) {
        if (!this.myIsInProcess || !this.isDeclarationsFound()) {
            return;
        }
        PsiElement psi = refElement.getPsiElement();
        if (psi != null) {
            for (RefManagerExtension refManagerExtension : this.myExtensions.values()) {
                refManagerExtension.onEntityInitialized(refElement, psi);
            }
        }
        for (RefGraphAnnotator refGraphAnnotator : this.myGraphAnnotators) {
            refGraphAnnotator.onInitialize(refElement);
        }
    }

    public void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting);
        }
    }

    public void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting, PsiElement element) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting, element);
        }
    }

    public void fireAnonymousReferenced(RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting, PsiElement element) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onAnonymousReferenced(refFrom, referencedFromClassInitializer, forReading, forWriting, element);
        }
    }

    public void fireNodeMarkedReferenced(PsiElement what, PsiElement from) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(what, from, false);
        }
    }

    private void fireBuildReferences(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onReferencesBuild(refElement);
        }
    }

    public void registerGraphAnnotator(@NotNull RefGraphAnnotator annotator) {
        if (annotator == null) {
            RefManagerImpl.$$$reportNull$$$0(5);
        }
        if (!this.myGraphAnnotators.contains(annotator)) {
            this.myGraphAnnotators.add(annotator);
            if (annotator instanceof RefGraphAnnotatorEx) {
                RefGraphAnnotatorEx annotatorEx = (RefGraphAnnotatorEx)annotator;
                annotatorEx.initialize((RefManager)this);
            }
        }
    }

    public void unregisterAnnotator(RefGraphAnnotator annotator) {
        this.myGraphAnnotators.remove(annotator);
    }

    public synchronized long getLastUsedMask() {
        if (this.myLastUsedMask < 0L) {
            throw new IllegalStateException("We're out of 64 bits, sorry");
        }
        this.myLastUsedMask <<= 1;
        return this.myLastUsedMask;
    }

    public <T> T getExtension(@NotNull Key<T> key) {
        if (key == null) {
            RefManagerImpl.$$$reportNull$$$0(6);
        }
        return (T)this.myExtensions.get(key);
    }

    @Nullable
    public String getType(@NotNull RefEntity ref) {
        if (ref == null) {
            RefManagerImpl.$$$reportNull$$$0(7);
        }
        for (RefManagerExtension<?> extension : this.myExtensions.values()) {
            String type = extension.getType(ref);
            if (type == null) continue;
            return type;
        }
        if (ref instanceof RefFile) {
            return "file";
        }
        if (ref instanceof RefModule) {
            return "module";
        }
        if (ref instanceof RefProject) {
            return "project";
        }
        if (ref instanceof RefDirectory) {
            return "dir";
        }
        return null;
    }

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref == null) {
            RefManagerImpl.$$$reportNull$$$0(8);
        }
        for (RefManagerExtension<?> extension : this.myExtensions.values()) {
            ref = extension.getRefinedElement(ref);
        }
        RefEntity refEntity = ref;
        if (refEntity == null) {
            RefManagerImpl.$$$reportNull$$$0(9);
        }
        return refEntity;
    }

    @Nullable
    public Element export(@NotNull RefEntity refEntity, int actualLine) {
        if (refEntity == null) {
            RefManagerImpl.$$$reportNull$$$0(10);
        }
        refEntity = this.getRefinedElement(refEntity);
        Element problem = new Element("problem");
        if (refEntity instanceof RefDirectory) {
            RefDirectory dir = (RefDirectory)refEntity;
            Element fileElement = new Element("file");
            VirtualFile virtualFile = ((PsiDirectory)dir.getPsiElement()).getVirtualFile();
            fileElement.addContent(virtualFile.getUrl());
            problem.addContent(fileElement);
        } else if (refEntity instanceof RefElement) {
            int resultLine;
            RefElement refElement = (RefElement)refEntity;
            SmartPsiElementPointer pointer = refElement.getPointer();
            if (pointer == null) {
                return null;
            }
            PsiFile psiFile = pointer.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            Element fileElement = new Element("file");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            fileElement.addContent(virtualFile.getUrl());
            problem.addContent(fileElement);
            if (actualLine == -1) {
                Document document = PsiDocumentManager.getInstance((Project)pointer.getProject()).getDocument(psiFile);
                LOG.assertTrue(document != null);
                Segment range = pointer.getRange();
                resultLine = range == null ? -1 : document.getLineNumber(range.getStartOffset()) + 1;
            } else {
                resultLine = actualLine + 1;
            }
            Element lineElement = new Element("line");
            lineElement.addContent(String.valueOf(resultLine));
            problem.addContent(lineElement);
            RefManagerImpl.appendModule(problem, refElement.getModule());
        } else if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            VirtualFile moduleFile = refModule.getModule().getModuleFile();
            Element fileElement = new Element("file");
            fileElement.addContent(moduleFile != null ? moduleFile.getUrl() : refEntity.getName());
            problem.addContent(fileElement);
            RefManagerImpl.appendModule(problem, refModule);
        }
        for (RefManagerExtension<?> extension : this.myExtensions.values()) {
            extension.export(refEntity, problem);
        }
        new SmartRefElementPointerImpl(refEntity, true).writeExternal(problem);
        return problem;
    }

    @Nullable
    public Element export(@NotNull RefEntity entity) {
        Element element;
        if (entity == null) {
            RefManagerImpl.$$$reportNull$$$0(11);
        }
        if ((element = this.export(entity, -1)) == null) {
            return null;
        }
        if (!(entity instanceof RefElement)) {
            return element;
        }
        RefElement refElement = (RefElement)entity;
        SmartPsiElementPointer pointer = refElement.getPointer();
        PsiElement psiElement = pointer.getElement();
        Element language = new Element("language");
        language.addContent(psiElement != null ? psiElement.getLanguage().getID() : "");
        element.addContent(language);
        PsiFile psiFile = pointer.getContainingFile();
        if (psiFile == null) {
            return element;
        }
        Document document = PsiDocumentManager.getInstance((Project)pointer.getProject()).getDocument(psiFile);
        if (document == null) {
            return element;
        }
        Segment range = pointer.getRange();
        if (range == null) {
            return element;
        }
        int firstRangeLine = document.getLineNumber(range.getStartOffset());
        int lineStartOffset = document.getLineStartOffset(firstRangeLine);
        int endOffset = Math.min(range.getEndOffset(), document.getLineEndOffset(firstRangeLine));
        TextRange exportedRange = new TextRange(range.getStartOffset(), endOffset);
        String text = ProblemDescriptorUtil.extractHighlightedText(exportedRange, (PsiElement)psiFile);
        element.addContent(new Element("offset").addContent(String.valueOf(exportedRange.getStartOffset() - lineStartOffset)));
        element.addContent(new Element("length").addContent(String.valueOf(exportedRange.getLength())));
        element.addContent(new Element("highlighted_element").addContent(ProblemDescriptorUtil.sanitizeIllegalXmlChars(text)));
        return element;
    }

    @Nullable
    public String getGroupName(@NotNull RefElement entity) {
        RefEntity parent;
        if (entity == null) {
            RefManagerImpl.$$$reportNull$$$0(12);
        }
        for (RefManagerExtension<?> extension : this.myExtensions.values()) {
            String groupName = extension.getGroupName((RefEntity)entity);
            if (groupName == null) continue;
            return groupName;
        }
        for (parent = entity.getOwner(); parent != null && !(parent instanceof RefDirectory); parent = parent.getOwner()) {
        }
        LinkedList<String> containingDirs = new LinkedList<String>();
        while (parent instanceof RefDirectory) {
            containingDirs.addFirst(parent.getName());
            parent = parent.getOwner();
        }
        return containingDirs.isEmpty() ? null : StringUtil.join(containingDirs, (String)"/");
    }

    private static void appendModule(Element problem, RefModule refModule) {
        if (refModule != null) {
            Element moduleElement = new Element("module");
            moduleElement.addContent(refModule.getName());
            problem.addContent(moduleElement);
        }
    }

    public void findAllDeclarations() {
        AnalysisScope scope = this.getScope();
        if (scope == null) {
            return;
        }
        if (!this.myDeclarationsFound.getAndSet(true)) {
            long before = System.currentTimeMillis();
            this.startTaskWorkers();
            if (!Registry.is((String)"batch.inspections.visit.psi.in.parallel")) {
                scope.accept((PsiElementVisitor)this.myProjectIterator);
            } else {
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                scope.accept(vFile -> {
                    this.executeTask(() -> {
                        PsiFile file = psiManager.findFile(vFile);
                        if (file != null && ProblemHighlightFilter.shouldProcessFileInBatch((PsiFile)file)) {
                            file.accept((PsiElementVisitor)this.myProjectIterator);
                        }
                    });
                    return true;
                });
                this.waitForWorkersToFinish();
            }
            LOG.info("Total duration of processing project usages: " + (System.currentTimeMillis() - before) + "ms");
        }
    }

    private void waitForWorkersToFinish() {
        if (this.myTasksInFlight.decrementAndGet() == 0) {
            return;
        }
        while (true) {
            try {
                do {
                    ProgressManager.checkCanceled();
                    this.myLatch.await(100L, TimeUnit.MILLISECONDS);
                } while (this.myTasksInFlight.intValue() != 0);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void buildReferences(RefElement element) {
        if (element.areReferencesBuilt()) {
            return;
        }
        this.executeTask(() -> {
            element.initializeIfNeeded();
            element.buildReferences();
            this.fireBuildReferences(element);
        });
    }

    public void executeTask(@Async.Schedule @NotNull Runnable runnable) {
        if (runnable == null) {
            RefManagerImpl.$$$reportNull$$$0(13);
        }
        if (this.myTasks != null) {
            this.myTasksInFlight.incrementAndGet();
            try {
                this.myTasks.put(runnable);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            runnable.run();
        }
    }

    private void startTaskWorkers() {
        if (this.myExecutor == null) {
            return;
        }
        this.myTasksInFlight.incrementAndGet();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ProgressIndicator progressIndicator = indicator == null && ApplicationManager.getApplication().isUnitTestMode() ? new EmptyProgressIndicator() : indicator;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            while (this.myTasksInFlight.intValue() != 0) {
                try {
                    Runnable task = this.myTasks.poll(50L, TimeUnit.MILLISECONDS);
                    ProgressManager.checkCanceled();
                    if (task == null) continue;
                    this.runTask(progressIndicator, task);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    private void runTask(ProgressIndicator progressIndicator, @Async.Execute Runnable task) {
        ReadAction.nonBlocking(() -> {
            try {
                task.run();
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }).inSmartMode(this.myProject).wrapProgress(progressIndicator).submit((Executor)this.myExecutor).onSuccess(x -> {
            if (this.myTasksInFlight.decrementAndGet() == 0) {
                this.myLatch.countDown();
            }
        });
    }

    public boolean isDeclarationsFound() {
        return this.myDeclarationsFound.get();
    }

    public void runInsideInspectionReadAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            RefManagerImpl.$$$reportNull$$$0(14);
        }
        this.myIsInProcess = true;
        try {
            runnable.run();
        }
        finally {
            this.myIsInProcess = false;
            if (this.myScope != null) {
                this.myScope.invalidate();
            }
            this.myCachedSortedRefs = null;
        }
    }

    public void startOfflineView() {
        this.myOfflineView = true;
    }

    public boolean isOfflineView() {
        return this.myOfflineView;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RefManagerImpl.$$$reportNull$$$0(15);
        }
        return project;
    }

    @NotNull
    public RefProject getRefProject() {
        RefProject refProject = this.myRefProject;
        if (refProject == null) {
            RefManagerImpl.$$$reportNull$$$0(16);
        }
        return refProject;
    }

    @NotNull
    public List<RefElement> getSortedElements() {
        List<RefElement> answer = this.myCachedSortedRefs;
        if (answer != null) {
            List<RefElement> list = answer;
            if (list == null) {
                RefManagerImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        HashMap<VirtualFile, List> map = new HashMap<VirtualFile, List>();
        for (RefElement ref : this.getElements()) {
            map.computeIfAbsent(((RefElementImpl)ref).getVirtualFile(), k -> new ArrayList()).add(ref);
        }
        for (List elementsInFile : map.values()) {
            if (elementsInFile.size() <= 1) continue;
            ReadAction.run(() -> elementsInFile.sort(Comparator.comparing(o -> (Segment)ObjectUtils.notNull((Object)o.getPointer().getRange(), (Object)TextRange.EMPTY_RANGE), Segment.BY_START_OFFSET_THEN_END_OFFSET)));
        }
        this.myCachedSortedRefs = Collections.unmodifiableList(((EntryStream)EntryStream.of(map).sorted((e1, e2) -> VfsUtilCore.compareByPath((VirtualFile)((VirtualFile)e1.getKey()), (VirtualFile)((VirtualFile)e2.getKey())))).values().toFlatList(Function.identity()));
        if (this.myCachedSortedRefs == null) {
            RefManagerImpl.$$$reportNull$$$0(18);
        }
        return this.myCachedSortedRefs;
    }

    @NotNull
    public List<RefElement> getElements() {
        return new ArrayList<RefElement>(this.myRefTable.values());
    }

    @NotNull
    public PsiManager getPsiManager() {
        PsiManager psiManager = this.myPsiManager;
        if (psiManager == null) {
            RefManagerImpl.$$$reportNull$$$0(19);
        }
        return psiManager;
    }

    public synchronized boolean isInGraph(VirtualFile file) {
        return !this.myUnprocessedFiles.contains(file);
    }

    @Nullable
    public PsiNamedElement getContainerElement(@NotNull PsiElement element) {
        Language language;
        RefManagerExtension<?> extension;
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(20);
        }
        if ((extension = this.myLanguageExtensions.get(language = element.getLanguage())) == null) {
            return null;
        }
        return extension.getElementContainer(element);
    }

    private synchronized void registerUnprocessed(VirtualFile virtualFile) {
        this.myUnprocessedFiles.add(virtualFile);
    }

    private void removeReference(@NotNull RefElement refElem) {
        PsiElement element;
        RefManagerExtension<?> extension;
        if (refElem == null) {
            RefManagerImpl.$$$reportNull$$$0(21);
        }
        RefManagerExtension<?> refManagerExtension = extension = (element = refElem.getPsiElement()) != null ? this.getExtension(element.getLanguage()) : null;
        if (extension != null) {
            extension.removeReference(refElem);
        }
        if (element != null && this.myRefTable.remove(RefManagerImpl.createAnchor(element)) != null) {
            return;
        }
        for (Map.Entry<PsiAnchor, RefElement> entry : this.myRefTable.entrySet()) {
            RefElement value = entry.getValue();
            PsiAnchor anchor = entry.getKey();
            if (value != refElem) continue;
            this.myRefTable.remove(anchor);
            break;
        }
        this.myCachedSortedRefs = null;
    }

    @NotNull
    private static PsiAnchor createAnchor(@NotNull PsiElement element) {
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(22);
        }
        PsiAnchor psiAnchor = (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create((PsiElement)element));
        if (psiAnchor == null) {
            RefManagerImpl.$$$reportNull$$$0(23);
        }
        return psiAnchor;
    }

    public void initializeAnnotators() {
        for (RefGraphAnnotator annotator : EP_NAME.getExtensionList()) {
            this.registerGraphAnnotator(annotator);
        }
    }

    @Nullable
    public RefElement getReference(@Nullable PsiElement elem) {
        return this.getReference(elem, false);
    }

    @Nullable
    public RefElement getReference(PsiElement elem, boolean ignoreScope) {
        if (((Boolean)ReadAction.compute(() -> elem == null || !elem.isValid() || elem instanceof LightElement || !(elem instanceof PsiDirectory) && !this.belongsToScope(elem, ignoreScope))).booleanValue()) {
            return null;
        }
        return this.getFromRefTableOrCache(elem, () -> (RefElementImpl)ReadAction.compute(() -> {
            RefElement refElement;
            RefManagerExtension<?> extension = this.getExtension(elem.getLanguage());
            if (extension != null && (refElement = extension.createRefElement(elem)) != null) {
                return (RefElementImpl)refElement;
            }
            if (elem instanceof PsiFile) {
                PsiFile file = (PsiFile)elem;
                return new RefFileImpl(file, (RefManager)this);
            }
            if (elem instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)elem;
                return new RefDirectoryImpl(dir, (RefManager)this);
            }
            return null;
        }), element -> ReadAction.run(() -> element.initializeIfNeeded()));
    }

    private RefManagerExtension<?> getExtension(Language language) {
        return this.myLanguageExtensions.get(language);
    }

    @Nullable
    public RefEntity getReference(String type, String fqName) {
        for (RefManagerExtension<?> extension : this.myExtensions.values()) {
            RefEntity refEntity = extension.getReference(type, fqName);
            if (refEntity == null) continue;
            return refEntity;
        }
        if ("file".equals(type)) {
            return RefFileImpl.fileFromExternalName(this, fqName);
        }
        if ("module".equals(type)) {
            return RefModuleImpl.moduleFromName(this, fqName);
        }
        if ("project".equals(type)) {
            return this.getRefProject();
        }
        if ("dir".equals(type)) {
            String url = VfsUtilCore.pathToUrl((String)PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPath(fqName));
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vFile != null) {
                PsiDirectory dir = PsiManager.getInstance((Project)this.getProject()).findDirectory(vFile);
                return this.getReference((PsiElement)dir);
            }
        }
        return null;
    }

    @Nullable
    public <T extends RefElement> T getFromRefTableOrCache(@NotNull PsiElement element, @NotNull Supplier<@Nullable T> factory) {
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(24);
        }
        if (factory == null) {
            RefManagerImpl.$$$reportNull$$$0(25);
        }
        return this.getFromRefTableOrCache(element, factory, null);
    }

    @Nullable
    public <T extends RefElement> T getFromRefTableOrCache(@NotNull PsiElement element, @NotNull Supplier<@Nullable T> factory, @Nullable Consumer<? super T> whenCached) {
        PsiAnchor psiAnchor;
        RefElement result;
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(26);
        }
        if (factory == null) {
            RefManagerImpl.$$$reportNull$$$0(27);
        }
        if ((result = this.myRefTable.get(psiAnchor = RefManagerImpl.createAnchor(element))) != null) {
            return (T)result;
        }
        if (!this.isValidPointForReference()) {
            return null;
        }
        RefElement newElement = (RefElement)factory.get();
        if (newElement == null) {
            return null;
        }
        this.myCachedSortedRefs = null;
        RefElement prev = this.myRefTable.putIfAbsent(psiAnchor, newElement);
        if (prev != null) {
            return (T)prev;
        }
        if (whenCached != null) {
            whenCached.accept(newElement);
        }
        return (T)newElement;
    }

    public RefModule getRefModule(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        RefModule refModule = (RefModule)this.myModules.get(module);
        if (refModule == null) {
            refModule = (RefModule)ConcurrencyUtil.cacheOrGet(this.myModules, (Object)module, (Object)new RefModuleImpl(module, (RefManager)this));
        }
        return refModule;
    }

    public boolean belongsToScope(PsiElement psiElement) {
        return this.belongsToScope(psiElement, false);
    }

    private boolean belongsToScope(PsiElement psiElement, boolean ignoreScope) {
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        if (psiElement instanceof PsiCompiledElement) {
            return false;
        }
        PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiElement)psiElement).getContainingFile());
        if (containingFile == null) {
            return false;
        }
        for (RefManagerExtension<?> extension : this.myExtensions.values()) {
            if (extension.belongsToScope(psiElement)) continue;
            return false;
        }
        Boolean inProject = (Boolean)ReadAction.compute(() -> psiElement.getManager().isInProject(psiElement));
        return !(inProject == false && !ScratchUtil.isScratch((VirtualFile)containingFile.getVirtualFile()) || !ignoreScope && this.getScope() != null && !this.getScope().contains(psiElement));
    }

    public String getQualifiedName(RefEntity refEntity) {
        if (refEntity == null || refEntity instanceof RefElementImpl && !refEntity.isValid()) {
            return AnalysisBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return refEntity.getQualifiedName();
    }

    public void removeRefElement(@NotNull RefElement refElement, @NotNull List<? super RefElement> deletedRefs) {
        RefElement[] refElements;
        if (refElement == null) {
            RefManagerImpl.$$$reportNull$$$0(28);
        }
        if (deletedRefs == null) {
            RefManagerImpl.$$$reportNull$$$0(29);
        }
        refElement.initializeIfNeeded();
        List children = refElement.getChildren();
        for (RefElement refChild : refElements = children.toArray(new RefElement[0])) {
            this.removeRefElement(refChild, deletedRefs);
        }
        ((RefManagerImpl)refElement.getRefManager()).removeReference(refElement);
        ((RefElementImpl)refElement).referenceRemoved();
        if (!deletedRefs.contains(refElement)) {
            deletedRefs.add((RefElement)refElement);
        } else {
            LOG.error("deleted second time");
        }
    }

    public boolean isValidPointForReference() {
        return this.myIsInProcess || this.myOfflineView || ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 15, 16, 17, 18, 19, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElem";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefinedElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefProject";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedElements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "internName";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerGraphAnnotator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRefinedElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runInsideInspectionReadAction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContainerElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeReference";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAnchor";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFromRefTableOrCache";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeRefElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 15, 16, 17, 18, 19, 23 -> new IllegalStateException(string);
        };
    }

    private class ProjectIterator
    extends PsiElementVisitor {
        private ProjectIterator() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ProjectIterator.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            RefManagerExtension<?> extension = RefManagerImpl.this.getExtension(element.getLanguage());
            if (extension != null) {
                PsiElement current = element;
                while (current != null) {
                    extension.visitElement(current);
                    current = ProjectIterator.depthFirstNext(current, element);
                }
            } else if (RefManagerImpl.this.processExternalElements) {
                this.processExternalElements(element);
            }
        }

        private void processExternalElements(@NotNull PsiElement element) {
            PsiFile file;
            if (element == null) {
                ProjectIterator.$$$reportNull$$$0(1);
            }
            if ((file = element.getContainingFile()) != null) {
                RefManagerExtension externalFileManagerExtension = (RefManagerExtension)ContainerUtil.find(RefManagerImpl.this.myExtensions.values(), ex -> ex.shouldProcessExternalFile(file));
                if (externalFileManagerExtension == null) {
                    VirtualFile virtualFile;
                    if (element instanceof PsiFile && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) instanceof VirtualFileWithId) {
                        RefManagerImpl.this.registerUnprocessed(virtualFile);
                    }
                } else {
                    RefElement refFile = RefManagerImpl.this.getReference((PsiElement)file);
                    LOG.assertTrue(refFile != null, (Object)file);
                    PsiElement current = element;
                    while (current != null) {
                        for (PsiReference reference : current.getReferences()) {
                            PsiElement resolve = reference.resolve();
                            if (resolve == null) continue;
                            RefManagerImpl.this.fireNodeMarkedReferenced(resolve, (PsiElement)file);
                            RefElement refWhat = RefManagerImpl.this.getReference(resolve);
                            if (refWhat == null) {
                                PsiFile targetContainingFile = resolve.getContainingFile();
                                if (file == targetContainingFile) continue;
                                refWhat = RefManagerImpl.this.getReference((PsiElement)targetContainingFile);
                            }
                            if (refWhat == null) continue;
                            ((WritableRefElement)refWhat).addInReference(refFile);
                            ((WritableRefElement)refFile).addOutReference(refWhat);
                        }
                        current = ProjectIterator.depthFirstNext(current, element);
                    }
                    Stream implicitRefs = externalFileManagerExtension.extractExternalFileImplicitReferences(file);
                    implicitRefs.forEach(e -> {
                        RefElement superClassReference = RefManagerImpl.this.getReference((PsiElement)e);
                        if (superClassReference != null) {
                            ((RefElementImpl)refFile).addOutReference(superClassReference);
                        }
                    });
                    if (element instanceof PsiFile) {
                        externalFileManagerExtension.markExternalReferencesProcessed(refFile);
                    }
                }
            }
        }

        private static PsiElement depthFirstNext(PsiElement current, PsiElement root) {
            PsiElement child = current.getFirstChild();
            if (child != null) {
                return child;
            }
            if (current == root) {
                return null;
            }
            PsiElement sibling = current.getNextSibling();
            if (sibling != null) {
                return sibling;
            }
            PsiElement parent;
            while ((parent = current.getParent()) != root && parent != null) {
                PsiElement parentSibling = parent.getNextSibling();
                if (parentSibling != null) {
                    return parentSibling;
                }
                current = parent;
            }
            return null;
        }

        public void visitFile(@NotNull PsiFile psiFile) {
            VirtualFile virtualFile;
            if (psiFile == null) {
                ProjectIterator.$$$reportNull$$$0(2);
            }
            if (!(psiFile instanceof PsiBinaryFile) && !psiFile.getFileType().isBinary()) {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                Set relevantLanguages = viewProvider.getLanguages();
                for (Language language : relevantLanguages) {
                    try {
                        this.visitElement((PsiElement)viewProvider.getPsi(language));
                    }
                    catch (ProcessCanceledException | IndexNotReadyException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                            LOG.error(psiFile.getName(), e);
                            continue;
                        }
                        LOG.error((Throwable)new RuntimeExceptionWithAttachments(e, new Attachment[]{new Attachment("diagnostics.txt", psiFile.getName())}));
                    }
                }
                RefManagerImpl.this.myPsiManager.dropResolveCaches();
            }
            if ((virtualFile = psiFile.getVirtualFile()) != null) {
                RefManagerImpl.this.executeTask(() -> {
                    String relative = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)RefManagerImpl.this.myProject, (boolean)true, (boolean)false);
                    RefManagerImpl.this.myContext.incrementJobDoneAmount(RefManagerImpl.this.myContext.getStdJobDescriptors().BUILD_GRAPH, relative);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/reference/RefManagerImpl$ProjectIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processExternalElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

