/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ClassicRootContainer;
import com.intellij.openapi.module.impl.scopes.ModuleScopeUtil;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScopeKt;
import com.intellij.openapi.module.impl.scopes.MultiverseRootContainer;
import com.intellij.openapi.module.impl.scopes.RootContainer;
import com.intellij.openapi.module.impl.scopes.RootContainerScope;
import com.intellij.openapi.module.impl.scopes.ScopeConstant;
import com.intellij.openapi.module.impl.scopes.ScopeRootDescriptor;
import com.intellij.openapi.module.impl.scopes.ScopeRootDescriptors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootEntry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import com.intellij.util.indexing.IndexingBundle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001,B\u001b\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u0006H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\n\u0010%\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010&\u001a\u00020\fH\u0002J\u0013\u0010'\u001a\u00020\u00162\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020\u0006H\u0014J\b\u0010+\u001a\u00020\u0019H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"8G\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006-"}, d2={"Lcom/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope;", "Lcom/intellij/openapi/module/impl/scopes/RootContainerScope;", "Lcom/intellij/psi/search/impl/VirtualFileEnumerationAware;", "module", "Lcom/intellij/openapi/module/Module;", "myOptions", "", "<init>", "(Lcom/intellij/openapi/module/Module;I)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "myVirtualFileEnumeration", "Lcom/intellij/psi/search/impl/VirtualFileEnumeration;", "myVFSModificationCount", "", "myRoots", "Lcom/intellij/openapi/module/impl/scopes/RootContainer;", "mainModules", "", "getMainModules$intellij_platform_analysis_impl", "()Ljava/util/List;", "hasOption", "", "option", "getDisplayName", "", "isSearchInModuleContent", "aModule", "testSources", "compare", "file1", "Lcom/intellij/openapi/vfs/VirtualFile;", "file2", "roots", "", "getRoots", "()Ljava/util/Collection;", "extractFileEnumeration", "doExtractFileEnumeration", "equals", "other", "", "calcHashCode", "toString", "RootCalculator", "intellij.platform.analysis.impl"})
public final class ModuleWithDependenciesScope
extends RootContainerScope
implements VirtualFileEnumerationAware {
    @NotNull
    private final Module module;
    @ScopeConstant
    private final int myOptions;
    @Nullable
    private volatile VirtualFileEnumeration myVirtualFileEnumeration;
    private volatile long myVFSModificationCount;
    @NotNull
    private final RootContainer myRoots;

    public ModuleWithDependenciesScope(@NotNull Module module, @ScopeConstant int myOptions) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        RootContainer rootContainer = new RootCalculator(module, myOptions).calculateRoots();
        Set set = ModuleWithDependenciesScopeKt.access$lazyModules(module, myOptions);
        boolean bl = ModuleScopeUtil.hasOption(myOptions, 2);
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(rootContainer, set, bl, project);
        this.module = module;
        this.myOptions = myOptions;
        this.myRoots = new RootCalculator(this.module, this.myOptions).calculateRoots();
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public List<Module> getMainModules$intellij_platform_analysis_impl() {
        return CollectionsKt.listOf((Object)this.module);
    }

    private final boolean hasOption(@ScopeConstant int option) {
        return ModuleScopeUtil.hasOption(this.myOptions, option);
    }

    @NotNull
    public String getDisplayName() {
        String string;
        if (this.hasOption(1)) {
            Object[] objectArray = new Object[]{this.module.getName()};
            String string2 = IndexingBundle.message((String)"search.scope.module", (Object[])objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{this.module.getName()};
            String string3 = IndexingBundle.message((String)"search.scope.module.runtime", (Object[])objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
        return this.isSearchInModuleContent(aModule) && (this.hasOption(8) || !testSources);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
        VirtualFile r1 = this.getMyProjectFileIndex().getModuleSourceOrLibraryClassesRoot(file1);
        VirtualFile r2 = this.getMyProjectFileIndex().getModuleSourceOrLibraryClassesRoot(file2);
        if (Comparing.equal((Object)r1, (Object)r2)) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        RootContainer roots = this.myRoots;
        int i1 = roots.getPriority(r1);
        int i2 = roots.getPriority(r2);
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    @TestOnly
    @NotNull
    public final Collection<VirtualFile> getRoots() {
        return this.myRoots.getSortedRoots();
    }

    @Nullable
    public VirtualFileEnumeration extractFileEnumeration() {
        VirtualFileEnumeration enumeration = this.myVirtualFileEnumeration;
        long currentVFSStamp = VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS.getModificationCount();
        if (currentVFSStamp != this.myVFSModificationCount) {
            this.myVirtualFileEnumeration = enumeration = this.doExtractFileEnumeration();
            this.myVFSModificationCount = currentVFSStamp;
        }
        return enumeration == VirtualFileEnumeration.EMPTY ? null : enumeration;
    }

    private final VirtualFileEnumeration doExtractFileEnumeration() {
        if (this.myRoots.getSize() > 1 && (this.hasOption(4) && this.getAllModules().size() > 1 || this.hasOption(2))) {
            VirtualFileEnumeration virtualFileEnumeration = VirtualFileEnumeration.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileEnumeration, (String)"EMPTY");
            return virtualFileEnumeration;
        }
        return ModuleScopeUtil.getFileEnumerationUnderRoots(this.myRoots.getRoots());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(((Object)((Object)this)).getClass(), other.getClass())) {
            return false;
        }
        ModuleWithDependenciesScope that = (ModuleWithDependenciesScope)((Object)other);
        return this.myOptions == that.myOptions && Intrinsics.areEqual((Object)this.module, (Object)that.module);
    }

    protected int calcHashCode() {
        return 31 * this.module.hashCode() + this.myOptions;
    }

    @NotNull
    public String toString() {
        return "Module-with-dependencies:" + this.module.getName() + " compile-only:" + this.hasOption(1) + " include-libraries:" + this.hasOption(2) + " include-other-modules:" + this.hasOption(4) + " include-tests:" + this.hasOption(8);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/module/impl/scopes/ModuleWithDependenciesScope$RootCalculator;", "", "module", "Lcom/intellij/openapi/module/Module;", "myOptions", "", "<init>", "(Lcom/intellij/openapi/module/Module;I)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getMyOptions", "()I", "calculateRoots", "Lcom/intellij/openapi/module/impl/scopes/RootContainer;", "calcRoots", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "calcRootsMultiverse", "", "Lcom/intellij/openapi/module/impl/scopes/ScopeRootDescriptor;", "intellij.platform.analysis.impl"})
    private static final class RootCalculator {
        @NotNull
        private final Module module;
        private final int myOptions;

        public RootCalculator(@NotNull Module module, int myOptions) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.module = module;
            this.myOptions = myOptions;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        public final int getMyOptions() {
            return this.myOptions;
        }

        @NotNull
        public final RootContainer calculateRoots() {
            Project project = this.module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return CodeInsightContexts.isSharedSourceSupportEnabled((Project)project) ? (RootContainer)new MultiverseRootContainer(this.calcRootsMultiverse()) : (RootContainer)new ClassicRootContainer(this.calcRoots());
        }

        private final Object2IntMap<VirtualFile> calcRoots() {
            OrderRootsEnumerator orderRootsEnumerator = ModuleScopeUtil.getOrderEnumeratorForOptions(this.module, this.myOptions).roots(arg_0 -> RootCalculator.calcRoots$lambda$1(RootCalculator::calcRoots$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)orderRootsEnumerator, (String)"roots(...)");
            OrderRootsEnumerator en = orderRootsEnumerator;
            LinkedHashSet roots = new LinkedHashSet();
            VirtualFile[] virtualFileArray = en.getRoots();
            Collections.addAll(roots, Arrays.copyOf(virtualFileArray, virtualFileArray.length));
            int i = 1;
            Object2IntOpenHashMap map = new Object2IntOpenHashMap(roots.size());
            Iterator iterator = roots.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                VirtualFile root = (VirtualFile)e;
                map.put((Object)root, i++);
            }
            return (Object2IntMap)map;
        }

        private final Map<VirtualFile, ScopeRootDescriptor> calcRootsMultiverse() {
            OrderRootsEnumerator orderRootsEnumerator = ModuleScopeUtil.getOrderEnumeratorForOptions(this.module, this.myOptions).roots(arg_0 -> RootCalculator.calcRootsMultiverse$lambda$1(RootCalculator::calcRootsMultiverse$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)orderRootsEnumerator, (String)"roots(...)");
            OrderRootsEnumerator en = orderRootsEnumerator;
            Collection collection = en.getRootEntries();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRootEntries(...)");
            Collection entries = collection;
            int i = 1;
            HashMap map = new HashMap(entries.size());
            for (RootEntry root : entries) {
                Map map2 = map;
                VirtualFile virtualFile = root.root();
                VirtualFile virtualFile2 = root.root();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"root(...)");
                OrderEntry orderEntry = root.orderEntry();
                Intrinsics.checkNotNullExpressionValue((Object)orderEntry, (String)"orderEntry(...)");
                ScopeRootDescriptor scopeRootDescriptor = ScopeRootDescriptors.ScopeRootDescriptor(virtualFile2, orderEntry, i++);
                map2.put(virtualFile, scopeRootDescriptor);
            }
            return map;
        }

        private static final OrderRootType calcRoots$lambda$0(OrderEntry entry) {
            if (entry instanceof ModuleOrderEntry || entry instanceof ModuleSourceOrderEntry) {
                return OrderRootType.SOURCES;
            }
            return OrderRootType.CLASSES;
        }

        private static final OrderRootType calcRoots$lambda$1(Function1 $tmp0, Object p0) {
            return (OrderRootType)$tmp0.invoke(p0);
        }

        private static final OrderRootType calcRootsMultiverse$lambda$0(OrderEntry entry) {
            return entry instanceof ModuleOrderEntry || entry instanceof ModuleSourceOrderEntry ? OrderRootType.SOURCES : OrderRootType.CLASSES;
        }

        private static final OrderRootType calcRootsMultiverse$lambda$1(Function1 $tmp0, Object p0) {
            return (OrderRootType)$tmp0.invoke(p0);
        }
    }
}

