// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.*;

import java.util.List;

@ApiStatus.Internal
final class InjectedLanguageFragmentSyntaxUtil {
  @Contract(pure = true)
  static @NotNull @Unmodifiable List<@NotNull HighlightInfo> addSyntaxInjectedFragmentInfo(@NotNull EditorColorsScheme scheme,
                                                                                           @NotNull TextRange hostRange,
                                                                                           TextAttributesKey @NotNull [] keys,
                                                                                           @Nullable Object toolId) {
    if (hostRange.isEmpty()) {
      return List.of();
    }
    // erase marker to override hosts colors
    HighlightInfo eraseInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT)
      .range(hostRange)
      .textAttributes(TextAttributes.ERASE_MARKER)
      .createUnconditionally();
    eraseInfo.toolId = toolId;
    eraseInfo.markFromInjection();
    if (toolId != null) {
      eraseInfo.setGroup(HighlightInfoUpdaterImpl.MANAGED_HIGHLIGHT_INFO_GROUP);
    }
    LayeredTextAttributes injectedAttributes = LayeredTextAttributes.create(scheme, keys);
    if (injectedAttributes.isEmpty() || keys.length == 1 && keys[0] == HighlighterColors.TEXT) {
      // nothing to add
      return List.of(eraseInfo);
    }

    HighlightInfo injectedInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT)
      .range(hostRange)
      .textAttributes(injectedAttributes)
      .createUnconditionally();
    injectedInfo.toolId = toolId;
    injectedInfo.markFromInjection();
    if (toolId != null) {
      injectedInfo.setGroup(HighlightInfoUpdaterImpl.MANAGED_HIGHLIGHT_INFO_GROUP);
    }
    return List.of(eraseInfo, injectedInfo);
  }
}
