/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.modcompletion.ModCompletionItemProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferencesWrapper;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.PairConsumer;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class LegacyCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(LegacyCompletionContributor.class);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet _result) {
        if (parameters == null) {
            LegacyCompletionContributor.$$$reportNull$$$0(0);
        }
        if (_result == null) {
            LegacyCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        if (ModCompletionItemProvider.modCommandCompletionEnabled()) {
            return;
        }
        CompletionData completionData = LegacyCompletionContributor.getCompletionData(parameters);
        if (completionData == null) {
            return;
        }
        PsiElement insertedElement = parameters.getPosition();
        CompletionResultSet result = _result.withPrefixMatcher(completionData.findPrefix(insertedElement, parameters.getOffset()));
        LegacyCompletionContributor.completeReference(parameters, result);
        if (DumbService.isDumb((Project)insertedElement.getProject())) {
            return;
        }
        LinkedHashSet<LookupElement> lookupSet = new LinkedHashSet<LookupElement>();
        HashSet keywordVariants = new HashSet();
        PsiFile file = parameters.getOriginalFile();
        completionData.addKeywordVariants(keywordVariants, insertedElement, file);
        completionData.completeKeywordsBySet(lookupSet, keywordVariants);
        result.addAllElements(lookupSet);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiFile file;
        PsiElement element;
        if (context == null) {
            LegacyCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((element = (file = context.getFile()).findElementAt(context.getStartOffset())) instanceof PsiWhiteSpace && element.textContains('\n') && element.getTextRange().getStartOffset() == context.getStartOffset()) {
            context.setReplacementOffset(context.getStartOffset());
        }
    }

    public static boolean completeReference(CompletionParameters parameters, CompletionResultSet result) {
        CompletionData completionData = LegacyCompletionContributor.getCompletionData(parameters);
        if (completionData == null) {
            return false;
        }
        Ref hasVariants = Ref.create((Object)false);
        LegacyCompletionContributor.processReferences(parameters, result, (PairConsumer<? super PsiReference, ? super CompletionResultSet>)((PairConsumer)(reference, resultSet) -> {
            LinkedHashSet lookupSet = new LinkedHashSet();
            completionData.completeReference((PsiReference)reference, lookupSet, parameters.getPosition(), parameters.getOriginalFile());
            for (LookupElement item : lookupSet) {
                if (!resultSet.getPrefixMatcher().prefixMatches(item)) continue;
                if (!item.isValid()) {
                    LOG.error(String.valueOf(completionData) + " has returned an invalid lookup element " + String.valueOf(item) + " of " + String.valueOf(item.getClass()) + " in " + String.valueOf(parameters.getOriginalFile()) + " of " + String.valueOf(parameters.getOriginalFile().getClass()) + "; reference=" + String.valueOf(reference) + " of " + String.valueOf(reference.getClass()));
                }
                hasVariants.set((Object)true);
                resultSet.addElement(item);
            }
        }));
        return (Boolean)hasVariants.get();
    }

    private static CompletionData getCompletionData(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        return CompletionUtil.getCompletionDataByElement(position, parameters.getOriginalFile());
    }

    public static void processReferences(CompletionParameters parameters, CompletionResultSet result, PairConsumer<? super PsiReference, ? super CompletionResultSet> consumer) {
        int startOffset = parameters.getOffset();
        PsiReference ref = parameters.getPosition().getContainingFile().findReferenceAt(startOffset);
        if (ref instanceof PsiMultiReference) {
            PsiMultiReference multi = (PsiMultiReference)ref;
            for (PsiReference reference : CompletionData.getReferences(multi)) {
                if (reference instanceof PsiReferencesWrapper) {
                    PsiReferencesWrapper wrapper = (PsiReferencesWrapper)reference;
                    for (PsiReference r : wrapper.getReferences()) {
                        LegacyCompletionContributor.processReference(result, startOffset, consumer, r);
                    }
                    continue;
                }
                LegacyCompletionContributor.processReference(result, startOffset, consumer, reference);
            }
        } else if (ref instanceof PsiDynaReference) {
            PsiDynaReference dyna = (PsiDynaReference)ref;
            for (PsiReference reference : dyna.getReferences()) {
                LegacyCompletionContributor.processReference(result, startOffset, consumer, reference);
            }
        } else if (ref != null) {
            LegacyCompletionContributor.processReference(result, startOffset, consumer, ref);
        }
    }

    private static void processReference(CompletionResultSet result, int startOffset, PairConsumer<? super PsiReference, ? super CompletionResultSet> consumer, PsiReference reference) {
        PsiElement element = reference.getElement();
        int offsetInElement = startOffset - element.getTextRange().getStartOffset();
        if (!ReferenceRange.containsOffsetInElement((PsiReference)reference, (int)offsetInElement)) {
            return;
        }
        TextRange range = reference.getRangeInElement();
        try {
            String prefix = element.getText().substring(range.getStartOffset(), offsetInElement);
            consumer.consume((Object)reference, (Object)result.withPrefixMatcher(prefix));
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Reference=" + String.valueOf(reference) + "; element=" + String.valueOf(element) + " of " + String.valueOf(element.getClass()) + "; range=" + String.valueOf(range) + "; offset=" + offsetInElement, (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/LegacyCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

