/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BatchConsumer;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.group.CompletionGroup;
import com.intellij.codeInsight.completion.group.GroupedCompletionContributor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionService {
    public static final Key<CompletionStatistician> STATISTICS_KEY = Key.create((String)"completion");
    public static final Key<CompletionWeigher> RELEVANCE_KEY = Key.create((String)"completion");

    public static CompletionService getCompletionService() {
        return (CompletionService)ApplicationManager.getApplication().getService(CompletionService.class);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public abstract void setAdvertisementText(@NlsContexts.PopupAdvertisement @Nullable String var1);

    public void getVariantsFromContributors(@NotNull CompletionParameters parameters, @Nullable CompletionContributor from, @NotNull Consumer<? super CompletionResult> consumer) {
        if (parameters == null) {
            CompletionService.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            CompletionService.$$$reportNull$$$0(1);
        }
        this.getVariantsFromContributors(parameters, from, this.createMatcher(this.suggestPrefix(parameters), false), consumer);
    }

    protected void getVariantsFromContributors(@NotNull CompletionParameters parameters, @Nullable CompletionContributor from, @NotNull PrefixMatcher matcher, @NotNull Consumer<? super CompletionResult> consumer) {
        if (parameters == null) {
            CompletionService.$$$reportNull$$$0(2);
        }
        if (matcher == null) {
            CompletionService.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            CompletionService.$$$reportNull$$$0(4);
        }
        this.getVariantsFromContributors(parameters, from, matcher, consumer, null);
    }

    @ApiStatus.Experimental
    protected void getVariantsFromGroupContributors(@NotNull CompletionParameters parameters, @NotNull PrefixMatcher matcher, @NotNull Consumer<? super CompletionResult> consumer) {
        if (parameters == null) {
            CompletionService.$$$reportNull$$$0(5);
        }
        if (matcher == null) {
            CompletionService.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            CompletionService.$$$reportNull$$$0(7);
        }
        if (!GroupedCompletionContributor.isGroupEnabledInApp()) {
            return;
        }
        List<CompletionContributor> contributors = CompletionContributor.forParameters(parameters);
        for (int i = 0; i < contributors.size(); ++i) {
            GroupedCompletionContributor groupedCompletionContributor;
            CompletionContributor contributor = contributors.get(i);
            if (!(contributor instanceof GroupedCompletionContributor) || !(groupedCompletionContributor = (GroupedCompletionContributor)((Object)contributor)).groupIsEnabled(parameters)) continue;
            CompletionGroup completionGroup = new CompletionGroup(i, groupedCompletionContributor.getGroupDisplayName());
            CompletionResultSet result = this.createResultSet(parameters, (Consumer<? super CompletionResult>)((Consumer)r -> {
                r.getLookupElement().putUserData(CompletionGroup.COMPLETION_GROUP_KEY, completionGroup);
                consumer.consume(r);
            }), contributor, matcher);
            try {
                this.getVariantsFromContributor(parameters, contributor, result);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (!result.isStopped()) continue;
            return;
        }
    }

    protected void getVariantsFromContributors(@NotNull CompletionParameters parameters, @Nullable CompletionContributor from, @NotNull PrefixMatcher matcher, @NotNull Consumer<? super CompletionResult> consumer, @Nullable CompletionSorter customSorter) {
        int startingIndex;
        if (parameters == null) {
            CompletionService.$$$reportNull$$$0(8);
        }
        if (matcher == null) {
            CompletionService.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            CompletionService.$$$reportNull$$$0(10);
        }
        List<CompletionContributor> contributors = CompletionContributor.forParameters(parameters);
        boolean groupEnabledInApp = GroupedCompletionContributor.isGroupEnabledInApp();
        for (int i = startingIndex = from != null ? contributors.indexOf(from) + 1 : 0; i < contributors.size(); ++i) {
            GroupedCompletionContributor groupedCompletionContributor;
            ProgressManager.checkCanceled();
            CompletionContributor contributor = contributors.get(i);
            if (groupEnabledInApp && contributor instanceof GroupedCompletionContributor && (groupedCompletionContributor = (GroupedCompletionContributor)((Object)contributor)).groupIsEnabled(parameters)) continue;
            CompletionResultSet result = this.createResultSet(parameters, consumer, contributor, matcher);
            if (customSorter != null) {
                result = result.withRelevanceSorter(customSorter);
            }
            try {
                this.getVariantsFromContributor(parameters, contributor, result);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (!result.isStopped()) continue;
            return;
        }
    }

    @ApiStatus.Internal
    public void getVariantsFromContributor(@NotNull CompletionParameters params, @NotNull CompletionContributor contributor, @NotNull CompletionResultSet result) {
        if (params == null) {
            CompletionService.$$$reportNull$$$0(11);
        }
        if (contributor == null) {
            CompletionService.$$$reportNull$$$0(12);
        }
        if (result == null) {
            CompletionService.$$$reportNull$$$0(13);
        }
        contributor.fillCompletionVariants(params, result);
    }

    @ApiStatus.Internal
    @NotNull
    public abstract CompletionResultSet createResultSet(@NotNull CompletionParameters var1, @NotNull Consumer<? super CompletionResult> var2, @NotNull CompletionContributor var3, @NotNull PrefixMatcher var4);

    @NotNull
    protected abstract String suggestPrefix(@NotNull CompletionParameters var1);

    @NotNull
    protected abstract PrefixMatcher createMatcher(String var1, boolean var2);

    @Nullable
    public abstract CompletionProcess getCurrentCompletion();

    public void performCompletion(@NotNull CompletionParameters parameters, final @NotNull Consumer<? super CompletionResult> consumer) {
        if (parameters == null) {
            CompletionService.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            CompletionService.$$$reportNull$$$0(15);
        }
        final ConcurrentHashMap.KeySetView lookupSet = ConcurrentHashMap.newKeySet();
        final AtomicBoolean typoTolerant = new AtomicBoolean();
        BatchConsumer<CompletionResult> batchConsumer = new BatchConsumer<CompletionResult>(this){

            @Override
            public void startBatch() {
                if (consumer instanceof BatchConsumer) {
                    BatchConsumer c = (BatchConsumer)consumer;
                    c.startBatch();
                }
            }

            @Override
            public void endBatch() {
                if (consumer instanceof BatchConsumer) {
                    BatchConsumer c = (BatchConsumer)consumer;
                    c.endBatch();
                }
            }

            public void consume(CompletionResult result) {
                if (typoTolerant.get() && result.getLookupElement().getAutoCompletionPolicy() != AutoCompletionPolicy.NEVER_AUTOCOMPLETE) {
                    result = result.withLookupElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(result.getLookupElement()));
                }
                if (lookupSet.add(result.getLookupElement())) {
                    consumer.consume((Object)result);
                }
            }
        };
        String prefix = this.suggestPrefix(parameters);
        this.getVariantsFromContributors(parameters, null, this.createMatcher(prefix, false), (Consumer<? super CompletionResult>)batchConsumer);
        this.getVariantsFromGroupContributors(parameters, this.createMatcher(prefix, false), (Consumer<? super CompletionResult>)batchConsumer);
        if (lookupSet.isEmpty() && prefix.length() > 2) {
            typoTolerant.set(true);
            this.getVariantsFromContributors(parameters, null, this.createMatcher(prefix, true), (Consumer<? super CompletionResult>)batchConsumer);
            this.getVariantsFromGroupContributors(parameters, this.createMatcher(prefix, true), (Consumer<? super CompletionResult>)batchConsumer);
        }
    }

    @NotNull
    public abstract CompletionSorter defaultSorter(@NotNull CompletionParameters var1, @NotNull PrefixMatcher var2);

    @NotNull
    public abstract CompletionSorter emptySorter();

    @ApiStatus.Internal
    public static boolean isStartMatch(@NotNull LookupElement element, @NotNull WeighingContext context) {
        if (element == null) {
            CompletionService.$$$reportNull$$$0(16);
        }
        if (context == null) {
            CompletionService.$$$reportNull$$$0(17);
        }
        return CompletionService.getItemMatcher(element, context).isStartMatch(element);
    }

    @ApiStatus.Internal
    public static PrefixMatcher getItemMatcher(@NotNull LookupElement element, @NotNull WeighingContext context) {
        if (element == null) {
            CompletionService.$$$reportNull$$$0(18);
        }
        if (context == null) {
            CompletionService.$$$reportNull$$$0(19);
        }
        PrefixMatcher itemMatcher = context.itemMatcher(element);
        String pattern = context.itemPattern(element);
        if (!pattern.equals(itemMatcher.getPrefix())) {
            return itemMatcher.cloneWithPrefix(pattern);
        }
        return itemMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/CompletionService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariantsFromContributors";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariantsFromGroupContributors";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariantsFromContributor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "performCompletion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isStartMatch";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemMatcher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

