/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import org.jetbrains.annotations.ApiStatus;

public interface DocumentationMarkup {
    @ApiStatus.Internal
    public static final String CLASS_DEFINITION = "definition";
    @ApiStatus.Internal
    public static final String CLASS_CONTENT = "content";
    @ApiStatus.Internal
    public static final String CLASS_SECTIONS = "sections";
    @ApiStatus.Internal
    public static final String CLASS_SECTION = "section";
    @ApiStatus.Internal
    public static final String CLASS_GRAYED = "grayed";
    @ApiStatus.Internal
    public static final String CLASS_CENTERED = "centered";
    @ApiStatus.Internal
    public static final String CLASS_BOTTOM = "bottom";
    @ApiStatus.Internal
    public static final String CLASS_TOP = "top";
    @ApiStatus.Internal
    public static final String CLASS_DOWNLOAD_DOCUMENTATION = "download-documentation";
    @NlsSafe
    public static final String DEFINITION_START = "<div class='definition'><pre>";
    @NlsSafe
    public static final String DEFINITION_END = "</pre></div>";
    @NlsSafe
    public static final String CONTENT_START = "<div class='content'>";
    @NlsSafe
    public static final String CONTENT_END = "</div>";
    @NlsSafe
    public static final String SECTIONS_START = "<table class='sections'>";
    @NlsSafe
    public static final String SECTIONS_END = "</table>";
    @NlsSafe
    public static final String SECTION_HEADER_START = "<tr><td valign='top' class='section'><p>";
    @NlsSafe
    public static final String SECTION_SEPARATOR = "</td><td valign='top'>";
    @NlsSafe
    public static final String SECTION_START = "<td valign='top'>";
    @NlsSafe
    public static final String SECTION_END = "</td>";
    @NlsSafe
    public static final String GRAYED_START = "<span class='grayed'>";
    @NlsSafe
    public static final String GRAYED_END = "</span>";
    public static final HtmlChunk.Element SECTION_CONTENT_CELL = HtmlChunk.tag((String)"td").attr("valign", "top");
    public static final HtmlChunk.Element SECTION_HEADER_CELL = HtmlChunk.tag((String)"td").attr("valign", "top").setClass("section");
    public static final HtmlChunk.Element SECTIONS_TABLE = HtmlChunk.tag((String)"table").setClass("sections");
    public static final HtmlChunk.Element CONTENT_ELEMENT = HtmlChunk.div().setClass("content");
    public static final HtmlChunk.Element DEFINITION_ELEMENT = HtmlChunk.div().setClass("definition");
    public static final HtmlChunk.Element TOP_ELEMENT = HtmlChunk.div().setClass("top");
    public static final HtmlChunk.Element BOTTOM_ELEMENT = HtmlChunk.div().setClass("bottom");
    public static final HtmlChunk.Element PRE_ELEMENT = HtmlChunk.tag((String)"pre");
    public static final HtmlChunk.Element GRAYED_ELEMENT = HtmlChunk.span().setClass("grayed");
    public static final HtmlChunk.Element CENTERED_ELEMENT = HtmlChunk.p().setClass("centered");
    public static final HtmlChunk.Element EXTERNAL_LINK_ICON = HtmlChunk.tag((String)"icon").attr("src", "AllIcons.Ide.External_link_arrow");
    public static final HtmlChunk.Element INFORMATION_ICON = HtmlChunk.tag((String)"icon").attr("src", "AllIcons.General.Information");
}

