/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevelColoredIcon;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u0001H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J,\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/codeHighlighting/HighlightDisplayLevelColorizedIcon;", "Ljavax/swing/Icon;", "Lcom/intellij/codeHighlighting/HighlightDisplayLevelColoredIcon;", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "baseIcon", "<init>", "(Lcom/intellij/openapi/editor/colors/TextAttributesKey;Ljavax/swing/Icon;)V", "lastEditorColorManagerModCounter", "", "lastColor", "Ljava/awt/Color;", "getColor", "getIcon", "getColorFromAttributes", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "getIconWidth", "getIconHeight", "intellij.platform.analysis"})
@SourceDebugExtension(value={"SMAP\nHighlightDisplayLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightDisplayLevel.kt\ncom/intellij/codeHighlighting/HighlightDisplayLevelColorizedIcon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n1#2:228\n*E\n"})
final class HighlightDisplayLevelColorizedIcon
implements Icon,
HighlightDisplayLevelColoredIcon {
    @NotNull
    private final TextAttributesKey key;
    @NotNull
    private final Icon baseIcon;
    private long lastEditorColorManagerModCounter;
    @Nullable
    private Color lastColor;

    public HighlightDisplayLevelColorizedIcon(@NotNull TextAttributesKey key, @NotNull Icon baseIcon2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)baseIcon2, (String)"baseIcon");
        this.key = key;
        this.baseIcon = IconManager.Companion.getInstance().colorizedIcon(baseIcon2, (Function0)new Function0<Color>((Object)this){

            public final Color invoke() {
                return ((HighlightDisplayLevelColorizedIcon)this.receiver).getColor();
            }
        });
        this.lastEditorColorManagerModCounter = -1L;
    }

    @Override
    @NotNull
    public Color getColor() {
        Color color = this.getColorFromAttributes(this.key);
        if (color == null) {
            JBColor jBColor = JBColor.GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GRAY");
            color = (Color)jBColor;
        }
        return color;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.baseIcon;
    }

    private final Color getColorFromAttributes(TextAttributesKey key) {
        TextAttributes attributes;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        if (editorColorsManager == null) {
            TextAttributes textAttributes = key.getDefaultAttributes();
            if (textAttributes == null) {
                textAttributes = TextAttributes.ERASE_MARKER;
            }
            return textAttributes.getErrorStripeColor();
        }
        EditorColorsManager editorColorManager = editorColorsManager;
        Color color = this.lastColor;
        if (color != null) {
            Color color2;
            Color color3;
            Color it = color3 = color;
            boolean bl = false;
            Color color4 = color2 = editorColorManager.getSchemeModificationCounter() == this.lastEditorColorManagerModCounter ? color3 : null;
            if (color2 != null) {
                it = color2;
                boolean bl2 = false;
                return it;
            }
        }
        TextAttributes textAttributes = attributes = editorColorManager.getGlobalScheme().getAttributes(key);
        Color stripe = textAttributes != null ? textAttributes.getErrorStripeColor() : null;
        Color color5 = stripe;
        if (color5 == null) {
            if (attributes == null) {
                color5 = null;
            } else {
                color5 = attributes.getEffectColor();
                if (color5 == null && (color5 = attributes.getForegroundColor()) == null) {
                    color5 = attributes.getBackgroundColor();
                }
            }
        }
        Color result = color5;
        this.lastEditorColorManagerModCounter = editorColorManager.getSchemeModificationCounter();
        this.lastColor = result;
        return result;
    }

    @Override
    public void paintIcon(@Nullable Component c, @Nullable Graphics g, int x, int y) {
        this.baseIcon.paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.baseIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.baseIcon.getIconHeight();
    }
}

