/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModCommandService;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ReportingClassSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class QuickFixWrapper
implements IntentionAction,
PriorityAction,
CustomizableIntentionAction,
ReportingClassSubstitutor,
PossiblyDumbAware {
    private static final Logger LOG = Logger.getInstance(QuickFixWrapper.class);
    private final ProblemDescriptor myDescriptor;
    private final LocalQuickFix myFix;

    @NotNull
    public static IntentionAction wrap(@NotNull ProblemDescriptor descriptor, int fixNumber) {
        if (descriptor == null) {
            QuickFixWrapper.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(fixNumber >= 0, (Object)fixNumber);
        QuickFix[] fixes = descriptor.getFixes();
        LOG.assertTrue(fixes != null && fixes.length > fixNumber);
        QuickFix fix = fixes[fixNumber];
        if (fix instanceof IntentionAction) {
            IntentionAction intention;
            IntentionAction intentionAction = intention = (IntentionAction)((Object)fix);
            if (intentionAction == null) {
                QuickFixWrapper.$$$reportNull$$$0(1);
            }
            return intentionAction;
        }
        LocalQuickFix localFix = (LocalQuickFix)fix;
        return QuickFixWrapper.wrap(descriptor, localFix);
    }

    @NotNull
    public static IntentionAction wrap(@NotNull ProblemDescriptor descriptor, @NotNull LocalQuickFix fix) {
        if (descriptor == null) {
            QuickFixWrapper.$$$reportNull$$$0(2);
        }
        if (fix == null) {
            QuickFixWrapper.$$$reportNull$$$0(3);
        }
        if (fix instanceof IntentionAction) {
            IntentionAction intention;
            IntentionAction intentionAction = intention = (IntentionAction)((Object)fix);
            if (intentionAction == null) {
                QuickFixWrapper.$$$reportNull$$$0(4);
            }
            return intentionAction;
        }
        if (fix instanceof ModCommandQuickFix) {
            ModCommandQuickFix modCommandFix = (ModCommandQuickFix)fix;
            IntentionAction intention = new ModCommandQuickFixAction(descriptor, modCommandFix).asIntention();
            PsiFile file = descriptor.getPsiElement().getContainingFile();
            intention.isAvailable(file.getProject(), null, file);
            IntentionAction intentionAction = intention;
            if (intentionAction == null) {
                QuickFixWrapper.$$$reportNull$$$0(5);
            }
            return intentionAction;
        }
        return new QuickFixWrapper(descriptor, fix);
    }

    @Nullable
    public static LocalQuickFix unwrap(@NotNull CommonIntentionAction action) {
        if (action == null) {
            QuickFixWrapper.$$$reportNull$$$0(6);
        }
        if (action instanceof QuickFixWrapper) {
            QuickFixWrapper wrapper = (QuickFixWrapper)action;
            return wrapper.myFix;
        }
        if (action instanceof LocalQuickFixAsIntentionAdapter) {
            LocalQuickFixAsIntentionAdapter adapter = (LocalQuickFixAsIntentionAdapter)action;
            return adapter.getFix();
        }
        if (action instanceof LocalQuickFixOnPsiElementAsIntentionAdapter) {
            LocalQuickFixOnPsiElementAsIntentionAdapter adapter = (LocalQuickFixOnPsiElementAsIntentionAdapter)action;
            return adapter.getFix();
        }
        ModCommandAction modCommandAction = action.asModCommandAction();
        if (modCommandAction instanceof ModCommandQuickFixAction) {
            ModCommandQuickFixAction qfAction = (ModCommandQuickFixAction)modCommandAction;
            return qfAction.myFix;
        }
        return null;
    }

    @Nullable
    public static PsiFile unwrapFile(@NotNull IntentionAction action) {
        if (action == null) {
            QuickFixWrapper.$$$reportNull$$$0(7);
        }
        if (action instanceof QuickFixWrapper) {
            QuickFixWrapper wrapper = (QuickFixWrapper)action;
            return wrapper.getFile();
        }
        ModCommandAction modCommandAction = action.asModCommandAction();
        if (modCommandAction instanceof ModCommandQuickFixAction) {
            ModCommandQuickFixAction qfAction = (ModCommandQuickFixAction)modCommandAction;
            PsiElement element = qfAction.myDescriptor.getPsiElement();
            return element == null ? null : element.getContainingFile();
        }
        return null;
    }

    private QuickFixWrapper(@NotNull ProblemDescriptor descriptor, @NotNull LocalQuickFix fix) {
        if (descriptor == null) {
            QuickFixWrapper.$$$reportNull$$$0(8);
        }
        if (fix == null) {
            QuickFixWrapper.$$$reportNull$$$0(9);
        }
        this.myDescriptor = descriptor;
        this.myFix = fix;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myFix.getName();
        if (string == null) {
            QuickFixWrapper.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.myFix.getFamilyName();
        if (string == null) {
            QuickFixWrapper.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        PsiElement psiElement;
        if (project == null) {
            QuickFixWrapper.$$$reportNull$$$0(12);
        }
        if ((psiElement = this.myDescriptor.getPsiElement()) == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        return containingFile == psiFile || containingFile == null || containingFile.getViewProvider().getVirtualFile().equals(psiFile.getViewProvider().getVirtualFile());
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        PsiElement element;
        if (project == null) {
            QuickFixWrapper.$$$reportNull$$$0(13);
        }
        PsiFile fileForUndo = (element = this.myDescriptor.getPsiElement()) == null ? null : element.getContainingFile();
        this.myFix.applyFix(project, this.myDescriptor);
        DaemonCodeAnalyzer.getInstance(project).restart(this);
        if (fileForUndo != null && !fileForUndo.equals((Object)psiFile)) {
            UndoUtil.markPsiFileForUndo((PsiFile)fileForUndo);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return this.myFix.startInWriteAction();
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            QuickFixWrapper.$$$reportNull$$$0(14);
        }
        return this.myFix.getElementToMakeWritable(file);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public LocalQuickFix getFix() {
        LocalQuickFix localQuickFix = this.myFix;
        if (localQuickFix == null) {
            QuickFixWrapper.$$$reportNull$$$0(15);
        }
        return localQuickFix;
    }

    @Override
    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority;
        LocalQuickFix localQuickFix = this.myFix;
        if (localQuickFix instanceof PriorityAction) {
            PriorityAction priority2 = (PriorityAction)((Object)localQuickFix);
            priority = priority2.getPriority();
        } else {
            priority = PriorityAction.Priority.NORMAL;
        }
        if (priority == null) {
            QuickFixWrapper.$$$reportNull$$$0(16);
        }
        return priority;
    }

    @TestOnly
    @Nullable
    public static ProblemHighlightType getHighlightType(@NotNull IntentionAction action) {
        if (action == null) {
            QuickFixWrapper.$$$reportNull$$$0(17);
        }
        if (action instanceof QuickFixWrapper) {
            QuickFixWrapper wrapper = (QuickFixWrapper)action;
            return wrapper.myDescriptor.getHighlightType();
        }
        ModCommandAction modCommandAction = action.asModCommandAction();
        if (modCommandAction instanceof ModCommandQuickFixAction) {
            ModCommandQuickFixAction qfAction = (ModCommandQuickFixAction)modCommandAction;
            return qfAction.myDescriptor.getHighlightType();
        }
        return null;
    }

    @Nullable
    public PsiFile getFile() {
        PsiElement element = this.myDescriptor.getPsiElement();
        return element != null ? element.getContainingFile() : null;
    }

    public String toString() {
        return this.getText();
    }

    @NotNull
    public Class<?> getSubstitutedClass() {
        Class clazz = ReportingClassSubstitutor.getClassToReport((Object)this.myFix);
        if (clazz == null) {
            QuickFixWrapper.$$$reportNull$$$0(18);
        }
        return clazz;
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        ProblemDescriptor descriptorForPreview;
        if (project == null) {
            QuickFixWrapper.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            QuickFixWrapper.$$$reportNull$$$0(20);
        }
        if (file == null) {
            QuickFixWrapper.$$$reportNull$$$0(21);
        }
        PsiFile psiFile = this.getFile();
        PsiFile originalFile = IntentionPreviewUtils.getOriginalFile(file);
        if (originalFile != psiFile) {
            IntentionPreviewInfo intentionPreviewInfo = this.myFix.generatePreview(project, this.myDescriptor);
            if (intentionPreviewInfo == null) {
                QuickFixWrapper.$$$reportNull$$$0(22);
            }
            return intentionPreviewInfo;
        }
        try {
            descriptorForPreview = this.myDescriptor.getDescriptorForPreview(file);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create preview descriptor for quickfix " + this.myFix.getFamilyName() + " (" + String.valueOf(this.myFix.getClass()) + ")", e);
        }
        IntentionPreviewInfo intentionPreviewInfo = this.myFix.generatePreview(project, descriptorForPreview);
        if (intentionPreviewInfo == null) {
            QuickFixWrapper.$$$reportNull$$$0(23);
        }
        return intentionPreviewInfo;
    }

    @Override
    @NotNull
    public @Unmodifiable @NotNull List<@NotNull CustomizableIntentionAction.RangeToHighlight> getRangesToHighlight(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            QuickFixWrapper.$$$reportNull$$$0(24);
        }
        if (file == null) {
            QuickFixWrapper.$$$reportNull$$$0(25);
        }
        List<CustomizableIntentionAction.RangeToHighlight> list = this.myFix.getRangesToHighlight(file.getProject(), this.myDescriptor);
        if (list == null) {
            QuickFixWrapper.$$$reportNull$$$0(26);
        }
        return list;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myFix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 10, 11, 15, 16, 18, 22, 23, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/QuickFixWrapper";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 6: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/QuickFixWrapper";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFix";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutedClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unwrapFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRangesToHighlight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 10, 11, 15, 16, 18, 22, 23, 26 -> new IllegalStateException(string);
        };
    }

    private static final class ModCommandQuickFixAction
    implements ModCommandAction,
    ReportingClassSubstitutor {
        @NotNull
        private final ProblemDescriptor myDescriptor;
        @NotNull
        private final ModCommandQuickFix myFix;
        @Nullable
        private final ModCommandAction myUnwrappedAction;

        private ModCommandQuickFixAction(@NotNull ProblemDescriptor descriptor, @NotNull ModCommandQuickFix fix) {
            if (descriptor == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(0);
            }
            if (fix == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(1);
            }
            this.myDescriptor = descriptor;
            this.myFix = fix;
            this.myUnwrappedAction = ModCommandService.getInstance().unwrap(this.myFix);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.myFix.getName();
            if (string == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        public Presentation getPresentation(@NotNull ActionContext context) {
            ModCommandQuickFix modCommandQuickFix;
            if (context == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(3);
            }
            if (this.myUnwrappedAction != null) {
                if (this.myDescriptor.getStartElement() == null) {
                    return null;
                }
                ActionContext descriptorContext = ActionContext.from(this.myDescriptor);
                return this.myUnwrappedAction.getPresentation(descriptorContext.withOffset(Math.clamp((long)context.offset(), descriptorContext.selection().getStartOffset(), descriptorContext.selection().getEndOffset())));
            }
            PsiElement psiElement = this.myDescriptor.getPsiElement();
            if (psiElement == null || !psiElement.isValid()) {
                return null;
            }
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile != context.file() && containingFile != null && !containingFile.getViewProvider().getVirtualFile().equals(context.file().getViewProvider().getVirtualFile())) {
                return null;
            }
            Presentation presentation = Presentation.of(this.myFix.getName());
            List<CustomizableIntentionAction.RangeToHighlight> highlight = this.myFix.getRangesToHighlight(context.project(), this.myDescriptor);
            if (!highlight.isEmpty()) {
                Presentation.HighlightRange[] ranges = (Presentation.HighlightRange[])ContainerUtil.map2Array(highlight, Presentation.HighlightRange.class, r -> new Presentation.HighlightRange(r.getRangeInFile(), ModCommandQuickFixAction.convertToHighlightingType(r.getHighlightKey())));
                presentation = presentation.withHighlighting(ranges);
            }
            if ((modCommandQuickFix = this.myFix) instanceof Iconable) {
                Iconable iconable = (Iconable)modCommandQuickFix;
                presentation = presentation.withIcon(iconable.getIcon(0));
            }
            if ((modCommandQuickFix = this.myFix) instanceof PriorityAction) {
                PriorityAction priorityAction = (PriorityAction)((Object)modCommandQuickFix);
                presentation = presentation.withPriority(priorityAction.getPriority());
            }
            return presentation;
        }

        @NotNull
        private static Presentation.HighlightingKind convertToHighlightingType(@NotNull TextAttributesKey key) {
            if (key == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(4);
            }
            if (key == EditorColors.SEARCH_RESULT_ATTRIBUTES) {
                Presentation.HighlightingKind highlightingKind = Presentation.HighlightingKind.AFFECTED_RANGE;
                if (highlightingKind == null) {
                    ModCommandQuickFixAction.$$$reportNull$$$0(5);
                }
                return highlightingKind;
            }
            if (key == EditorColors.DELETED_TEXT_ATTRIBUTES) {
                Presentation.HighlightingKind highlightingKind = Presentation.HighlightingKind.DELETED_RANGE;
                if (highlightingKind == null) {
                    ModCommandQuickFixAction.$$$reportNull$$$0(6);
                }
                return highlightingKind;
            }
            Presentation.HighlightingKind highlightingKind = Presentation.HighlightingKind.AFFECTED_RANGE;
            if (highlightingKind == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(7);
            }
            return highlightingKind;
        }

        @Override
        @NotNull
        public ModCommand perform(@NotNull ActionContext context) {
            if (context == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(8);
            }
            ModCommand modCommand = this.myFix.perform(context.project(), this.myDescriptor);
            if (modCommand == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(9);
            }
            return modCommand;
        }

        @Override
        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull ActionContext context) {
            if (context == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(10);
            }
            IntentionPreviewInfo intentionPreviewInfo = this.myFix.generatePreview(context.project(), this.myDescriptor.getDescriptorForPreview(context.file()));
            if (intentionPreviewInfo == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        public Class<?> getSubstitutedClass() {
            Class clazz = ReportingClassSubstitutor.getClassToReport((Object)this.myFix);
            if (clazz == null) {
                ModCommandQuickFixAction.$$$reportNull$$$0(12);
            }
            return clazz;
        }

        public String toString() {
            return "ModCommandQuickFixAction[fix=" + String.valueOf(this.myFix) + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 6, 7, 9, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ex/QuickFixWrapper$ModCommandQuickFixAction";
                    break;
                }
                case 3: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ex/QuickFixWrapper$ModCommandQuickFixAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToHighlightingType";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitutedClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToHighlightingType";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 6, 7, 9, 11, 12 -> new IllegalStateException(string);
            };
        }
    }
}

