/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveRenameUsageInfo
extends UsageInfo
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(MoveRenameUsageInfo.class);
    private SmartPsiElementPointer<?> myReferencedElementPointer;
    private PsiElement myReferencedElement;
    private PsiReference myReference;
    private RangeMarker myReferenceRangeMarker;

    public MoveRenameUsageInfo(PsiReference reference, PsiElement referencedElement) {
        this(reference.getElement(), reference, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element, PsiReference reference, PsiElement referencedElement) {
        super(element);
        this.init(element, reference, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element, PsiReference reference, int startOffset, int endOffset, PsiElement referencedElement, boolean nonCodeUsage) {
        super(element, startOffset, endOffset, nonCodeUsage);
        this.init(element, reference, referencedElement);
    }

    private void init(PsiElement element, PsiReference reference, PsiElement referencedElement) {
        TextRange textRange;
        Project project = element.getProject();
        this.myReferencedElement = referencedElement;
        if (referencedElement != null) {
            this.myReferencedElementPointer = SmartPointerManager.getInstance((Project)referencedElement.getProject()).createSmartPsiElementPointer(referencedElement);
        }
        if (reference == null) {
            reference = element.getReference();
        }
        PsiFile containingFile = element.getContainingFile();
        if (reference == null && (textRange = element.getTextRange()) != null) {
            reference = containingFile.findReferenceAt(textRange.getStartOffset());
        }
        this.myReference = reference;
        if (reference != null) {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(containingFile);
            if (document != null) {
                TextRange rangeInElement;
                int elementStart = reference.getElement().getTextRange().getStartOffset();
                LOG.assertTrue(elementStart + (rangeInElement = reference.getRangeInElement()).getEndOffset() <= document.getTextLength(), (Object)reference);
                this.myReferenceRangeMarker = document.createRangeMarker(elementStart + rangeInElement.getStartOffset(), elementStart + rangeInElement.getEndOffset());
            }
            this.myDynamicUsage = reference.resolve() == null;
        }
    }

    @Nullable
    public PsiElement getUpToDateReferencedElement() {
        return this.myReferencedElementPointer == null ? null : this.myReferencedElementPointer.getElement();
    }

    @Nullable
    public PsiElement getReferencedElement() {
        return this.myReferencedElement;
    }

    @Nullable
    public PsiReference getReference() {
        PsiElement element;
        if (this.myReference != null && (element = this.myReference.getElement()).isValid()) {
            if (this.myReferenceRangeMarker == null) {
                return this.myReference;
            }
            PsiReference reference = this.checkReferenceRange(element, (Function<? super Integer, ? extends PsiReference>)((Function)start -> this.myReference));
            if (reference != null) {
                return reference;
            }
        }
        if (this.myReferenceRangeMarker == null) {
            return null;
        }
        element = this.getElement();
        if (element == null || !element.isValid()) {
            return null;
        }
        return this.checkReferenceRange(element, (Function<? super Integer, ? extends PsiReference>)((Function)start -> element.findReferenceAt(start.intValue())));
    }

    @NotNull
    protected Segment getReferenceRangeToCheck(@NotNull PsiElement element) {
        if (element == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(0);
        }
        RangeMarker rangeMarker = this.myReferenceRangeMarker;
        if (rangeMarker == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(1);
        }
        return rangeMarker;
    }

    @Nullable
    private PsiReference checkReferenceRange(PsiElement element, Function<? super Integer, ? extends PsiReference> fn) {
        Segment rangeToCheck = this.getReferenceRangeToCheck(element);
        int start = rangeToCheck.getStartOffset() - element.getTextRange().getStartOffset();
        int end = rangeToCheck.getEndOffset() - element.getTextRange().getStartOffset();
        PsiReference reference = (PsiReference)fn.fun((Object)start);
        if (reference == null) {
            return null;
        }
        TextRange rangeInElement = reference.getRangeInElement();
        if (rangeInElement.getStartOffset() != start || rangeInElement.getEndOffset() != end) {
            return null;
        }
        return reference;
    }

    private static boolean isPackage(PsiElement element) {
        return element instanceof PsiDirectoryContainer && element.getContainingFile() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/MoveRenameUsageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/MoveRenameUsageInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceRangeToCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceRangeToCheck";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

