/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DaemonCodeAnalyzer {
    @Topic.ProjectLevel
    public static final Topic<DaemonListener> DAEMON_EVENT_TOPIC = new Topic(DaemonListener.class, Topic.BroadcastDirection.NONE, true);

    public static DaemonCodeAnalyzer getInstance(Project project) {
        return (DaemonCodeAnalyzer)project.getService(DaemonCodeAnalyzer.class);
    }

    public abstract void settingsChanged();

    @ApiStatus.Internal
    public abstract void setUpdateByTimerEnabled(boolean var1);

    public abstract void disableUpdateByTimer(@NotNull Disposable var1);

    public abstract boolean isHighlightingAvailable(@NotNull PsiFile var1);

    public abstract void setImportHintsEnabled(@NotNull PsiFile var1, boolean var2);

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public abstract void resetImportHintsEnabledForProject();

    public abstract void setHighlightingEnabled(@NotNull PsiFile var1, boolean var2);

    public abstract boolean isImportHintsEnabled(@NotNull PsiFile var1);

    public abstract boolean isAutohintsAvailable(@NotNull PsiFile var1);

    @Deprecated
    public void restart() {
        this.restart("Global restart");
    }

    public void restart(@NotNull @NonNls Object reason) {
        if (reason == null) {
            DaemonCodeAnalyzer.$$$reportNull$$$0(0);
        }
        throw new AbstractMethodError();
    }

    @Deprecated
    public void restart(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            DaemonCodeAnalyzer.$$$reportNull$$$0(1);
        }
        this.restart(psiFile, "Global restart");
    }

    public void restart(@NotNull PsiFile psiFile, @NotNull @NonNls Object reason) {
        if (psiFile == null) {
            DaemonCodeAnalyzer.$$$reportNull$$$0(2);
        }
        if (reason == null) {
            DaemonCodeAnalyzer.$$$reportNull$$$0(3);
        }
        throw new AbstractMethodError();
    }

    public abstract void autoImportReferenceAtCursor(@NotNull Editor var1, @NotNull PsiFile var2);

    @ApiStatus.Internal
    public boolean isRunning() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "reason";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/DaemonCodeAnalyzer";
        objectArray[2] = "restart";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface DaemonListener {
        default public void daemonStarting(@NotNull @NotNull Collection<? extends @NotNull FileEditor> fileEditors) {
            if (fileEditors == null) {
                DaemonListener.$$$reportNull$$$0(0);
            }
        }

        default public void daemonFinished() {
        }

        default public void daemonFinished(@NotNull @NotNull Collection<? extends @NotNull FileEditor> fileEditors) {
            if (fileEditors == null) {
                DaemonListener.$$$reportNull$$$0(1);
            }
            this.daemonFinished();
        }

        default public void daemonCanceled(@NotNull String reason, @NotNull @NotNull Collection<? extends @NotNull FileEditor> fileEditors) {
            if (reason == null) {
                DaemonListener.$$$reportNull$$$0(2);
            }
            if (fileEditors == null) {
                DaemonListener.$$$reportNull$$$0(3);
            }
            this.daemonCancelEventOccurred(reason);
        }

        default public void daemonCancelEventOccurred(@NotNull String reason) {
            if (reason == null) {
                DaemonListener.$$$reportNull$$$0(4);
            }
        }

        @ApiStatus.Internal
        default public void daemonAnnotatorStatisticsGenerated(@NotNull AnnotationSession session, @NotNull Collection<? extends AnnotatorStatistics> statistics, @NotNull PsiFile psiFile) {
            if (session == null) {
                DaemonListener.$$$reportNull$$$0(5);
            }
            if (statistics == null) {
                DaemonListener.$$$reportNull$$$0(6);
            }
            if (psiFile == null) {
                DaemonListener.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileEditors";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statistics";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "daemonStarting";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "daemonFinished";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "daemonCanceled";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "daemonCancelEventOccurred";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "daemonAnnotatorStatisticsGenerated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        @ApiStatus.Internal
        public static final class AnnotatorStatistics {
            public final Annotator annotator;
            public long annotatorStartStamp;
            public long firstAnnotationStamp;
            public Annotation firstAnnotation;
            public long lastAnnotationStamp;
            public Annotation lastAnnotation;
            public long annotatorFinishStamp;

            public AnnotatorStatistics(@NotNull Annotator annotator) {
                if (annotator == null) {
                    AnnotatorStatistics.$$$reportNull$$$0(0);
                }
                this.annotatorStartStamp = System.nanoTime();
                this.annotator = annotator;
            }

            public String toString() {
                return "AnnotatorStatistics{annotator=" + String.valueOf(this.annotator) + ", annotatorStartStamp=" + this.annotatorStartStamp + ", firstAnnotationStamp=" + this.firstAnnotationStamp + ", firstAnnotation=" + String.valueOf(this.firstAnnotation) + ", lastAnnotationStamp=" + this.lastAnnotationStamp + ", lastAnnotation=" + String.valueOf(this.lastAnnotation) + ", annotatorFinishStamp=" + this.annotatorFinishStamp + "}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotator", "com/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener$AnnotatorStatistics", "<init>"));
            }
        }
    }
}

