/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.CacheAvoidingVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.SystemProperties;
import com.intellij.util.keyFMap.KeyFMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
@VisibleForTesting
public final class TransientVirtualFileImpl
extends VirtualFile
implements CacheAvoidingVirtualFile {
    private static final Logger LOG = Logger.getInstance(TransientVirtualFileImpl.class);
    private static final FileAttributes CACHED_NULL = new FileAttributes(false, false, false, false, 0L, -1L, false);
    private final String name;
    private final transient String path;
    private final VirtualFile parent;
    private final NewVirtualFileSystem fileSystem;
    private volatile FileAttributes cachedAttributes;
    static final boolean LOG_USER_DATA_HOLDER_ACCESS = SystemProperties.getBooleanProperty((String)"com.intellij.openapi.vfs.newvfs.TransientVirtualFileImpl.LOG_USER_DATA_HOLDER_ACCESS", (boolean)false);

    @VisibleForTesting
    public TransientVirtualFileImpl(@NotNull String name, @NotNull String path, @NotNull NewVirtualFileSystem fileSystem, @NotNull VirtualFile parent) {
        if (name == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(1);
        }
        if (fileSystem == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(3);
        }
        this.cachedAttributes = null;
        this.name = name;
        this.path = path;
        this.fileSystem = fileSystem;
        this.parent = parent;
    }

    @Nullable
    public VirtualFile asCacheable() {
        return this.fileSystem.findFileByPath(this.getPath());
    }

    public boolean isCached() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.path;
        if (string == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        NewVirtualFileSystem newVirtualFileSystem = this.fileSystem;
        if (newVirtualFileSystem == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(6);
        }
        return newVirtualFileSystem;
    }

    public VirtualFile getParent() {
        return this.parent;
    }

    public boolean isValid() {
        return this.exists();
    }

    public boolean exists() {
        FileAttributes attributes = this.fetchAttributes();
        if (attributes != null) {
            return true;
        }
        return this.fileSystem.exists(this);
    }

    public boolean isDirectory() {
        FileAttributes attributes = this.fetchAttributes();
        if (attributes == null) {
            return this.fileSystem.isDirectory(this);
        }
        return attributes.isDirectory();
    }

    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(7);
        }
        return switch (property) {
            default -> throw new MatchException(null, null);
            case VFileProperty.SYMLINK -> {
                FileAttributes attributes = this.fetchAttributes();
                if (attributes != null && attributes.isSymLink()) {
                    yield true;
                }
                yield false;
            }
            case VFileProperty.HIDDEN -> {
                FileAttributes attributes = this.fetchAttributes();
                if (attributes != null && attributes.isHidden()) {
                    yield true;
                }
                yield false;
            }
            case VFileProperty.SPECIAL -> {
                FileAttributes attributes = this.fetchAttributes();
                if (attributes != null && attributes.isSpecial()) {
                    yield true;
                }
                yield false;
            }
        };
    }

    public boolean isWritable() {
        FileAttributes attributes = this.fetchAttributes();
        return attributes != null && attributes.isWritable();
    }

    public VirtualFile[] getChildren() {
        String[] childNames = this.fileSystem.list(this);
        return (VirtualFile[])Arrays.stream(childNames).map(childName -> new TransientVirtualFileImpl((String)childName, this.path + "/" + childName, this.fileSystem, this)).toArray(VirtualFile[]::new);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = this.fileSystem.getOutputStream(this, requestor, newModificationStamp, newTimeStamp);
        if (outputStream == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(8);
        }
        return outputStream;
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        byte[] byArray = this.fileSystem.contentsToByteArray(this);
        if (byArray == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(9);
        }
        return byArray;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.fileSystem.getInputStream(this);
        if (inputStream == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(10);
        }
        return inputStream;
    }

    public long getTimeStamp() {
        FileAttributes attributes = this.fetchAttributes();
        if (attributes == null) {
            return this.fileSystem.getTimeStamp(this);
        }
        return attributes.lastModified;
    }

    public long getLength() {
        FileAttributes attributes = this.fetchAttributes();
        if (attributes == null) {
            return this.fileSystem.getLength(this);
        }
        return attributes.length;
    }

    public void setWritable(boolean writable) throws IOException {
        this.fileSystem.setWritable(this, writable);
    }

    public long getModificationStamp() {
        return 1L;
    }

    @Nullable
    private FileAttributes fetchAttributes() {
        FileAttributes cachedAttributes = this.cachedAttributes;
        if (cachedAttributes == CACHED_NULL) {
            return null;
        }
        if (cachedAttributes != null) {
            return cachedAttributes;
        }
        FileAttributes attributes = this.fileSystem.getAttributes(this);
        this.cachedAttributes = Objects.requireNonNullElse(attributes, CACHED_NULL);
        return attributes;
    }

    public void copyUserDataTo(@NotNull UserDataHolderBase other) {
        if (other == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(11);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        super.copyUserDataTo(other);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(12);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        return (T)super.getUserData(key);
    }

    @NotNull
    public KeyFMap getUserMap() {
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        KeyFMap keyFMap = super.getUserMap();
        if (keyFMap == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(13);
        }
        return keyFMap;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(14);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        super.putUserData(key, value);
    }

    protected boolean changeUserMap(@NotNull KeyFMap oldMap, @NotNull KeyFMap newMap) {
        if (oldMap == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(15);
        }
        if (newMap == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(16);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        return super.changeUserMap(oldMap, newMap);
    }

    public <T> @UnknownNullability T getCopyableUserData(@NotNull Key<T> key) {
        if (key == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(17);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        return (T)super.getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(18);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        super.putCopyableUserData(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(19);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        return super.replace(key, oldValue, newValue);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(20);
        }
        if (value == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(21);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        Object object = super.putUserDataIfAbsent(key, value);
        if (object == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(22);
        }
        return (T)object;
    }

    public void copyCopyableDataTo(@NotNull UserDataHolderBase clone) {
        if (clone == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(23);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        super.copyCopyableDataTo(clone);
    }

    public boolean isCopyableDataEqual(@NotNull UserDataHolderBase other) {
        if (other == null) {
            TransientVirtualFileImpl.$$$reportNull$$$0(24);
        }
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        return super.isCopyableDataEqual(other);
    }

    public boolean isUserDataEmpty() {
        TransientVirtualFileImpl.logUnsupportedIfNeeded(LOG_USER_DATA_HOLDER_ACCESS);
        return super.isUserDataEmpty();
    }

    private static void logUnsupportedIfNeeded(boolean logUserDataHolderAccess) {
        if (logUserDataHolderAccess) {
            LOG.error("TransientVirtualFileImpl does NOT really support UserDataHolder (see javadoc)");
        }
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        this.cachedAttributes = null;
        RefreshQueue.getInstance().refresh(asynchronous, recursive, postRunnable, this);
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TransientVirtualFileImpl file = (TransientVirtualFileImpl)((Object)o);
        boolean caseSensitive = this.fileSystem.isCaseSensitive();
        return (caseSensitive ? this.name.equals(file.name) : this.name.equalsIgnoreCase(file.name)) && this.parent.equals(file.parent) && ((Object)((Object)this.fileSystem)).equals((Object)file.fileSystem);
    }

    public int hashCode() {
        boolean caseSensitive = this.fileSystem.isCaseSensitive();
        int result = caseSensitive ? this.name.hashCode() : Strings.stringHashCodeInsensitive((CharSequence)this.name);
        result = 31 * result + this.parent.hashCode();
        result = 31 * result + ((Object)((Object)this.fileSystem)).hashCode();
        return result;
    }

    public String toString() {
        return "TransientVirtualFileImpl[" + this.path + "][fileSystem: " + String.valueOf((Object)this.fileSystem) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 9, 10, 13, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/TransientVirtualFileImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 11: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMap";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/TransientVirtualFileImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyUserDataTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "changeUserMap";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCopyableUserData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putCopyableUserData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyCopyableDataTo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isCopyableDataEqual";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 9, 10, 13, 22 -> new IllegalStateException(string);
        };
    }
}

