/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.providers.ModuleBookmarkProvider;
import com.intellij.ide.bookmark.providers.ModuleNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/ide/bookmark/providers/ModuleBookmark;", "Lcom/intellij/ide/bookmark/Bookmark;", "provider", "Lcom/intellij/ide/bookmark/providers/ModuleBookmarkProvider;", "name", "", "Lorg/jetbrains/annotations/Nls;", "isGroup", "", "<init>", "(Lcom/intellij/ide/bookmark/providers/ModuleBookmarkProvider;Ljava/lang/String;Z)V", "getProvider", "()Lcom/intellij/ide/bookmark/providers/ModuleBookmarkProvider;", "getName", "()Ljava/lang/String;", "()Z", "attributes", "", "getAttributes", "()Ljava/util/Map;", "createNode", "Lcom/intellij/ide/bookmark/providers/ModuleNode;", "canNavigate", "canNavigateToSource", "navigate", "", "requestFocus", "hashCode", "", "equals", "other", "", "toString", "intellij.platform.bookmarks"})
public final class ModuleBookmark
implements Bookmark {
    @NotNull
    private final ModuleBookmarkProvider provider;
    @NotNull
    private final String name;
    private final boolean isGroup;

    public ModuleBookmark(@NotNull ModuleBookmarkProvider provider, @NotNull String name, boolean isGroup) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.provider = provider;
        this.name = name;
        this.isGroup = isGroup;
    }

    @NotNull
    public ModuleBookmarkProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isGroup() {
        return this.isGroup;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        return this.isGroup ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"group", (Object)this.name)) : MapsKt.mapOf((Pair)TuplesKt.to((Object)"module", (Object)this.name));
    }

    @NotNull
    public ModuleNode createNode() {
        return new ModuleNode(this.getProvider().getProject(), this);
    }

    public boolean canNavigate() {
        return this.getProvider().getProjectSettingsService$intellij_platform_bookmarks() != null && this.getProvider().getModuleManager$intellij_platform_bookmarks() != null;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void navigate(boolean requestFocus) {
        ProjectSettingsService projectSettingsService = this.getProvider().getProjectSettingsService$intellij_platform_bookmarks();
        if (projectSettingsService == null) {
            return;
        }
        ProjectSettingsService service = projectSettingsService;
        ModuleManager moduleManager = this.getProvider().getModuleManager$intellij_platform_bookmarks();
        Module module = moduleManager != null ? moduleManager.findModuleByName(this.name) : null;
        if (module != null && service.canOpenModuleSettings()) {
            service.openModuleSettings(module);
        } else {
            service.openProjectSettings();
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getProvider(), this.name, this.isGroup};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof ModuleBookmark && Intrinsics.areEqual((Object)((ModuleBookmark)other).getProvider(), (Object)this.getProvider()) && ((ModuleBookmark)other).isGroup == this.isGroup && Intrinsics.areEqual((Object)((ModuleBookmark)other).name, (Object)this.name);
    }

    @NotNull
    public String toString() {
        return this.isGroup ? "ModuleBookmark(group=" + this.name + ",provider=" + this.getProvider() + ")" : "ModuleBookmark(module=" + this.name + ",provider=" + this.getProvider() + ")";
    }
}

