/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksSelectInTarget;", "Lcom/intellij/ide/SelectInTarget;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "toString", "", "Lorg/jetbrains/annotations/Nls;", "getToolWindowId", "getWeight", "", "canSelect", "", "context", "Lcom/intellij/ide/SelectInContext;", "selectIn", "", "requestFocus", "view", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nBookmarksSelectInTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksSelectInTarget.kt\ncom/intellij/ide/bookmark/ui/BookmarksSelectInTarget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1761#2,3:54\n*S KotlinDebug\n*F\n+ 1 BookmarksSelectInTarget.kt\ncom/intellij/ide/bookmark/ui/BookmarksSelectInTarget\n*L\n25#1:54,3\n*E\n"})
public final class BookmarksSelectInTarget
implements SelectInTarget,
DumbAware {
    @NotNull
    private final Project project;

    public BookmarksSelectInTarget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public String toString() {
        String string = BookmarkBundle.message("select.in.target.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getToolWindowId() {
        return "Bookmarks";
    }

    public float getWeight() {
        return 1.001f;
    }

    public boolean canSelect(@Nullable SelectInContext context) {
        boolean bl;
        block5: {
            SelectInContext selectInContext = context;
            if (selectInContext == null || (selectInContext = selectInContext.getVirtualFile()) == null) {
                return false;
            }
            SelectInContext file = selectInContext;
            BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.project);
            if (bookmarksManager == null) {
                return false;
            }
            BookmarksManager manager = bookmarksManager;
            List list2 = manager.getBookmarks();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBookmarks(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile ancestor;
                    Bookmark it = (Bookmark)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = it instanceof FileBookmark ? ((ancestor = ((FileBookmark)it).getFile()).isDirectory() ? VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false) : Intrinsics.areEqual((Object)ancestor, (Object)file)) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void selectIn(@NotNull SelectInContext context, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Bookmarks");
        if (toolWindow == null) {
            return;
        }
        ToolWindow window = toolWindow;
        Content content = window.getContentManager().getSelectedContent();
        JComponent jComponent = content != null ? content.getComponent() : null;
        BookmarksView bookmarksView = jComponent instanceof BookmarksView ? (BookmarksView)((Object)jComponent) : null;
        if (bookmarksView == null) {
            return;
        }
        BookmarksView view = bookmarksView;
        if (requestFocus) {
            window.activate(() -> BookmarksSelectInTarget.selectIn$lambda$0(this, context, view));
        } else {
            window.show(() -> BookmarksSelectInTarget.selectIn$lambda$1(this, context, view));
        }
    }

    private final void selectIn(SelectInContext context, BookmarksView view) {
        VirtualFile virtualFile = context.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        view.select(virtualFile);
    }

    private static final void selectIn$lambda$0(BookmarksSelectInTarget this$0, SelectInContext $context, BookmarksView $view) {
        this$0.selectIn($context, $view);
    }

    private static final void selectIn$lambda$1(BookmarksSelectInTarget this$0, SelectInContext $context, BookmarksView $view) {
        this$0.selectIn($context, $view);
    }
}

