/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0019\u0010\u0010\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0016J\u0015\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0015J-\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001dH\u0000\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/bookmark/ui/GroupInputValidator;", "Lcom/intellij/openapi/ui/InputValidatorEx;", "manager", "Lcom/intellij/ide/bookmark/BookmarksManager;", "groups", "", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "<init>", "(Lcom/intellij/ide/bookmark/BookmarksManager;Ljava/util/Collection;)V", "group", "(Lcom/intellij/ide/bookmark/BookmarksManager;Lcom/intellij/ide/bookmark/BookmarkGroup;)V", "(Lcom/intellij/ide/bookmark/BookmarksManager;)V", "getManager", "()Lcom/intellij/ide/bookmark/BookmarksManager;", "getGroups", "()Ljava/util/Collection;", "getErrorText", "", "Lorg/jetbrains/annotations/Nls;", "name", "findValidName", "findValidName$intellij_platform_bookmarks", "install", "Lcom/intellij/openapi/ui/ComponentValidator;", "parent", "Lcom/intellij/openapi/Disposable;", "component", "Ljavax/swing/JComponent;", "text", "Lkotlin/Function0;", "install$intellij_platform_bookmarks", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nGroupInputValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupInputValidator.kt\ncom/intellij/ide/bookmark/ui/GroupInputValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class GroupInputValidator
implements InputValidatorEx {
    @NotNull
    private final BookmarksManager manager;
    @NotNull
    private final Collection<BookmarkGroup> groups;

    public GroupInputValidator(@NotNull BookmarksManager manager, @NotNull Collection<? extends BookmarkGroup> groups) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        this.manager = manager;
        this.groups = groups;
    }

    @NotNull
    public final BookmarksManager getManager() {
        return this.manager;
    }

    @NotNull
    public final Collection<BookmarkGroup> getGroups() {
        return this.groups;
    }

    public GroupInputValidator(@NotNull BookmarksManager manager, @NotNull BookmarkGroup group) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this(manager, CollectionsKt.listOf((Object)group));
    }

    public GroupInputValidator(@NotNull BookmarksManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this(manager, SetsKt.emptySet());
    }

    @Nullable
    public String getErrorText(@Nullable String name) {
        String string;
        CharSequence charSequence = name;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            string = "";
        } else {
            BookmarkGroup it = this.manager.getGroup(((Object)StringsKt.trim((CharSequence)name)).toString());
            boolean bl = false;
            string = it == null || this.groups.contains(it) ? null : BookmarkBundle.message("dialog.name.exists.error", new Object[0]);
        }
        return string;
    }

    @NotNull
    public final String findValidName$intellij_platform_bookmarks(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String initial = ((Object)StringsKt.trim((CharSequence)name)).toString();
        if (this.checkInput(initial)) {
            return initial;
        }
        for (int index = 1; index < 100; ++index) {
            String indexed = initial + " (" + index + ")";
            if (!this.checkInput(indexed)) continue;
            return indexed;
        }
        return initial;
    }

    @NotNull
    public final ComponentValidator install$intellij_platform_bookmarks(@NotNull Disposable parent, @NotNull JComponent component, @NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(text, (String)"text");
        ComponentValidator componentValidator = new ComponentValidator(parent).withValidator(() -> GroupInputValidator.install$lambda$0(this, text, component)).installOn(component);
        Intrinsics.checkNotNullExpressionValue((Object)componentValidator, (String)"installOn(...)");
        return componentValidator;
    }

    private static final ValidationInfo install$lambda$0(GroupInputValidator this$0, Function0 $text, JComponent $component) {
        ValidationInfo validationInfo;
        String string = this$0.getErrorText((String)$text.invoke());
        if (string != null) {
            String it = string;
            boolean bl = false;
            validationInfo = new ValidationInfo(it, $component);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }
}

