/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.ui.tree.FileSystemNode;
import com.intellij.ide.bookmark.ui.tree.FolderNode;
import com.intellij.ide.bookmark.ui.tree.RootNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchTreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u0006\u0012\u0002\b\u00030\u0013H\u0000\u001a\u001f\u0010\u0014\u001a\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u0016*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a-\u0010\u0019\u001a\u0017\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u001a*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u001a\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u001c*\u0006\u0012\u0002\b\u00030\u0013H\u0000\"\u001e\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001e\u0010\t\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"asAbstractTreeNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "", "getAsAbstractTreeNode", "(Ljava/lang/Object;)Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "bookmarksManager", "Lcom/intellij/ide/bookmark/BookmarksManager;", "getBookmarksManager", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/ide/bookmark/BookmarksManager;", "parentRootNode", "Lcom/intellij/ide/bookmark/ui/tree/RootNode;", "getParentRootNode", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/ide/bookmark/ui/tree/RootNode;", "parentFolderNode", "Lcom/intellij/ide/bookmark/ui/tree/FolderNode;", "getParentFolderNode", "(Lcom/intellij/ide/util/treeView/AbstractTreeNode;)Lcom/intellij/ide/bookmark/ui/tree/FolderNode;", "findFileIcon", "Ljavax/swing/Icon;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "computeExternalLocation", "", "Lcom/intellij/openapi/util/NlsSafe;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "computeScratchPresentation", "Lkotlin/Pair;", "computeDirectoryChildren", "", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nextensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extensions.kt\ncom/intellij/ide/bookmark/ui/tree/ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,92:1\n1#2:93\n13805#3,2:94\n*S KotlinDebug\n*F\n+ 1 extensions.kt\ncom/intellij/ide/bookmark/ui/tree/ExtensionsKt\n*L\n65#1:94,2\n*E\n"})
public final class ExtensionsKt {
    @Nullable
    public static final AbstractTreeNode<?> getAsAbstractTreeNode(@NotNull Object $this$asAbstractTreeNode) {
        Intrinsics.checkNotNullParameter((Object)$this$asAbstractTreeNode, (String)"<this>");
        return $this$asAbstractTreeNode instanceof AbstractTreeNode ? (AbstractTreeNode)$this$asAbstractTreeNode : null;
    }

    @Nullable
    public static final BookmarksManager getBookmarksManager(@NotNull AbstractTreeNode<?> $this$bookmarksManager) {
        Intrinsics.checkNotNullParameter($this$bookmarksManager, (String)"<this>");
        return BookmarksManager.getInstance((Project)$this$bookmarksManager.getProject());
    }

    @Nullable
    public static final RootNode getParentRootNode(@NotNull AbstractTreeNode<?> $this$parentRootNode) {
        Intrinsics.checkNotNullParameter($this$parentRootNode, (String)"<this>");
        RootNode rootNode = $this$parentRootNode instanceof RootNode ? (RootNode)$this$parentRootNode : null;
        if (rootNode == null) {
            AbstractTreeNode abstractTreeNode = $this$parentRootNode.getParent();
            rootNode = abstractTreeNode != null ? ExtensionsKt.getParentRootNode(abstractTreeNode) : null;
        }
        return rootNode;
    }

    @Nullable
    public static final FolderNode getParentFolderNode(@NotNull AbstractTreeNode<?> $this$parentFolderNode) {
        Intrinsics.checkNotNullParameter($this$parentFolderNode, (String)"<this>");
        FolderNode folderNode = $this$parentFolderNode instanceof FolderNode ? (FolderNode)$this$parentFolderNode : null;
        if (folderNode == null) {
            AbstractTreeNode abstractTreeNode = $this$parentFolderNode.getParent();
            folderNode = abstractTreeNode != null ? ExtensionsKt.getParentFolderNode(abstractTreeNode) : null;
        }
        return folderNode;
    }

    @Nullable
    public static final Icon findFileIcon(@NotNull ProjectViewNode<?> $this$findFileIcon) {
        Intrinsics.checkNotNullParameter($this$findFileIcon, (String)"<this>");
        return CompoundIconProvider.findIcon((PsiElement)((PsiElement)PsiUtilCore.findFileSystemItem((Project)$this$findFileIcon.getProject(), (VirtualFile)$this$findFileIcon.getVirtualFile())), (int)0);
    }

    @Nullable
    public static final String computeExternalLocation(@NotNull ProjectViewNode<?> $this$computeExternalLocation, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter($this$computeExternalLocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = ExtensionsKt.computeScratchPresentation($this$computeExternalLocation, file);
        if (object == null || (object = (String)object.getFirst()) == null) {
            object = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        }
        return object;
    }

    @Nullable
    public static final Pair<String, Icon> computeScratchPresentation(@NotNull ProjectViewNode<?> $this$computeScratchPresentation, @NotNull VirtualFile file) {
        Pair pair;
        Intrinsics.checkNotNullParameter($this$computeScratchPresentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RootType rootType = ScratchFileService.findRootType((VirtualFile)file);
        if (rootType == null) {
            return null;
        }
        RootType type = rootType;
        VirtualFile virtualFile = ScratchTreeStructureProvider.getVirtualFile((RootType)type);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        VirtualFile virtualFile2 = root;
        if (Intrinsics.areEqual((Object)virtualFile2, (Object)file)) {
            String string = type.getDisplayName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                pair = TuplesKt.to((Object)it, (Object)AllIcons.Nodes.Folder);
            } else {
                pair = null;
            }
        } else if (Intrinsics.areEqual((Object)virtualFile2, (Object)file.getParent())) {
            String string = type.substituteName($this$computeScratchPresentation.getProject(), file);
            if (string != null) {
                String it = string;
                boolean bl = false;
                pair = TuplesKt.to((Object)it, (Object)IconUtil.getIcon((VirtualFile)file, (int)0, (Project)$this$computeScratchPresentation.getProject()));
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }

    @NotNull
    public static final Collection<AbstractTreeNode<?>> computeDirectoryChildren(@NotNull ProjectViewNode<?> $this$computeDirectoryChildren) {
        List list2;
        Intrinsics.checkNotNullParameter($this$computeDirectoryChildren, (String)"<this>");
        PsiFileSystemItem psiFileSystemItem = PsiUtilCore.findFileSystemItem((Project)$this$computeDirectoryChildren.getProject(), (VirtualFile)$this$computeDirectoryChildren.getVirtualFile());
        PsiDirectory psiDirectory = psiFileSystemItem instanceof PsiDirectory ? (PsiDirectory)psiFileSystemItem : null;
        if (psiDirectory == null) {
            return CollectionsKt.emptyList();
        }
        PsiDirectory directory = psiDirectory;
        if (ProjectFileIndex.getInstance((Project)directory.getProject()).getModuleForFile(directory.getVirtualFile(), false) != null) {
            Collection collection = ProjectViewDirectoryHelper.getInstance((Project)directory.getProject()).getDirectoryChildren(directory, $this$computeDirectoryChildren.getSettings(), true);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDirectoryChildren(...)");
            return collection;
        }
        VirtualFile[] virtualFileArray = directory.getVirtualFile().getChildren();
        if (virtualFileArray == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile[] children = virtualFileArray;
        RootType type = RootType.forFile((VirtualFile)directory.getVirtualFile());
        List $this$computeDirectoryChildren_u24lambda_u240 = list2 = (List)new ArrayList();
        boolean bl = false;
        VirtualFile[] $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            PsiFileSystemItem item;
            VirtualFile element$iv;
            VirtualFile it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            if (type != null && type.isIgnored(directory.getProject(), directory.getVirtualFile()) || (item = PsiUtilCore.findFileSystemItem((Project)directory.getProject(), (VirtualFile)it)) == null) continue;
            $this$computeDirectoryChildren_u24lambda_u240.add(new FileSystemNode(item, $this$computeDirectoryChildren.getSettings()));
        }
        return list2;
    }
}

