/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui;

import com.intellij.execution.Location;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.actions.BookmarksDeleteProvider;
import com.intellij.ide.bookmark.ui.BookmarksViewState;
import com.intellij.ide.bookmark.ui.ContextMenuActionGroup;
import com.intellij.ide.bookmark.ui.DragAndDropHandler;
import com.intellij.ide.bookmark.ui.ExtensionsKt;
import com.intellij.ide.bookmark.ui.GroupBookmarkVisitor;
import com.intellij.ide.bookmark.ui.IdeViewForBookmarksView;
import com.intellij.ide.bookmark.ui.tree.BookmarksTreeStructure;
import com.intellij.ide.bookmark.ui.tree.FolderNodeComparator;
import com.intellij.ide.bookmark.ui.tree.FolderNodeUpdater;
import com.intellij.ide.bookmark.ui.tree.VirtualFileVisitor;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.preview.DescriptorPreview;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 k2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002klB\u0019\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0016J\r\u0010;\u001a\u00070<\u00a2\u0006\u0002\b=H\u0016J\r\u0010>\u001a\u00070<\u00a2\u0006\u0002\b=H\u0016J\b\u0010?\u001a\u00020\bH\u0016J\b\u0010@\u001a\u00020\bH\u0016J\n\u0010A\u001a\u0004\u0018\u00010BH\u0016J\n\u0010C\u001a\u0004\u0018\u00010BH\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010B2\u0006\u0010E\u001a\u000201H\u0002J\u000e\u0010F\u001a\u0002072\u0006\u0010G\u001a\u00020HJ\u0014\u0010F\u001a\b\u0012\u0004\u0012\u00020J0I2\u0006\u0010K\u001a\u00020LJ\u001c\u0010F\u001a\b\u0012\u0004\u0012\u00020J0I2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ?\u0010F\u001a)\u0012 \u0012\u001e Q*\u000e\u0018\u00010J\u00a2\u0006\u0002\bO\u00a2\u0006\u0002\bP0J\u00a2\u0006\u0002\bO\u00a2\u0006\u0002\bP0I\u00a2\u0006\u0002\bO2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\bH\u0002J\b\u0010U\u001a\u000207H\u0014J\b\u0010V\u001a\u000207H\u0014J\u0010\u0010W\u001a\u0002072\u0006\u0010X\u001a\u00020\bH\u0016J\u0012\u0010e\u001a\u0002072\b\b\u0002\u0010f\u001a\u00020\bH\u0002J\u0010\u0010g\u001a\u0002072\u0006\u0010h\u001a\u00020\bH\u0002J\u000e\u0010i\u001a\u0002072\u0006\u0010j\u001a\u00020\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001d\u0010,\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0018\u00010-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0016\u00100\u001a\u0004\u0018\u0001018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0016\u00104\u001a\u0004\u0018\u0001018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00103R\u0011\u0010Y\u001a\u00020Z\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\R\u0011\u0010]\u001a\u00020Z\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\\R\u0011\u0010_\u001a\u00020Z\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010\\R\u0011\u0010a\u001a\u00020Z\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010\\R\u0011\u0010c\u001a\u00020Z\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010\\\u00a8\u0006m"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksView;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/ide/OccurenceNavigator;", "Lcom/intellij/ui/OnePixelSplitter;", "project", "Lcom/intellij/openapi/project/Project;", "showToolbar", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Boolean;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isPopup", "()Z", "editSourceListeners", "", "Lcom/intellij/ide/bookmark/ui/BookmarksView$EditSourceListener;", "state", "Lcom/intellij/ide/bookmark/ui/BookmarksViewState;", "preview", "Lcom/intellij/ui/preview/DescriptorPreview;", "selectionAlarm", "Lcom/intellij/util/SingleAlarm;", "structure", "Lcom/intellij/ide/bookmark/ui/tree/BookmarksTreeStructure;", "model", "Lcom/intellij/ui/tree/StructureTreeModel;", "getModel$intellij_platform_bookmarks", "()Lcom/intellij/ui/tree/StructureTreeModel;", "tree", "Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "getTree", "()Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "treeExpander", "Lcom/intellij/ide/DefaultTreeExpander;", "panel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "updater", "Lcom/intellij/ide/bookmark/ui/tree/FolderNodeUpdater;", "selectedNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getSelectedNode", "()Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "selectedNodes", "", "getSelectedNodes", "()Ljava/util/List;", "previousOccurrence", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "getPreviousOccurrence", "()Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "nextOccurrence", "getNextOccurrence", "dispose", "", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getNextOccurenceActionName", "", "Lorg/jetbrains/annotations/Nls;", "getPreviousOccurenceActionName", "hasNextOccurence", "hasPreviousOccurence", "goNextOccurence", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "goPreviousOccurence", "go", "occurrence", "select", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/concurrency/Promise;", "Ljavax/swing/tree/TreePath;", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "kotlin.jvm.PlatformType", "visitor", "Lcom/intellij/ui/tree/TreeVisitor;", "centered", "saveProportion", "loadProportion", "setOrientation", "vertical", "groupLineBookmarks", "Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "getGroupLineBookmarks", "()Lcom/intellij/openapi/actionSystem/ToggleOptionAction$Option;", "autoScrollFromSource", "getAutoScrollFromSource", "autoScrollToSource", "getAutoScrollToSource", "openInPreviewTab", "getOpenInPreviewTab", "showPreview", "getShowPreview", "selectionChanged", "autoScroll", "navigateToSource", "requestFocus", "addEditSourceListener", "listener", "Companion", "EditSourceListener", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nBookmarksView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksView.kt\ncom/intellij/ide/bookmark/ui/BookmarksView\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,319:1\n11879#2,9:320\n13805#2:329\n13806#2:331\n11888#2:332\n1#3:330\n1#3:333\n1#3:344\n1#3:347\n1617#4,9:334\n1869#4:343\n1870#4:345\n1626#4:346\n1869#4,2:350\n1869#4,2:352\n37#5,2:348\n*S KotlinDebug\n*F\n+ 1 BookmarksView.kt\ncom/intellij/ide/bookmark/ui/BookmarksView\n*L\n86#1:320,9\n86#1:329\n86#1:331\n86#1:332\n86#1:330\n117#1:344\n117#1:334,9\n117#1:343\n117#1:345\n117#1:346\n263#1:350,2\n264#1:352,2\n117#1:348,2\n*E\n"})
public final class BookmarksView
extends OnePixelSplitter
implements Disposable,
UiDataProvider,
OccurenceNavigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean isPopup;
    @NotNull
    private final List<EditSourceListener> editSourceListeners;
    @NotNull
    private final BookmarksViewState state;
    @NotNull
    private final DescriptorPreview preview;
    @NotNull
    private final SingleAlarm selectionAlarm;
    @NotNull
    private final BookmarksTreeStructure structure;
    @NotNull
    private final StructureTreeModel<BookmarksTreeStructure> model;
    @NotNull
    private final DnDAwareTree tree;
    @NotNull
    private final DefaultTreeExpander treeExpander;
    @NotNull
    private final BorderLayoutPanel panel;
    @NotNull
    private final FolderNodeUpdater updater;
    @NotNull
    private final ToggleOptionAction.Option groupLineBookmarks;
    @NotNull
    private final ToggleOptionAction.Option autoScrollFromSource;
    @NotNull
    private final ToggleOptionAction.Option autoScrollToSource;
    @NotNull
    private final ToggleOptionAction.Option openInPreviewTab;
    @NotNull
    private final ToggleOptionAction.Option showPreview;
    @NotNull
    private static final DataKey<BookmarksView> BOOKMARKS_VIEW = DataKey.Companion.create("BOOKMARKS_VIEW");

    public BookmarksView(@NotNull Project project, @Nullable Boolean showToolbar) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(false, 0.3f, 0.1f, 0.9f);
        this.project = project;
        this.isPopup = showToolbar == null;
        this.editSourceListeners = new ArrayList();
        this.state = BookmarksViewState.Companion.getInstance(this.project);
        this.preview = new DescriptorPreview((Splitter)this, false, ClientSessionsUtil.getCurrentSession((Project)this.project));
        Runnable runnable = () -> BookmarksView.selectionAlarm$lambda$0(this);
        Disposable disposable = this;
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)((Object)this)));
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        this.selectionAlarm = new SingleAlarm(runnable, 50, disposable, modalityState);
        this.structure = new BookmarksTreeStructure(this);
        this.model = new StructureTreeModel((AbstractTreeStructure)this.structure, (Comparator)((Object)new FolderNodeComparator(this.project)), (Disposable)this);
        this.tree = new DnDAwareTree((TreeModel)new AsyncTreeModel((TreeModel)this.model, (Disposable)this));
        this.treeExpander = new DefaultTreeExpander((JTree)this.tree);
        this.panel = new BorderLayoutPanel();
        this.updater = new FolderNodeUpdater(this);
        this.groupLineBookmarks = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isEnabled() {
                return !this.this$0.isPopup();
            }

            public boolean isSelected() {
                return this.isEnabled() && BookmarksView.access$getState$p(this.this$0).getGroupLineBookmarks();
            }

            public void setSelected(boolean selected) {
                BookmarksView.access$getState$p(this.this$0).setGroupLineBookmarks(selected);
                this.this$0.getModel$intellij_platform_bookmarks().invalidateAsync();
            }
        };
        this.autoScrollFromSource = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isEnabled() {
                return false;
            }

            public boolean isSelected() {
                return BookmarksView.access$getState$p(this.this$0).getAutoscrollFromSource();
            }

            public void setSelected(boolean selected) {
                BookmarksView.access$getState$p(this.this$0).setAutoscrollFromSource(selected);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        };
        this.autoScrollToSource = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isEnabled() {
                return this.this$0.getOpenInPreviewTab().isEnabled();
            }

            public boolean isSelected() {
                return BookmarksView.access$getState$p(this.this$0).getAutoscrollToSource();
            }

            public void setSelected(boolean selected) {
                BookmarksView.access$getState$p(this.this$0).setAutoscrollToSource(selected);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        };
        this.openInPreviewTab = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isEnabled() {
                return this.this$0.isVertical() || !BookmarksView.access$getState$p(this.this$0).getShowPreview();
            }

            public boolean isSelected() {
                return UISettings.Companion.getInstance().getOpenInPreviewTabIfPossible();
            }

            public void setSelected(boolean selected) {
                UISettings.Companion.getInstance().setOpenInPreviewTabIfPossible(selected);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        };
        this.showPreview = new ToggleOptionAction.Option(this){
            final /* synthetic */ BookmarksView this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isAlwaysVisible() {
                return !this.this$0.isVertical();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isEnabled() {
                if (this.this$0.isVertical()) return false;
                AbstractTreeNode<?> abstractTreeNode = this.this$0.getSelectedNode();
                if (abstractTreeNode == null) return false;
                boolean bl = abstractTreeNode.canNavigateToSource();
                if (!bl) return false;
                return true;
            }

            public boolean isSelected() {
                return BookmarksView.access$getState$p(this.this$0).getShowPreview();
            }

            public void setSelected(boolean selected) {
                BookmarksView.access$getState$p(this.this$0).setShowPreview(selected);
                SingleAlarm.cancelAndRequest$default((SingleAlarm)BookmarksView.access$getSelectionAlarm$p(this.this$0), (boolean)false, (int)1, null);
            }
        };
        this.panel.addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.tree), (boolean)true));
        this.panel.putClientProperty((Object)FileEditorManagerImpl.OPEN_IN_PREVIEW_TAB, (Object)true);
        this.setFirstComponent((JComponent)this.panel);
        this.tree.setHorizontalAutoScrollingEnabled(false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        if (!this.isPopup) {
            DragAndDropHandler handler = new DragAndDropHandler(this);
            DnDSupport.createBuilder((JComponent)((JComponent)this.tree)).setDisposableParent((Disposable)this).setBeanProvider(arg_0 -> BookmarksView._init_$lambda$0((Function1)new Function1<DnDActionInfo, DnDDragStartBean>((Object)handler){

                public final DnDDragStartBean invoke(DnDActionInfo p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((DragAndDropHandler)this.receiver).createBean(p0);
                }
            }, arg_0)).setDropHandlerWithResult((DnDDropHandler.WithResult)handler).setTargetChecker((DnDTargetChecker)handler).enableAsNativeTarget().install();
        }
        StatusText statusText = this.tree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        ExtensionsKt.initialize(statusText, (Component)this.tree);
        this.tree.addTreeSelectionListener((TreeSelectionListener)new RestoreSelectionListener());
        this.tree.addTreeSelectionListener(arg_0 -> BookmarksView._init_$lambda$1(this, arg_0));
        this.tree.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent event) {
            }

            @Override
            public void focusGained(FocusEvent event) {
                SingleAlarm.cancelAndRequest$default((SingleAlarm)selectionAlarm, (boolean)false, (int)1, null);
            }
        });
        this.tree.getAccessibleContext().setAccessibleName(BookmarkBundle.message("bookmarks.tree.accessible.name", new Object[0]));
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.tree);
        TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)this.tree));
        com.intellij.ide.bookmark.actions.ExtensionsKt.registerNavigateOnEnterAction((JTree)this.tree, (Function0<Unit>)((Function0)() -> BookmarksView._init_$lambda$2(this)));
        EditSourceOnDoubleClickHandler.install((JTree)((JTree)this.tree), () -> BookmarksView._init_$lambda$3(this));
        ContextMenuActionGroup group = new ContextMenuActionGroup((JTree)this.tree);
        PopupHandler.installPopupMenu((JComponent)((JComponent)this.tree), (ActionGroup)group, (String)"BookmarksPopup");
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = BookmarksListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new BookmarksListener(){

            public void groupsSorted() {
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void groupAdded(BookmarkGroup group) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void groupRemoved(BookmarkGroup group) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void groupRenamed(BookmarkGroup group) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void bookmarksSorted(BookmarkGroup group) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void bookmarkAdded(BookmarkGroup group, Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void bookmarkRemoved(BookmarkGroup group, Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void bookmarkChanged(BookmarkGroup group, Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void bookmarkTypeChanged(Bookmark bookmark) {
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void defaultGroupChanged(BookmarkGroup oldGroup, BookmarkGroup newGroup) {
                this.getModel$intellij_platform_bookmarks().invalidateAsync();
            }

            public void structureChanged(Object node) {
                if (node == null) {
                    CompletableFuture completableFuture = this.getModel$intellij_platform_bookmarks().invalidateAsync();
                    v1 = completableFuture;
                    Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"invalidateAsync(...)");
                } else {
                    CompletableFuture completableFuture = this.getModel$intellij_platform_bookmarks().invalidateAsync(node, true);
                    v1 = completableFuture;
                    Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"invalidateAsync(...)");
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean isPopup() {
        return this.isPopup;
    }

    @NotNull
    public final StructureTreeModel<BookmarksTreeStructure> getModel$intellij_platform_bookmarks() {
        return this.model;
    }

    @NotNull
    public final DnDAwareTree getTree() {
        return this.tree;
    }

    @Nullable
    public final AbstractTreeNode<?> getSelectedNode() {
        return TreeUtil.getAbstractTreeNode((TreePath)TreeUtil.getSelectedPathIfOne((JTree)((JTree)this.tree)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<AbstractTreeNode<?>> getSelectedNodes() {
        List list2;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            Collection collection;
            void $this$mapNotNullTo$iv$iv;
            TreePath[] $this$mapNotNull$iv = treePathArray;
            boolean $i$f$mapNotNull = false;
            TreePath[] treePathArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                AbstractTreeNode it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (TreeUtil.getAbstractTreeNode((TreePath)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv;
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = null;
            } else {
                collection = collection2;
            }
            list2 = (List)collection;
        } else {
            list2 = null;
        }
        return list2;
    }

    private final BookmarkOccurrence getPreviousOccurrence() {
        AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
        BookmarkOccurrence occurrence = abstractTreeNode != null ? ExtensionsKt.getBookmarkOccurrence(abstractTreeNode) : null;
        return occurrence == null ? BookmarkOccurrence.Companion.lastLineBookmark(this.project) : occurrence.previousLineBookmark();
    }

    private final BookmarkOccurrence getNextOccurrence() {
        AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
        BookmarkOccurrence occurrence = abstractTreeNode != null ? ExtensionsKt.getBookmarkOccurrence(abstractTreeNode) : null;
        return occurrence == null ? BookmarkOccurrence.Companion.firstLineBookmark(this.project) : occurrence.nextLineBookmark();
    }

    public void dispose() {
        this.preview.close();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        List<AbstractTreeNode<?>> selection = this.getSelectedNodes();
        sink.set(BOOKMARKS_VIEW, (Object)this);
        DataKey dataKey = PlatformDataKeys.TREE_EXPANDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"TREE_EXPANDER");
        sink.set(dataKey, (Object)this.treeExpander);
        DataKey dataKey2 = PlatformDataKeys.SELECTED_ITEMS;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"SELECTED_ITEMS");
        List<AbstractTreeNode<?>> list2 = selection;
        sink.set(dataKey2, list2 != null ? UtilKt.toArray((Collection)list2, (Object[])new Object[0]) : null);
        DataKey dataKey3 = PlatformDataKeys.SELECTED_ITEM;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"SELECTED_ITEM");
        List<AbstractTreeNode<?>> list3 = selection;
        sink.set(dataKey3, list3 != null ? (AbstractTreeNode)CollectionsKt.firstOrNull(list3) : null);
        DataKey dataKey4 = PlatformDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey4, (String)"PROJECT");
        sink.set(dataKey4, (Object)this.project);
        DataKey dataKey5 = PlatformDataKeys.DELETE_ELEMENT_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey5, (String)"DELETE_ELEMENT_PROVIDER");
        sink.set(dataKey5, (Object)new BookmarksDeleteProvider());
        DataKey dataKey6 = LangDataKeys.IDE_VIEW;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey6, (String)"IDE_VIEW");
        sink.set(dataKey6, (Object)new IdeViewForBookmarksView(this, selection));
        DataKey dataKey7 = PlatformDataKeys.VIRTUAL_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey7, (String)"VIRTUAL_FILE");
        sink.lazy(dataKey7, () -> BookmarksView.uiDataSnapshot$lambda$0(selection));
        DataKey dataKey8 = PlatformDataKeys.VIRTUAL_FILE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey8, (String)"VIRTUAL_FILE_ARRAY");
        sink.lazy(dataKey8, () -> BookmarksView.uiDataSnapshot$lambda$1(selection));
        DataKey dataKey9 = PlatformCoreDataKeys.MODULE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey9, (String)"MODULE");
        sink.lazy(dataKey9, () -> BookmarksView.uiDataSnapshot$lambda$2(selection, this));
        DataKey dataKey10 = Location.DATA_KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey10, (String)"DATA_KEY");
        sink.lazy(dataKey10, () -> BookmarksView.uiDataSnapshot$lambda$3(selection));
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = BookmarkBundle.message("bookmark.go.to.next.occurence.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = BookmarkBundle.message("bookmark.go.to.previous.occurence.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean hasNextOccurence() {
        return this.getNextOccurrence() != null;
    }

    public boolean hasPreviousOccurence() {
        return this.getPreviousOccurrence() != null;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        OccurenceNavigator.OccurenceInfo occurenceInfo;
        BookmarkOccurrence bookmarkOccurrence = this.getNextOccurrence();
        if (bookmarkOccurrence != null) {
            BookmarkOccurrence it = bookmarkOccurrence;
            boolean bl = false;
            occurenceInfo = this.go(it);
        } else {
            occurenceInfo = null;
        }
        return occurenceInfo;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        OccurenceNavigator.OccurenceInfo occurenceInfo;
        BookmarkOccurrence bookmarkOccurrence = this.getPreviousOccurrence();
        if (bookmarkOccurrence != null) {
            BookmarkOccurrence it = bookmarkOccurrence;
            boolean bl = false;
            occurenceInfo = this.go(it);
        } else {
            occurenceInfo = null;
        }
        return occurenceInfo;
    }

    private final OccurenceNavigator.OccurenceInfo go(BookmarkOccurrence occurrence) {
        this.select(occurrence.getGroup(), occurrence.getBookmark()).onSuccess(arg_0 -> BookmarksView.go$lambda$1(arg_0 -> BookmarksView.go$lambda$0(this, arg_0), arg_0));
        return null;
    }

    public final void select(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.updater.updateImmediately(() -> BookmarksView.select$lambda$0(this, file));
    }

    @NotNull
    public final Promise<TreePath> select(@NotNull BookmarkGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return this.select(new GroupBookmarkVisitor(group, null, 2, null), true);
    }

    @NotNull
    public final Promise<TreePath> select(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        return this.select(new GroupBookmarkVisitor(group, bookmark), false);
    }

    private final Promise<TreePath> select(TreeVisitor visitor, boolean centered) {
        Promise promise = TreeUtil.promiseMakeVisible((JTree)((JTree)this.tree), (TreeVisitor)visitor).onSuccess(arg_0 -> BookmarksView.select$lambda$2(arg_0 -> BookmarksView.select$lambda$1(this, centered, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onSuccess(...)");
        return promise;
    }

    protected void saveProportion() {
        block1: {
            block0: {
                if (!this.isPopup) break block0;
                BookmarksViewState bookmarksViewState = this.state;
                if (bookmarksViewState == null) break block1;
                bookmarksViewState.setProportionPopup(this.getProportion());
                break block1;
            }
            BookmarksViewState bookmarksViewState = this.state;
            if (bookmarksViewState == null) break block1;
            bookmarksViewState.setProportionView(this.getProportion());
        }
    }

    protected void loadProportion() {
        if (this.isPopup) {
            this.setProportion(this.state.getProportionPopup());
        } else {
            this.setProportion(this.state.getProportionView());
        }
    }

    public void setOrientation(boolean vertical) {
        super.setOrientation(vertical);
        this.selectionChanged(false);
    }

    @NotNull
    public final ToggleOptionAction.Option getGroupLineBookmarks() {
        return this.groupLineBookmarks;
    }

    @NotNull
    public final ToggleOptionAction.Option getAutoScrollFromSource() {
        return this.autoScrollFromSource;
    }

    @NotNull
    public final ToggleOptionAction.Option getAutoScrollToSource() {
        return this.autoScrollToSource;
    }

    @NotNull
    public final ToggleOptionAction.Option getOpenInPreviewTab() {
        return this.openInPreviewTab;
    }

    @NotNull
    public final ToggleOptionAction.Option getShowPreview() {
        return this.showPreview;
    }

    private final void selectionChanged(boolean autoScroll) {
        if (this.isPopup || !this.openInPreviewTab.isEnabled()) {
            AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
            this.preview.open((OpenFileDescriptor)(abstractTreeNode != null ? ExtensionsKt.toOpenFileDescriptor(abstractTreeNode) : null));
        } else {
            this.preview.close();
            if (autoScroll && (this.autoScrollToSource.isSelected() || this.openInPreviewTab.isSelected())) {
                this.navigateToSource(false);
            }
        }
    }

    static /* synthetic */ void selectionChanged$default(BookmarksView bookmarksView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = bookmarksView.tree.hasFocus();
        }
        bookmarksView.selectionChanged(bl);
    }

    private final void navigateToSource(boolean requestFocus) {
        block2: {
            AbstractTreeNode<?> abstractTreeNode = this.getSelectedNode();
            if (abstractTreeNode == null) {
                return;
            }
            AbstractTreeNode<?> node = abstractTreeNode;
            VirtualFile virtualFile = ExtensionsKt.asVirtualFile(node);
            if (Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getFileType() : null), (Object)FileTypes.UNKNOWN)) {
                return;
            }
            Runnable task = () -> BookmarksView.navigateToSource$lambda$0(requestFocus, node);
            Application application = ApplicationManager.getApplication();
            if (application == null) break block2;
            application.invokeLater(task, ModalityState.stateForComponent((Component)((Component)this.tree)), arg_0 -> BookmarksView.navigateToSource$lambda$1(this, arg_0));
        }
    }

    public final void addEditSourceListener(@NotNull EditSourceListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.editSourceListeners.add(listener2);
    }

    private static final void selectionAlarm$lambda$0(BookmarksView this$0) {
        WriteIntentReadAction.run(() -> BookmarksView.selectionChanged$default(this$0, false, 1, null));
    }

    private static final VirtualFile uiDataSnapshot$lambda$0(List $selection) {
        List list2 = $selection;
        return list2 != null && (list2 = (AbstractTreeNode)CollectionsKt.firstOrNull((List)list2)) != null ? ExtensionsKt.asVirtualFile(list2) : null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final VirtualFile[] uiDataSnapshot$lambda$1(List $selection) {
        Collection collection;
        void $this$mapNotNullTo$iv$iv;
        List list2 = $selection;
        List list3 = list2;
        if (list2 == null) return null;
        Iterable $this$mapNotNull$iv = list3;
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            AbstractTreeNode it = (AbstractTreeNode)element$iv$iv;
            boolean bl2 = false;
            if (ExtensionsKt.asVirtualFile(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $i$f$mapNotNull22 = (List)destination$iv$iv;
        if ($i$f$mapNotNull22.isEmpty()) {
            boolean bl = false;
            collection = null;
        } else {
            collection = $i$f$mapNotNull22;
        }
        List list4 = (List)collection;
        list3 = list4;
        if (list4 == null) return null;
        Collection $this$toTypedArray$iv = list3;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        return virtualFileArray;
    }

    private static final Module uiDataSnapshot$lambda$2(List $selection, BookmarksView this$0) {
        Module module;
        List list2 = $selection;
        if (list2 != null && (list2 = (AbstractTreeNode)CollectionsKt.firstOrNull((List)list2)) != null && (list2 = ExtensionsKt.asVirtualFile(list2)) != null && (list2 = VirtualFileUtil.validOrNull((VirtualFile)list2)) != null) {
            List it = list2;
            boolean bl = false;
            module = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)this$0.project);
        } else {
            module = null;
        }
        return module;
    }

    private static final Location uiDataSnapshot$lambda$3(List $selection) {
        List list2 = $selection;
        return list2 != null && (list2 = (AbstractTreeNode)CollectionsKt.firstOrNull((List)list2)) != null ? ExtensionsKt.toLocation(list2) : null;
    }

    private static final Unit go$lambda$0(BookmarksView this$0, TreePath it) {
        this$0.navigateToSource(true);
        return Unit.INSTANCE;
    }

    private static final void go$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void select$lambda$0(BookmarksView this$0, VirtualFile $file) {
        this$0.select(new VirtualFileVisitor($file, null), true);
    }

    private static final Unit select$lambda$1(BookmarksView this$0, boolean $centered, TreePath it) {
        this$0.tree.setSelectionPath(it);
        TreeUtil.scrollToVisible((JTree)((JTree)this$0.tree), (TreePath)it, (boolean)$centered);
        if (!this$0.tree.hasFocus()) {
            BookmarksView.selectionChanged$default(this$0, false, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final void select$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void navigateToSource$lambda$0(boolean $requestFocus, AbstractTreeNode $node) {
        OpenSourceUtil.navigateToSource((boolean)$requestFocus, (boolean)false, (Navigatable)((Navigatable)$node));
    }

    private static final boolean navigateToSource$lambda$1(BookmarksView this$0, Object it) {
        return this$0.project.isDisposed();
    }

    private static final DnDDragStartBean _init_$lambda$0(Function1 $tmp0, Object p0) {
        return (DnDDragStartBean)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$1(BookmarksView this$0, TreeSelectionEvent it) {
        if (this$0.tree.hasFocus()) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this$0.selectionAlarm, (boolean)false, (int)1, null);
        }
    }

    private static final Unit _init_$lambda$2(BookmarksView this$0) {
        Iterable $this$forEach$iv = this$0.editSourceListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditSourceListener it = (EditSourceListener)element$iv;
            boolean bl = false;
            it.onEditSource();
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(BookmarksView this$0) {
        Iterable $this$forEach$iv = this$0.editSourceListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditSourceListener it = (EditSourceListener)element$iv;
            boolean bl = false;
            it.onEditSource();
        }
    }

    public static final /* synthetic */ BookmarksViewState access$getState$p(BookmarksView $this) {
        return $this.state;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksView$Companion;", "", "<init>", "()V", "BOOKMARKS_VIEW", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "getBOOKMARKS_VIEW", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.platform.bookmarks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<BookmarksView> getBOOKMARKS_VIEW() {
            return BOOKMARKS_VIEW;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ide/bookmark/ui/BookmarksView$EditSourceListener;", "", "onEditSource", "", "intellij.platform.bookmarks"})
    public static interface EditSourceListener {
        public void onEditSource();
    }
}

