/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.ide.bookmark.ui.GroupSelectDialog;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/bookmark/actions/ToggleBookmarkAction;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "addSingleBookmark", "addMultipleBookmarks", "bookmarks", "", "Lcom/intellij/ide/bookmark/Bookmark;", "isUnexpected", "", "Ljava/awt/event/MouseEvent;", "(Ljava/awt/event/MouseEvent;)Z", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nToggleBookmarkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToggleBookmarkAction.kt\ncom/intellij/ide/bookmark/actions/ToggleBookmarkAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1#2:96\n1915#3,2:97\n1915#3,2:99\n*S KotlinDebug\n*F\n+ 1 ToggleBookmarkAction.kt\ncom/intellij/ide/bookmark/actions/ToggleBookmarkAction\n*L\n76#1:97,2\n85#1:99,2\n*E\n"})
public final class ToggleBookmarkAction
extends DumbAwareAction
implements Toggleable {
    public ToggleBookmarkAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation;
        Object object;
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (ExtensionsKt.getContextBookmarks(event) != null) {
            Presentation presentation2;
            Presentation $this$update_u24lambda_u240 = presentation2 = event.getPresentation();
            boolean bl = false;
            $this$update_u24lambda_u240.setEnabledAndVisible(true);
            $this$update_u24lambda_u240.setText(BookmarkBundle.message("bookmark.add.multiple.action.text", new Object[0]));
            return;
        }
        BookmarksManager manager = ExtensionsKt.getBookmarksManager(event);
        Bookmark bookmark2 = bookmark = ExtensionsKt.getContextBookmark(event);
        if (bookmark2 != null) {
            Bookmark it = bookmark2;
            boolean bl = false;
            BookmarksManager bookmarksManager = manager;
            object = bookmarksManager != null ? bookmarksManager.getType(it) : null;
        } else {
            object = null;
        }
        BookmarkType type = object;
        Presentation $this$update_u24lambda_u242 = presentation = event.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u242.setEnabledAndVisible(bookmark != null);
        String string = event.getPlace();
        $this$update_u24lambda_u242.setIcon(switch (string.hashCode()) {
            case -1388598828 -> {
                if (string.equals("TouchBarGeneral")) {
                    Toggleable.setSelected((Presentation)$this$update_u24lambda_u242, (type != null ? 1 : 0) != 0);
                    yield AllIcons.Actions.Checked;
                }
            }
            default -> null;
        });
        $this$update_u24lambda_u242.setText(!event.isFromContextMenu() ? ActionsBundle.message((String)"action.ToggleBookmark.text", (Object[])new Object[0]) : (type != null ? BookmarkBundle.message("bookmark.delete.action.text", new Object[0]) : BookmarkBundle.message("bookmark.add.action.text", new Object[0])));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Boolean unexpectedGutterClick;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InputEvent inputEvent = event.getInputEvent();
        MouseEvent mouseEvent = inputEvent instanceof MouseEvent ? (MouseEvent)inputEvent : null;
        if (mouseEvent != null) {
            MouseEvent $this$actionPerformed_u24lambda_u240 = mouseEvent;
            boolean bl = false;
            v1 = $this$actionPerformed_u24lambda_u240.getSource() instanceof EditorGutter && this.isUnexpected($this$actionPerformed_u24lambda_u240);
        } else {
            v1 = unexpectedGutterClick = null;
        }
        if (Intrinsics.areEqual(unexpectedGutterClick, (Object)true)) {
            return;
        }
        List<Bookmark> bookmarks = ExtensionsKt.getContextBookmarks(event);
        if (bookmarks != null) {
            this.addMultipleBookmarks(event, bookmarks);
        } else {
            this.addSingleBookmark(event);
        }
    }

    private final void addSingleBookmark(AnActionEvent event) {
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Bookmark bookmark = ExtensionsKt.getContextBookmark(event);
        if (bookmark == null) {
            return;
        }
        Bookmark bookmark2 = bookmark;
        BookmarkType bookmarkType = manager.getType(bookmark2);
        if (bookmarkType == null) {
            bookmarkType = BookmarkType.DEFAULT;
        }
        BookmarkType type = bookmarkType;
        manager.toggle(bookmark2, type);
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        String selectedText = editor != null && (editor = editor.getSelectionModel()) != null ? editor.getSelectedText() : null;
        CharSequence charSequence = selectedText;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            List list2 = manager.getGroups(bookmark2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getGroups(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BookmarkGroup group = (BookmarkGroup)element$iv;
                boolean bl = false;
                group.setDescription(bookmark2, selectedText);
            }
        }
    }

    private final void addMultipleBookmarks(AnActionEvent event, List<? extends Bookmark> bookmarks) {
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Project project = event.getProject();
        List list2 = manager.getGroups();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getGroups(...)");
        BookmarkGroup bookmarkGroup = new GroupSelectDialog(project, null, manager, list2).showAndGetGroup(false);
        if (bookmarkGroup == null) {
            return;
        }
        BookmarkGroup group = bookmarkGroup;
        Iterable $this$forEach$iv = bookmarks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bookmark it = (Bookmark)element$iv;
            boolean bl = false;
            BookmarkGroup.add$default((BookmarkGroup)group, (Bookmark)it, (BookmarkType)BookmarkType.DEFAULT, null, (int)4, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnexpected(MouseEvent $this$isUnexpected) {
        if (!SwingUtilities.isLeftMouseButton($this$isUnexpected)) return true;
        if ($this$isUnexpected.isPopupTrigger()) return true;
        if (SystemInfo.isMac) {
            if ($this$isUnexpected.isMetaDown()) return false;
            return true;
        }
        if ($this$isUnexpected.isControlDown()) return false;
        return true;
    }
}

