/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.BookmarksManagerImpl;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.providers.FileBookmarkImpl;
import com.intellij.ide.bookmark.providers.InvalidBookmark;
import com.intellij.ide.bookmark.providers.LineBookmarkImpl;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.FileNode;
import com.intellij.ide.bookmark.ui.tree.LineNode;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001BB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J$\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0016J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\tJ!\u0010\u0013\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010\u0013\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00162\b\b\u0002\u0010\u001c\u001a\u00020\tH\u0002J\u001c\u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020\u00162\b\b\u0002\u0010\u001c\u001a\u00020\tH\u0002J\u001a\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00162\b\b\u0002\u0010\u001c\u001a\u00020\tH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u0004\u0018\u0001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0010H\u0002J\b\u0010<\u001a\u00020-H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020\rH\u0002J\u0014\u0010?\u001a\u00020@2\n\u0010A\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010(\u001a\t\u0018\u00010\u001b\u00a2\u0006\u0002\b)*\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u00106\u001a2\u0012\u000e\u0012\f0/\u00a2\u0006\u0002\b8\u00a2\u0006\u0002\b9 ;*\u0017\u0012\u000e\u0012\f0/\u00a2\u0006\u0002\b8\u00a2\u0006\u0002\b90:\u00a2\u0006\u0002\b807\u00a2\u0006\u0002\b8X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "Lcom/intellij/ide/bookmark/BookmarkProvider;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getWeight", "", "getProject", "compare", "bookmark1", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmark2", "prepareGroup", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "nodes", "createBookmark", "map", "", "", "context", "", "Lcom/intellij/ide/bookmark/FileBookmark;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;)Lcom/intellij/ide/bookmark/FileBookmark;", "url", "createValidBookmark", "createInvalidBookmark", "Lcom/intellij/ide/bookmark/providers/InvalidBookmark;", "element", "Lcom/intellij/psi/PsiElement;", "path", "Ljavax/swing/tree/TreePath;", "asVirtualFile", "Lorg/jetbrains/annotations/Nullable;", "getAsVirtualFile", "(Ljavax/swing/tree/TreePath;)Lcom/intellij/openapi/vfs/VirtualFile;", "afterDocumentChange", "", "document", "Lcom/intellij/openapi/editor/Document;", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "validateAlarm", "Lcom/intellij/util/SingleAlarm;", "reloadingDocs", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "validateAndUpdate", "validate", "bookmark", "isNodeVisible", "", "node", "Util", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nLineBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineBookmarkProvider.kt\ncom/intellij/ide/bookmark/providers/LineBookmarkProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,247:1\n1915#2,2:248\n777#2:251\n873#2,2:252\n777#2:254\n873#2,2:255\n1915#2,2:257\n1915#2,2:273\n1642#2,10:275\n1915#2:285\n1916#2:287\n1652#2:288\n1807#2,3:291\n1915#2,2:294\n1#3:250\n1#3:270\n1#3:286\n139#4,10:259\n221#4:269\n222#4:271\n149#4:272\n221#4,2:289\n*S KotlinDebug\n*F\n+ 1 LineBookmarkProvider.kt\ncom/intellij/ide/bookmark/providers/LineBookmarkProvider\n*L\n64#1:248,2\n65#1:251\n65#1:252,2\n66#1:254\n66#1:255,2\n69#1:257,2\n76#1:273,2\n82#1:275,10\n82#1:285\n82#1:287\n82#1:288\n178#1:291,3\n189#1:294,2\n76#1:270\n82#1:286\n76#1:259,10\n76#1:269\n76#1:271\n76#1:272\n165#1:289,2\n*E\n"})
public final class LineBookmarkProvider
implements BookmarkProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final SingleAlarm validateAlarm;
    @NotNull
    private final Set<Document> reloadingDocs;

    public LineBookmarkProvider(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        SingleAlarm.Companion companion = SingleAlarm.Companion;
        KFunction kFunction = (KFunction)new Function0<Unit>((Object)this){

            public final void invoke() {
                LineBookmarkProvider.access$validateAndUpdate((LineBookmarkProvider)this.receiver);
            }
        };
        this.validateAlarm = companion.singleAlarm(100, coroutineScope, (Function0)kFunction);
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.reloadingDocs = set;
        if (!this.project.isDefault()) {
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
            EditorEventMulticaster multicaster = editorEventMulticaster;
            multicaster.addDocumentListener((DocumentListener)new BulkAwareDocumentListener.Simple(){

                public void afterDocumentChange(Document document) {
                    Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                    this.afterDocumentChange(document);
                }
            }, (Disposable)this.project);
            VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

                public AsyncFileListener.ChangeApplier prepareChange(List<? extends VFileEvent> events) {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    return this.prepareChange(events);
                }
            }, (Disposable)this.project);
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
            Topic topic = FileDocumentManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new FileDocumentManagerListener(){

                public void beforeFileContentReload(VirtualFile file, Document document) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                    reloadingDocs.add(document);
                }

                public void fileContentReloaded(VirtualFile file, Document document) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                    reloadingDocs.remove(document);
                }
            });
        }
    }

    public int getWeight() {
        return Integer.MIN_VALUE;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public int compare(@NotNull Bookmark bookmark1, @NotNull Bookmark bookmark2) {
        VirtualFile file2;
        FileBookmark fileBookmark2;
        Intrinsics.checkNotNullParameter((Object)bookmark1, (String)"bookmark1");
        Intrinsics.checkNotNullParameter((Object)bookmark2, (String)"bookmark2");
        FileBookmark fileBookmark1 = bookmark1 instanceof FileBookmark ? (FileBookmark)bookmark1 : null;
        FileBookmark fileBookmark = fileBookmark2 = bookmark2 instanceof FileBookmark ? (FileBookmark)bookmark2 : null;
        if (fileBookmark1 == null && fileBookmark2 == null) {
            return 0;
        }
        if (fileBookmark1 == null) {
            return -1;
        }
        if (fileBookmark2 == null) {
            return 1;
        }
        VirtualFile file1 = fileBookmark1.getFile();
        if (Intrinsics.areEqual((Object)file1, (Object)(file2 = fileBookmark2.getFile()))) {
            LineBookmark lineBookmark2;
            Bookmark bookmark = bookmark1;
            LineBookmark lineBookmark1 = bookmark instanceof LineBookmark ? (LineBookmark)bookmark : null;
            Bookmark bookmark3 = bookmark2;
            LineBookmark lineBookmark = lineBookmark2 = bookmark3 instanceof LineBookmark ? (LineBookmark)bookmark3 : null;
            if (lineBookmark1 == null && lineBookmark2 == null) {
                return 0;
            }
            if (lineBookmark1 == null) {
                return -1;
            }
            if (lineBookmark2 == null) {
                return 1;
            }
            return Intrinsics.compare((int)lineBookmark1.getLine(), (int)lineBookmark2.getLine());
        }
        if (file1.isDirectory() && !file2.isDirectory()) {
            return -1;
        }
        if (!file1.isDirectory() && file2.isDirectory()) {
            return 1;
        }
        return StringUtil.naturalCompare((String)file1.getPresentableName(), (String)file2.getPresentableName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AbstractTreeNode<?>> prepareGroup(@NotNull List<? extends AbstractTreeNode<?>> nodes) {
        VirtualFile it$iv$iv;
        AbstractTreeNode it;
        Object element$iv$iv$iv;
        Object $this$mapNotNullTo$iv$iv;
        Object destination$iv$iv;
        BookmarkNode bookmarkNode;
        Object it22;
        block15: {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            Iterable $this$forEach$iv = nodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it22 = (AbstractTreeNode)element$iv;
                boolean bl = false;
                FileNode fileNode = it22 instanceof FileNode ? (FileNode)((Object)it22) : null;
                if (fileNode == null) continue;
                fileNode.ungroup();
            }
            for (Object it22 : (Iterable)nodes) {
                boolean bl = false;
                if ((it22 = it22 instanceof LineNode ? (LineNode)((Object)it22) : null) == null) continue;
                bookmarkNode = it22;
                break block15;
            }
            bookmarkNode = null;
        }
        if (bookmarkNode == null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = nodes;
            boolean $i$f$filter2 = false;
            it22 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AbstractTreeNode p0 = (AbstractTreeNode)element$iv$iv;
                boolean bl = false;
                if (!this.isNodeVisible(p0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            return (List)destination$iv$iv2;
        }
        BookmarkNode node = bookmarkNode;
        BookmarksView bookmarksView = node.getBookmarksView$intellij_platform_bookmarks();
        if (!(bookmarksView != null && (bookmarksView = bookmarksView.getGroupLineBookmarks()) != null ? bookmarksView.isSelected() : false)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = nodes;
            boolean $i$f$filter = false;
            Iterable $i$f$filter2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AbstractTreeNode p0 = (AbstractTreeNode)element$iv$iv;
                boolean bl = false;
                if (!this.isNodeVisible(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractTreeNode it3 = (AbstractTreeNode)element$iv;
            boolean bl = false;
            AbstractTreeNode p0 = it3;
            if (p0 instanceof LineNode) {
                map.putIfAbsent(((LineNode)it3).getVirtualFile(), null);
                continue;
            }
            if (!(p0 instanceof FileNode)) continue;
            map.put(((FileNode)it3).getVirtualFile(), it3);
        }
        Object $this$mapNotNull$iv = map;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach22 = false;
        Object object = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            AbstractTreeNode element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            it = element$iv$iv;
            boolean bl2 = false;
            if ((it.getValue() == null ? (VirtualFile)it.getKey() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it4 = (VirtualFile)element$iv;
            boolean bl = false;
            Map $i$f$forEach22 = map;
            Object $this$prepareGroup_u24lambda_u245_u240 = object = new FileNode(this.project, new FileBookmarkImpl(this, it4));
            boolean bl4 = false;
            ((BookmarkNode)((Object)$this$prepareGroup_u24lambda_u245_u240)).setBookmarkGroup(node.getBookmarkGroup());
            $this$prepareGroup_u24lambda_u245_u240.setParent(node.getParent());
            $i$f$forEach22.put(it4, object);
        }
        $this$mapNotNull$iv = nodes;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        object = $this$forEach$iv$iv$iv2.iterator();
        while (object.hasNext()) {
            AbstractTreeNode abstractTreeNode;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            it = element$iv$iv;
            boolean bl5 = false;
            if (!this.isNodeVisible(it)) {
                abstractTreeNode = null;
            } else if (it instanceof LineNode) {
                Object v = map.get(((LineNode)it).getVirtualFile());
                Intrinsics.checkNotNull(v);
                abstractTreeNode = (AbstractTreeNode)((FileNode)((Object)v)).grouped(it);
            } else {
                abstractTreeNode = it instanceof FileNode ? (AbstractTreeNode)((FileNode)it).grouped() : it;
            }
            if (abstractTreeNode == null) continue;
            it$iv$iv = abstractTreeNode;
            boolean bl6 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        return (List)destination$iv$iv3;
    }

    @Nullable
    public Bookmark createBookmark(@NotNull Map<String, String> map) {
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        String string = map.get("url");
        if (string != null) {
            String it = string;
            boolean bl = false;
            bookmark = this.createBookmark(it, StringUtil.parseInt((String)map.get("line"), (int)-1));
        } else {
            bookmark = null;
        }
        return bookmark;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Bookmark createBookmark(@Nullable Object context) {
        Bookmark bookmark;
        Object object = context;
        if (object instanceof com.intellij.ide.bookmarks.Bookmark) {
            VirtualFile virtualFile = ((com.intellij.ide.bookmarks.Bookmark)context).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            bookmark = (Bookmark)this.createBookmark(virtualFile, ((com.intellij.ide.bookmarks.Bookmark)context).getLine());
            return bookmark;
        }
        if (object instanceof AbstractUrl) {
            String string = ((AbstractUrl)context).getType();
            switch (string.hashCode()) {
                case -287291038: {
                    if (string.equals("psiFile")) break;
                    return null;
                }
                case -962584979: {
                    if (!string.equals("directory")) return null;
                    String string2 = ((AbstractUrl)context).getURL();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getURL(...)");
                    bookmark = LineBookmarkProvider.createBookmark$default(this, string2, 0, 2, null);
                    return bookmark;
                }
            }
            String string3 = ((AbstractUrl)context).getURL();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getURL(...)");
            bookmark = LineBookmarkProvider.createBookmark$default(this, string3, 0, 2, null);
            return bookmark;
            return null;
        }
        if (object instanceof PsiElement) {
            bookmark = (Bookmark)this.createBookmark((PsiElement)context);
            return bookmark;
        } else if (object instanceof VirtualFile) {
            bookmark = (Bookmark)this.createBookmark((VirtualFile)context, -1);
            return bookmark;
        } else if (object instanceof ProjectFileNode) {
            VirtualFile virtualFile = ((ProjectFileNode)context).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            bookmark = (Bookmark)LineBookmarkProvider.createBookmark$default(this, virtualFile, 0, 2, null);
            return bookmark;
        } else {
            if (!(object instanceof TreePath)) return null;
            bookmark = (Bookmark)this.createBookmark((TreePath)context);
        }
        return bookmark;
    }

    @Nullable
    public final FileBookmark createBookmark(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !file.isValid() || file instanceof LightVirtualFile ? null : (line >= 0 ? (FileBookmark)new LineBookmarkImpl(this, file, line) : (FileBookmark)new FileBookmarkImpl(this, file));
    }

    public static /* synthetic */ FileBookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, VirtualFile virtualFile, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createBookmark(virtualFile, n);
    }

    @Nullable
    public final FileBookmark createBookmark(@NotNull Editor editor, @Nullable Integer line) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor.isOneLineMode()) {
            return null;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        Integer n = line;
        return this.createBookmark(file, n != null ? n : editor.getCaretModel().getLogicalPosition().line);
    }

    public static /* synthetic */ FileBookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, Editor editor, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return lineBookmarkProvider.createBookmark(editor, n);
    }

    private final Bookmark createBookmark(String url, int line) {
        FileBookmark fileBookmark = this.createValidBookmark(url, line);
        return fileBookmark != null ? (Bookmark)fileBookmark : (Bookmark)this.createInvalidBookmark(url, line);
    }

    static /* synthetic */ Bookmark createBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createBookmark(string, n);
    }

    private final FileBookmark createValidBookmark(String url, int line) {
        FileBookmark fileBookmark;
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(url);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            fileBookmark = this.createBookmark(it, line);
        } else {
            fileBookmark = null;
        }
        return fileBookmark;
    }

    static /* synthetic */ FileBookmark createValidBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createValidBookmark(string, n);
    }

    private final InvalidBookmark createInvalidBookmark(String url, int line) {
        return new InvalidBookmark(this, url, line);
    }

    static /* synthetic */ InvalidBookmark createInvalidBookmark$default(LineBookmarkProvider lineBookmarkProvider, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return lineBookmarkProvider.createInvalidBookmark(string, n);
    }

    private final FileBookmark createBookmark(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            FileBookmark fileBookmark;
            VirtualFile virtualFile = ((PsiFileSystemItem)element).getVirtualFile();
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                fileBookmark = LineBookmarkProvider.createBookmark$default(this, it, 0, 2, null);
            } else {
                fileBookmark = null;
            }
            return fileBookmark;
        }
        if (element instanceof PsiCompiledElement) {
            return null;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (file instanceof LightVirtualFile) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int offset = element.getTextOffset();
        return (0 <= offset ? offset <= document2.getTextLength() : false) ? this.createBookmark(file, document2.getLineNumber(offset)) : null;
    }

    private final FileBookmark createBookmark(TreePath path) {
        VirtualFile virtualFile = this.getAsVirtualFile(path);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        TreePath treePath = path.getParentPath();
        if (treePath == null || (treePath = this.getAsVirtualFile(treePath)) == null) {
            return null;
        }
        TreePath parent = treePath;
        return !parent.isDirectory() || !Intrinsics.areEqual((Object)file.getParent(), (Object)parent) ? null : LineBookmarkProvider.createBookmark$default(this, file, 0, 2, null);
    }

    private final VirtualFile getAsVirtualFile(TreePath $this$asVirtualFile) {
        ProjectViewNode projectViewNode = (ProjectViewNode)TreeUtil.getLastUserObject(ProjectViewNode.class, (TreePath)$this$asVirtualFile);
        return projectViewNode != null ? projectViewNode.getVirtualFile() : null;
    }

    /*
     * Unable to fully structure code
     */
    private final void afterDocumentChange(Document document) {
        if (this.reloadingDocs.contains(document)) {
            return;
        }
        v0 = FileDocumentManager.getInstance().getFile(document);
        if (v0 == null) {
            return;
        }
        file = v0;
        if (file instanceof LightVirtualFile) {
            return;
        }
        v1 = BookmarksManager.getInstance((Project)this.project);
        if (v1 == null) {
            return;
        }
        manager = v1;
        map = MapsKt.sortedMapOf((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LineBookmarkImpl it = (LineBookmarkImpl)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getLine());
                it = (LineBookmarkImpl)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLine()));
            }
        }, (Pair[])new Pair[0]);
        set = new LinkedHashSet<E>();
        for (Bookmark bookmark : manager.getBookmarks()) {
            if (!(bookmark instanceof LineBookmarkImpl) || !Intrinsics.areEqual((Object)((LineBookmarkImpl)bookmark).getFile(), (Object)file)) continue;
            v2 = manager instanceof BookmarksManagerImpl != false ? (BookmarksManagerImpl)manager : null;
            rangeMarker = v2 != null && (v2 = v2.findLineHighlighter$intellij_platform_bookmarks(bookmark)) != null ? (RangeMarker)v2 : ((LineBookmarkImpl)bookmark).getDescriptor().getRangeMarker();
            v3 = rangeMarker;
            if (v3 == null) ** GOTO lbl-1000
            it = v3;
            $i$a$-let-LineBookmarkProvider$afterDocumentChange$line$1 = false;
            v4 = it.isValid() ? Integer.valueOf(it.getDocument().getLineNumber(it.getStartOffset())) : null;
            v3 = v4;
            if (v4 != null) {
                v5 = v3.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v5 = line = -1;
            }
            if (((LineBookmarkImpl)bookmark).getLine() == line) {
                set.add(line);
                continue;
            }
            ((Map)map).put(bookmark, line);
        }
        if (map.isEmpty()) {
            return;
        }
        bookmarks = new LinkedHashMap<K, V>();
        $this$forEach$iv = map;
        $i$f$forEach = false;
        var9_11 = $this$forEach$iv.entrySet().iterator();
        while (var9_11.hasNext()) {
            var11_17 = element$iv = var9_11.next();
            $i$a$-forEach-LineBookmarkProvider$afterDocumentChange$1 = false;
            bookmark = (LineBookmarkImpl)var11_17.getKey();
            line = (Integer)var11_17.getValue();
            if (line < 0 || set.contains(line)) {
                v6 = null;
            } else {
                Intrinsics.checkNotNull((Object)line);
                set.add(line);
                v6 = this.createBookmark(file, (int)line);
            }
            bookmarks.put(bookmark, v6);
        }
        manager.update(bookmarks);
    }

    private final AsyncFileListener.ChangeApplier prepareChange(List<? extends VFileEvent> events) {
        boolean update;
        block4: {
            Iterable $this$any$iv = events;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VFileEvent it = (VFileEvent)element$iv;
                    boolean bl = false;
                    if (!(it instanceof VFileCreateEvent || it instanceof VFileDeleteEvent)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = update = false;
            }
        }
        if (update) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.validateAlarm, (boolean)false, (int)1, null);
        }
        return null;
    }

    private final void validateAndUpdate() {
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)this.project);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Map bookmarks = new LinkedHashMap();
        List list2 = manager.getBookmarks();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBookmarks(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bookmark $this$validateAndUpdate_u24lambda_u240_u240;
            Bookmark it = (Bookmark)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.validate(it) == null) continue;
            boolean bl2 = false;
            bookmarks.put(it, $this$validateAndUpdate_u24lambda_u240_u240);
        }
        manager.update(bookmarks);
    }

    private final Bookmark validate(Bookmark bookmark) {
        Bookmark bookmark2;
        Bookmark bookmark3 = bookmark;
        if (bookmark3 instanceof InvalidBookmark) {
            bookmark2 = (Bookmark)this.createValidBookmark(((InvalidBookmark)bookmark).getUrl(), ((InvalidBookmark)bookmark).getLine());
        } else if (bookmark3 instanceof FileBookmarkImpl) {
            VirtualFile $this$validate_u24lambda_u240 = ((FileBookmarkImpl)bookmark).getFile();
            boolean bl = false;
            if ($this$validate_u24lambda_u240.isValid()) {
                bookmark2 = null;
            } else {
                String string = $this$validate_u24lambda_u240.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                bookmark2 = LineBookmarkProvider.createBookmark$default(this, string, 0, 2, null);
            }
        } else if (bookmark3 instanceof LineBookmarkImpl) {
            VirtualFile $this$validate_u24lambda_u241 = ((LineBookmarkImpl)bookmark).getFile();
            boolean bl = false;
            if ($this$validate_u24lambda_u241.isValid()) {
                bookmark2 = null;
            } else {
                String string = $this$validate_u24lambda_u241.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                bookmark2 = this.createBookmark(string, ((LineBookmarkImpl)bookmark).getLine());
            }
        } else {
            bookmark2 = null;
        }
        return bookmark2;
    }

    private final boolean isNodeVisible(AbstractTreeNode<?> node) {
        boolean bl;
        Object object = node.getValue();
        InvalidBookmark invalidBookmark = object instanceof InvalidBookmark ? (InvalidBookmark)object : null;
        if (invalidBookmark != null) {
            InvalidBookmark $this$isNodeVisible_u24lambda_u240 = invalidBookmark;
            boolean bl2 = false;
            bl = $this$isNodeVisible_u24lambda_u240.getLine() < 0;
        } else {
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ void access$validateAndUpdate(LineBookmarkProvider $this) {
        $this.validateAndUpdate();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider$Util;", "", "<init>", "()V", "find", "Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "project", "Lcom/intellij/openapi/project/Project;", "readLineText", "", "bookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "intellij.platform.bookmarks"})
    @SourceDebugExtension(value={"SMAP\nLineBookmarkProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineBookmarkProvider.kt\ncom/intellij/ide/bookmark/providers/LineBookmarkProvider$Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1#2:248\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @JvmStatic
        @Nullable
        public static final LineBookmarkProvider find(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return project.isDisposed() ? null : (LineBookmarkProvider)BookmarkProvider.EP.findExtension(LineBookmarkProvider.class, (AreaInstance)project);
        }

        @Nullable
        public final String readLineText(@Nullable LineBookmark bookmark) {
            String string;
            LineBookmark lineBookmark = bookmark;
            if (lineBookmark != null) {
                LineBookmark it = lineBookmark;
                boolean bl = false;
                string = INSTANCE.readLineText(it.getFile(), it.getLine());
            } else {
                string = null;
            }
            return string;
        }

        private final String readLineText(VirtualFile file, int line) {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return null;
            }
            Document document2 = document;
            if (line < 0 || document2.getLineCount() <= line) {
                return null;
            }
            int start = document2.getLineStartOffset(line);
            if (start < 0) {
                return null;
            }
            int end = document2.getLineEndOffset(line);
            if (end < start) {
                return null;
            }
            return document2.getText(TextRange.create((int)start, (int)end));
        }
    }
}

