/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@State(name="BookmarkManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Deprecated
public final class BookmarkManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(BookmarkManager.class);
    private static final int MAX_AUTO_DESCRIPTION_SIZE = 50;
    private final MultiMap<VirtualFile, Bookmark> myBookmarks;
    private final Map<DeletedDocumentBookmarkKey, Bookmark> myDeletedDocumentBookmarks;
    private final Map<Document, List<BookmarkInfo>> myBeforeChangeData;
    private final Project myProject;
    private boolean mySortedState;
    private final AtomicReference<List<Bookmark>> myPendingState;

    public static BookmarkManager getInstance(@NotNull Project project) {
        if (project == null) {
            BookmarkManager.$$$reportNull$$$0(0);
        }
        return (BookmarkManager)project.getService(BookmarkManager.class);
    }

    public BookmarkManager(@NotNull Project project) {
        if (project == null) {
            BookmarkManager.$$$reportNull$$$0(1);
        }
        this.myBookmarks = MultiMap.createConcurrentSet();
        this.myDeletedDocumentBookmarks = new HashMap<DeletedDocumentBookmarkKey, Bookmark>();
        this.myBeforeChangeData = new HashMap<Document, List<BookmarkInfo>>();
        this.myPendingState = new AtomicReference();
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorColorsManager.TOPIC, __ -> this.colorsChanged());
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this);
        this.mySortedState = UISettings.getInstance().getSortBookmarks();
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            if (this.mySortedState != uiSettings.getSortBookmarks()) {
                this.mySortedState = uiSettings.getSortBookmarks();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!project.isDisposed()) {
                        ((BookmarksListener)project.getMessageBus().syncPublisher(BookmarksListener.TOPIC)).bookmarksOrderChanged();
                    }
                });
            }
        });
    }

    @NotNull
    public Bookmark addTextBookmark(@NotNull VirtualFile file, int lineIndex, @NotNull @NlsSafe String description) {
        if (file == null) {
            BookmarkManager.$$$reportNull$$$0(2);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Bookmark b = new Bookmark(this.myProject, file, lineIndex, description);
        this.myBookmarks.values().forEach(bookmark -> ++bookmark.index);
        this.myBookmarks.putValue((Object)file, (Object)b);
        this.getPublisher().bookmarkAdded(b);
        Bookmark bookmark2 = b;
        if (bookmark2 == null) {
            BookmarkManager.$$$reportNull$$$0(4);
        }
        return bookmark2;
    }

    @NotNull
    private BookmarksListener getPublisher() {
        BookmarksListener bookmarksListener = (BookmarksListener)this.myProject.getMessageBus().syncPublisher(BookmarksListener.TOPIC);
        if (bookmarksListener == null) {
            BookmarkManager.$$$reportNull$$$0(5);
        }
        return bookmarksListener;
    }

    @TestOnly
    public void addFileBookmark(@NotNull VirtualFile file, @NotNull @NlsSafe String description) {
        if (file == null) {
            BookmarkManager.$$$reportNull$$$0(6);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(7);
        }
        if (this.findFileBookmark(file) != null) {
            return;
        }
        this.addTextBookmark(file, -1, description);
    }

    @NotNull
    private static String getAutoDescription(@NotNull Editor editor, int lineIndex) {
        String autoDescription;
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(8);
        }
        if ((autoDescription = editor.getSelectionModel().getSelectedText()) == null) {
            Document document = editor.getDocument();
            autoDescription = document.getCharsSequence().subSequence(document.getLineStartOffset(lineIndex), document.getLineEndOffset(lineIndex)).toString().trim();
        }
        if (autoDescription.length() > 50) {
            String string = autoDescription.substring(0, 50) + "...";
            if (string == null) {
                BookmarkManager.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = autoDescription;
        if (string == null) {
            BookmarkManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public @Unmodifiable List<Bookmark> getValidBookmarks() {
        List answer = ContainerUtil.filter((Collection)this.myBookmarks.values(), b -> b.isValid());
        if (UISettings.getInstance().getSortBookmarks()) {
            List list2 = ContainerUtil.sorted((Collection)answer);
            if (list2 == null) {
                BookmarkManager.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List list3 = ContainerUtil.sorted((Collection)answer, Comparator.comparingInt(b -> b.index));
        if (list3 == null) {
            BookmarkManager.$$$reportNull$$$0(12);
        }
        return list3;
    }

    @NotNull
    public Collection<Bookmark> getAllBookmarks() {
        Collection collection = this.myBookmarks.values();
        if (collection == null) {
            BookmarkManager.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public Collection<Bookmark> getFileBookmarks(@Nullable VirtualFile file) {
        Collection collection = this.myBookmarks.get((Object)file);
        if (collection == null) {
            BookmarkManager.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Nullable
    public Bookmark findEditorBookmark(@NotNull Document document, int line) {
        VirtualFile file;
        if (document == null) {
            BookmarkManager.$$$reportNull$$$0(15);
        }
        if ((file = FileDocumentManager.getInstance().getFile(document)) == null) {
            return null;
        }
        return this.findBookmark(file, line);
    }

    @ApiStatus.Internal
    @Nullable
    public Bookmark findBookmark(@NotNull VirtualFile file, int line) {
        if (file == null) {
            BookmarkManager.$$$reportNull$$$0(16);
        }
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.get((Object)file), bookmark -> bookmark.getLine() == line);
    }

    @Nullable
    public Bookmark findFileBookmark(@NotNull VirtualFile file) {
        if (file == null) {
            BookmarkManager.$$$reportNull$$$0(17);
        }
        return this.findBookmark(file, -1);
    }

    @Nullable
    public Bookmark findBookmarkForMnemonic(char m) {
        char mm = Character.toUpperCase(m);
        return (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), bookmark -> bookmark.getMnemonic() == mm);
    }

    public boolean hasBookmarksWithMnemonics() {
        return ContainerUtil.or((Iterable)this.myBookmarks.values(), bookmark -> bookmark.getMnemonic() != '\u0000');
    }

    public void removeBookmark(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.assertEventDispatchThread();
        VirtualFile file = bookmark.getFile();
        if (this.myBookmarks.remove((Object)file, (Object)bookmark)) {
            int index = bookmark.index;
            this.myBookmarks.values().forEach(b -> {
                b.index = b.index - (b.index > index ? 1 : 0);
            });
            bookmark.release();
            this.getPublisher().bookmarkRemoved(bookmark);
        }
    }

    @Nullable
    public Bookmark findElementBookmark(@NotNull PsiElement element) {
        if (element == null) {
            BookmarkManager.$$$reportNull$$$0(19);
        }
        if (!(element instanceof PsiNameIdentifierOwner) || !element.isValid()) {
            return null;
        }
        if (element instanceof PsiCompiledElement) {
            return null;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        PsiElement nameIdentifier = virtualFile == null ? null : ((PsiNameIdentifierOwner)element).getNameIdentifier();
        TextRange nameRange = nameIdentifier == null ? null : nameIdentifier.getTextRange();
        Document document = nameRange == null ? null : FileDocumentManager.getInstance().getDocument(virtualFile);
        List<Bookmark> bookmarks = document == null ? Collections.emptyList() : this.getFileBookmarks(virtualFile);
        for (Bookmark bookmark : bookmarks) {
            int line = bookmark.getLine();
            if (line == -1 || !nameRange.intersects(document.getLineStartOffset(line), document.getLineEndOffset(line))) continue;
            return bookmark;
        }
        return null;
    }

    public Element getState() {
        Element container = new Element("BookmarkManager");
        this.writeExternal(container);
        return container;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            BookmarkManager.$$$reportNull$$$0(20);
        }
        this.myPendingState.set(BookmarkManager.readExternal(state));
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
            List newList = this.myPendingState.getAndSet(null);
            if (newList != null) {
                this.applyNewState(newList, true);
            }
        }, ModalityState.nonModal(), this.myProject.getDisposed()));
    }

    public void noStateLoaded() {
        LOG.info("no state loaded for old bookmarks");
    }

    @TestOnly
    public void applyNewStateInTestMode(@NotNull List<Bookmark> newList) {
        if (newList == null) {
            BookmarkManager.$$$reportNull$$$0(21);
        }
        this.applyNewState(newList, false);
    }

    private void applyNewState(@NotNull List<Bookmark> newList, boolean fireEvents) {
        if (newList == null) {
            BookmarkManager.$$$reportNull$$$0(22);
        }
        if (!this.myBookmarks.isEmpty()) {
            Bookmark[] bookmarks;
            for (Bookmark bookmark : bookmarks = this.myBookmarks.values().toArray(new Bookmark[0])) {
                bookmark.release();
            }
            this.myBookmarks.clear();
        }
        int bookmarkIndex = newList.size() - 1;
        ArrayList<Bookmark> addedBookmarks = new ArrayList<Bookmark>(newList.size());
        for (Bookmark bookmark : newList) {
            Bookmark old;
            OpenFileDescriptor target = bookmark.init(this.myProject);
            if (target == null || target.getLine() == -1 && this.findFileBookmark(target.getFile()) != null) continue;
            bookmark.index = bookmarkIndex--;
            char mnemonic = bookmark.getMnemonic();
            if (mnemonic != '\u0000' && (old = this.findBookmarkForMnemonic(mnemonic)) != null) {
                this.removeBookmark(old);
            }
            this.myBookmarks.putValue((Object)target.getFile(), (Object)bookmark);
            addedBookmarks.add(bookmark);
        }
        if (fireEvents) {
            for (Bookmark bookmark : addedBookmarks) {
                this.getPublisher().bookmarkAdded(bookmark);
            }
        }
    }

    @NotNull
    private static List<Bookmark> readExternal(@NotNull Element element) {
        if (element == null) {
            BookmarkManager.$$$reportNull$$$0(23);
        }
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        for (Element bookmarkElement : element.getChildren("bookmark")) {
            String url = bookmarkElement.getAttributeValue("url");
            if (StringUtil.isEmptyOrSpaces((String)url)) continue;
            String line = bookmarkElement.getAttributeValue("line");
            String description = StringUtil.notNullize((String)bookmarkElement.getAttributeValue("description"));
            String mnemonic = bookmarkElement.getAttributeValue("mnemonic");
            int lineIndex = -1;
            if (line != null) {
                try {
                    lineIndex = Integer.parseInt(line);
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
            }
            Bookmark bookmark = new Bookmark(url, lineIndex, description);
            if (mnemonic != null && mnemonic.length() == 1) {
                bookmark.setMnemonic(mnemonic.charAt(0));
            }
            result.add(bookmark);
        }
        ArrayList<Bookmark> arrayList = result;
        if (arrayList == null) {
            BookmarkManager.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    private void writeExternal(Element element) {
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>(this.myBookmarks.values());
        bookmarks.sort(Comparator.comparingInt(o -> o.index).reversed());
        for (Bookmark bookmark : bookmarks) {
            char mnemonic;
            int line;
            if (!bookmark.isValid()) continue;
            Element bookmarkElement = new Element("bookmark");
            bookmarkElement.setAttribute("url", bookmark.getFile().getUrl());
            String description = bookmark.nullizeEmptyDescription();
            if (description != null) {
                bookmarkElement.setAttribute("description", description);
            }
            if ((line = bookmark.getLine()) >= 0) {
                bookmarkElement.setAttribute("line", String.valueOf(line));
            }
            if ((mnemonic = bookmark.getMnemonic()) != '\u0000') {
                bookmarkElement.setAttribute("mnemonic", String.valueOf(mnemonic));
            }
            element.addContent(bookmarkElement);
        }
    }

    public void moveBookmarkUp(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(25);
        }
        ThreadingAssertions.assertEventDispatchThread();
        int index = bookmark.index;
        if (index > 0) {
            Bookmark other = (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), b -> b.index == index - 1);
            other.index = index;
            bookmark.index = index - 1;
            EventQueue.invokeLater(() -> {
                this.getPublisher().bookmarkChanged(bookmark);
                this.getPublisher().bookmarkChanged(other);
            });
        }
    }

    public void moveBookmarkDown(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(26);
        }
        ThreadingAssertions.assertEventDispatchThread();
        int index = bookmark.index;
        if (index < this.myBookmarks.values().size() - 1) {
            Bookmark other = (Bookmark)ContainerUtil.find((Iterable)this.myBookmarks.values(), b -> b.index == index + 1);
            other.index = index;
            bookmark.index = index + 1;
            EventQueue.invokeLater(() -> {
                this.getPublisher().bookmarkChanged(bookmark);
                this.getPublisher().bookmarkChanged(other);
            });
        }
    }

    @Nullable
    public Bookmark findLineBookmark(@NotNull Editor editor, boolean isWrapped, boolean next) {
        VirtualFile file;
        if (editor == null) {
            BookmarkManager.$$$reportNull$$$0(27);
        }
        if ((file = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) {
            return null;
        }
        ArrayList bookmarksForDocument = new ArrayList(this.myBookmarks.get((Object)file));
        if (bookmarksForDocument.isEmpty()) {
            return null;
        }
        int sign = next ? 1 : -1;
        bookmarksForDocument.sort((o1, o2) -> sign * (o1.getLine() - o2.getLine()));
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (Bookmark bookmark : bookmarksForDocument) {
            if (next && bookmark.getLine() > caretLine) {
                return bookmark;
            }
            if (next || bookmark.getLine() >= caretLine) continue;
            return bookmark;
        }
        return isWrapped && !bookmarksForDocument.isEmpty() ? (Bookmark)bookmarksForDocument.get(0) : null;
    }

    public void deleteMnemonic(@NotNull Bookmark bookmark) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(28);
        }
        if (BookmarkType.DEFAULT != bookmark.getType()) {
            this.updateMnemonic(bookmark, BookmarkType.DEFAULT.getMnemonic());
        }
    }

    public void setMnemonic(@NotNull Bookmark bookmark, char c) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Bookmark old = this.findBookmarkForMnemonic(c);
        if (old != null) {
            this.removeBookmark(old);
        }
        this.updateMnemonic(bookmark, c);
    }

    private void updateMnemonic(@NotNull Bookmark bookmark, char c) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(30);
        }
        bookmark.setMnemonic(c);
        this.getPublisher().bookmarkChanged(bookmark);
        bookmark.updateHighlighter();
    }

    public void setDescription(@NotNull Bookmark bookmark, @NotNull @NlsSafe String description) {
        if (bookmark == null) {
            BookmarkManager.$$$reportNull$$$0(31);
        }
        if (description == null) {
            BookmarkManager.$$$reportNull$$$0(32);
        }
        ThreadingAssertions.assertEventDispatchThread();
        bookmark.setDescription(description);
        this.getPublisher().bookmarkChanged(bookmark);
    }

    private void colorsChanged() {
        for (Bookmark bookmark : this.myBookmarks.values()) {
            bookmark.updateHighlighter();
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 9, 10, 11, 12, 13, 14, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/bookmarks/BookmarkManager";
                break;
            }
            case 8: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 18: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmark";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addTextBookmark";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoDescription";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidBookmarks";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBookmarks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBookmarks";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTextBookmark";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 24: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFileBookmark";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAutoDescription";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findEditorBookmark";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findBookmark";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findFileBookmark";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeBookmark";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findElementBookmark";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "applyNewStateInTestMode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyNewState";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "moveBookmarkUp";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "moveBookmarkDown";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findLineBookmark";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "deleteMnemonic";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setMnemonic";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateMnemonic";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 9, 10, 11, 12, 13, 14, 24 -> new IllegalStateException(string);
        };
    }

    private final class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            Document doc = e.getDocument();
            VirtualFile file = FileDocumentManager.getInstance().getFile(doc);
            if (file != null) {
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks.get((Object)file)) {
                    if (bookmark.getLine() == -1) continue;
                    List list2 = BookmarkManager.this.myBeforeChangeData.computeIfAbsent(doc, __ -> new ArrayList());
                    list2.add(new BookmarkInfo(bookmark, bookmark.getLine(), doc.getText(new TextRange(doc.getLineStartOffset(bookmark.getLine()), doc.getLineEndOffset(bookmark.getLine())))));
                }
            }
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            VirtualFile file = FileDocumentManager.getInstance().getFile(e.getDocument());
            ArrayList<Bookmark> bookmarksToRemove = null;
            if (file != null) {
                for (Bookmark bookmark : BookmarkManager.this.myBookmarks.get((Object)file)) {
                    if (bookmark.isValid() && !this.isDuplicate(bookmark, file, (List<Bookmark>)bookmarksToRemove)) continue;
                    if (bookmarksToRemove == null) {
                        bookmarksToRemove = new ArrayList<Bookmark>();
                    }
                    bookmarksToRemove.add(bookmark);
                }
            }
            if (bookmarksToRemove != null) {
                for (Bookmark bookmark : bookmarksToRemove) {
                    this.moveToDeleted(bookmark);
                }
            }
            BookmarkManager.this.myBeforeChangeData.remove(e.getDocument());
            Iterator<Map.Entry<DeletedDocumentBookmarkKey, Bookmark>> iterator = BookmarkManager.this.myDeletedDocumentBookmarks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DeletedDocumentBookmarkKey, Bookmark> entry = iterator.next();
                VirtualFile virtualFile = entry.getKey().file;
                if (!virtualFile.isValid()) {
                    iterator.remove();
                    continue;
                }
                Bookmark bookmark = entry.getValue();
                Document document = bookmark.getCachedDocument();
                if (document == null || !bookmark.getFile().equals(virtualFile)) continue;
                int line = entry.getKey().line;
                if (document.getLineCount() <= line) continue;
                String bookmarkedText = entry.getKey().text;
                String lineContent = MyDocumentListener.getLineContent(document, line);
                if (!bookmarkedText.equals(lineContent) && line > 1 && (bookmarkedText.equals(StringUtil.trimEnd((String)e.getNewFragment().toString(), (String)"\n")) || bookmarkedText.equals(StringUtil.trimEnd((String)e.getOldFragment().toString(), (String)"\n")))) {
                    lineContent = MyDocumentListener.getLineContent(document, line -= 2);
                }
                if (!bookmarkedText.equals(lineContent) || BookmarkManager.this.findEditorBookmark(document, line) != null) continue;
                Bookmark restored = BookmarkManager.this.addTextBookmark(bookmark.getFile(), line, bookmark.getDescription());
                if (bookmark.getMnemonic() != '\u0000') {
                    BookmarkManager.this.setMnemonic(restored, bookmark.getMnemonic());
                }
                iterator.remove();
            }
        }

        private boolean isDuplicate(Bookmark bookmark, @NotNull VirtualFile file, @Nullable List<Bookmark> toRemove) {
            if (file == null) {
                MyDocumentListener.$$$reportNull$$$0(2);
            }
            for (Bookmark b : BookmarkManager.this.myBookmarks.get((Object)file)) {
                if (b == bookmark || !b.isValid() || !Comparing.equal((Object)b.getFile(), (Object)bookmark.getFile()) || b.getLine() != bookmark.getLine() || toRemove != null && toRemove.contains(b)) continue;
                return true;
            }
            return false;
        }

        private void moveToDeleted(Bookmark bookmark) {
            List<BookmarkInfo> list2 = BookmarkManager.this.myBeforeChangeData.get(bookmark.getCachedDocument());
            if (list2 != null) {
                for (BookmarkInfo bookmarkInfo : list2) {
                    if (bookmarkInfo.bookmark != bookmark) continue;
                    BookmarkManager.this.removeBookmark(bookmark);
                    BookmarkManager.this.myDeletedDocumentBookmarks.put(new DeletedDocumentBookmarkKey(bookmark.getFile(), bookmarkInfo.line, bookmarkInfo.text), bookmark);
                    break;
                }
            }
        }

        private static String getLineContent(Document document, int line) {
            int start = document.getLineStartOffset(line);
            int end = document.getLineEndOffset(line);
            return document.getText(new TextRange(start, end));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/bookmarks/BookmarkManager$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDuplicate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record DeletedDocumentBookmarkKey(VirtualFile file, int line, String text) {
    }

    private record BookmarkInfo(Bookmark bookmark, int line, String text) {
    }
}

