/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarkProvider;
import com.intellij.ide.bookmark.BookmarkState;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.BookmarksManagerImpl;
import com.intellij.ide.bookmark.BookmarksManagerImplKt;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.GroupState;
import com.intellij.ide.bookmark.GutterLineBookmarkRenderer;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.ManagerState;
import com.intellij.ide.bookmark.ModificationNotifier;
import com.intellij.ide.bookmark.providers.FileBookmarkImpl;
import com.intellij.ide.bookmark.providers.LineBookmarkImpl;
import com.intellij.ide.bookmark.providers.LineBookmarkProvider;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.BookmarksViewState;
import com.intellij.ide.bookmark.ui.GroupCreateDialog;
import com.intellij.ide.bookmark.ui.GroupSelectDialog;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TreeItem;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

@State(name="BookmarksManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0006\u0082\u0001\u0083\u0001\u0084\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0003H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0003H\u0016J\b\u0010,\u001a\u00020*H\u0016J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0002J \u0010/\u001a\b\u0018\u00010\u0015R\u00020\u00002\u0006\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u000203H\u0002J\u0014\u00104\u001a\u0004\u0018\u00010\u00112\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u00107\u001a\u0002012\u0006\u00108\u001a\u00020\u0011H\u0002J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00110\u001fH\u0016J\n\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u000201H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020;0\u001fH\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020;0\u001f2\u0006\u00108\u001a\u00020\u0011H\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u0002012\u0006\u0010?\u001a\u00020\u001bH\u0016J%\u0010@\u001a\u00060\u0015R\u00020\u00002\u0006\u00100\u001a\u0002012\n\b\u0002\u0010A\u001a\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010BJ\u0012\u0010C\u001a\u0004\u0018\u00010\u00112\u0006\u0010D\u001a\u00020EH\u0016J\u0016\u0010F\u001a\b\u0018\u00010\u0012R\u00020\u00002\u0006\u0010D\u001a\u00020EH\u0002J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020E0HH\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010E2\u0006\u00108\u001a\u00020\u0011H\u0016J\u0018\u0010J\u001a\u00020*2\u0006\u00108\u001a\u00020\u00112\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010K\u001a\u00020*2\u0006\u00108\u001a\u00020\u00112\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010L\u001a\u00020*2\u0006\u00108\u001a\u00020\u00112\u0006\u0010D\u001a\u00020EH\u0016J\u001c\u0010M\u001a\u000e\u0012\b\u0012\u00060\u0015R\u00020\u0000\u0018\u00010\u001f2\u0006\u00108\u001a\u00020\u0011H\u0002J2\u0010N\u001a\u00020*2\u0010\u0010O\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00000\u001f2\u0016\u0010P\u001a\u0012\u0012\b\u0012\u00060\u0015R\u00020\u0000\u0012\u0004\u0012\u00020*0QH\u0002J\u0010\u0010R\u001a\u00020*2\u0006\u00108\u001a\u00020\u0011H\u0016J\u001c\u0010S\u001a\u000e\u0012\b\u0012\u00060\u0015R\u00020\u0000\u0018\u00010\u001f2\u0006\u00108\u001a\u00020\u0011H\u0002J\u0017\u0010T\u001a\u0004\u0018\u00010*2\u0006\u00108\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010UJ4\u0010V\u001a\u001a\u0012\b\u0012\u00060\u0012R\u00020\u0000\u0012\n\u0012\b\u0018\u00010XR\u00020\u0000\u0018\u00010W2\n\u0010\u0016\u001a\u00060\u0015R\u00020\u00002\u0006\u00108\u001a\u00020\u0011H\u0002J\b\u0010R\u001a\u00020*H\u0016J\u0018\u0010Y\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020E2\u0006\u0010Z\u001a\u00020\u0011H\u0002J\u0018\u0010[\u001a\u00020*2\u0006\u0010D\u001a\u00020E2\u0006\u0010Z\u001a\u00020\u0011H\u0002J\u0010\u0010\\\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020;H\u0007J\u001c\u0010]\u001a\u00020*2\u0006\u0010^\u001a\u0002032\n\u0010\u0016\u001a\u00060\u0015R\u00020\u0000H\u0002J\u0014\u0010_\u001a\u00060\u0015R\u00020\u00002\u0006\u0010^\u001a\u000203H\u0002J\u0018\u0010`\u001a\u00020*2\u0006\u0010a\u001a\u0002032\u0006\u0010b\u001a\u000203H\u0002J\u0018\u0010c\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020;2\u0006\u0010d\u001a\u00020;H\u0007J \u0010c\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020;2\u0006\u00108\u001a\u00020\u00112\u0006\u0010d\u001a\u00020\u0011H\u0007J\u001e\u0010e\u001a\u00020*2\u0014\u0010f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0016J\u0018\u0010g\u001a\u00020\u001b2\u0006\u0010h\u001a\u00020\u00112\u0006\u0010i\u001a\u00020\u0011H\u0002J\u0014\u0010j\u001a\u00020\u001b2\n\u0010\u0016\u001a\u00060\u0015R\u00020\u0000H\u0002J\u0010\u0010j\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020;H\u0002J\u0018\u0010k\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020;2\u0006\u0010l\u001a\u00020$H\u0002J\u001e\u0010k\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020;2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020$0\u001fH\u0007J\u001e\u0010n\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020;2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020$0\u001fH\u0007J&\u0010o\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\u001b2\u0006\u0010l\u001a\u00020$2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020$0\u001fH\u0007J&\u0010q\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\u001b2\u0006\u0010l\u001a\u00020$2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020$0\u001fH\u0007J&\u0010o\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020;2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020;0\u001fH\u0007J&\u0010q\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020;2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020;0\u001fH\u0007J\u001e\u0010r\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020;2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020t0\u001fH\u0007J\u001e\u0010u\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020;2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020t0\u001fH\u0007J&\u0010v\u001a\u00020\u001b2\u0006\u0010p\u001a\u00020\u001b2\u0006\u0010l\u001a\u00020$2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020t0\u001fH\u0007J:\u0010v\u001a\u00020\u001b2\n\u0010\u0016\u001a\u00060\u0015R\u00020\u00002\f\u0010s\u001a\b\u0012\u0004\u0012\u00020t0\u001f2\u0016\u0010w\u001a\u0012\u0012\b\u0012\u00060\u0015R\u00020\u0000\u0012\u0004\u0012\u0002030QH\u0002J:\u0010q\u001a\u00020\u001b2\n\u0010\u0016\u001a\u00060\u0015R\u00020\u00002\f\u0010m\u001a\b\u0012\u0004\u0012\u00020$0\u001f2\u0016\u0010w\u001a\u0012\u0012\b\u0012\u00060\u0015R\u00020\u0000\u0012\u0004\u0012\u0002030QH\u0002J\u0012\u0010x\u001a\u0004\u0018\u00010y2\u0006\u00108\u001a\u00020\u0011H\u0002J\u0012\u0010z\u001a\u0004\u0018\u00010y2\u0006\u00108\u001a\u00020\u0011H\u0002J\u0018\u0010{\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u00112\u0006\u0010|\u001a\u00020yH\u0002J\u0017\u0010}\u001a\u0004\u0018\u00010~2\u0006\u00108\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u007fJ\u0017\u0010\u0080\u0001\u001a\u00020*2\u0006\u0010|\u001a\u00020yH\u0000\u00a2\u0006\u0003\b\u0081\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\b\u0018\u00010\u0015R\u00020\u00002\f\u0010\u0016\u001a\b\u0018\u00010\u0015R\u00020\u0000@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\"\u00a8\u0006\u0085\u0001"}, d2={"Lcom/intellij/ide/bookmark/BookmarksManagerImpl;", "Lcom/intellij/ide/bookmark/BookmarksManager;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/intellij/ide/bookmark/ManagerState;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "invoker", "Lcom/intellij/util/concurrency/Invoker;", "Lorg/jetbrains/annotations/NotNull;", "notifier", "Lcom/intellij/ide/bookmark/ModificationNotifier;", "allBookmarks", "", "Lcom/intellij/ide/bookmark/Bookmark;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InManagerInfo;", "allGroups", "", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;", "group", "defaultGroup", "setDefaultGroup", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;)V", "groupLineBookmarks", "", "getGroupLineBookmarks", "()Z", "sortedProviders", "", "Lcom/intellij/ide/bookmark/BookmarkProvider;", "getSortedProviders", "()Ljava/util/List;", "snapshot", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "getSnapshot$intellij_platform_bookmarks", "getStateModificationCount", "", "getState", "loadState", "", "state", "noStateLoaded", "manager", "Lcom/intellij/ide/favoritesTreeView/FavoritesManager;", "findGroup", "name", "", "hash", "", "createBookmark", "context", "", "createDescription", "bookmark", "getBookmarks", "getDefaultGroup", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "getGroup", "getGroups", "addGroup", "isDefault", "addOrReuseGroup", "isDefaultState", "(Ljava/lang/String;Ljava/lang/Boolean;)Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;", "getBookmark", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "findInfo", "getAssignedTypes", "", "getType", "setType", "toggle", "add", "findGroupsToAdd", "chooseGroupToAdd", "groups", "addHandler", "Lkotlin/Function1;", "remove", "findGroupsToRemove", "removeFromAllGroups", "(Lcom/intellij/ide/bookmark/Bookmark;)Lkotlin/Unit;", "removeFromGroup", "Lkotlin/Pair;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InGroupInfo;", "canRewriteType", "allowed", "rewriteType", "sort", "addGroupTo", "index", "removeGroupFrom", "moveGroup", "fromIndex", "toIndex", "move", "anchor", "update", "map", "updateInAllGroups", "old", "new", "contains", "canDragInto", "occurrence", "occurrences", "dragInto", "canDrag", "above", "drag", "canDragAddInto", "files", "Ljava/io/File;", "dragAddInto", "dragAdd", "indexSupplier", "getFileGrouping", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLineGrouping", "isLineGrouping", "file", "findLineHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "findLineHighlighter$intellij_platform_bookmarks", "refreshRenderers", "refreshRenderers$intellij_platform_bookmarks", "Group", "InGroupInfo", "InManagerInfo", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nBookmarksManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,679:1\n1080#2:680\n1661#2,3:682\n1915#2:685\n1915#2,2:686\n1916#2:688\n296#2,2:689\n777#2:691\n873#2,2:692\n1586#2:694\n1661#2,3:695\n873#2,2:698\n777#2:700\n873#2,2:701\n777#2:703\n873#2,2:704\n1915#2,2:706\n363#2,7:708\n363#2,7:715\n1786#2,3:722\n1786#2,3:725\n1786#2,3:728\n1786#2,3:731\n1786#2,3:734\n1786#2,3:737\n1661#2,3:740\n1915#2,2:743\n1915#2,2:745\n1661#2,3:747\n1807#2,3:750\n1642#2,10:753\n1915#2:763\n1916#2:765\n1652#2:766\n1915#2,2:767\n1915#2,2:769\n1915#2,2:771\n1915#2,2:773\n1915#2,2:775\n1#3:681\n1#3:764\n*S KotlinDebug\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl\n*L\n64#1:680\n82#1:682,3\n87#1:685\n89#1:686,2\n87#1:688\n122#1:689,2\n137#1:691\n137#1:692,2\n159#1:694\n159#1:695,3\n159#1:698,2\n195#1:700\n195#1:701,2\n232#1:703\n232#1:704,2\n236#1:706,2\n296#1:708,7\n298#1:715,7\n361#1:722,3\n372#1:725,3\n376#1:728,3\n379#1:731,3\n380#1:734,3\n393#1:737,3\n400#1:740,3\n403#1:743,2\n407#1:745,2\n414#1:747,3\n415#1:750,3\n433#1:753,10\n433#1:763\n433#1:765\n433#1:766\n435#1:767,2\n441#1:769,2\n443#1:771,2\n652#1:773,2\n103#1:775,2\n433#1:764\n*E\n"})
public final class BookmarksManagerImpl
implements BookmarksManager,
PersistentStateComponentWithModificationTracker<ManagerState> {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Invoker invoker;
    @NotNull
    private final ModificationNotifier notifier;
    @NotNull
    private final Map<Bookmark, InManagerInfo> allBookmarks;
    @NotNull
    private final List<Group> allGroups;
    @Nullable
    private Group defaultGroup;

    @ApiStatus.Internal
    public BookmarksManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        Invoker invoker = Invoker.forBackgroundThreadWithReadAction((Disposable)((Disposable)this.project));
        Intrinsics.checkNotNullExpressionValue((Object)invoker, (String)"forBackgroundThreadWithReadAction(...)");
        this.invoker = invoker;
        this.notifier = new ModificationNotifier(this.project);
        this.allBookmarks = new LinkedHashMap();
        this.allGroups = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setDefaultGroup(Group group) {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            block6: {
                Group old;
                block7: {
                    boolean bl = false;
                    old = this.defaultGroup;
                    if (old == group) break block6;
                    Group group2 = group;
                    if (group2 == null) break block7;
                    Group it = group2;
                    boolean bl2 = false;
                    int index = this.allGroups.indexOf(it);
                    if (index < 0) break block6;
                    if (index > 0) {
                        this.moveGroup(index, 0);
                    }
                }
                this.defaultGroup = group;
                this.notifier.defaultGroupChanged(old, group);
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
    }

    private final boolean getGroupLineBookmarks() {
        return BookmarksViewState.Companion.getInstance(this.project).getGroupLineBookmarks();
    }

    private final List<BookmarkProvider> getSortedProviders() {
        List list2;
        if (this.project.isDisposed()) {
            list2 = CollectionsKt.emptyList();
        } else {
            Iterable $this$sortedByDescending$iv = BookmarkProvider.EP.getExtensions((AreaInstance)this.project);
            boolean $i$f$sortedByDescending = false;
            list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    BookmarkProvider it = (BookmarkProvider)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getWeight());
                    it = (BookmarkProvider)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getWeight()));
                }
            });
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<BookmarkOccurrence> getSnapshot$intellij_platform_bookmarks() {
        List list2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            List list3 = this.notifier.getSnapshot$intellij_platform_bookmarks();
            if (list3 == null) {
                List list4;
                List it = list4 = (List)new ArrayList();
                boolean bl2 = false;
                this.notifier.setSnapshot$intellij_platform_bookmarks(it);
                for (Group group : this.allGroups) {
                    for (Bookmark bookmark : group.getBookmarks()) {
                        it.add(new BookmarkOccurrence(group, bookmark, it.size(), it));
                    }
                }
                list3 = list4;
            }
            list2 = list3;
        }
        return list2;
    }

    public long getStateModificationCount() {
        return this.notifier.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public ManagerState getState() {
        ManagerState managerState;
        ManagerState $this$getState_u24lambda_u240 = managerState = new ManagerState();
        boolean bl = false;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            void $this$mapTo$iv;
            boolean bl2 = false;
            Iterable iterable = this.allGroups;
            Collection destination$iv = $this$getState_u24lambda_u240.getGroups();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Group group = (Group)item$iv;
                Collection collection = destination$iv;
                boolean bl3 = false;
                collection.add(it.getState$intellij_platform_bookmarks());
            }
            Unit unit = Unit.INSTANCE;
        }
        return managerState;
    }

    public void loadState(@NotNull ManagerState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.remove();
        Iterable $this$forEach$iv = state.getGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GroupState it = (GroupState)element$iv;
            boolean bl = false;
            Group group = this.addOrReuseGroup(it.getName(), it.isDefault());
            Iterable $this$forEach$iv2 = it.getBookmarks();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BookmarkState bookmark = (BookmarkState)element$iv2;
                boolean bl2 = false;
                group.addLater$intellij_platform_bookmarks(bookmark, bookmark.getType(), bookmark.getDescription());
            }
        }
    }

    public void noStateLoaded() {
        String string = this.project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Group group = BookmarksManagerImpl.addOrReuseGroup$default(this, string, null, 2, null);
        BookmarksListener listener2 = new BookmarksListener(group){
            final /* synthetic */ Group $group;
            {
                this.$group = $group;
            }

            public void bookmarkAdded(com.intellij.ide.bookmarks.Bookmark old) {
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                BookmarkType bookmarkType = old.getType();
                Intrinsics.checkNotNullExpressionValue((Object)bookmarkType, (String)"getType(...)");
                this.$group.addLater$intellij_platform_bookmarks(old, bookmarkType, old.getDescription());
            }
        };
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic<BookmarksListener> topic = BookmarksListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener2);
        StartupManager.getInstance((Project)this.project).runAfterOpened(() -> BookmarksManagerImpl.noStateLoaded$lambda$0(this, listener2));
    }

    private final void noStateLoaded(FavoritesManager manager) {
        for (String name : manager.getAvailableFavoritesListNames()) {
            Intrinsics.checkNotNull((Object)name);
            Group group = BookmarksManagerImpl.addOrReuseGroup$default(this, name, null, 2, null);
            for (TreeItem item : manager.getFavoritesListRootUrls(name)) {
                Object object = ((Pair)item.getData()).first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                group.addLater$intellij_platform_bookmarks(object, BookmarkType.DEFAULT, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Group findGroup(String name, int hash) {
        Group group;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Object v0;
            block4: {
                boolean bl = false;
                Iterable iterable = this.allGroups;
                for (Object t : iterable) {
                    Group it = (Group)t;
                    boolean bl2 = false;
                    if (!(it.getHash$intellij_platform_bookmarks() == hash && Intrinsics.areEqual((Object)it.getName(), (Object)name))) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            group = v0;
        }
        return group;
    }

    static /* synthetic */ Group findGroup$default(BookmarksManagerImpl bookmarksManagerImpl, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = string.hashCode();
        }
        return bookmarksManagerImpl.findGroup(string, n);
    }

    @Nullable
    public Bookmark createBookmark(@Nullable Object context) {
        Bookmark bookmark;
        block5: {
            if (context instanceof BookmarkState) {
                Object v0;
                block4: {
                    Iterable $this$firstOrNull$iv = this.getSortedProviders();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        BookmarkProvider it = (BookmarkProvider)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getClass().getName(), (Object)((BookmarkState)context).getProvider())) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                BookmarkProvider bookmarkProvider = v0;
                bookmark = bookmarkProvider != null ? bookmarkProvider.createBookmark(((BookmarkState)context).getAttributes()) : null;
            } else {
                for (BookmarkProvider it : (Iterable)this.getSortedProviders()) {
                    boolean bl = false;
                    Bookmark bookmark2 = it.createBookmark(context);
                    if (bookmark2 == null) continue;
                    bookmark = bookmark2;
                    break block5;
                }
                bookmark = null;
            }
        }
        return bookmark;
    }

    private final String createDescription(Bookmark bookmark) {
        String string = LineBookmarkProvider.Util.INSTANCE.readLineText(bookmark instanceof LineBookmark ? (LineBookmark)bookmark : null);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Bookmark> getBookmarks() {
        List list2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            list2 = CollectionsKt.toList((Iterable)this.allBookmarks.keySet());
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BookmarkGroup getDefaultGroup() {
        Group group;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            group = this.defaultGroup;
        }
        return group;
    }

    @Nullable
    public BookmarkGroup getGroup(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return BookmarksManagerImpl.findGroup$default(this, name, 0, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<BookmarkGroup> getGroups() {
        List list2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            list2 = CollectionsKt.toList((Iterable)this.allGroups);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<BookmarkGroup> getGroups(@NotNull Bookmark bookmark) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            List list3;
            boolean bl = false;
            Object object = this.allBookmarks.get(bookmark);
            if (object != null && (object = ((InManagerInfo)object).getGroups()) != null) {
                void $this$filterTo$iv$iv;
                Object it = object;
                boolean bl2 = false;
                Iterable $this$filter$iv = this.allGroups;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Group p0 = (Group)element$iv$iv;
                    boolean bl3 = false;
                    if (!it.contains(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = CollectionsKt.emptyList();
            }
            list2 = list3;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BookmarkGroup addGroup(@NotNull String name, boolean isDefault) {
        Group group;
        Group group2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (StringsKt.isBlank((CharSequence)name)) {
            group2 = null;
        } else {
            ModificationNotifier modificationNotifier = this.notifier;
            synchronized (modificationNotifier) {
                boolean $i$a$-synchronized-BookmarksManagerImpl$addGroup$22 = false;
                Group $i$a$-synchronized-BookmarksManagerImpl$addGroup$22 = BookmarksManagerImpl.findGroup$default(this, name, 0, 2, null) != null ? null : new Group(this, name, isDefault, true);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var5_3
                group2 = $i$a$-synchronized-BookmarksManagerImpl$addGroup$22;
            }
        }
        Group group3 = group2;
        if (group3 != null) {
            Group group4;
            Group $this$addGroup_u24lambda_u241 = group4 = group3;
            boolean bl = false;
            this.notifier.selectLater$intellij_platform_bookmarks((Function1<? super BookmarksView, Unit>)((Function1)arg_0 -> BookmarksManagerImpl.addGroup$lambda$1$0($this$addGroup_u24lambda_u241, arg_0)));
            group = group4;
        } else {
            group = null;
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Group addOrReuseGroup(String name, Boolean isDefaultState) {
        Group group;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Group group2;
            block8: {
                block7: {
                    Group group3;
                    boolean bl = false;
                    group2 = BookmarksManagerImpl.findGroup$default(this, name, 0, 2, null);
                    if (group2 == null) break block7;
                    Group $this$addOrReuseGroup_u24lambda_u240_u240 = group3 = group2;
                    boolean bl2 = false;
                    Boolean bl3 = isDefaultState;
                    if (bl3 != null) {
                        boolean it = bl3;
                        boolean bl4 = false;
                        $this$addOrReuseGroup_u24lambda_u240_u240.setDefault(it);
                    }
                    if ((group2 = group3) != null) break block8;
                }
                Boolean bl = isDefaultState;
                group2 = new Group(this, name, bl != null ? bl : false, false);
            }
            group = group2;
        }
        return group;
    }

    static /* synthetic */ Group addOrReuseGroup$default(BookmarksManagerImpl bookmarksManagerImpl, String string, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return bookmarksManagerImpl.addOrReuseGroup(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Bookmark getBookmark(@NotNull BookmarkType type) {
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            InManagerInfo inManagerInfo = this.findInfo(type);
            bookmark = inManagerInfo != null ? inManagerInfo.getBookmark() : null;
        }
        return bookmark;
    }

    private final InManagerInfo findInfo(BookmarkType type) {
        InManagerInfo inManagerInfo;
        if (WhenMappings.$EnumSwitchMapping$0[type.ordinal()] == 1) {
            inManagerInfo = null;
        } else {
            Object v1;
            block3: {
                Iterable iterable = this.allBookmarks.values();
                for (Object t : iterable) {
                    InManagerInfo it = (InManagerInfo)t;
                    boolean bl = false;
                    if (!(it.getType() == type)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            inManagerInfo = v1;
        }
        return inManagerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Set<BookmarkType> getAssignedTypes() {
        Set set;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            void destination$iv;
            void $this$filterTo$iv;
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.allBookmarks.values();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InManagerInfo inManagerInfo = (InManagerInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getType());
            }
            $this$map$iv = (List)destination$iv$iv;
            Collection $i$f$map22 = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                BookmarkType it = (BookmarkType)element$iv;
                boolean bl3 = false;
                if (!(it != BookmarkType.DEFAULT)) continue;
                destination$iv.add(element$iv);
            }
            set = (Set)destination$iv;
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BookmarkType getType(@NotNull Bookmark bookmark) {
        BookmarkType bookmarkType;
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            InManagerInfo inManagerInfo = this.allBookmarks.get(bookmark);
            bookmarkType = inManagerInfo != null ? inManagerInfo.getType() : null;
        }
        return bookmarkType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(@NotNull Bookmark bookmark, @NotNull BookmarkType type) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!this.canRewriteType(type, bookmark)) {
            return;
        }
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            InManagerInfo inManagerInfo = this.allBookmarks.get(bookmark);
            if (inManagerInfo == null) {
                return;
            }
            InManagerInfo info = inManagerInfo;
            if (info.getType() == type) {
                return;
            }
            this.rewriteType(type, bookmark);
            info.changeType(type);
            Unit unit = Unit.INSTANCE;
        }
    }

    public void toggle(@NotNull Bookmark bookmark, @NotNull BookmarkType type) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        BookmarkType bookmarkType = this.getType(bookmark);
        if (bookmarkType != null) {
            BookmarkType it = bookmarkType;
            boolean bl = false;
            if (it != type) {
                this.setType(bookmark, type);
            } else {
                this.remove(bookmark);
            }
        } else {
            this.add(bookmark, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull Bookmark bookmark, @NotNull BookmarkType type) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            if (this.allGroups.isEmpty()) {
                String string = this.project.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                BookmarksManagerImpl.addOrReuseGroup$default(this, string, null, 2, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        List<Group> list2 = this.findGroupsToAdd(bookmark);
        if (list2 == null) {
            return;
        }
        List<Group> groups = list2;
        this.chooseGroupToAdd(groups, (Function1<? super Group, Unit>)((Function1)arg_0 -> BookmarksManagerImpl.add$lambda$1(bookmark, type, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Group> findGroupsToAdd(Bookmark bookmark) {
        Group group;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Object object;
            block10: {
                InManagerInfo info;
                block8: {
                    block9: {
                        boolean bl = false;
                        info = this.allBookmarks.get(bookmark);
                        if (info != null) break block8;
                        object = this.defaultGroup;
                        if (object == null) break block9;
                        Group it = object;
                        boolean bl2 = false;
                        List list2 = CollectionsKt.listOf((Object)it);
                        object = list2;
                        if (list2 != null) break block10;
                    }
                    object = CollectionsKt.toList((Iterable)this.allGroups);
                    break block10;
                }
                if (bookmark instanceof LineBookmark) {
                    object = null;
                } else {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.allGroups;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Group it = (Group)element$iv$iv;
                        boolean bl = false;
                        if (!(!info.getGroups().contains(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    object = (List)destination$iv$iv;
                }
            }
            group = object;
        }
        return group;
    }

    private final void chooseGroupToAdd(List<Group> groups, Function1<? super Group, Unit> addHandler) {
        if (groups.size() == 1) {
            addHandler.invoke((Object)groups.get(0));
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(groups, this, addHandler, null){
            int label;
            final /* synthetic */ List<Group> $groups;
            final /* synthetic */ BookmarksManagerImpl this$0;
            final /* synthetic */ Function1<Group, Unit> $addHandler;
            {
                this.$groups = $groups;
                this.this$0 = $receiver;
                this.$addHandler = $addHandler;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        BookmarkGroup group;
                        ResultKt.throwOnFailure((Object)$result);
                        BookmarkGroup bookmarkGroup = group = this.$groups.isEmpty() ? new GroupCreateDialog(BookmarksManagerImpl.access$getProject$p(this.this$0), null, this.this$0).showAndGetGroup(true) : new GroupSelectDialog(BookmarksManagerImpl.access$getProject$p(this.this$0), null, this.this$0, this.$groups).showAndGetGroup(true);
                        if (bookmarkGroup != null) {
                            BookmarkGroup bookmarkGroup2 = bookmarkGroup;
                            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
                            Function1<Group, Unit> function1 = this.$addHandler;
                            BookmarkGroup it = bookmarkGroup2;
                            boolean bl = false;
                            BuildersKt.launch$default((CoroutineScope)BookmarksManagerImpl.access$getCoroutineScope$p(bookmarksManagerImpl), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(function1, it, null){
                                int label;
                                final /* synthetic */ Function1<Group, Unit> $addHandler;
                                final /* synthetic */ BookmarkGroup $it;
                                {
                                    this.$addHandler = $addHandler;
                                    this.$it = $it;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            BookmarkGroup bookmarkGroup = this.$it;
                                            Intrinsics.checkNotNull((Object)bookmarkGroup, (String)"null cannot be cast to non-null type com.intellij.ide.bookmark.BookmarksManagerImpl.Group");
                                            this.$addHandler.invoke((Object)((Group)bookmarkGroup));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void remove(@NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        List<Group> groups = this.findGroupsToRemove(bookmark);
        Collection collection = groups;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (groups.size() == 1) {
            this.removeFromGroup(groups.get(0), bookmark);
        } else if (!((Collection)groups).isEmpty()) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Group> findGroupsToRemove(Bookmark bookmark) {
        List list2;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            List list3;
            boolean bl = false;
            Object object = this.allBookmarks.get(bookmark);
            if (object != null && (object = ((InManagerInfo)object).getGroups()) != null) {
                void $this$filterTo$iv$iv;
                Object it = object;
                boolean bl2 = false;
                Iterable $this$filter$iv = this.allGroups;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Group p0 = (Group)element$iv$iv;
                    boolean bl3 = false;
                    if (!it.contains(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = null;
            }
            list2 = list3;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Unit removeFromAllGroups(Bookmark bookmark) {
        Unit unit;
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Unit unit2;
            boolean bl = false;
            List<Group> list2 = this.findGroupsToRemove(bookmark);
            if (list2 != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Group it = (Group)element$iv;
                    boolean bl2 = false;
                    this.removeFromGroup(it, bookmark);
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final kotlin.Pair<InManagerInfo, InGroupInfo> removeFromGroup(Group group, Bookmark bookmark) {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            InManagerInfo info;
            block7: {
                InManagerInfo inManagerInfo;
                block6: {
                    boolean bl = false;
                    if (this.allBookmarks.get(bookmark) != null) break block6;
                    kotlin.Pair<InManagerInfo, InGroupInfo> pair = null;
                    return pair;
                }
                info = inManagerInfo;
                if (info.getGroups().remove(group)) break block7;
                kotlin.Pair<InManagerInfo, InGroupInfo> pair = null;
                return pair;
            }
            boolean removed = info.getGroups().isEmpty();
            if (removed) {
                this.allBookmarks.remove(bookmark);
            }
            kotlin.Pair result = TuplesKt.to((Object)info, (Object)group.removeInfo$intellij_platform_bookmarks(bookmark));
            info.bookmarkRemoved(group, removed);
            kotlin.Pair pair = result;
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            while (!((Collection)this.allGroups).isEmpty()) {
                this.allGroups.get(0).remove();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean canRewriteType(BookmarkType type, Bookmark allowed) {
        String string;
        if (BookmarksViewState.Companion.getInstance(this.project).getRewriteBookmarkType()) {
            return true;
        }
        Bookmark bookmark = this.getBookmark(type);
        if (bookmark == null) {
            return true;
        }
        Bookmark bookmark2 = bookmark;
        if (Intrinsics.areEqual((Object)bookmark2, (Object)allowed)) {
            return true;
        }
        String string2 = BookmarkBundle.message("bookmark.type.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Bookmark bookmark3 = bookmark2;
        if (bookmark3 instanceof LineBookmark) {
            var6_5 = new Object[]{Character.valueOf(type.getMnemonic()), ((LineBookmark)bookmark2).getFile().getPresentableName(), ((LineBookmark)bookmark2).getLine() + 1};
            string = BookmarkBundle.message("bookmark.type.confirmation.line.bookmark", var6_5);
        } else if (bookmark3 instanceof FileBookmark) {
            var6_5 = new Object[]{Character.valueOf(type.getMnemonic()), ((FileBookmark)bookmark2).getFile().getPresentableName()};
            string = BookmarkBundle.message("bookmark.type.confirmation.file.bookmark", var6_5);
        } else {
            var6_5 = new Object[]{Character.valueOf(type.getMnemonic())};
            string = BookmarkBundle.message("bookmark.type.confirmation.bookmark", var6_5);
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        OkCancelDialogBuilder okCancelDialogBuilder = (OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(string2, string3).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(this){
            final /* synthetic */ BookmarksManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                BookmarksViewState.Companion.getInstance(BookmarksManagerImpl.access$getProject$p(this.this$0)).setRewriteBookmarkType(isSelected);
            }
        });
        String string4 = BookmarkBundle.message("bookmark.type.confirmation.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string4)).asWarning()).ask(this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rewriteType(BookmarkType type, Bookmark allowed) {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Unit unit;
            boolean bl = false;
            InManagerInfo inManagerInfo = this.findInfo(type);
            if (inManagerInfo == null) {
                return;
            }
            InManagerInfo info = inManagerInfo;
            Bookmark bookmark = info.getBookmark();
            if (Intrinsics.areEqual((Object)bookmark, (Object)allowed)) {
                return;
            }
            if (bookmark instanceof LineBookmark) {
                unit = this.removeFromAllGroups(info.getBookmark());
            } else {
                info.changeType(BookmarkType.DEFAULT);
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
    }

    @ApiStatus.Internal
    public final void sort(@NotNull BookmarkGroup group) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Group group2 = group instanceof Group ? (Group)group : null;
            if (group2 == null) break block0;
            group2.sortLater$intellij_platform_bookmarks();
        }
    }

    private final void addGroupTo(int index, Group group) {
        Unit unit;
        this.allGroups.add(index, group);
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        this.notifier.groupAdded(group);
    }

    private final Group removeGroupFrom(int index) {
        Group group;
        Group it = group = this.allGroups.remove(index);
        boolean bl = false;
        this.notifier.groupRemoved(it);
        return group;
    }

    private final void moveGroup(int fromIndex, int toIndex) {
        this.addGroupTo(toIndex, this.removeGroupFrom(fromIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final void move(@NotNull BookmarkGroup group, @NotNull BookmarkGroup anchor) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            int toIndex;
            int fromIndex;
            block11: {
                int n;
                block10: {
                    int n2;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)group, (Object)this.defaultGroup) || Intrinsics.areEqual((Object)anchor, (Object)this.defaultGroup)) {
                        return;
                    }
                    List<Group> $this$indexOfFirst$iv = this.allGroups;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<Group> iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        Group item$iv;
                        Group it = item$iv = iterator.next();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it, (Object)group)) {
                            n2 = index$iv;
                            break block10;
                        }
                        ++index$iv;
                    }
                    n2 = fromIndex = -1;
                }
                if (fromIndex < 0) {
                    return;
                }
                List<Group> $this$indexOfFirst$iv = this.allGroups;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Group> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Group item$iv;
                    Group it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)anchor)) {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = toIndex = -1;
            }
            if (toIndex < 0 || toIndex == fromIndex) {
                return;
            }
            this.moveGroup(fromIndex, toIndex);
            Unit unit = Unit.INSTANCE;
        }
    }

    @ApiStatus.Internal
    public final void move(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark, @NotNull Bookmark anchor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Group group2 = group instanceof Group ? (Group)group : null;
            if (group2 == null) break block0;
            Group $this$move_u24lambda_u241 = group2;
            boolean bl = false;
            $this$move_u24lambda_u241.move$intellij_platform_bookmarks(bookmark, anchor);
        }
    }

    public void update(@NotNull Map<Bookmark, Bookmark> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        while (!map.isEmpty()) {
            int size = map.size();
            Iterator<Map.Entry<Bookmark, Bookmark>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Boolean updated;
                Map.Entry<Bookmark, Bookmark> entry = iterator.next();
                if (entry.getValue() != null) {
                    Bookmark it;
                    boolean bl = false;
                    v0 = this.updateInAllGroups(entry.getKey(), it);
                } else {
                    v0 = updated = null;
                }
                if (updated == null) {
                    this.removeFromAllGroups(entry.getKey());
                }
                if (Intrinsics.areEqual(updated, (Object)false)) continue;
                iterator.remove();
            }
            if (map.size() != size) continue;
        }
        if (!map.isEmpty()) {
            StringBuilder sb = new StringBuilder("cannot resolve");
            for (Map.Entry<Bookmark, Bookmark> entry : map.entrySet()) {
                sb.append('\n').append(entry.getKey()).append(" -> ").append(entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean updateInAllGroups(Bookmark old, Bookmark bookmark) {
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            InManagerInfo inManagerInfo;
            block10: {
                block9: {
                    boolean bl = false;
                    if (!this.allBookmarks.containsKey(bookmark)) break block9;
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.allBookmarks.remove(old) != null) break block10;
                boolean bl = true;
                return bl;
            }
            InManagerInfo oldInfo = inManagerInfo;
            InManagerInfo newInfo = new InManagerInfo(bookmark, oldInfo.getType());
            Iterator<Group> oldIterator = oldInfo.getGroups().iterator();
            while (oldIterator.hasNext()) {
                Group group = oldIterator.next();
                if (group.updateInfo$intellij_platform_bookmarks(old, bookmark)) {
                    newInfo.getGroups().add(group);
                }
                oldIterator.remove();
                oldInfo.bookmarkRemoved(group, !oldIterator.hasNext());
            }
            Iterator<Group> newIterator = newInfo.getGroups().iterator();
            if (newIterator.hasNext()) {
                this.allBookmarks.put(bookmark, newInfo);
                newInfo.bookmarkAdded(newIterator.next(), true);
                while (newIterator.hasNext()) {
                    newInfo.bookmarkAdded(newIterator.next(), false);
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private final boolean contains(Group group) {
        return this.allGroups.contains(group);
    }

    private final boolean contains(BookmarkGroup group) {
        return group instanceof Group && this.contains((Group)group);
    }

    private final boolean canDragInto(BookmarkGroup group, BookmarkOccurrence occurrence) {
        Group group2 = group instanceof Group ? (Group)group : null;
        if (group2 == null) {
            return false;
        }
        Group to = group2;
        BookmarkGroup bookmarkGroup = occurrence.getGroup();
        Group group3 = bookmarkGroup instanceof Group ? (Group)bookmarkGroup : null;
        if (group3 == null) {
            return false;
        }
        Group from = group3;
        InManagerInfo inManagerInfo = this.allBookmarks.get(occurrence.getBookmark());
        if (inManagerInfo == null) {
            return this.getGroupLineBookmarks();
        }
        InManagerInfo info = inManagerInfo;
        Set<Group> $this$canDragInto_u24lambda_u240 = info.getGroups();
        boolean bl = false;
        return $this$canDragInto_u24lambda_u240.contains(from) && (Intrinsics.areEqual((Object)from, (Object)to) || !$this$canDragInto_u24lambda_u240.contains(to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public final boolean canDragInto(@NotNull BookmarkGroup group, @NotNull List<BookmarkOccurrence> occurrences) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            BookmarkOccurrence it;
            boolean bl = false;
            if (!this.contains(group)) return false;
            Iterable $this$all$iv = occurrences;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                it = (BookmarkOccurrence)element$iv;
                boolean bl2 = false;
            } while (this.canDragInto(group, it));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final boolean dragInto(@NotNull BookmarkGroup group, @NotNull List<BookmarkOccurrence> occurrences) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl2 = false;
            bl = this.canDragInto(group, occurrences) && this.drag((Group)group, occurrences, (Function1<? super Group, Integer>)((Function1)BookmarksManagerImpl::dragInto$lambda$0$0));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final boolean canDrag(boolean above, @NotNull BookmarkOccurrence occurrence, @NotNull List<BookmarkOccurrence> occurrences) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl;
            block28: {
                block26: {
                    boolean bl2;
                    block27: {
                        VirtualFile file;
                        block24: {
                            boolean bl3;
                            block25: {
                                block23: {
                                    block22: {
                                        boolean bl4;
                                        block21: {
                                            block20: {
                                                boolean bl5 = false;
                                                if (this.contains(occurrence.getGroup())) break block20;
                                                boolean bl6 = false;
                                                return bl6;
                                            }
                                            Iterable $this$all$iv = occurrences;
                                            boolean $i$f$all = false;
                                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                                bl4 = true;
                                            } else {
                                                for (Object element$iv : $this$all$iv) {
                                                    BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                                                    boolean bl7 = false;
                                                    if (!Intrinsics.areEqual((Object)it, (Object)occurrence) && this.canDragInto(occurrence.getGroup(), it)) continue;
                                                    bl4 = false;
                                                    break block21;
                                                }
                                                bl4 = true;
                                            }
                                        }
                                        if (bl4) break block22;
                                        boolean bl8 = false;
                                        return bl8;
                                    }
                                    if (this.getGroupLineBookmarks()) break block23;
                                    boolean bl9 = true;
                                    return bl9;
                                }
                                if (above || (file = this.getFileGrouping(occurrence.getBookmark())) == null) break block24;
                                Iterable $this$all$iv = occurrences;
                                boolean $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    bl3 = true;
                                } else {
                                    for (Object element$iv : $this$all$iv) {
                                        BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                                        boolean bl10 = false;
                                        if (this.isLineGrouping(it.getBookmark(), file)) continue;
                                        bl3 = false;
                                        break block25;
                                    }
                                    bl3 = true;
                                }
                            }
                            if (!bl3) break block24;
                            boolean bl11 = true;
                            return bl11;
                        }
                        file = this.getLineGrouping(occurrence.getBookmark());
                        if (file == null) break block26;
                        Iterable $this$all$iv = occurrences;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                                boolean bl12 = false;
                                if (this.isLineGrouping(it.getBookmark(), file)) continue;
                                bl2 = false;
                                break block27;
                            }
                            bl2 = true;
                        }
                    }
                    boolean bl13 = bl2;
                    return bl13;
                }
                Iterable $this$all$iv = occurrences;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
                        boolean bl14 = false;
                        if (!(it.getBookmark() instanceof LineBookmarkImpl)) continue;
                        bl = false;
                        break block28;
                    }
                    bl = true;
                }
            }
            boolean bl15 = bl;
            return bl15;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public final boolean drag(boolean above, @NotNull BookmarkOccurrence occurrence, @NotNull List<BookmarkOccurrence> occurrences) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter(occurrences, (String)"occurrences");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            if (!this.canDrag(above, occurrence, occurrences)) return false;
            BookmarkGroup bookmarkGroup = occurrence.getGroup();
            Intrinsics.checkNotNull((Object)bookmarkGroup, (String)"null cannot be cast to non-null type com.intellij.ide.bookmark.BookmarksManagerImpl.Group");
            if (!this.drag((Group)bookmarkGroup, occurrences, (Function1<? super Group, Integer>)((Function1)arg_0 -> BookmarksManagerImpl.drag$lambda$0$0(occurrence, above, arg_0)))) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public final boolean canDrag(boolean above, @NotNull BookmarkGroup group, @NotNull List<? extends BookmarkGroup> groups) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl;
            boolean bl2 = false;
            if (above) {
                if (Intrinsics.areEqual((Object)group, (Object)this.defaultGroup)) return false;
            }
            if (!this.contains(group)) return false;
            Iterable $this$all$iv = groups;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                BookmarkGroup it = (BookmarkGroup)element$iv;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it, (Object)this.defaultGroup)) return false;
                if (Intrinsics.areEqual((Object)it, (Object)group)) return false;
                if (!this.contains(it)) return false;
                bl = true;
            } while (bl);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public final boolean drag(boolean above, @NotNull BookmarkGroup group, @NotNull List<? extends BookmarkGroup> groups) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            Set set;
            block10: {
                void $this$mapTo$iv;
                block9: {
                    boolean bl = false;
                    if (this.canDrag(above, group, groups)) break block9;
                    boolean bl2 = false;
                    return bl2;
                }
                set = new LinkedHashSet();
                Iterable iterable = groups;
                Collection destination$iv = set;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    BookmarkGroup bookmarkGroup = (BookmarkGroup)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.ide.bookmark.BookmarksManagerImpl.Group");
                    collection.add((Group)it);
                }
                if (groups.size() == set.size()) break block10;
                boolean bl = false;
                return bl;
            }
            this.allGroups.removeAll(set);
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Group it = (Group)element$iv;
                boolean bl = false;
                this.notifier.groupRemoved(it);
            }
            int index = RangesKt.coerceAtLeast((int)this.allGroups.indexOf((Group)group), (int)0);
            if (!above) {
                ++index;
            }
            this.allGroups.addAll(index, set);
            Iterable $this$forEach$iv2 = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Group it = (Group)element$iv;
                boolean bl = false;
                this.notifier.groupAdded(it);
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public final boolean canDragAddInto(@NotNull BookmarkGroup group, @NotNull List<? extends File> files) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl;
            block9: {
                void destination$iv;
                void $this$mapTo$iv;
                block8: {
                    boolean bl2 = false;
                    if (this.contains(group)) break block8;
                    boolean bl3 = false;
                    return bl3;
                }
                Iterable iterable = files;
                Collection collection = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    File file = (File)item$iv;
                    void var11_16 = destination$iv;
                    boolean bl4 = false;
                    var11_16.add(FileUtilKt.getSystemIndependentPath((File)it));
                }
                Set set = (Set)destination$iv;
                Iterable $this$any$iv = group.getBookmarks();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Bookmark it = (Bookmark)element$iv;
                        boolean bl5 = false;
                        if (!(it instanceof FileBookmarkImpl && set.contains(((FileBookmarkImpl)it).getFile().getPath()))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            boolean bl6 = !bl;
            return bl6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final boolean dragAddInto(@NotNull BookmarkGroup group, @NotNull List<? extends File> files) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl2 = false;
            bl = this.canDragAddInto(group, files) && this.dragAdd((Group)group, files, (Function1<? super Group, Integer>)((Function1)BookmarksManagerImpl::dragAddInto$lambda$0$0));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public final boolean dragAdd(boolean above, @NotNull BookmarkOccurrence occurrence, @NotNull List<? extends File> files) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            if (!this.canDragAddInto(occurrence.getGroup(), files)) return false;
            BookmarkGroup bookmarkGroup = occurrence.getGroup();
            Intrinsics.checkNotNull((Object)bookmarkGroup, (String)"null cannot be cast to non-null type com.intellij.ide.bookmark.BookmarksManagerImpl.Group");
            if (!this.dragAdd((Group)bookmarkGroup, files, (Function1<? super Group, Integer>)((Function1)arg_0 -> BookmarksManagerImpl.dragAdd$lambda$0$0(occurrence, above, arg_0)))) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean dragAdd(Group group, List<? extends File> files, Function1<? super Group, Integer> indexSupplier) {
        void $this$mapNotNullTo$iv$iv;
        LineBookmarkProvider lineBookmarkProvider = LineBookmarkProvider.Util.find(this.project);
        if (lineBookmarkProvider == null) {
            return false;
        }
        LineBookmarkProvider provider = lineBookmarkProvider;
        Iterable $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Bookmark it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (provider.createBookmark(VfsUtil.findFileByIoFile((File)it, (boolean)true)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        if ($this$mapNotNull$iv.isEmpty()) {
            boolean bl = false;
            return false;
        }
        List bookmarks = (List)$this$mapNotNull$iv;
        int index = RangesKt.coerceAtLeast((int)((Number)indexSupplier.invoke((Object)group)).intValue(), (int)0);
        Iterable $this$forEach$iv = bookmarks;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Bookmark it = (Bookmark)element$iv;
            boolean bl = false;
            group.add$intellij_platform_bookmarks(it, BookmarkType.DEFAULT, null, index);
        }
        return true;
    }

    private final boolean drag(Group group, List<BookmarkOccurrence> occurrences, Function1<? super Group, Integer> indexSupplier) {
        List pairs = new ArrayList();
        Iterable $this$forEach$iv = occurrences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BookmarkOccurrence it = (BookmarkOccurrence)element$iv;
            boolean bl = false;
            BookmarkGroup bookmarkGroup = it.getGroup();
            Intrinsics.checkNotNull((Object)bookmarkGroup, (String)"null cannot be cast to non-null type com.intellij.ide.bookmark.BookmarksManagerImpl.Group");
            ((Group)bookmarkGroup).removeWithGrouping$intellij_platform_bookmarks(it.getBookmark(), (Function1<? super kotlin.Pair<InManagerInfo, InGroupInfo>, Unit>)((Function1)arg_0 -> BookmarksManagerImpl.drag$lambda$2$0(pairs, arg_0)));
        }
        int index = RangesKt.coerceAtLeast((int)((Number)indexSupplier.invoke((Object)group)).intValue(), (int)0);
        Iterable $this$forEach$iv2 = pairs;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            kotlin.Pair it = (kotlin.Pair)element$iv;
            boolean bl = false;
            InGroupInfo inGroupInfo = (InGroupInfo)it.getSecond();
            group.add$intellij_platform_bookmarks(((InManagerInfo)it.getFirst()).getBookmark(), ((InManagerInfo)it.getFirst()).getType(), inGroupInfo != null ? inGroupInfo.getDescription() : null, index);
        }
        return true;
    }

    private final VirtualFile getFileGrouping(Bookmark bookmark) {
        return bookmark instanceof FileBookmarkImpl ? ((FileBookmarkImpl)bookmark).getFile() : null;
    }

    private final VirtualFile getLineGrouping(Bookmark bookmark) {
        return bookmark instanceof LineBookmarkImpl ? ((LineBookmarkImpl)bookmark).getFile() : null;
    }

    private final boolean isLineGrouping(Bookmark bookmark, VirtualFile file) {
        return bookmark instanceof LineBookmarkImpl && Intrinsics.areEqual((Object)((LineBookmarkImpl)bookmark).getFile(), (Object)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RangeHighlighter findLineHighlighter$intellij_platform_bookmarks(@NotNull Bookmark bookmark) {
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            Object object = this.allBookmarks.get(bookmark);
            rangeHighlighter = object != null && (object = ((InManagerInfo)object).getRenderer()) != null ? ((GutterLineBookmarkRenderer)((Object)object)).getHighlighter$intellij_platform_bookmarks() : null;
        }
        return rangeHighlighter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshRenderers$intellij_platform_bookmarks(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ModificationNotifier modificationNotifier = this.notifier;
        synchronized (modificationNotifier) {
            boolean bl = false;
            Iterable $this$forEach$iv = this.allBookmarks.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InManagerInfo it = (InManagerInfo)element$iv;
                boolean bl2 = false;
                GutterLineBookmarkRenderer gutterLineBookmarkRenderer = it.getRenderer();
                if (!Intrinsics.areEqual((Object)(gutterLineBookmarkRenderer != null && (gutterLineBookmarkRenderer = gutterLineBookmarkRenderer.getBookmark()) != null ? gutterLineBookmarkRenderer.getFile() : null), (Object)file)) continue;
                it.refreshRenderer();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void noStateLoaded$lambda$0$1(BookmarksManagerImpl this$0) {
        FavoritesManager favoritesManager = FavoritesManager.getInstance((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)favoritesManager, (String)"getInstance(...)");
        this$0.noStateLoaded(favoritesManager);
    }

    private static final void noStateLoaded$lambda$0(BookmarksManagerImpl this$0, noStateLoaded.listener.1 $listener) {
        BookmarksManagerImplKt.access$getLOG$p().info("no state loaded for new bookmarks");
        Collection<com.intellij.ide.bookmarks.Bookmark> collection = BookmarkManager.getInstance(this$0.project).getAllBookmarks();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllBookmarks(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.intellij.ide.bookmarks.Bookmark it = (com.intellij.ide.bookmarks.Bookmark)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            $listener.bookmarkAdded(it);
        }
        this$0.invoker.invokeLater(() -> BookmarksManagerImpl.noStateLoaded$lambda$0$1(this$0));
    }

    private static final Unit addGroup$lambda$1$0(Group $this_apply, BookmarksView it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.select($this_apply);
        return Unit.INSTANCE;
    }

    private static final Unit add$lambda$1(Bookmark $bookmark, BookmarkType $type, Group group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        group.add($bookmark, $type, $bookmark.prepareDefaultDescription());
        return Unit.INSTANCE;
    }

    private static final int dragInto$lambda$0$0(Group it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0;
    }

    private static final int drag$lambda$0$0(BookmarkOccurrence $occurrence, boolean $above, Group it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int index = it.indexWithGrouping$intellij_platform_bookmarks($occurrence.getBookmark());
        return index < 0 || $above ? index : index + 1;
    }

    private static final int dragAddInto$lambda$0$0(Group it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0;
    }

    private static final int dragAdd$lambda$0$0(BookmarkOccurrence $occurrence, boolean $above, Group it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int index = it.indexWithGrouping$intellij_platform_bookmarks($occurrence.getBookmark());
        return index < 0 || $above ? index : index + 1;
    }

    private static final Unit drag$lambda$2$0(List $pairs, kotlin.Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"pair");
        $pairs.add(0, pair);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(BookmarksManagerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(BookmarksManagerImpl $this) {
        return $this.coroutineScope;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0015\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b!J?\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2(\u0010$\u001a$\u0012\u001a\u0012\u0018\u0012\b\u0012\u00060'R\u00020\u001b\u0012\n\u0012\b\u0018\u00010\u001aR\u00020\u001b0&\u0012\u0004\u0012\u00020#0%H\u0000\u00a2\u0006\u0002\b(J\u0016\u0010)\u001a\b\u0018\u00010\u001aR\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001b\u0010*\u001a\b\u0018\u00010\u001aR\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b+J\u001d\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b/J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u001e01H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u00103\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u0003H\u0016J\u0010\u00105\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u00106\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00107\u001a\u0002082\b\u00104\u001a\u0004\u0018\u00010\u0003H\u0016J/\u00106\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00107\u001a\u0002082\b\u00104\u001a\u0004\u0018\u00010\u00032\u0006\u00109\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b:J'\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020=2\u0006\u00107\u001a\u0002082\b\u00104\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b>J\u0010\u0010?\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010@\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010@\u001a\u00020#H\u0016J\u0011\u0010A\u001a\u0006\u0012\u0002\b\u00030BH\u0000\u00a2\u0006\u0002\bCJ\b\u0010D\u001a\u00020#H\u0002J \u0010E\u001a\u00020\u000b2\n\u0010F\u001a\u00060\u001aR\u00020\u001b2\n\u0010G\u001a\u00060\u001aR\u00020\u001bH\u0002J\u001d\u0010H\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010I\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bJJ\r\u0010K\u001a\u00020LH\u0000\u00a2\u0006\u0002\bMR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u001aR\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "name", "", "<init>", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl;Ljava/lang/String;)V", "isDefault", "", "asFirst", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl;Ljava/lang/String;ZZ)V", "hash", "", "getHash$intellij_platform_bookmarks", "()I", "setHash$intellij_platform_bookmarks", "(I)V", "value", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "()Z", "setDefault", "(Z)V", "groupBookmarks", "", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InGroupInfo;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl;", "indexOf", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "indexOf$intellij_platform_bookmarks", "indexWithGrouping", "indexWithGrouping$intellij_platform_bookmarks", "removeWithGrouping", "", "process", "Lkotlin/Function1;", "Lkotlin/Pair;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InManagerInfo;", "removeWithGrouping$intellij_platform_bookmarks", "getInfo", "removeInfo", "removeInfo$intellij_platform_bookmarks", "updateInfo", "old", "new", "updateInfo$intellij_platform_bookmarks", "getBookmarks", "", "getDescription", "setDescription", "description", "canAdd", "add", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "index", "add$intellij_platform_bookmarks", "addLater", "context", "", "addLater$intellij_platform_bookmarks", "canRemove", "remove", "sortLater", "Lorg/jetbrains/concurrency/CancellablePromise;", "sortLater$intellij_platform_bookmarks", "sort", "compare", "info1", "info2", "move", "anchor", "move$intellij_platform_bookmarks", "getState", "Lcom/intellij/ide/bookmark/GroupState;", "getState$intellij_platform_bookmarks", "intellij.platform.bookmarks"})
    @ApiStatus.Internal
    @SourceDebugExtension(value={"SMAP\nBookmarksManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl$Group\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,679:1\n363#2,7:680\n363#2,7:687\n1642#2,10:695\n1915#2:705\n1916#2:707\n1652#2:708\n1915#2,2:709\n1586#2:711\n1661#2,3:712\n1#3:694\n1#3:706\n*S KotlinDebug\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl$Group\n*L\n491#1:680,7\n500#1:687,7\n507#1:695,10\n507#1:705\n507#1:707\n507#1:708\n508#1:709,2\n523#1:711\n523#1:712,3\n507#1:706\n*E\n"})
    public final class Group
    implements BookmarkGroup {
        private int hash;
        @NotNull
        private String name;
        @NotNull
        private final List<InGroupInfo> groupBookmarks;
        final /* synthetic */ BookmarksManagerImpl this$0;

        public Group(@NotNull BookmarksManagerImpl this$0, String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.this$0 = this$0;
            this.hash = name.hashCode();
            this.name = name;
            this.groupBookmarks = new ArrayList();
        }

        public Group(@NotNull BookmarksManagerImpl this$0, String name, boolean isDefault, boolean asFirst) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this(this$0, name);
            int index = isDefault ? 0 : (!asFirst ? this$0.allGroups.size() : (this$0.defaultGroup == null ? 0 : RangesKt.coerceAtMost((int)this$0.allGroups.size(), (int)1)));
            this$0.addGroupTo(index, this);
            this.setDefault(isDefault);
        }

        public final int getHash$intellij_platform_bookmarks() {
            return this.hash;
        }

        public final void setHash$intellij_platform_bookmarks(int n) {
            this.hash = n;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setName(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                if (!StringsKt.isBlank((CharSequence)value) && BookmarksManagerImpl.findGroup$default(bookmarksManagerImpl, value, 0, 2, null) == null) {
                    this.name = value;
                    this.hash = value.hashCode();
                    if (bookmarksManagerImpl.contains(this)) {
                        bookmarksManagerImpl.notifier.groupRenamed(this);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public boolean isDefault() {
            return this == this.this$0.defaultGroup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDefault(boolean value) {
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                if (value) {
                    bookmarksManagerImpl.setDefaultGroup(this);
                } else if (this.isDefault()) {
                    bookmarksManagerImpl.setDefaultGroup(null);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public final int indexOf$intellij_platform_bookmarks(@NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            return switch (this.groupBookmarks.size()) {
                case 0 -> -1;
                case 1 -> {
                    if (Intrinsics.areEqual((Object)this.groupBookmarks.get(0).getBookmark(), (Object)bookmark)) {
                        yield 0;
                    }
                    yield -1;
                }
                default -> {
                    int hash = bookmark.hashCode();
                    List<InGroupInfo> $this$indexOfFirst$iv = this.groupBookmarks;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<InGroupInfo> var6_6 = $this$indexOfFirst$iv.iterator();
                    while (var6_6.hasNext()) {
                        InGroupInfo item$iv;
                        InGroupInfo it = item$iv = var6_6.next();
                        boolean $i$a$-indexOfFirst-BookmarksManagerImpl$Group$indexOf$1 = false;
                        if (it.getHash() == hash && Intrinsics.areEqual((Object)it.getBookmark(), (Object)bookmark)) {
                            yield index$iv;
                        }
                        ++index$iv;
                    }
                    yield -1;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        public final int indexWithGrouping$intellij_platform_bookmarks(@NotNull Bookmark bookmark) {
            int n;
            block5: {
                void $this$indexOfFirst$iv;
                Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
                int index = this.indexOf$intellij_platform_bookmarks(bookmark);
                if (index >= 0) {
                    return index;
                }
                if (!this.this$0.getGroupLineBookmarks()) {
                    return -1;
                }
                VirtualFile virtualFile = this.this$0.getFileGrouping(bookmark);
                if (virtualFile == null) {
                    return -1;
                }
                VirtualFile file = virtualFile;
                List<InGroupInfo> list2 = this.groupBookmarks;
                BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    InGroupInfo it = (InGroupInfo)item$iv;
                    boolean bl = false;
                    if (bookmarksManagerImpl.isLineGrouping(it.getBookmark(), file)) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public final void removeWithGrouping$intellij_platform_bookmarks(@NotNull Bookmark bookmark, @NotNull Function1<? super kotlin.Pair<InManagerInfo, InGroupInfo>, Unit> process) {
            void $this$forEach$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object $this$removeWithGrouping_u24lambda_u240;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter(process, (String)"process");
            kotlin.Pair pair = this.this$0.removeFromGroup(this, bookmark);
            if (pair != null) {
                $this$removeWithGrouping_u24lambda_u240 = pair;
                boolean bl = false;
                process.invoke($this$removeWithGrouping_u24lambda_u240);
            }
            if (!this.this$0.getGroupLineBookmarks()) {
                return;
            }
            VirtualFile virtualFile = this.this$0.getFileGrouping(bookmark);
            if (virtualFile == null) {
                return;
            }
            VirtualFile file = virtualFile;
            $this$removeWithGrouping_u24lambda_u240 = this.groupBookmarks;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Bookmark it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                InGroupInfo it = (InGroupInfo)element$iv$iv;
                boolean bl2 = false;
                if ((bookmarksManagerImpl.isLineGrouping(it.getBookmark(), file) ? it.getBookmark() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List bookmarks = (List)destination$iv$iv;
            $this$mapNotNull$iv = bookmarks;
            bookmarksManagerImpl = this.this$0;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                kotlin.Pair $this$removeWithGrouping_u24lambda_u242_u240;
                Bookmark it = (Bookmark)element$iv;
                boolean bl = false;
                if (bookmarksManagerImpl.removeFromGroup(this, it) == null) continue;
                boolean bl4 = false;
                process.invoke((Object)$this$removeWithGrouping_u24lambda_u242_u240);
            }
        }

        private final InGroupInfo getInfo(Bookmark bookmark) {
            int it = this.indexOf$intellij_platform_bookmarks(bookmark);
            boolean bl = false;
            return it < 0 ? null : this.groupBookmarks.get(it);
        }

        @Nullable
        public final InGroupInfo removeInfo$intellij_platform_bookmarks(@NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            int it = this.indexOf$intellij_platform_bookmarks(bookmark);
            boolean bl = false;
            return it < 0 ? null : this.groupBookmarks.remove(it);
        }

        public final boolean updateInfo$intellij_platform_bookmarks(@NotNull Bookmark old, @NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)old, (String)"old");
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"new");
            int index = this.indexOf$intellij_platform_bookmarks(old);
            if (index < 0) {
                return false;
            }
            InGroupInfo info = this.groupBookmarks.get(index);
            this.groupBookmarks.set(index, this.this$0.new InGroupInfo(bookmark, info.getDescription()));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public List<Bookmark> getBookmarks() {
            List list2;
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            synchronized (modificationNotifier) {
                void $this$mapTo$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = this.groupBookmarks;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    InGroupInfo inGroupInfo = (InGroupInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getBookmark());
                }
                list2 = (List)destination$iv$iv;
            }
            return list2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public String getDescription(@NotNull Bookmark bookmark) {
            String string;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                InGroupInfo inGroupInfo;
                block5: {
                    boolean bl = false;
                    if (this.getInfo(bookmark) != null) break block5;
                    String string2 = null;
                    return string2;
                }
                InGroupInfo info = inGroupInfo;
                if (info.getDescription() == null) {
                    info.setDescription(bookmarksManagerImpl.createDescription(bookmark));
                }
                string = info.getDescription();
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDescription(@NotNull Bookmark bookmark, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                InGroupInfo inGroupInfo = this.getInfo(bookmark);
                if (inGroupInfo == null) {
                    return;
                }
                InGroupInfo info = inGroupInfo;
                if (Intrinsics.areEqual((Object)info.getDescription(), (Object)description)) {
                    return;
                }
                info.setDescription(description);
                bookmarksManagerImpl.notifier.bookmarkChanged(this, bookmark);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canAdd(@NotNull Bookmark bookmark) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl2 = false;
                bl = bookmarksManagerImpl.contains(this) && this.indexOf$intellij_platform_bookmarks(bookmark) < 0 && (!(bookmark instanceof LineBookmark) || !bookmarksManagerImpl.allBookmarks.containsKey(bookmark));
            }
            return bl;
        }

        public boolean add(@NotNull Bookmark bookmark, @NotNull BookmarkType type, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (!this.this$0.canRewriteType(type, bookmark)) {
                return false;
            }
            if (!this.add$intellij_platform_bookmarks(bookmark, type, description, 0)) {
                return false;
            }
            this.this$0.notifier.selectLater$intellij_platform_bookmarks((Function1<? super BookmarksView, Unit>)((Function1)arg_0 -> Group.add$lambda$0(this, bookmark, arg_0)));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean add$intellij_platform_bookmarks(@NotNull Bookmark bookmark, @NotNull BookmarkType type, @Nullable String description, int index) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                block4: {
                    boolean bl = false;
                    if (this.canAdd(bookmark)) break block4;
                    boolean bl2 = false;
                    return bl2;
                }
                bookmarksManagerImpl.rewriteType(type, bookmark);
                InManagerInfo inManagerInfo = bookmarksManagerImpl.allBookmarks.computeIfAbsent(bookmark, arg_0 -> Group.add$lambda$1$1(arg_0 -> Group.add$lambda$1$0(bookmarksManagerImpl, type, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)inManagerInfo, (String)"computeIfAbsent(...)");
                InManagerInfo info = inManagerInfo;
                this.groupBookmarks.add(index < 0 ? this.groupBookmarks.size() : index, bookmarksManagerImpl.new InGroupInfo(info.getBookmark(), description));
                boolean added = info.getGroups().isEmpty();
                info.getGroups().add(this);
                info.bookmarkAdded(this, added);
                info.changeType(type);
                boolean bl = true;
                return bl;
            }
        }

        public final void addLater$intellij_platform_bookmarks(@NotNull Object context, @NotNull BookmarkType type, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.this$0.invoker.invokeLater(() -> Group.addLater$lambda$0(this.this$0, context, this, type, description));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canRemove(@NotNull Bookmark bookmark) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl2 = false;
                Object object = (InManagerInfo)bookmarksManagerImpl.allBookmarks.get(bookmark);
                bl = object != null && (object = ((InManagerInfo)object).getGroups()) != null ? object.contains(this) : false;
            }
            return bl;
        }

        public boolean remove(@NotNull Bookmark bookmark) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            return this.this$0.removeFromGroup(this, bookmark) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                int index = bookmarksManagerImpl.allGroups.indexOf(this);
                if (index >= 0) {
                    if (this.isDefault()) {
                        bookmarksManagerImpl.setDefaultGroup(null);
                    }
                    for (Bookmark bookmark : this.getBookmarks()) {
                        bookmarksManagerImpl.removeFromGroup(this, bookmark);
                    }
                    bookmarksManagerImpl.removeGroupFrom(index);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @NotNull
        public final CancellablePromise<?> sortLater$intellij_platform_bookmarks() {
            CancellablePromise cancellablePromise = this.this$0.invoker.invokeLater(() -> Group.sortLater$lambda$0(this));
            Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"invokeLater(...)");
            return cancellablePromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sort() {
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                if (this.groupBookmarks.isEmpty()) {
                    return;
                }
                if (!bookmarksManagerImpl.contains(this)) {
                    return;
                }
                List list2 = CollectionsKt.sortedWith((Iterable)this.groupBookmarks, (arg_0, arg_1) -> Group.sort$lambda$0$0((Function2)new Function2<InGroupInfo, InGroupInfo, Integer>((Object)this){

                    public final Integer invoke(InGroupInfo p0, InGroupInfo p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return Group.access$compare((Group)this.receiver, p0, p1);
                    }
                }, arg_0, arg_1));
                if (Intrinsics.areEqual((Object)list2, this.groupBookmarks)) {
                    return;
                }
                this.groupBookmarks.clear();
                this.groupBookmarks.addAll(list2);
                bookmarksManagerImpl.notifier.bookmarksSorted(this);
                Unit unit = Unit.INSTANCE;
            }
        }

        private final int compare(InGroupInfo info1, InGroupInfo info2) {
            int weight2;
            int weight1 = info1.getBookmark().getProvider().getWeight();
            if (weight1 > (weight2 = info2.getBookmark().getProvider().getWeight())) {
                return -1;
            }
            if (weight1 < weight2) {
                return 1;
            }
            return info1.getBookmark().getProvider().compare((Object)info1.getBookmark(), (Object)info2.getBookmark());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void move$intellij_platform_bookmarks(@NotNull Bookmark bookmark, @NotNull Bookmark anchor) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            ModificationNotifier modificationNotifier = this.this$0.notifier;
            BookmarksManagerImpl bookmarksManagerImpl = this.this$0;
            ModificationNotifier modificationNotifier2 = modificationNotifier;
            synchronized (modificationNotifier2) {
                boolean bl = false;
                int fromIndex = this.indexWithGrouping$intellij_platform_bookmarks(bookmark);
                if (fromIndex < 0) {
                    return;
                }
                int toIndex = this.indexWithGrouping$intellij_platform_bookmarks(anchor);
                if (toIndex < 0 || toIndex == fromIndex) {
                    return;
                }
                InGroupInfo info = this.groupBookmarks.remove(RangesKt.coerceAtLeast((int)fromIndex, (int)toIndex));
                bookmarksManagerImpl.notifier.bookmarkRemoved(this, info.getBookmark());
                this.groupBookmarks.add(RangesKt.coerceAtMost((int)toIndex, (int)fromIndex), info);
                bookmarksManagerImpl.notifier.bookmarkAdded(this, info.getBookmark());
                Unit unit = Unit.INSTANCE;
            }
        }

        @NotNull
        public final GroupState getState$intellij_platform_bookmarks() {
            GroupState groupState;
            GroupState it = groupState = new GroupState();
            boolean bl = false;
            it.setName(this.getName());
            it.setDefault(this.isDefault());
            for (InGroupInfo info : this.groupBookmarks) {
                it.getBookmarks().add(info.getState());
            }
            return groupState;
        }

        private static final Unit add$lambda$0(Group this$0, Bookmark $bookmark, BookmarksView it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            it.select(this$0, $bookmark);
            return Unit.INSTANCE;
        }

        private static final InManagerInfo add$lambda$1$0(BookmarksManagerImpl this$0, BookmarkType $type, Bookmark it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.new InManagerInfo(it, $type);
        }

        private static final InManagerInfo add$lambda$1$1(Function1 $tmp0, Object p0) {
            return (InManagerInfo)$tmp0.invoke(p0);
        }

        private static final void addLater$lambda$0(BookmarksManagerImpl this$0, Object $context, Group this$1, BookmarkType $type, String $description) {
            Boolean bl;
            Bookmark bookmark = this$0.createBookmark($context);
            if (bookmark != null) {
                Bookmark it = bookmark;
                boolean bl2 = false;
                v1 = this$1.add$intellij_platform_bookmarks(it, $type, $description, -1);
            } else {
                v1 = bl = null;
            }
            if (bl == null) {
                BookmarksManagerImplKt.access$getLOG$p().info("cannot create bookmark for " + $context);
            } else if (Intrinsics.areEqual(bl, (Object)false)) {
                BookmarksManagerImplKt.access$getLOG$p().info("cannot add bookmark for " + $context);
            }
        }

        private static final void sortLater$lambda$0(Group this$0) {
            this$0.sort();
        }

        private static final int sort$lambda$0$0(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        public static final /* synthetic */ int access$compare(Group $this, InGroupInfo info1, InGroupInfo info2) {
            return $this.compare(info1, info2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InGroupInfo;", "", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "description", "", "<init>", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl;Lcom/intellij/ide/bookmark/Bookmark;Ljava/lang/String;)V", "getBookmark", "()Lcom/intellij/ide/bookmark/Bookmark;", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "hash", "", "getHash", "()I", "getState", "Lcom/intellij/ide/bookmark/BookmarkState;", "intellij.platform.bookmarks"})
    public final class InGroupInfo {
        @NotNull
        private final Bookmark bookmark;
        @Nullable
        private String description;
        private final int hash;

        public InGroupInfo(@Nullable Bookmark bookmark, String description) {
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            this.bookmark = bookmark;
            this.description = description;
            this.hash = this.bookmark.hashCode();
        }

        @NotNull
        public final Bookmark getBookmark() {
            return this.bookmark;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string) {
            this.description = string;
        }

        public final int getHash() {
            return this.hash;
        }

        @NotNull
        public final BookmarkState getState() {
            BookmarkState bookmarkState = new BookmarkState();
            BookmarksManagerImpl bookmarksManagerImpl = BookmarksManagerImpl.this;
            BookmarkState it = bookmarkState;
            boolean bl = false;
            it.setProvider(this.bookmark.getProvider().getClass().getName());
            it.setDescription(this.description);
            InManagerInfo inManagerInfo = (InManagerInfo)bookmarksManagerImpl.allBookmarks.get(this.bookmark);
            if (inManagerInfo == null || (inManagerInfo = inManagerInfo.getType()) == null) {
                inManagerInfo = BookmarkType.DEFAULT;
            }
            it.setType((BookmarkType)inManagerInfo);
            it.getAttributes().putAll(this.bookmark.getAttributes());
            return bookmarkState;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001fJ\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/ide/bookmark/BookmarksManagerImpl$InManagerInfo;", "", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "<init>", "(Lcom/intellij/ide/bookmark/BookmarksManagerImpl;Lcom/intellij/ide/bookmark/Bookmark;Lcom/intellij/ide/bookmark/BookmarkType;)V", "getBookmark", "()Lcom/intellij/ide/bookmark/Bookmark;", "getType", "()Lcom/intellij/ide/bookmark/BookmarkType;", "setType", "(Lcom/intellij/ide/bookmark/BookmarkType;)V", "renderer", "Lcom/intellij/ide/bookmark/GutterLineBookmarkRenderer;", "getRenderer", "()Lcom/intellij/ide/bookmark/GutterLineBookmarkRenderer;", "groups", "", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl$Group;", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl;", "getGroups", "()Ljava/util/Set;", "refreshRenderer", "", "()Lkotlin/Unit;", "bookmarkAdded", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "initial", "", "bookmarkRemoved", "completely", "changeType", "intellij.platform.bookmarks"})
    @SourceDebugExtension(value={"SMAP\nBookmarksManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarksManagerImpl.kt\ncom/intellij/ide/bookmark/BookmarksManagerImpl$InManagerInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,679:1\n1#2:680\n*E\n"})
    public final class InManagerInfo {
        @NotNull
        private final Bookmark bookmark;
        @NotNull
        private BookmarkType type;
        @Nullable
        private final GutterLineBookmarkRenderer renderer;
        @NotNull
        private final Set<Group> groups;

        /*
         * WARNING - void declaration
         */
        public InManagerInfo(@NotNull Bookmark bookmark, BookmarkType type) {
            GutterLineBookmarkRenderer gutterLineBookmarkRenderer;
            Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.bookmark = bookmark;
            this.type = type;
            InManagerInfo inManagerInfo = this;
            Bookmark bookmark2 = this.bookmark;
            LineBookmark lineBookmark = bookmark2 instanceof LineBookmark ? (LineBookmark)bookmark2 : null;
            if (lineBookmark != null) {
                void it;
                LineBookmark lineBookmark2 = lineBookmark;
                InManagerInfo inManagerInfo2 = inManagerInfo;
                boolean bl = false;
                gutterLineBookmarkRenderer = new GutterLineBookmarkRenderer((LineBookmark)it);
                inManagerInfo = inManagerInfo2;
            } else {
                gutterLineBookmarkRenderer = null;
            }
            inManagerInfo.renderer = gutterLineBookmarkRenderer;
            this.groups = new LinkedHashSet();
        }

        @NotNull
        public final Bookmark getBookmark() {
            return this.bookmark;
        }

        @NotNull
        public final BookmarkType getType() {
            return this.type;
        }

        public final void setType(@NotNull BookmarkType bookmarkType) {
            Intrinsics.checkNotNullParameter((Object)bookmarkType, (String)"<set-?>");
            this.type = bookmarkType;
        }

        @Nullable
        public final GutterLineBookmarkRenderer getRenderer() {
            return this.renderer;
        }

        @NotNull
        public final Set<Group> getGroups() {
            return this.groups;
        }

        @Nullable
        public final Unit refreshRenderer() {
            Unit unit;
            GutterLineBookmarkRenderer gutterLineBookmarkRenderer = this.renderer;
            if (gutterLineBookmarkRenderer != null) {
                gutterLineBookmarkRenderer.refreshHighlighter((Function0<Boolean>)((Function0)() -> InManagerInfo.refreshRenderer$lambda$0(this)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        public final void bookmarkAdded(@NotNull BookmarkGroup group, boolean initial) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            BookmarksManagerImpl.this.notifier.bookmarkAdded(group, this.bookmark);
            if (initial) {
                this.refreshRenderer();
            }
        }

        public final void bookmarkRemoved(@NotNull BookmarkGroup group, boolean completely) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            BookmarksManagerImpl.this.notifier.bookmarkRemoved(group, this.bookmark);
            if (completely) {
                this.refreshRenderer();
            }
        }

        public final void changeType(@NotNull BookmarkType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (this.type == type) {
                return;
            }
            this.type = type;
            BookmarksManagerImpl.this.notifier.bookmarkTypeChanged(this.bookmark);
            this.refreshRenderer();
        }

        private static final boolean refreshRenderer$lambda$0(InManagerInfo this$0) {
            return this$0.groups.isEmpty();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BookmarkType.values().length];
            try {
                nArray[BookmarkType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

