/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.bookmark.ui.tree.RootNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.presentation.FilePresentationService;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.IconManager;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0011\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0096\u0002J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\u001fH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001fH\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0014J\u0012\u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010-\u001a\u00020.H\u0016J\u0012\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000100H\u0004J\u0010\u00102\u001a\u00020(2\u0006\u00103\u001a\u000204H\u0014J\"\u00105\u001a\u00020(2\u0006\u00103\u001a\u0002042\u0006\u0010#\u001a\u00020$2\b\b\u0002\u00106\u001a\u00020.H\u0004J8\u00105\u001a\u00020(2\u0006\u00103\u001a\u0002042\u000b\u00107\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\u000f\b\u0002\u00108\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\b\b\u0002\u00106\u001a\u00020.H\u0004J\u0017\u00109\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\u0006\u0010#\u001a\u00020$H\u0002R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006:"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "B", "Lcom/intellij/ide/bookmark/Bookmark;", "Lcom/intellij/ui/BackgroundSupplier;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "project", "Lcom/intellij/openapi/project/Project;", "bookmark", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/bookmark/Bookmark;)V", "bookmarksView", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "getBookmarksView$intellij_platform_bookmarks", "()Lcom/intellij/ide/bookmark/ui/BookmarksView;", "bookmarkType", "Lcom/intellij/ide/bookmark/BookmarkType;", "Lorg/jetbrains/annotations/Nullable;", "getBookmarkType", "()Lcom/intellij/ide/bookmark/BookmarkType;", "bookmarkDescription", "", "Lcom/intellij/openapi/util/NlsSafe;", "getBookmarkDescription", "()Ljava/lang/String;", "bookmarkGroup", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "getBookmarkGroup", "()Lcom/intellij/ide/bookmark/BookmarkGroup;", "setBookmarkGroup", "(Lcom/intellij/ide/bookmark/BookmarkGroup;)V", "canRepresent", "", "element", "", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canNavigate", "canNavigateToSource", "navigate", "", "requestFocus", "computeBackgroundColor", "Ljava/awt/Color;", "getElementBackground", "row", "", "wrapIcon", "Ljavax/swing/Icon;", "icon", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "addTextTo", "line", "name", "location", "getRelativePath", "intellij.platform.bookmarks"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBookmarkNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkNode.kt\ncom/intellij/ide/bookmark/ui/tree/BookmarkNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public abstract class BookmarkNode<B extends Bookmark>
extends ProjectViewNode<B>
implements BackgroundSupplier {
    @Nullable
    private BookmarkGroup bookmarkGroup;

    public BookmarkNode(@NotNull Project project, @NotNull B bookmark) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(bookmark, (String)"bookmark");
        super(project, bookmark, (ViewSettings)ProjectViewSettings.Immutable.DEFAULT);
    }

    @Nullable
    public final BookmarksView getBookmarksView$intellij_platform_bookmarks() {
        RootNode rootNode = ExtensionsKt.getParentRootNode((AbstractTreeNode)this);
        return rootNode != null ? (BookmarksView)((Object)rootNode.getValue()) : null;
    }

    private final BookmarkType getBookmarkType() {
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager((AbstractTreeNode)this);
        return bookmarksManager != null ? bookmarksManager.getType((Bookmark)this.getValue()) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getBookmarkDescription() {
        CharSequence charSequence;
        BookmarkGroup bookmarkGroup = this.bookmarkGroup;
        Object object = bookmarkGroup;
        if (bookmarkGroup == null) return null;
        Object object2 = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getValue(...)");
        String string = object.getDescription((Bookmark)object2);
        object = string;
        if (string == null) return null;
        CharSequence charSequence2 = (CharSequence)object;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        String string2 = (String)charSequence;
        return string2;
    }

    @Nullable
    public final BookmarkGroup getBookmarkGroup() {
        return this.bookmarkGroup;
    }

    public final void setBookmarkGroup(@Nullable BookmarkGroup bookmarkGroup) {
        this.bookmarkGroup = bookmarkGroup;
    }

    public boolean canRepresent(@Nullable Object element) {
        VirtualFile virtualFile = this.getVirtualFile();
        return virtualFile != null ? virtualFile.equals(element) : false;
    }

    public boolean contains(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            bl = VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean canNavigate() {
        return ((Navigatable)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((Navigatable)this.getValue()).canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.getValue()).navigate(requestFocus);
    }

    @Nullable
    protected Color computeBackgroundColor() {
        return FilePresentationService.getFileBackgroundColor((Project)this.getProject(), (VirtualFile)this.getVirtualFile());
    }

    @Nullable
    public Color getElementBackground(int row) {
        return this.getPresentation().getBackground();
    }

    @NotNull
    protected final Icon wrapIcon(@Nullable Icon icon) {
        Icon icon2;
        BookmarkType bookmarkType = this.getBookmarkType();
        if (bookmarkType == null) {
            bookmarkType = BookmarkType.DEFAULT;
        }
        BookmarkType type = bookmarkType;
        if (icon == null) {
            icon2 = type.getIcon();
        } else if (type == BookmarkType.DEFAULT) {
            icon2 = icon;
        } else {
            Icon[] iconArray = new Icon[]{type.getIcon(), icon};
            icon2 = (Icon)IconManager.Companion.getInstance().createRowIcon(iconArray);
        }
        return icon2;
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        presentation.setIcon(this.wrapIcon(ExtensionsKt.findFileIcon(this)));
        BookmarkNode.addTextTo$default(this, presentation, file, 0, 4, null);
    }

    protected final void addTextTo(@NotNull PresentationData presentation, @NotNull VirtualFile file, int line) {
        String string;
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
        String name = string2;
        VirtualFile virtualFile = file.getParent();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            string = this.getRelativePath(it);
        } else {
            string = null;
        }
        String location = string;
        this.addTextTo(presentation, name, location, line);
    }

    public static /* synthetic */ void addTextTo$default(BookmarkNode bookmarkNode, PresentationData presentationData, VirtualFile virtualFile, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTextTo");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        bookmarkNode.addTextTo(presentationData, virtualFile, n);
    }

    protected final void addTextTo(@NotNull PresentationData presentation, @NotNull String name, @Nullable String location, int line) {
        block3: {
            String description;
            block2: {
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                description = this.getBookmarkDescription();
                if (description != null) break block2;
                presentation.setPresentableText(name);
                presentation.addText(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (line > 0) {
                    presentation.addText(" :" + line, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                String string = location;
                if (string == null) break block3;
                String it = string;
                boolean bl = false;
                presentation.addText("  " + it, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                break block3;
            }
            presentation.setPresentableText(description + " " + name);
            presentation.addText(description + "  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            presentation.addText(name, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            if (line > 0) {
                presentation.addText(" :" + line, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            String string = location;
            if (string == null) break block3;
            String it = string;
            boolean bl = false;
            presentation.addText("  (" + it + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public static /* synthetic */ void addTextTo$default(BookmarkNode bookmarkNode, PresentationData presentationData, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTextTo");
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        bookmarkNode.addTextTo(presentationData, string, string2, n);
    }

    private final String getRelativePath(VirtualFile file) {
        VirtualFile parent;
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        if (project2.isDisposed()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex index = projectFileIndex;
        if (index.getModuleForFile(file, false) == null) {
            return ExtensionsKt.computeExternalLocation(this, file);
        }
        VirtualFile root = file;
        while (root.getParent() != null && index.getModuleForFile(parent, false) != null) {
            root = parent;
        }
        return Intrinsics.areEqual((Object)file, (Object)root) ? null : VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)root);
    }
}

