// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.ide.bookmark.actions

import com.intellij.ide.bookmark.LineBookmark
import com.intellij.openapi.actionSystem.ActionUpdateThread
import com.intellij.openapi.actionSystem.AnActionEvent
import com.intellij.openapi.project.DumbAwareAction

internal class AddAnotherBookmarkAction : DumbAwareAction() {
  override fun getActionUpdateThread(): ActionUpdateThread = ActionUpdateThread.BGT

  override fun update(event: AnActionEvent) {
    event.presentation.isEnabledAndVisible = process(event, false)
  }

  override fun actionPerformed(event: AnActionEvent) {
    process(event, true)
  }

  private fun process(event: AnActionEvent, perform: Boolean): Boolean {
    if (event.contextBookmarks != null) { return false }
    val manager = event.bookmarksManager ?: return false
    val bookmark = event.contextBookmark ?: return false
    if (bookmark is LineBookmark) return false
    val type = manager.getType(bookmark) ?: return false
    if (perform) manager.add(bookmark, type)
    return true
  }

  init {
    isEnabledInModalContext = true
  }
}
