/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.BookmarksManagerImpl;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0000J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00002\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00160\u0015J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0000J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u00002\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00160\u0015J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\u0013\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "current", "", "snapshot", "", "<init>", "(Lcom/intellij/ide/bookmark/BookmarkGroup;Lcom/intellij/ide/bookmark/Bookmark;ILjava/util/List;)V", "(Lcom/intellij/ide/bookmark/BookmarkGroup;Lcom/intellij/ide/bookmark/Bookmark;)V", "getGroup", "()Lcom/intellij/ide/bookmark/BookmarkGroup;", "getBookmark", "()Lcom/intellij/ide/bookmark/Bookmark;", "nextFileBookmark", "nextLineBookmark", "next", "predicate", "Lkotlin/Function1;", "", "previousFileBookmark", "previousLineBookmark", "previous", "hashCode", "equals", "other", "Companion", "intellij.platform.bookmarks"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBookmarkOccurrence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkOccurrence.kt\ncom/intellij/ide/bookmark/BookmarkOccurrence\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n388#2,7:72\n295#2,2:79\n360#2,7:81\n543#2,6:88\n*S KotlinDebug\n*F\n+ 1 BookmarkOccurrence.kt\ncom/intellij/ide/bookmark/BookmarkOccurrence\n*L\n23#1:72,7\n26#1:79,2\n38#1:81,7\n42#1:88,6\n*E\n"})
public final class BookmarkOccurrence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BookmarkGroup group;
    @NotNull
    private final Bookmark bookmark;
    private final int current;
    @Nullable
    private final List<BookmarkOccurrence> snapshot;

    public BookmarkOccurrence(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark, int current, @Nullable List<BookmarkOccurrence> snapshot) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.group = group;
        this.bookmark = bookmark;
        this.current = current;
        this.snapshot = snapshot;
    }

    @NotNull
    public final BookmarkGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final Bookmark getBookmark() {
        return this.bookmark;
    }

    public BookmarkOccurrence(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this(group, bookmark, -1, null);
    }

    @Nullable
    public final BookmarkOccurrence nextFileBookmark() {
        return this.next((Function1<? super BookmarkOccurrence, Boolean>)((Function1)BookmarkOccurrence::nextFileBookmark$lambda$0));
    }

    @Nullable
    public final BookmarkOccurrence nextLineBookmark() {
        return this.next((Function1<? super BookmarkOccurrence, Boolean>)((Function1)BookmarkOccurrence::nextLineBookmark$lambda$0));
    }

    @Nullable
    public final BookmarkOccurrence next(@NotNull Function1<? super BookmarkOccurrence, Boolean> predicate) {
        BookmarkOccurrence occurrence;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        List<BookmarkOccurrence> list2 = this.snapshot;
        if (list2 == null) {
            Project project = this.bookmark.getProvider().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BookmarksManagerImpl bookmarksManagerImpl = BookmarkOccurrence.Companion.manager(project);
            list2 = bookmarksManagerImpl != null ? bookmarksManagerImpl.getSnapshot$intellij_platform_bookmarks() : null;
            if (list2 == null) {
                return null;
            }
        }
        List<BookmarkOccurrence> list3 = list2;
        int index = this.current;
        if (index < 0) {
            int n;
            block8: {
                List<BookmarkOccurrence> $this$indexOfLast$iv = list3;
                boolean $i$f$indexOfLast = false;
                ListIterator<BookmarkOccurrence> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    BookmarkOccurrence it = iterator$iv.previous();
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.group, (Object)this.group) && Intrinsics.areEqual((Object)it.bookmark, (Object)this.bookmark))) continue;
                    n = iterator$iv.nextIndex();
                    break block8;
                }
                n = -1;
            }
            index = n;
        }
        do {
            BookmarkOccurrence bookmarkOccurrence;
            if ((BookmarkOccurrence)CollectionsKt.getOrNull(list3, (int)(++index)) != null) continue;
            if (Companion.getCyclic()) {
                Object v4;
                block9: {
                    Iterable $this$firstOrNull$iv = list3;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                        v4 = element$iv;
                        break block9;
                    }
                    v4 = null;
                }
                bookmarkOccurrence = v4;
            } else {
                bookmarkOccurrence = null;
            }
            return bookmarkOccurrence;
        } while (!((Boolean)predicate.invoke((Object)occurrence)).booleanValue());
        return occurrence;
    }

    @Nullable
    public final BookmarkOccurrence previousFileBookmark() {
        return this.previous((Function1<? super BookmarkOccurrence, Boolean>)((Function1)BookmarkOccurrence::previousFileBookmark$lambda$0));
    }

    @Nullable
    public final BookmarkOccurrence previousLineBookmark() {
        return this.previous((Function1<? super BookmarkOccurrence, Boolean>)((Function1)BookmarkOccurrence::previousLineBookmark$lambda$0));
    }

    @Nullable
    public final BookmarkOccurrence previous(@NotNull Function1<? super BookmarkOccurrence, Boolean> predicate) {
        BookmarkOccurrence occurrence;
        int index;
        List<BookmarkOccurrence> list2;
        block10: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            List<BookmarkOccurrence> list3 = this.snapshot;
            if (list3 == null) {
                Project project = this.bookmark.getProvider().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                BookmarksManagerImpl bookmarksManagerImpl = BookmarkOccurrence.Companion.manager(project);
                list3 = bookmarksManagerImpl != null ? bookmarksManagerImpl.getSnapshot$intellij_platform_bookmarks() : null;
                if (list3 == null) {
                    return null;
                }
            }
            list2 = list3;
            index = this.current;
            if (index < 0) {
                int n;
                List<BookmarkOccurrence> $this$indexOfFirst$iv = list2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<BookmarkOccurrence> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    BookmarkOccurrence item$iv;
                    BookmarkOccurrence it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.group, (Object)this.group) && Intrinsics.areEqual((Object)it.bookmark, (Object)this.bookmark)) {
                        n = index$iv;
                        break block10;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
        }
        if (index < 0) {
            index = list2.size();
        }
        do {
            BookmarkOccurrence bookmarkOccurrence;
            if ((BookmarkOccurrence)CollectionsKt.getOrNull(list2, (int)(--index)) != null) continue;
            if (Companion.getCyclic()) {
                BookmarkOccurrence bookmarkOccurrence2;
                block11: {
                    List<BookmarkOccurrence> $this$lastOrNull$iv = list2;
                    boolean $i$f$lastOrNull = false;
                    ListIterator<BookmarkOccurrence> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        BookmarkOccurrence element$iv = iterator$iv.previous();
                        if (!((Boolean)predicate.invoke((Object)element$iv)).booleanValue()) continue;
                        bookmarkOccurrence2 = element$iv;
                        break block11;
                    }
                    bookmarkOccurrence2 = null;
                }
                bookmarkOccurrence = bookmarkOccurrence2;
            } else {
                bookmarkOccurrence = null;
            }
            return bookmarkOccurrence;
        } while (!((Boolean)predicate.invoke((Object)occurrence)).booleanValue());
        return occurrence;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.group, this.bookmark};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof BookmarkOccurrence && Intrinsics.areEqual((Object)((BookmarkOccurrence)other).group, (Object)this.group) && Intrinsics.areEqual((Object)((BookmarkOccurrence)other).bookmark, (Object)this.bookmark);
    }

    private static final boolean nextFileBookmark$lambda$0(BookmarkOccurrence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.bookmark instanceof FileBookmark;
    }

    private static final boolean nextLineBookmark$lambda$0(BookmarkOccurrence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.bookmark instanceof LineBookmark;
    }

    private static final boolean previousFileBookmark$lambda$0(BookmarkOccurrence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.bookmark instanceof FileBookmark;
    }

    private static final boolean previousLineBookmark$lambda$0(BookmarkOccurrence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.bookmark instanceof LineBookmark;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u0011R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/bookmark/BookmarkOccurrence$Companion;", "", "<init>", "()V", "manager", "Lcom/intellij/ide/bookmark/BookmarksManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "cyclic", "", "getCyclic", "()Z", "firstFileBookmark", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "firstLineBookmark", "first", "predicate", "Lkotlin/Function1;", "lastFileBookmark", "lastLineBookmark", "last", "intellij.platform.bookmarks"})
    @SourceDebugExtension(value={"SMAP\nBookmarkOccurrence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkOccurrence.kt\ncom/intellij/ide/bookmark/BookmarkOccurrence$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n295#2,2:72\n543#2,6:74\n*S KotlinDebug\n*F\n+ 1 BookmarkOccurrence.kt\ncom/intellij/ide/bookmark/BookmarkOccurrence$Companion\n*L\n63#1:72,2\n68#1:74,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final BookmarksManagerImpl manager(Project project) {
            BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)project);
            return bookmarksManager instanceof BookmarksManagerImpl ? (BookmarksManagerImpl)bookmarksManager : null;
        }

        public final boolean getCyclic() {
            return Registry.Companion.is("ide.bookmark.occurrence.cyclic.iteration.allowed", false);
        }

        @Nullable
        public final BookmarkOccurrence firstFileBookmark(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.first(project, (Function1<? super BookmarkOccurrence, Boolean>)((Function1)Companion::firstFileBookmark$lambda$0));
        }

        @Nullable
        public final BookmarkOccurrence firstLineBookmark(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.first(project, (Function1<? super BookmarkOccurrence, Boolean>)((Function1)Companion::firstLineBookmark$lambda$0));
        }

        @Nullable
        public final BookmarkOccurrence first(@NotNull Project project, @NotNull Function1<? super BookmarkOccurrence, Boolean> predicate) {
            BookmarkOccurrence bookmarkOccurrence;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Object object = this.manager(project);
            if (object != null && (object = ((BookmarksManagerImpl)object).getSnapshot$intellij_platform_bookmarks()) != null) {
                Object v1;
                block3: {
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                bookmarkOccurrence = v1;
            } else {
                bookmarkOccurrence = null;
            }
            return bookmarkOccurrence;
        }

        @Nullable
        public final BookmarkOccurrence lastFileBookmark(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.last(project, (Function1<? super BookmarkOccurrence, Boolean>)((Function1)Companion::lastFileBookmark$lambda$0));
        }

        @Nullable
        public final BookmarkOccurrence lastLineBookmark(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.last(project, (Function1<? super BookmarkOccurrence, Boolean>)((Function1)Companion::lastLineBookmark$lambda$0));
        }

        @Nullable
        public final BookmarkOccurrence last(@NotNull Project project, @NotNull Function1<? super BookmarkOccurrence, Boolean> predicate) {
            BookmarkOccurrence bookmarkOccurrence;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Object object = this.manager(project);
            if (object != null && (object = ((BookmarksManagerImpl)object).getSnapshot$intellij_platform_bookmarks()) != null) {
                Object v1;
                block3: {
                    Object $this$lastOrNull$iv = object;
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                bookmarkOccurrence = v1;
            } else {
                bookmarkOccurrence = null;
            }
            return bookmarkOccurrence;
        }

        private static final boolean firstFileBookmark$lambda$0(BookmarkOccurrence it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getBookmark() instanceof FileBookmark;
        }

        private static final boolean firstLineBookmark$lambda$0(BookmarkOccurrence it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getBookmark() instanceof LineBookmark;
        }

        private static final boolean lastFileBookmark$lambda$0(BookmarkOccurrence it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getBookmark() instanceof FileBookmark;
        }

        private static final boolean lastLineBookmark$lambda$0(BookmarkOccurrence it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getBookmark() instanceof LineBookmark;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

