/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/bookmark/actions/ToggleBookmarkTypeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "<init>", "(Lcom/intellij/ide/bookmark/BookmarkType;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.bookmarks"})
public class ToggleBookmarkTypeAction
extends DumbAwareAction {
    @NotNull
    private final BookmarkType type;

    public ToggleBookmarkTypeAction(@NotNull BookmarkType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Object[] objectArray = new Object[]{Character.valueOf(type.getMnemonic())};
        super(BookmarkBundle.messagePointer("bookmark.type.toggle.action.text", objectArray));
        this.type = type;
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BookmarksManager manager = ExtensionsKt.getBookmarksManager(event);
        Bookmark bookmark = ExtensionsKt.getContextBookmark(event);
        event.getPresentation().setEnabledAndVisible(manager != null && bookmark != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Bookmark bookmark = ExtensionsKt.getContextBookmark(event);
        if (bookmark == null) {
            return;
        }
        Bookmark bookmark2 = bookmark;
        manager.toggle(bookmark2, this.type);
    }
}

