/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.startup.multiProcess;

import com.intellij.idea.Main;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.PathManager;
import com.intellij.platform.ide.impl.startup.multiProcess.CustomConfigFiles;
import java.io.IOException;
import java.nio.file.Path;

final class PerProcessPathCustomization {
    PerProcessPathCustomization() {
    }

    public static Path getStartupScriptDir() {
        return PathManager.getSystemDir().resolve("startup-script");
    }

    public static void prepareConfig(Path newConfig, Path oldConfigPath, boolean migratePlugins) {
        try {
            if (Main.isConfigImportNeeded(oldConfigPath)) {
                Main.customTargetDirectoryToImportConfig = oldConfigPath;
            } else if (migratePlugins) {
                Main.customTargetDirectoryToImportConfig = newConfig;
                new CustomConfigMigrationOption.MigratePluginsFromCustomPlace(oldConfigPath).writeConfigMarkerFile(newConfig);
            }
            CustomConfigFiles.prepareConfigDir(newConfig, oldConfigPath);
        }
        catch (IOException e) {
            System.err.println("Failed to prepare config directory " + String.valueOf(newConfig));
            e.printStackTrace();
        }
    }
}

