/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.dependencies.ArchiveContent;
import org.jetbrains.intellij.build.dependencies.Entry;
import org.jetbrains.intellij.build.dependencies.EntryNameConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0012J\u0012\u0010\u0018\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0010*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u001cJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\nJ\u001e\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\nJ\u001e\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\nJ4\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\n2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0)H\u0002J(\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\nH\u0002J\u000e\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u0012J\u0010\u00100\u001a\u00020!2\u0006\u00101\u001a\u00020\u0012H\u0002J\u000e\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020\u001cJ\u000e\u00104\u001a\u00020!2\u0006\u00105\u001a\u00020\u001cJ\u001a\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012072\u0006\u00103\u001a\u00020\u001cJ\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f2\u0006\u00105\u001a\u00020\u001cJ\u0018\u00109\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u001c2\b\u0010:\u001a\u0004\u0018\u00010\u0012R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0015\u0010\u0015\u001a\u00020\u0012*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006;"}, d2={"Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesUtil;", "", "<init>", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "octal_0111", "", "isWindows", "", "()Z", "createDocumentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "getChildElements", "", "Lorg/w3c/dom/Element;", "tagName", "", "getComponentElement", "componentName", "asText", "getAsText", "(Lorg/w3c/dom/Element;)Ljava/lang/String;", "getSingleChildElement", "tryGetSingleChildElement", "getLibraryMavenId", "libraryXml", "Ljava/nio/file/Path;", "getLibraryElement", "libraryName", "iml", "extractZip", "", "archiveFile", "target", "stripRoot", "extractTarBz2", "extractTarGz", "extractTarBasedArchive", "decompressor", "Lkotlin/Function1;", "Ljava/io/InputStream;", "genericExtract", "archive", "Lorg/jetbrains/intellij/build/dependencies/ArchiveContent;", "normalizeEntryName", "name", "assertValidEntryName", "normalizedEntryName", "deleteFileOrFolder", "file", "cleanDirectory", "directory", "loadPropertiesFile", "", "listDirectory", "directoryContentToString", "humanReadableName", "intellij.platform.buildScripts.downloader"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBuildDependenciesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildDependenciesUtil.kt\norg/jetbrains/intellij/build/dependencies/BuildDependenciesUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,365:1\n777#2:366\n873#2,2:367\n777#2:370\n873#2,2:371\n1586#2:373\n1661#2,3:374\n672#2,11:377\n1915#2,2:388\n1#3:369\n129#4:390\n158#4,3:391\n*S KotlinDebug\n*F\n+ 1 BuildDependenciesUtil.kt\norg/jetbrains/intellij/build/dependencies/BuildDependenciesUtil\n*L\n100#1:366\n100#1:367,2\n144#1:370\n144#1:371,2\n145#1:373\n145#1:374,3\n146#1:377,11\n299#1:388,2\n304#1:390\n304#1:391,3\n*E\n"})
public final class BuildDependenciesUtil {
    @NotNull
    public static final BuildDependenciesUtil INSTANCE = new BuildDependenciesUtil();
    private static final Logger LOG = Logger.getLogger(BuildDependenciesUtil.class.getName());
    private static final int octal_0111 = Integer.parseInt("111", CharsKt.checkRadix((int)8));
    private static final boolean isWindows;

    private BuildDependenciesUtil() {
    }

    public final boolean isWindows() {
        return isWindows;
    }

    @NotNull
    public final DocumentBuilder createDocumentBuilder() {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newDefaultInstance();
        try {
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            documentBuilder = dbf.newDocumentBuilder();
            Intrinsics.checkNotNull((Object)documentBuilder);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Unable to create DOM parser", throwable);
        }
        return documentBuilder;
    }

    @NotNull
    public final List<Element> getChildElements(@NotNull Element $this$getChildElements, @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)$this$getChildElements, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        NodeList childNodes = $this$getChildElements.getChildNodes();
        ArrayList<Node> result = new ArrayList<Node>();
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !Intrinsics.areEqual((Object)tagName, (Object)((Element)node).getTagName())) continue;
            result.add(node);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Element getComponentElement(@NotNull Element $this$getComponentElement, @NotNull String componentName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getComponentElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Iterable $this$filter$iv = this.getChildElements($this$getComponentElement, "component");
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element x = (Element)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)componentName, (Object)x.getAttribute("name"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List elements = (List)destination$iv$iv;
        if (!(elements.size() == 1)) {
            boolean bl = false;
            String string = "Expected one and only one component with name '" + componentName + "'";
            throw new IllegalStateException(string.toString());
        }
        return (Element)elements.get(0);
    }

    @NotNull
    public final String getAsText(@NotNull Element $this$asText) {
        Intrinsics.checkNotNullParameter((Object)$this$asText, (String)"<this>");
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        Intrinsics.checkNotNullExpressionValue((Object)transformer, (String)"newTransformer(...)");
        Transformer transformer2 = transformer;
        StringWriter buffer = new StringWriter();
        transformer2.setOutputProperty("omit-xml-declaration", "yes");
        transformer2.transform(new DOMSource($this$asText), new StreamResult(buffer));
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.replace$default((String)string, (String)"\r", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final Element getSingleChildElement(@NotNull Element $this$getSingleChildElement, @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)$this$getSingleChildElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        List<Element> result = this.getChildElements($this$getSingleChildElement, tagName);
        if (!(result.size() == 1)) {
            boolean bl = false;
            String string = "Expected one and only one element by tag '" + tagName + "'";
            throw new IllegalStateException(string.toString());
        }
        return result.get(0);
    }

    @Nullable
    public final Element tryGetSingleChildElement(@NotNull Element $this$tryGetSingleChildElement, @NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)$this$tryGetSingleChildElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        List<Element> result = this.getChildElements($this$tryGetSingleChildElement, tagName);
        return result.size() == 1 ? result.get(0) : null;
    }

    @NotNull
    public final String getLibraryMavenId(@NotNull Path libraryXml) {
        String string;
        Intrinsics.checkNotNullParameter((Object)libraryXml, (String)"libraryXml");
        try {
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            Document document = documentBuilder.parse(libraryXml.toFile());
            Element element = document.getDocumentElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getDocumentElement(...)");
            Element libraryElement = this.getSingleChildElement(element, "library");
            Element propertiesElement = this.getSingleChildElement(libraryElement, "properties");
            String mavenId = propertiesElement.getAttribute("maven-id");
            Intrinsics.checkNotNull((Object)mavenId);
            if (!(!StringsKt.isBlank((CharSequence)mavenId))) {
                boolean bl = false;
                String string2 = "Invalid maven-id";
                throw new IllegalStateException(string2.toString());
            }
            string = mavenId;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to load maven-id from " + libraryXml + ": " + t.getMessage(), t);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Element getLibraryElement(@NotNull Element $this$getLibraryElement, @NotNull String libraryName, @NotNull Path iml) {
        Object v0;
        block5: {
            void $this$singleOrNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Element it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getLibraryElement, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            Intrinsics.checkNotNullParameter((Object)iml, (String)"iml");
            Element rootManager = this.getComponentElement($this$getLibraryElement, "NewModuleRootManager");
            Iterable iterable = this.getChildElements(rootManager, "orderEntry");
            boolean $i$f$filter = false;
            void var8_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Element)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAttribute("type"), (Object)"module-library")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(INSTANCE.getSingleChildElement(it, "library"));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Element it2 = (Element)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getAttribute("name"), (Object)libraryName)) continue;
                if (found$iv) {
                    v0 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        Element element = v0;
        if (element == null) {
            throw new IllegalStateException(("Library '" + libraryName + "' was not found in '" + iml + "'").toString());
        }
        Element library = element;
        return library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extractZip(@NotNull Path archiveFile, @NotNull Path target, boolean stripRoot) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Closeable closeable = (Closeable)new ZipFile.Builder().setSeekableByteChannel((SeekableByteChannel)FileChannel.open(archiveFile, new OpenOption[0])).get();
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Enumeration entries = zipFile.getEntries();
            INSTANCE.genericExtract(archiveFile, new ArchiveContent(entries, zipFile){
                final /* synthetic */ Enumeration<ZipArchiveEntry> $entries;
                final /* synthetic */ ZipFile $zipFile;
                {
                    this.$entries = $entries;
                    this.$zipFile = $zipFile;
                }

                public Entry getNextEntry() {
                    if (!this.$entries.hasMoreElements()) {
                        return null;
                    }
                    ZipArchiveEntry entry = this.$entries.nextElement();
                    return new Entry(entry, this.$zipFile){
                        final /* synthetic */ ZipArchiveEntry $entry;
                        final /* synthetic */ ZipFile $zipFile;
                        {
                            this.$entry = $entry;
                            this.$zipFile = $zipFile;
                        }

                        public Entry.Type getType() {
                            return this.$entry.isUnixSymlink() ? Entry.Type.SYMLINK : (this.$entry.isDirectory() ? Entry.Type.DIR : Entry.Type.FILE);
                        }

                        public String getName() {
                            String string = this.$entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            return string;
                        }

                        public boolean isExecutable() {
                            return (this.$entry.getUnixMode() & BuildDependenciesUtil.access$getOctal_0111$p()) != 0;
                        }

                        public String getLinkTarget() throws IOException {
                            return this.$zipFile.getUnixSymlink(this.$entry);
                        }

                        public InputStream getInputStream() throws IOException {
                            InputStream inputStream = this.$zipFile.getInputStream(this.$entry);
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                            return inputStream;
                        }
                    };
                }
            }, target, stripRoot);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void extractTarBz2(@NotNull Path archiveFile, @NotNull Path target, boolean stripRoot) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.extractTarBasedArchive(archiveFile, target, stripRoot, (Function1<? super InputStream, ? extends InputStream>)((Function1)BuildDependenciesUtil::extractTarBz2$lambda$0));
    }

    public final void extractTarGz(@NotNull Path archiveFile, @NotNull Path target, boolean stripRoot) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.extractTarBasedArchive(archiveFile, target, stripRoot, (Function1<? super InputStream, ? extends InputStream>)((Function1)BuildDependenciesUtil::extractTarGz$lambda$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void extractTarBasedArchive(Path archiveFile, Path target, boolean stripRoot, Function1<? super InputStream, ? extends InputStream> decompressor) {
        Closeable closeable = (Closeable)new TarArchiveInputStream((InputStream)decompressor.invoke((Object)new BufferedInputStream(Files.newInputStream(archiveFile, new OpenOption[0]))));
        Throwable throwable = null;
        try {
            TarArchiveInputStream archive = (TarArchiveInputStream)closeable;
            boolean bl = false;
            INSTANCE.genericExtract(archiveFile, new ArchiveContent(archive, archiveFile){
                final /* synthetic */ TarArchiveInputStream $archive;
                final /* synthetic */ Path $archiveFile;
                {
                    this.$archive = $archive;
                    this.$archiveFile = $archiveFile;
                }

                public Entry getNextEntry() throws IOException {
                    TarArchiveEntry tarArchiveEntry = this.$archive.getNextEntry();
                    if (tarArchiveEntry == null) {
                        return null;
                    }
                    TarArchiveEntry entry = tarArchiveEntry;
                    return new Entry(entry, this.$archiveFile, this.$archive){
                        final /* synthetic */ TarArchiveEntry $entry;
                        final /* synthetic */ Path $archiveFile;
                        final /* synthetic */ TarArchiveInputStream $archive;
                        {
                            this.$entry = $entry;
                            this.$archiveFile = $archiveFile;
                            this.$archive = $archive;
                        }

                        public Entry.Type getType() {
                            Entry.Type type;
                            if (this.$entry.isSymbolicLink()) {
                                type = Entry.Type.SYMLINK;
                            } else if (this.$entry.isDirectory()) {
                                type = Entry.Type.DIR;
                            } else if (this.$entry.isFile()) {
                                type = Entry.Type.FILE;
                            } else {
                                throw new IllegalStateException(this.$archiveFile + ": unknown entry type at '" + this.$entry.getName());
                            }
                            return type;
                        }

                        public String getName() {
                            String string = this.$entry.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            return string;
                        }

                        public boolean isExecutable() {
                            return (this.$entry.getMode() & BuildDependenciesUtil.access$getOctal_0111$p()) != 0;
                        }

                        public String getLinkTarget() {
                            return this.$entry.getLinkName();
                        }

                        public InputStream getInputStream() {
                            CloseShieldInputStream closeShieldInputStream = CloseShieldInputStream.wrap((InputStream)((InputStream)this.$archive));
                            Intrinsics.checkNotNullExpressionValue((Object)closeShieldInputStream, (String)"wrap(...)");
                            return (InputStream)closeShieldInputStream;
                        }
                    };
                }
            }, target, stripRoot);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void genericExtract(Path archiveFile, ArchiveContent archive, Path target, boolean stripRoot) {
        boolean isPosixFs = target.getFileSystem().supportedFileAttributeViews().contains("posix");
        Set createdDirs = new HashSet();
        EntryNameConverter converter = new EntryNameConverter(archiveFile, target, stripRoot);
        Path canonicalTarget = target.normalize();
        while (archive.getNextEntry() != null) {
            Path entryPath;
            Entry entry;
            Entry.Type type = entry.getType();
            if (converter.getOutputPath(entry.getName(), type == Entry.Type.DIR) == null) continue;
            if (type == Entry.Type.DIR) {
                Files.createDirectories(entryPath, new FileAttribute[0]);
                createdDirs.add(entryPath);
                continue;
            }
            Path parent = entryPath.getParent();
            Intrinsics.checkNotNull((Object)parent);
            if (createdDirs.add(parent)) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (type == Entry.Type.SYMLINK) {
                String string = entry.getLinkTarget();
                Intrinsics.checkNotNull((Object)string);
                Path relativeSymlinkTarget = Path.of(string, new String[0]);
                Path resolvedTarget = entryPath.resolveSibling(relativeSymlinkTarget).normalize();
                if (!resolvedTarget.startsWith(canonicalTarget) || Intrinsics.areEqual((Object)resolvedTarget, (Object)canonicalTarget)) {
                    LOG.fine(StringsKt.trimIndent((String)("\n  " + archiveFile + ": skipping symlink entry '" + entry.getName() + "' which points outside of archive extraction directory, which is forbidden.\n  resolved target = " + resolvedTarget + "\n  root = " + canonicalTarget + "\n  \n  ")));
                    continue;
                }
                if (isWindows) {
                    if (!Files.isRegularFile(resolvedTarget, new LinkOption[0])) continue;
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(resolvedTarget, entryPath, copyOptionArray);
                    continue;
                }
                Files.createSymbolicLink(entryPath, relativeSymlinkTarget, new FileAttribute[0]);
                continue;
            }
            if (type == Entry.Type.FILE) {
                Closeable closeable = entry.getInputStream();
                Throwable throwable = null;
                try {
                    InputStream fs = (InputStream)closeable;
                    boolean bl = false;
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    long l = Files.copy(fs, entryPath, copyOptionArray);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                if (!isPosixFs || !entry.isExecutable()) continue;
                Files.setPosixFilePermissions(entryPath, PosixFilePermissions.fromString("rwxr-xr-x"));
                continue;
            }
            throw new IllegalStateException("Unknown entry type: " + type);
        }
    }

    @NotNull
    public final String normalizeEntryName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        char[] cArray = new char[]{'/'};
        String normalized = StringsKt.trim((String)StringsKt.replace$default((String)name, (char)'\\', (char)'/', (boolean)false, (int)4, null), (char[])cArray);
        this.assertValidEntryName(normalized);
        return normalized;
    }

    private final void assertValidEntryName(String normalizedEntryName) {
        char[] cArray;
        if (!(!StringsKt.isBlank((CharSequence)normalizedEntryName))) {
            boolean $i$a$-check-BuildDependenciesUtil$assertValidEntryName$72 = false;
            String $i$a$-check-BuildDependenciesUtil$assertValidEntryName$72 = "Entry names should not be blank";
            throw new IllegalStateException($i$a$-check-BuildDependenciesUtil$assertValidEntryName$72.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)normalizedEntryName, (char)'\\', (boolean)false, (int)2, null))) {
            boolean $i$a$-check-BuildDependenciesUtil$assertValidEntryName$82 = false;
            String $i$a$-check-BuildDependenciesUtil$assertValidEntryName$82 = "Normalized entry names should not contain '\\'";
            throw new IllegalStateException($i$a$-check-BuildDependenciesUtil$assertValidEntryName$82.toString());
        }
        if (!(!StringsKt.startsWith$default((CharSequence)normalizedEntryName, (char)'/', (boolean)false, (int)2, null))) {
            boolean $i$a$-check-BuildDependenciesUtil$assertValidEntryName$92 = false;
            String $i$a$-check-BuildDependenciesUtil$assertValidEntryName$92 = "Normalized entry names should not start with '/': " + normalizedEntryName;
            throw new IllegalStateException($i$a$-check-BuildDependenciesUtil$assertValidEntryName$92.toString());
        }
        if (!(!StringsKt.endsWith$default((CharSequence)normalizedEntryName, (char)'/', (boolean)false, (int)2, null))) {
            boolean $i$a$-check-BuildDependenciesUtil$assertValidEntryName$102 = false;
            String $i$a$-check-BuildDependenciesUtil$assertValidEntryName$102 = "Normalized entry names should not end with '/': " + normalizedEntryName;
            throw new IllegalStateException($i$a$-check-BuildDependenciesUtil$assertValidEntryName$102.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)normalizedEntryName, (CharSequence)"//", (boolean)false, (int)2, null))) {
            boolean $i$a$-check-BuildDependenciesUtil$assertValidEntryName$112 = false;
            String $i$a$-check-BuildDependenciesUtil$assertValidEntryName$112 = "Normalized entry name should not contain '//': " + normalizedEntryName;
            throw new IllegalStateException($i$a$-check-BuildDependenciesUtil$assertValidEntryName$112.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)normalizedEntryName, (CharSequence)"..", (boolean)false, (int)2, null) || !StringsKt.split$default((CharSequence)normalizedEntryName, (char[])(cArray = new char[]{'/'}), (boolean)false, (int)0, (int)6, null).contains(".."))) {
            boolean bl = false;
            String string = "Invalid entry name: " + normalizedEntryName;
            throw new IllegalStateException(string.toString());
        }
    }

    public final void deleteFileOrFolder(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PathsKt.deleteRecursively((Path)file);
    }

    public final void cleanDirectory(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Files.createDirectories(directory, new FileAttribute[0]);
        Iterable $this$forEach$iv = PathsKt.listDirectoryEntries$default((Path)directory, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            INSTANCE.deleteFileOrFolder(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> loadPropertiesFile(@NotNull Path file) {
        void $this$mapTo$iv$iv;
        Object it;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = Files.newBufferedReader(file);
        Throwable throwable = null;
        try {
            it = (BufferedReader)closeable;
            boolean bl = false;
            Properties properties = new Properties();
            properties.load((Reader)it);
            it = properties;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Map $this$map$iv = (Map)it;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = entry.getKey();
            Object v = entry.getValue();
            Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)k;
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            collection.add(TuplesKt.to((Object)string, (Object)((String)v)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Path> listDirectory(@NotNull Path directory) {
        List list;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Closeable closeable = Files.newDirectoryStream(directory);
        Throwable throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            list = CollectionsKt.toList((Iterable)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    @NotNull
    public final String directoryContentToString(@NotNull Path directory, @Nullable String humanReadableName) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        List<Path> contents = this.listDirectory(directory);
        StringBuilder sb = new StringBuilder();
        sb.append("Directory contents of ");
        sb.append(directory.toAbsolutePath());
        sb.append(" (");
        sb.append(humanReadableName);
        sb.append("), ");
        sb.append(contents.size());
        sb.append(" entries:");
        for (Path p : contents) {
            sb.append(Files.isDirectory(p, new LinkOption[0]) ? "\nD " : "\nF ");
            sb.append(((Object)p.getFileName()).toString());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final InputStream extractTarBz2$lambda$0(InputStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (InputStream)new BZip2CompressorInputStream(it);
    }

    private static final InputStream extractTarGz$lambda$0(InputStream it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (InputStream)new GzipCompressorInputStream(it);
    }

    public static final /* synthetic */ int access$getOctal_0111$p() {
        return octal_0111;
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        isWindows = StringsKt.startsWith((String)string, (String)"windows", (boolean)true);
    }
}

