/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.impl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.build.impl.ExecutionResult;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\b\b\u0002\u0010\u000f\u001a\u00020\bJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007J\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007J\u0006\u0010\u0015\u001a\u00020\bJ!\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0019\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0019\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001cJ'\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0019\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/intellij/build/impl/Git;", "", "dir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "log", "", "", "commitCount", "", "formatLatestCommit", "format", "listTree", "Lorg/jetbrains/intellij/build/impl/Git$Entry;", "refSpec", "listStagingFiles", "rm", "", "files", "add", "currentCommitShortHash", "maybeExecute", "Lorg/jetbrains/intellij/build/impl/ExecutionResult;", "command", "", "([Ljava/lang/String;)Lorg/jetbrains/intellij/build/impl/ExecutionResult;", "executeWithNullSeparatedOutput", "([Ljava/lang/String;)Ljava/util/List;", "execute", "Entry", "intellij.platform.buildScripts.downloader"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Git.kt\norg/jetbrains/intellij/build/impl/Git\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1586#2:113\n1661#2,3:114\n1586#2:117\n1661#2,3:118\n1586#2:123\n1661#2,3:124\n777#2:130\n873#2,2:131\n37#3,2:121\n37#3,2:127\n1#4:129\n*S KotlinDebug\n*F\n+ 1 Git.kt\norg/jetbrains/intellij/build/impl/Git\n*L\n30#1:113\n30#1:114,3\n43#1:117\n43#1:118,3\n47#1:123\n47#1:124,3\n99#1:130\n99#1:131,2\n43#1:121,2\n47#1:127,2\n*E\n"})
public final class Git {
    @NotNull
    private final Path dir;

    public Git(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
    }

    @NotNull
    public final List<String> log(int commitCount) {
        String[] stringArray = new String[]{"git", "log", "-" + commitCount, "--pretty=tformat:%H"};
        return this.execute(stringArray);
    }

    @NotNull
    public final String formatLatestCommit(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String[] stringArray = new String[]{"git", "log", "--pretty=format:" + format, "-n", "1"};
        return CollectionsKt.joinToString$default((Iterable)this.execute(stringArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entry> listTree(@NotNull String refSpec) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)refSpec, (String)"refSpec");
        String[] stringArray = new String[]{"git", "ls-tree", "-z", "-r", refSpec};
        Iterable $this$map$iv = this.executeWithNullSeparatedOutput(stringArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String path;
            void line;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int tabIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)line), (char)'\t', (int)0, (boolean)false, (int)6, null);
            String string2 = line.substring(0, tabIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String mode = StringsKt.substringBefore$default((String)string2, (char)' ', null, (int)2, null);
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(tabIndex + 1), (String)"substring(...)");
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            collection.add(new Entry(PathsKt.getInvariantSeparatorsPathString((Path)path2), mode));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List listTree$default(Git git, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "HEAD";
        }
        return git.listTree(string);
    }

    @NotNull
    public final List<String> listStagingFiles() {
        String[] stringArray = new String[]{"git", "ls-files", "-z"};
        return this.executeWithNullSeparatedOutput(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void rm(@NotNull List<? extends Path> files) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)"git");
        spreadBuilder.add((Object)"rm");
        Iterable iterable = files;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        Git git = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        git.execute((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull List<? extends Path> files) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add((Object)"git");
        spreadBuilder.add((Object)"add");
        Iterable iterable = files;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        Git git = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        git.execute((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    @NotNull
    public final String currentCommitShortHash() {
        String repoDirectory = ((Object)this.dir.toAbsolutePath()).toString();
        String[] stringArray = new String[]{"git", "-c", "safe.directory=" + repoDirectory, "rev-parse", "--short=13", "HEAD"};
        List<String> lines = this.execute(stringArray);
        if (lines.size() != 1) {
            throw new IllegalStateException("Single line output is expected but got '" + lines + "'");
        }
        String hash = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first(lines)))).toString();
        if (hash.length() != 13) {
            throw new IllegalStateException("Short hash must be exactly 13 chars, but got '" + hash + "'");
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExecutionResult maybeExecute(String ... command) {
        int n3;
        Object it;
        Process process = new ProcessBuilder(Arrays.copyOf(command, command.length)).directory(this.dir.toFile()).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Object object = inputStream;
        Object object2 = Charsets.UTF_8;
        Object object3 = new InputStreamReader((InputStream)object, (Charset)object2);
        int n2 = 8192;
        object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n2);
        object2 = null;
        try {
            it = (BufferedReader)object;
            n3 = 0;
            it = ((BufferedReader)it).lines().map(arg_0 -> Git.maybeExecute$lambda$0$1(Git::maybeExecute$lambda$0$0, arg_0)).toList();
        }
        catch (Throwable n3) {
            object2 = n3;
            throw n3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Object output = it;
        if (!process.waitFor(1L, TimeUnit.MINUTES)) {
            process.destroyForcibly().waitFor();
            throw new IllegalStateException("Cannot execute '" + ArraysKt.joinToString$default((Object[])command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "': 1 minute timeout");
        }
        if (process.exitValue() != 0) {
            InputStream inputStream2 = process.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
            object = inputStream2;
            object2 = Charsets.UTF_8;
            it = new InputStreamReader((InputStream)object, (Charset)object2);
            n3 = 8192;
            object = it instanceof BufferedReader ? (BufferedReader)it : new BufferedReader((Reader)it, n3);
            object2 = null;
            try {
                it = (BufferedReader)object;
                boolean bl = false;
                object3 = TextStreamsKt.readText((Reader)((Reader)it));
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Collection collection = CollectionsKt.listOf((Object)object3);
            object = output;
            Intrinsics.checkNotNull((Object)object);
            output = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        }
        int n4 = process.exitValue();
        object = output;
        Intrinsics.checkNotNull((Object)object);
        return new ExecutionResult(n4, (List<String>)object);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> executeWithNullSeparatedOutput(String ... command) {
        void $this$filterTo$iv$iv;
        Process process = new ProcessBuilder(Arrays.copyOf(command, command.length)).redirectError(ProcessBuilder.Redirect.INHERIT).directory(this.dir.toFile()).start();
        process.getOutputStream().close();
        ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)memoryStream, (int)0, (int)2, null);
        if (!process.waitFor(5L, TimeUnit.MINUTES)) {
            process.destroyForcibly().waitFor();
            throw new IllegalStateException("Cannot execute " + ArraysKt.toList((Object[])command) + ": 5 minutes timeout");
        }
        int exitCode = process.exitValue();
        if (exitCode != 0) {
            throw new IllegalStateException("Cannot execute " + ArraysKt.toList((Object[])command) + ": exit code " + exitCode);
        }
        byte[] byArray = memoryStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        char[] cArray = new char[]{'\u0000'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)StringsKt.decodeToString((byte[])byArray), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> execute(String ... command) {
        ExecutionResult result = this.maybeExecute(Arrays.copyOf(command, command.length));
        if (result.exitCode != 0) {
            throw new IllegalStateException(ArraysKt.toList((Object[])command) + " failed with " + result + ".exitCode:\n" + CollectionsKt.joinToString$default((Iterable)result.output, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        return result.output;
    }

    private static final String maybeExecute$lambda$0$0(String line) {
        Intrinsics.checkNotNull((Object)line);
        return ((Object)StringsKt.trim((CharSequence)line)).toString();
    }

    private static final String maybeExecute$lambda$0$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/intellij/build/impl/Git$Entry;", "", "path", "", "mode", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getMode", "isExecutable", "", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.buildScripts.downloader"})
    public static final class Entry {
        @NotNull
        private final String path;
        @NotNull
        private final String mode;

        public Entry(@NotNull String path, @NotNull String mode) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            this.path = path;
            this.mode = mode;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getMode() {
            return this.mode;
        }

        public final boolean isExecutable() {
            return (Integer.parseInt(this.mode, CharsKt.checkRadix((int)8)) & 0x49) != 0;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.mode;
        }

        @NotNull
        public final Entry copy(@NotNull String path, @NotNull String mode) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            return new Entry(path, mode);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = entry.path;
            }
            if ((n & 2) != 0) {
                string2 = entry.mode;
            }
            return entry.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Entry(path=" + this.path + ", mode=" + this.mode + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.mode.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)entry.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mode, (Object)entry.mode);
        }
    }
}

