/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/intellij/build/dependencies/DotNetPackagesCredentials;", "", "<init>", "()V", "setupSystemCredentials", "", "loadFromEnvVars", "loadFromNuGetConfig", "intellij.platform.buildScripts.downloader"})
@SourceDebugExtension(value={"SMAP\nDotNetPackagesCredentials.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetPackagesCredentials.kt\norg/jetbrains/intellij/build/dependencies/DotNetPackagesCredentials\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,94:1\n739#2,9:95\n739#2,9:106\n37#3,2:104\n37#3,2:115\n*S KotlinDebug\n*F\n+ 1 DotNetPackagesCredentials.kt\norg/jetbrains/intellij/build/dependencies/DotNetPackagesCredentials\n*L\n38#1:95,9\n42#1:106,9\n38#1:104,2\n42#1:115,2\n*E\n"})
public final class DotNetPackagesCredentials {
    @NotNull
    public static final DotNetPackagesCredentials INSTANCE = new DotNetPackagesCredentials();

    private DotNetPackagesCredentials() {
    }

    @JvmStatic
    public static final boolean setupSystemCredentials() {
        try {
            if (INSTANCE.loadFromEnvVars()) {
                System.out.println((Object)"* DotNet packages credentials loaded from environment variable");
                return true;
            }
            if (INSTANCE.loadFromNuGetConfig()) {
                System.out.println((Object)"* DotNet packages credentials loaded from NuGet.Config");
                return true;
            }
        }
        catch (Throwable t) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            String string = writer.getBuffer().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            throw new IllegalStateException(string2.toString());
        }
        System.out.println((Object)"* DotNet packages credentials not loaded");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean loadFromEnvVars() {
        List list;
        String string = System.getenv("NuGetPackageSourceCredentials_dotnet_build_space");
        if (string == null) {
            return false;
        }
        String credentialsFromEnvVar = string;
        CharSequence charSequence = credentialsFromEnvVar;
        Regex regex = new Regex(";");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        boolean isUsernameSet = false;
        boolean isPasswordSet = false;
        for (String part : parts) {
            void $this$toTypedArray$iv2;
            List list2;
            Collection $this$dropLastWhile$iv2;
            Object object = part;
            Regex regex2 = new Regex("=");
            int n2 = 0;
            object = regex2.split((CharSequence)object, n2);
            boolean $i$f$dropLastWhile2 = false;
            if (!$this$dropLastWhile$iv2.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv2 = list2;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv2;
            String[] subParts = thisCollection$iv2.toArray(new String[0]);
            if (Intrinsics.areEqual((Object)"Username", (Object)subParts[0])) {
                System.setProperty("jps.auth.spaceUsername", subParts[1]);
                isUsernameSet = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)"Password", (Object)subParts[0])) continue;
            System.setProperty("jps.auth.spacePassword", subParts[1]);
            isPasswordSet = true;
        }
        return isUsernameSet && isPasswordSet;
    }

    private final boolean loadFromNuGetConfig() throws IOException, SAXException {
        File nuGetConfig;
        if (BuildDependenciesUtil.INSTANCE.isWindows()) {
            var3_1 = new String[]{"NuGet", "NuGet.Config"};
            var2_2 = Path.of(System.getenv("APPDATA"), var3_1).toFile();
            Intrinsics.checkNotNull((Object)var2_2);
            v0 = var2_2;
        } else {
            var3_1 = new String[]{".nuget", "NuGet", "NuGet.Config"};
            var2_2 = Path.of(System.getProperty("user.home"), var3_1).toFile();
            Intrinsics.checkNotNull((Object)var2_2);
            v0 = nuGetConfig = var2_2;
        }
        if (!nuGetConfig.exists()) {
            return false;
        }
        DocumentBuilder documentBuilder = BuildDependenciesUtil.INSTANCE.createDocumentBuilder();
        Document document = documentBuilder.parse(nuGetConfig);
        Element element = document.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getDocumentElement(...)");
        Element element2 = BuildDependenciesUtil.INSTANCE.tryGetSingleChildElement(element, "packageSourceCredentials");
        if (element2 == null) {
            return false;
        }
        Element packageSourceCredentialsElement = element2;
        Element element3 = BuildDependenciesUtil.INSTANCE.tryGetSingleChildElement(packageSourceCredentialsElement, "dotnet_build_space");
        if (element3 == null) {
            return false;
        }
        Element dotNetSpaceBuild = element3;
        boolean isUsernameSet = false;
        boolean isPasswordSet = false;
        int n = dotNetSpaceBuild.getChildNodes().getLength();
        for (int i = 0; i < n; ++i) {
            if (!(dotNetSpaceBuild.getChildNodes().item(i) instanceof Element)) continue;
            Node node = dotNetSpaceBuild.getChildNodes().item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element childElement = (Element)node;
            if (!Intrinsics.areEqual((Object)"add", (Object)childElement.getTagName())) continue;
            String key = childElement.getAttribute("key");
            String value = childElement.getAttribute("value");
            if (Intrinsics.areEqual((Object)"Username", (Object)key)) {
                System.setProperty("jps.auth.spaceUsername", value);
                isUsernameSet = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)"ClearTextPassword", (Object)key)) continue;
            System.setProperty("jps.auth.spacePassword", value);
            isPasswordSet = true;
        }
        return isUsernameSet && isPasswordSet;
    }
}

