/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.ui.AppIcon;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.RestService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0003J(\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/ide/InstallPluginService;", "Lorg/jetbrains/ide/RestService;", "<init>", "()V", "getServiceName", "", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "isAvailable", "", "()Z", "setAvailable", "(Z)V", "trustedPredefinedHosts", "", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "checkCompatibility", "", "pluginIds", "", "installPlugin", "productInfo", "writeIDEInfo", "", "out", "Ljava/io/OutputStream;", "isHostTrusted", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nInstallPluginService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallPluginService.kt\norg/jetbrains/ide/InstallPluginService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1563#2:150\n1634#2,3:151\n1563#2:154\n1634#2,3:155\n1869#2,2:158\n1563#2:160\n1634#2,3:161\n*S KotlinDebug\n*F\n+ 1 InstallPluginService.kt\norg/jetbrains/ide/InstallPluginService\n*L\n75#1:150\n75#1:151,3\n76#1:154\n76#1:155,3\n86#1:158,2\n100#1:160\n100#1:161,3\n*E\n"})
public final class InstallPluginService
extends RestService {
    private boolean isAvailable = true;
    @NotNull
    private final Set<String> trustedPredefinedHosts;

    public InstallPluginService() {
        Object[] objectArray = new String[]{"blog.jetbrains.com", "jetbrains.com", "lp.jetbrains.com", "lp.jetbrains.com.cn", "marketplace.jetbrains.com", "plugins.jetbrains.com", "www.jetbrains.com", "www.jetbrains.com.cn", "vision.jetbrains.dev", "internal.vision.jetbrains.dev"};
        this.trustedPredefinedHosts = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    protected String getServiceName() {
        return "installPlugin";
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return HttpRequestHandler.OriginCheckResult.ASK_CONFIRMATION;
    }

    public final boolean isAvailable() {
        return this.isAvailable;
    }

    public final void setAvailable(boolean bl) {
        this.isAvailable = bl;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        List list;
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String pluginId = RestService.Companion.getStringParameter("pluginId", urlDecoder);
        String passedPluginIds = RestService.Companion.getStringParameter("pluginIds", urlDecoder);
        String action = RestService.Companion.getStringParameter("action", urlDecoder);
        CharSequence charSequence = pluginId;
        if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && ((charSequence = (CharSequence)passedPluginIds) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return (String)((Object)this.productInfo(request, context));
        }
        Object object = pluginId;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            object = this.getGson().fromJson(passedPluginIds, new TypeToken<List<? extends String>>(){}.getType());
            Intrinsics.checkNotNull((Object)object);
            list = (List)object;
        } else {
            list = CollectionsKt.listOf((Object)pluginId);
        }
        List pluginIds2 = list;
        object = action;
        return Intrinsics.areEqual((Object)object, (Object)"checkCompatibility") ? (String)((Object)this.checkCompatibility(request, context, pluginIds2)) : (Intrinsics.areEqual((Object)object, (Object)"install") ? (String)((Object)this.installPlugin(request, context, pluginIds2)) : (String)((Object)this.productInfo(request, context)));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    private final Void checkCompatibility(FullHttpRequest request, ChannelHandlerContext context, List<String> pluginIds2) {
        PluginId it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        MarketplaceRequests marketplaceRequests = MarketplaceRequests.Companion.getInstance();
        Iterable iterable = pluginIds2;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PluginId.Companion.invoke((String)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void id;
            it = (PluginId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)id.getIdString(), (Object)(MarketplaceRequests.getLastCompatiblePluginUpdate$default((MarketplaceRequests)marketplaceRequests, (PluginId)id, null, null, (int)6, null) != null ? 1 : 0)));
        }
        List info = (List)destination$iv$iv;
        boolean bl = false;
        List compatibleUpdatesInfo = info.size() != 1 ? info : CollectionsKt.listOf((Object)TuplesKt.to((Object)"compatible", (Object)((Pair)info.get(0)).getSecond()));
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        JsonWriter writer = RestService.Companion.createJsonWriter((OutputStream)out);
        writer.beginObject();
        Iterable $this$forEach$iv = compatibleUpdatesInfo;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it2 = (Pair)element$iv;
            boolean bl2 = false;
            String pluginId = (String)it2.component1();
            boolean value = (Boolean)it2.component2();
            writer.name(pluginId).value(value);
        }
        writer.endObject();
        writer.close();
        RestService.Companion.send(out, (HttpRequest)request, context);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Void installPlugin(FullHttpRequest request, ChannelHandlerContext context, List<String> pluginIds2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = pluginIds2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PluginId.Companion.invoke((String)it));
        }
        List plugins = (List)destination$iv$iv;
        if (this.isAvailable) {
            this.isAvailable = false;
            Project project = RestService.Companion.getLastFocusedOrOpenedProject();
            if (project == null) {
                Project project2 = ProjectManager.getInstance().getDefaultProject();
                project = project2;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
            }
            Project effectiveProject = project;
            ApplicationManager.getApplication().invokeLater(() -> InstallPluginService.installPlugin$lambda$1(effectiveProject, plugins, this), effectiveProject.getDisposed());
        }
        RestService.Companion.sendOk(request, context);
        return null;
    }

    private final Void productInfo(FullHttpRequest request, ChannelHandlerContext context) {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        this.writeIDEInfo((OutputStream)out);
        RestService.Companion.send(out, (HttpRequest)request, context);
        return null;
    }

    private final void writeIDEInfo(OutputStream out) {
        JsonWriter writer = RestService.Companion.createJsonWriter(out);
        writer.beginObject();
        String appName = ApplicationInfo.getInstance().getFullApplicationName();
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber build = buildNumber;
        if (!PlatformUtils.isIdeaUltimate()) {
            String productName = ApplicationNamesInfo.getInstance().getProductName();
            String string = appName;
            Intrinsics.checkNotNull((Object)string);
            String string2 = productName + " (" + productName + ")";
            Intrinsics.checkNotNull((Object)productName);
            appName = StringsKt.replace$default((String)string, (String)string2, (String)productName, (boolean)false, (int)4, null);
            appName = StringsKt.removePrefix((String)appName, (CharSequence)"JetBrains ");
        }
        writer.name("name").value(appName);
        writer.name("buildNumber").value(build.asString());
        writer.endObject();
        writer.close();
    }

    @Override
    protected boolean isHostTrusted(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        return this.isHostInPredefinedHosts((HttpRequest)request, this.trustedPredefinedHosts, "idea.api.install.hosts.trusted") || super.isHostTrusted(request, urlDecoder);
    }

    private static final void installPlugin$lambda$1(Project $effectiveProject, List $plugins, InstallPluginService this$0) {
        AppIcon.getInstance().requestAttention($effectiveProject, true);
        PluginsAdvertiser.installAndEnable$default((Project)$effectiveProject, (Set)CollectionsKt.toSet((Iterable)$plugins), (boolean)true, (boolean)false, null, InstallPluginService::installPlugin$lambda$1$0, (int)24, null);
        this$0.isAvailable = true;
    }

    private static final void installPlugin$lambda$1$0() {
    }
}

