/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerBundle;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.CustomPortServerManagerBase;

@State(name="BuiltInServerOptions", category=SettingsCategory.TOOLS, exportable=true, storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
public final class BuiltInServerOptions
implements PersistentStateComponent<BuiltInServerOptions> {
    public static final int DEFAULT_PORT = 63342;
    @Attribute
    public int builtInServerPort = 63342;
    @Attribute
    public boolean builtInServerAvailableExternally = false;
    @Attribute
    public boolean allowUnsignedRequests = false;

    public static BuiltInServerOptions getInstance() {
        return (BuiltInServerOptions)ApplicationManager.getApplication().getService(BuiltInServerOptions.class);
    }

    @NotNull
    public BuiltInServerOptions getState() {
        BuiltInServerOptions builtInServerOptions = this;
        if (builtInServerOptions == null) {
            BuiltInServerOptions.$$$reportNull$$$0(0);
        }
        return builtInServerOptions;
    }

    public void loadState(@NotNull BuiltInServerOptions state) {
        if (state == null) {
            BuiltInServerOptions.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public int getEffectiveBuiltInServerPort() {
        MyCustomPortServerManager portServerManager = (MyCustomPortServerManager)((Object)CustomPortServerManager.EP_NAME.findExtensionOrFail(MyCustomPortServerManager.class));
        if (!portServerManager.isBound()) {
            return BuiltInServerManager.getInstance().getPort();
        }
        return this.builtInServerPort;
    }

    public static void onBuiltInServerPortChanged() {
        CustomPortServerManager.EP_NAME.forEachExtensionSafe(extension -> {
            if (extension instanceof CustomPortServerManagerBase) {
                CustomPortServerManagerBase baseManager = (CustomPortServerManagerBase)((Object)extension);
                baseManager.portChanged();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/builtInWebServer/BuiltInServerOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/builtInWebServer/BuiltInServerOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static final class MyCustomPortServerManager
    extends CustomPortServerManagerBase {
        public void cannotBind(@NotNull Exception e, int port) {
            if (e == null) {
                MyCustomPortServerManager.$$$reportNull$$$0(0);
            }
            String message = BuiltInServerBundle.message((String)"notification.content.cannot.start.built.in.http.server.on.custom.port", (Object[])new Object[]{port, ApplicationNamesInfo.getInstance().getFullProductName()});
            new Notification("Built-in Server", message, NotificationType.ERROR).notify(null);
        }

        public int getPort() {
            int port = BuiltInServerOptions.getInstance().builtInServerPort;
            return port == 63342 ? -1 : port;
        }

        public boolean isAvailableExternally() {
            return BuiltInServerOptions.getInstance().builtInServerAvailableExternally;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/builtInWebServer/BuiltInServerOptions$MyCustomPortServerManager", "cannotBind"));
        }
    }
}

