/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;
import org.jetbrains.ide.ToolboxInnerHandler;
import org.jetbrains.ide.ToolboxRestServiceKt;
import org.jetbrains.ide.ToolboxServiceHandler;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0014J\"\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/ide/ToolboxRestService;", "Lorg/jetbrains/ide/RestService;", "<init>", "()V", "getServiceName", "", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "isMethodSupported", "method", "Lio/netty/handler/codec/http/HttpMethod;", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nToolboxRestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxRestService.kt\norg/jetbrains/ide/ToolboxRestService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,235:1\n1#2:236\n19#3:237\n*S KotlinDebug\n*F\n+ 1 ToolboxRestService.kt\norg/jetbrains/ide/ToolboxRestService\n*L\n165#1:237\n*E\n"})
public final class ToolboxRestService
extends RestService {
    @Override
    @NotNull
    protected String getServiceName() {
        return "toolbox";
    }

    @Override
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        String requestUri = StringsKt.substringBefore$default((String)string, (char)'?', null, (int)2, null);
        ToolboxServiceHandler handler2 = ToolboxRestServiceKt.access$findToolboxHandlerByUri(requestUri);
        if (handler2 == null) {
            return false;
        }
        HttpMethod httpMethod = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"method(...)");
        return handler2.isMethodSupported(httpMethod) && super.isSupported(request);
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return Intrinsics.areEqual((Object)method, (Object)HttpMethod.POST) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.GET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Object $this$execute_u24lambda_u243;
        Object $this$execute_u24lambda_u242;
        Object $this$execute_u24lambda_u241;
        Object response;
        JsonReader requestJson;
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Channel channel = context.channel();
        String token = System.getProperty("toolbox.notification.token");
        if (token == null || !Intrinsics.areEqual((Object)request.headers().get("Authorization"), (Object)("toolbox " + token))) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Intrinsics.checkNotNull((Object)channel);
            RestService.Companion.sendStatus(httpResponseStatus, false, channel);
            return null;
        }
        try {
            long l;
            JsonObject jsonObject;
            JsonReader it;
            Closeable closeable = (Closeable)RestService.Companion.createJsonReader(request);
            Throwable throwable = null;
            try {
                it = (JsonReader)closeable;
                boolean bl = false;
                it = JsonParser.parseReader((JsonReader)it);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            requestJson = it;
            String string = urlDecoder.path();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path(...)");
            ToolboxServiceHandler handler2 = ToolboxRestServiceKt.access$findToolboxHandlerByUri(string);
            if (handler2 == null) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                Intrinsics.checkNotNull((Object)channel);
                RestService.Companion.sendStatus(httpResponseStatus, false, channel);
                return null;
            }
            Intrinsics.checkNotNull((Object)requestJson);
            ToolboxInnerHandler toolboxRequest = ToolboxRestServiceKt.access$wrapHandler(handler2, (JsonElement)requestJson);
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=utf-8");
            Responses.addCommonHeaders((HttpResponse)((HttpResponse)response));
            response.headers().remove((CharSequence)HttpHeaderNames.ACCEPT_RANGES);
            response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
            response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(Calendar.getInstance().getTimeInMillis()));
            channel.writeAndFlush(response).get();
            JsonReader $this$asSafely$iv = requestJson;
            boolean $i$f$asSafely = false;
            JsonReader jsonReader = $this$asSafely$iv;
            if (!(jsonReader instanceof JsonObject)) {
                jsonReader = null;
            }
            if ((jsonObject = (JsonObject)jsonReader) != null && (jsonObject = jsonObject.get("heartbeatMillis")) != null) {
                l = jsonObject.getAsLong();
            } else {
                String string2 = System.getProperty("toolbox.heartbeat.millis", "5000");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
                l = Long.parseLong(string2);
            }
            long heartbeatDelay = l;
            requestJson = TuplesKt.to((Object)toolboxRequest, (Object)heartbeatDelay);
        }
        catch (Throwable t) {
            RestService.LOG.warn("Failed to process parameters of " + request + ". " + t.getMessage(), t);
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_REQUEST");
            Intrinsics.checkNotNull((Object)channel);
            RestService.Companion.sendStatus(httpResponseStatus, false, channel);
            return null;
        }
        JsonReader jsonReader = requestJson;
        ToolboxInnerHandler toolboxRequest = (ToolboxInnerHandler)jsonReader.component1();
        long heartbeatDelay = ((Number)jsonReader.component2()).longValue();
        response = this;
        try {
            $this$execute_u24lambda_u241 = (ToolboxRestService)((Object)response);
            boolean bl = false;
            $this$execute_u24lambda_u241 = Result.constructor-impl((Object)channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true));
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        response = this;
        try {
            $this$execute_u24lambda_u242 = (ToolboxRestService)((Object)response);
            boolean bl = false;
            $this$execute_u24lambda_u242 = Result.constructor-impl((Object)channel.config().setOption(ChannelOption.SO_KEEPALIVE, (Object)true));
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        response = this;
        try {
            $this$execute_u24lambda_u243 = (ToolboxRestService)((Object)response);
            boolean bl = false;
            $this$execute_u24lambda_u243 = Result.constructor-impl((Object)channel.config().setOption(ChannelOption.SO_TIMEOUT, (Object)((int)heartbeatDelay * 2)));
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        Disposable disposable = Disposer.newDisposable((String)"toolbox-service-request");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable lifetime = disposable;
        ScheduledFuture heartbeat = context.executor().scheduleWithFixedDelay(() -> ToolboxRestService.execute$lambda$4(channel, lifetime), heartbeatDelay, heartbeatDelay, TimeUnit.MILLISECONDS);
        Disposer.register((Disposable)lifetime, () -> ToolboxRestService.execute$lambda$5(heartbeat));
        CompletableFuture callback = new CompletableFuture();
        AppExecutorUtil.getAppExecutorService().submit(() -> ToolboxRestService.execute$lambda$6(toolboxRequest, lifetime, callback));
        channel.closeFuture().addListener(arg_0 -> ToolboxRestService.execute$lambda$7(lifetime, arg_0));
        ((CompletableFuture)callback.exceptionally(ToolboxRestService::execute$lambda$8)).thenAcceptAsync(arg_0 -> ToolboxRestService.execute$lambda$10(arg_0 -> ToolboxRestService.execute$lambda$9(this, lifetime, heartbeat, channel, arg_0), arg_0), (Executor)AppExecutorUtil.getAppExecutorService());
        return null;
    }

    private static final void execute$lambda$4(Channel $channel, Disposable $lifetime) {
        try {
            $channel.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)" ", (Charset)Charsets.UTF_8)).get();
        }
        catch (Throwable t) {
            RestService.LOG.debug("Failed to write next heartbeat. " + t.getMessage(), t);
            Disposer.dispose((Disposable)$lifetime);
        }
    }

    private static final void execute$lambda$5(ScheduledFuture $heartbeat) {
        $heartbeat.cancel(false);
    }

    private static final void execute$lambda$6(ToolboxInnerHandler $toolboxRequest, Disposable $lifetime, CompletableFuture $callback) {
        $toolboxRequest.handleToolboxRequest($lifetime, (Function1<? super JsonElement, Unit>)((Function1)arg_0 -> ToolboxRestService.execute$lambda$6$0($callback, arg_0)));
    }

    private static final Unit execute$lambda$6$0(CompletableFuture $callback, JsonElement r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        $callback.complete(r);
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$7(Disposable $lifetime, Future it) {
        Disposer.dispose((Disposable)$lifetime);
    }

    private static final JsonElement execute$lambda$8(Throwable e) {
        JsonObject jsonObject;
        RestService.LOG.warn("The future completed with exception. " + e.getMessage(), e);
        JsonObject $this$execute_u24lambda_u248_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$execute_u24lambda_u248_u240.addProperty("status", "error");
        return (JsonElement)jsonObject;
    }

    private static final Unit execute$lambda$9(ToolboxRestService this$0, Disposable $lifetime, ScheduledFuture $heartbeat, Channel $channel, JsonElement json) {
        Object object;
        Object $this$execute_u24lambda_u249_u242;
        Object $this$execute_u24lambda_u249_u240;
        ToolboxRestService toolboxRestService = this$0;
        try {
            $this$execute_u24lambda_u249_u240 = toolboxRestService;
            boolean bl = false;
            $heartbeat.cancel(false);
            $this$execute_u24lambda_u249_u240 = Result.constructor-impl((Object)$heartbeat.await());
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u249_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        if (Disposer.isDisposed((Disposable)$lifetime)) {
            Object $this$execute_u24lambda_u249_u241;
            toolboxRestService = this$0;
            try {
                $this$execute_u24lambda_u249_u241 = toolboxRestService;
                boolean bl = false;
                $this$execute_u24lambda_u249_u241 = Result.constructor-impl((Object)$channel.close());
            }
            catch (Throwable bl) {
                $this$execute_u24lambda_u249_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            return Unit.INSTANCE;
        }
        toolboxRestService = this$0;
        try {
            $this$execute_u24lambda_u249_u242 = toolboxRestService;
            boolean bl = false;
            $this$execute_u24lambda_u249_u242 = Result.constructor-impl((Object)((Void)$channel.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)((RestService)((Object)$this$execute_u24lambda_u249_u242)).getGson().toJson(json), (Charset)Charsets.UTF_8)).get()));
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u249_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        toolboxRestService = this$0;
        try {
            ToolboxRestService $this$execute_u24lambda_u249_u243 = toolboxRestService;
            boolean bl = false;
            object = Result.constructor-impl((Object)((Void)$channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).get()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Disposer.dispose((Disposable)$lifetime);
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

