/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.NettyKt;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.AboutHttpServiceKt;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.RestService;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\f\u0010\n\u001a\u00020\u000b*\u00020\tH\u0002J\"\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/ide/AboutHttpService;", "Lorg/jetbrains/ide/RestService;", "<init>", "()V", "getServiceName", "", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "isJetBrainsAcademyPluginRelated", "", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.platform.builtInServer.impl"})
public final class AboutHttpService
extends RestService {
    @Override
    @NotNull
    protected String getServiceName() {
        return "about";
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpRequestHandler.OriginCheckResult originAllowed = super.isOriginAllowed(request);
        if (originAllowed == HttpRequestHandler.OriginCheckResult.FORBID && this.isJetBrainsAcademyPluginRelated(request)) {
            return HttpRequestHandler.OriginCheckResult.ALLOW;
        }
        return originAllowed;
    }

    private final boolean isJetBrainsAcademyPluginRelated(HttpRequest $this$isJetBrainsAcademyPluginRelated) {
        String string = NettyKt.getOrigin((HttpRequest)$this$isJetBrainsAcademyPluginRelated);
        if (string == null) {
            return false;
        }
        String origin = string;
        Regex hyperskillRegex = new Regex("https://([a-z0-9-]+\\.)*hyperskill\\.org$");
        Regex academyJetbrainsRegex = new Regex("https://([a-z0-9-.]+)\\.jetbrains\\.com$");
        return hyperskillRegex.matches((CharSequence)origin) || academyJetbrainsRegex.matches((CharSequence)origin);
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
        AboutHttpServiceKt.writeApplicationInfoJson((OutputStream)byteOut, urlDecoder, NettyKt.isLocalOrigin$default((HttpRequest)((HttpRequest)request), (boolean)false, (boolean)false, (int)3, null));
        RestService.Companion.send(byteOut, (HttpRequest)request, context);
        return null;
    }
}

