/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.SuitableRoot;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/WebServerRootsProvider;", "<init>", "()V", "resolve", "Lorg/jetbrains/builtInWebServer/PathInfo;", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "getPathInfo", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultWebServerRootsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultWebServerRootsProvider.kt\norg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1#2:270\n*E\n"})
final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project, @NotNull PathQuery pathQuery) {
        Object object;
        VirtualFile virtualFile;
        int index;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        Ref.ObjectRef effectivePath = new Ref.ObjectRef();
        effectivePath.element = path;
        if (PlatformUtils.isIntelliJ() && (index = StringsKt.indexOf$default((CharSequence)((CharSequence)effectivePath.element), (char)'/', (int)0, (boolean)false, (int)6, null)) > 0) {
            String string = (String)effectivePath.element;
            String string2 = project.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (!StringsKt.regionMatches((String)string, (int)0, (String)string2, (int)0, (int)index, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                String string3 = ((String)effectivePath.element).substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String moduleName = string3;
                Module module = (Module)ActionsKt.runReadAction(() -> DefaultWebServerRootsProvider.resolve$lambda$0(project, moduleName));
                if (module != null && !module.isDisposed()) {
                    PathInfo result;
                    PathInfo pathInfo;
                    Object object2;
                    FileResolver resolver;
                    block18: {
                        String string4 = ((String)effectivePath.element).substring(index + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        effectivePath.element = string4;
                        resolver = pathToFileManager.getResolver((String)effectivePath.element);
                        virtualFile = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])RootProvider.values()), arg_0 -> DefaultWebServerRootsProvider.resolve$lambda$1(effectivePath, module, resolver, moduleName, pathQuery, arg_0));
                        Iterator iterator = virtualFile.iterator();
                        while (iterator.hasNext()) {
                            Object it = object = iterator.next();
                            boolean bl = false;
                            if (!(it != null)) continue;
                            object2 = object;
                            break block18;
                        }
                        object2 = null;
                    }
                    if ((pathInfo = (PathInfo)object2) == null) {
                        pathInfo = DefaultWebServerRootsProviderKt.access$findInModuleLibraries((String)effectivePath.element, module, resolver, pathQuery);
                    }
                    if ((result = pathInfo) != null) {
                        return result;
                    }
                }
            }
        }
        FileResolver resolver = pathToFileManager.getResolver((String)effectivePath.element);
        Module[] modules = (Module[])ActionsKt.runReadAction(() -> DefaultWebServerRootsProvider.resolve$lambda$3(project));
        if (pathQuery.getUseVfs()) {
            void var8_12;
            String string;
            String string5;
            int it = StringsKt.indexOf$default((CharSequence)path, (String)"/", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            if (it > 0) {
                String string6 = path.substring(0, it);
                string5 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            } else {
                string5 = null;
            }
            if ((string = string5) == null && ((CharSequence)path).length() > 0 && !StringsKt.contains$default((CharSequence)path, (char)'.', (boolean)false, (int)2, null)) {
                String string7 = path;
            }
            if (var8_12 != null) {
                Object object3 = pathToFileManager.getParentToSuitableRoot$intellij_platform_builtInServer_impl().get((Object)var8_12);
                Intrinsics.checkNotNull((Object)object3);
                for (SuitableRoot suitableRoot : (List)object3) {
                    VirtualFile file = suitableRoot.component1();
                    String moduleQualifier = suitableRoot.component2();
                    virtualFile = file.findFileByRelativePath(path);
                    if (virtualFile == null) continue;
                    VirtualFile it2 = virtualFile;
                    boolean bl2 = false;
                    return new PathInfo(null, it2, file, moduleQualifier, false, false, 48, null);
                }
            }
        } else {
            for (RootProvider rootProvider : RootProvider.values()) {
                int n = modules.length;
                for (int i = 0; i < n; ++i) {
                    Module module = modules[i];
                    if (module.isDisposed() || (object = DefaultWebServerRootsProviderKt.access$findByRelativePath(path, rootProvider.getRoots(ProjectUtil.getRootManager((Module)module)), resolver, null, pathQuery)) == null) continue;
                    PathInfo it = object;
                    boolean bl = false;
                    it.setModuleName(DefaultWebServerRootsProviderKt.getModuleNameQualifier(project, module));
                    return it;
                }
            }
        }
        if (!pathQuery.getSearchInLibs()) {
            return null;
        }
        Boolean bl = (Boolean)pathToFileManager.getPathToExistShortTermCache$intellij_platform_builtInServer_impl().getIfPresent((Object)"config.json");
        if (bl == null || bl.booleanValue()) {
            PathInfo result = DefaultWebServerRootsProvider.resolve$findByConfigJson(modules, resolver, pathQuery, project);
            pathToFileManager.getPathToExistShortTermCache$intellij_platform_builtInServer_impl().put((Object)"config.json", (Object)(result != null ? 1 : 0));
            if (result != null) {
                return result;
            }
        }
        return DefaultWebServerRootsProviderKt.access$findInLibraries(project, (String)effectivePath.element, resolver, pathQuery);
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (PathInfo)ActionsKt.runReadAction(() -> DefaultWebServerRootsProvider.getPathInfo$lambda$0(project, file));
    }

    private static final Module resolve$lambda$0(Project $project, String $moduleName) {
        return ModuleManager.Companion.getInstance($project).findModuleByName($moduleName);
    }

    private static final PathInfo resolve$lambda$1(Ref.ObjectRef $effectivePath, Module $module, FileResolver $resolver, String $moduleName, PathQuery $pathQuery, RootProvider it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return DefaultWebServerRootsProviderKt.access$findByRelativePath((String)$effectivePath.element, it.getRoots(ProjectUtil.getRootManager((Module)$module)), $resolver, $moduleName, $pathQuery);
    }

    private static final Module[] resolve$lambda$3(Project $project) {
        return ModuleManager.Companion.getInstance($project).getModules();
    }

    private static final PathInfo resolve$findByConfigJson(Module[] modules, FileResolver resolver, PathQuery $pathQuery, Project $project) {
        for (RootProvider rootProvider : RootProvider.values()) {
            for (Module module : modules) {
                if (module.isDisposed()) continue;
                for (VirtualFile root : rootProvider.getRoots(ProjectUtil.getRootManager((Module)module))) {
                    PathInfo pathInfo;
                    if (FileResolver.resolve$default(resolver, "config.json", root, null, false, $pathQuery, 12, null) == null || (pathInfo = FileResolver.resolve$default(resolver, "index.html", root, null, false, $pathQuery, 12, null)) == null) continue;
                    PathInfo it = pathInfo;
                    boolean bl = false;
                    it.setModuleName(DefaultWebServerRootsProviderKt.getModuleNameQualifier($project, module));
                    return it;
                }
            }
        }
        return null;
    }

    private static final PathInfo getPathInfo$lambda$0(Project $project, VirtualFile $file) {
        PathInfo pathInfo;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        boolean isInLibrary = fileIndex.isInLibrary($file);
        if (!(fileIndex.isInContent($file) || isInLibrary || fileIndex.isExcluded($file))) {
            pathInfo = Intrinsics.areEqual((Object)$file.getFileSystem(), (Object)JarFileSystem.getInstance()) ? DefaultWebServerRootsProviderKt.access$getInfoForDocJar($file, $project) : null;
        } else {
            VirtualFile root = fileIndex.getSourceRootForFile($file);
            boolean isRootNameOptionalInPath = false;
            if (root == null) {
                isRootNameOptionalInPath = false;
                root = fileIndex.getContentRootForFile($file, false);
                if (root == null && (root = fileIndex.getClassRootForFile($file)) == null) {
                    return null;
                }
            } else {
                isRootNameOptionalInPath = !isInLibrary;
            }
            Module module = fileIndex.getModuleForFile($file, false);
            if (isInLibrary && module == null) {
                for (OrderEntry entry : fileIndex.getOrderEntriesForFile($file)) {
                    if (!OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)entry)) continue;
                    module = entry.getOwnerModule();
                    break;
                }
            }
            pathInfo = new PathInfo(null, $file, root, DefaultWebServerRootsProviderKt.getModuleNameQualifier($project, module), isInLibrary, isRootNameOptionalInPath);
        }
        return pathInfo;
    }
}

