/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentFactory;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.DummyFormattingModel;
import com.intellij.formatting.ExternalFormattingModelBuilderImpl;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.formatting.FormattingModelFactory;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentFactory;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingFactory;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.VirtualFormattingImplKt;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapFactory;
import com.intellij.formatting.WrapImpl;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.engine.ExpandableIndent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FormatterImpl
extends FormatterEx
implements IndentFactory,
WrapFactory,
AlignmentFactory,
SpacingFactory,
FormattingModelFactory {
    private static final Logger LOG = Logger.getInstance(FormatterImpl.class);
    private final AtomicReference<FormattingProgressCallback> myProgressTask = new AtomicReference();
    private final IndentImpl NONE_INDENT = new IndentImpl(Indent.Type.NONE, false, false);
    private final IndentImpl myAbsoluteNoneIndent = new IndentImpl(Indent.Type.NONE, true, false);
    private final IndentImpl myLabelIndent = new IndentImpl(Indent.Type.LABEL, false, false);
    private final IndentImpl myContinuationIndentRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION, false, true);
    private final IndentImpl myContinuationIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION, false, false);
    private final IndentImpl myContinuationWithoutFirstIndentRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION_WITHOUT_FIRST, false, true);
    private final IndentImpl myContinuationWithoutFirstIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION_WITHOUT_FIRST, false, false);
    private final IndentImpl myAbsoluteLabelIndent = new IndentImpl(Indent.Type.LABEL, true, false);
    private final IndentImpl myNormalIndentRelativeToDirectParent = new IndentImpl(Indent.Type.NORMAL, false, true);
    private final IndentImpl myNormalIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.NORMAL, false, false);
    private final SpacingImpl myReadOnlySpacing = new SpacingImpl(0, 0, 0, true, false, true, 0, false, 0);
    private final Map<SpacingImpl, SpacingImpl> ourSharedProperties = new HashMap<SpacingImpl, SpacingImpl>();
    private final SpacingImpl ourSharedSpacing = new SpacingImpl(-1, -1, -1, false, false, false, -1, false, 0);

    public Alignment createAlignment(boolean applyToNonFirstBlocksOnLine, @NotNull Alignment.Anchor anchor) {
        if (anchor == null) {
            FormatterImpl.$$$reportNull$$$0(0);
        }
        return new AlignmentImpl(applyToNonFirstBlocksOnLine, anchor);
    }

    public Alignment createChildAlignment(Alignment base) {
        AlignmentImpl result = new AlignmentImpl();
        result.setParent(base);
        return result;
    }

    public Indent getNormalIndent(boolean relative) {
        return relative ? this.myNormalIndentRelativeToDirectParent : this.myNormalIndentNotRelativeToDirectParent;
    }

    public Indent getNoneIndent() {
        return this.NONE_INDENT;
    }

    @Override
    public void setProgressTask(@NotNull FormattingProgressCallback progressIndicator) {
        if (progressIndicator == null) {
            FormatterImpl.$$$reportNull$$$0(1);
        }
        if (!FormatterUtil.isFormatterCalledExplicitly()) {
            return;
        }
        this.myProgressTask.set(progressIndicator);
    }

    @Override
    public int getSpacingForBlockAtOffset(FormattingModel model, int offset) {
        int minSpaces;
        SpacingImpl spacing = FormatterImpl.getSpacingBeforeBlockAtOffset(model, offset);
        if (spacing != null && (minSpaces = spacing.getMinSpaces()) >= 0) {
            return minSpaces;
        }
        return -1;
    }

    @Override
    public int getMinLineFeedsBeforeBlockAtOffset(FormattingModel model, int offset) {
        int minLineFeeds;
        SpacingImpl spacing = FormatterImpl.getSpacingBeforeBlockAtOffset(model, offset);
        if (spacing != null && (minLineFeeds = spacing.getMinLineFeeds()) >= 0) {
            return minLineFeeds;
        }
        return -1;
    }

    private static SpacingImpl getSpacingBeforeBlockAtOffset(FormattingModel model, int offset) {
        Couple<Block> blockWithParent = FormatterImpl.getBlockAtOffset(null, model.getRootBlock(), offset);
        if (blockWithParent != null) {
            Block prevBlock;
            Block parentBlock = (Block)blockWithParent.first;
            Block targetBlock = (Block)blockWithParent.second;
            if (parentBlock != null && targetBlock != null && (prevBlock = FormatterImpl.findPreviousSibling(parentBlock, targetBlock)) != null) {
                return (SpacingImpl)parentBlock.getSpacing(prevBlock, targetBlock);
            }
        }
        return null;
    }

    @Nullable
    private static Couple<Block> getBlockAtOffset(@Nullable Block parent, @NotNull Block block, int offset) {
        if (block == null) {
            FormatterImpl.$$$reportNull$$$0(2);
        }
        TextRange textRange = block.getTextRange();
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        if (startOffset == offset) {
            return Couple.of((Object)parent, (Object)block);
        }
        if (startOffset > offset || endOffset < offset || block.isLeaf()) {
            return null;
        }
        for (Block subBlock : block.getSubBlocks()) {
            Couple<Block> result = FormatterImpl.getBlockAtOffset(block, subBlock, offset);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static Block findPreviousSibling(@NotNull Block parent, Block block) {
        if (parent == null) {
            FormatterImpl.$$$reportNull$$$0(3);
        }
        Block result = null;
        for (Block subBlock : parent.getSubBlocks()) {
            if (subBlock == block) {
                return result;
            }
            result = subBlock;
        }
        return null;
    }

    public Wrap createWrap(WrapType type, boolean wrapFirstElement) {
        return new WrapImpl(type, wrapFirstElement);
    }

    public Wrap createChildWrap(Wrap parentWrap, WrapType wrapType, boolean wrapFirstElement) {
        WrapImpl result = new WrapImpl(wrapType, wrapFirstElement);
        result.registerParent((WrapImpl)parentWrap);
        return result;
    }

    @NotNull
    public Spacing createSpacing(int minOffset, int maxOffset, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        SpacingImpl spacingImpl = this.getSpacingImpl(minOffset, maxOffset, minLineFeeds, false, false, keepLineBreaks, keepBlankLines, false, 0);
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(4);
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing getReadOnlySpacing() {
        SpacingImpl spacingImpl = this.myReadOnlySpacing;
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(5);
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull TextRange dependencyRange, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependencyRange == null) {
            FormatterImpl.$$$reportNull$$$0(6);
        }
        if (rule == null) {
            FormatterImpl.$$$reportNull$$$0(7);
        }
        return new DependantSpacingImpl(minSpaces, maxSpaces, dependencyRange, keepLineBreaks, keepBlankLines, rule);
    }

    @NotNull
    public Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull List<TextRange> dependentRegion, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependentRegion == null) {
            FormatterImpl.$$$reportNull$$$0(8);
        }
        if (rule == null) {
            FormatterImpl.$$$reportNull$$$0(9);
        }
        return new DependantSpacingImpl(minSpaces, maxSpaces, dependentRegion, keepLineBreaks, keepBlankLines, rule);
    }

    @NotNull
    private FormattingProgressCallback getProgressCallback() {
        FormattingProgressCallback result = this.myProgressTask.get();
        FormattingProgressCallback formattingProgressCallback = result == null ? FormattingProgressCallback.EMPTY : result;
        if (formattingProgressCallback == null) {
            FormatterImpl.$$$reportNull$$$0(10);
        }
        return formattingProgressCallback;
    }

    @Override
    public void format(final FormattingModel model, final CodeStyleSettings settings, final CommonCodeStyleSettings.IndentOptions indentOptions, final FormatTextRanges affectedRanges) throws IncorrectOperationException {
        try {
            FormatterImpl.validateModel(model);
            MyFormattingTask task = new MyFormattingTask(){

                @Override
                @NotNull
                protected FormatProcessor buildProcessor() {
                    FormatProcessor.FormatOptions options = new FormatProcessor.FormatOptions(settings, indentOptions, affectedRanges);
                    FormatProcessor processor = new FormatProcessor(model.getDocumentModel(), model.getRootBlock(), options, FormatterImpl.this.getProgressCallback());
                    processor.format(model, true);
                    FormatProcessor formatProcessor = processor;
                    if (formatProcessor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return formatProcessor;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl$1", "buildProcessor"));
                }
            };
            this.execute(task);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)((Object)e));
        }
    }

    public void formatWithoutModifications(final FormattingDocumentModel model, final Block rootBlock, final CodeStyleSettings settings, final CommonCodeStyleSettings.IndentOptions indentOptions, final TextRange affectedRange) throws IncorrectOperationException {
        MyFormattingTask task = new MyFormattingTask(this){

            @Override
            @NotNull
            protected FormatProcessor buildProcessor() {
                FormatProcessor result = new FormatProcessor(model, rootBlock, settings, indentOptions, new FormatTextRanges(affectedRange, true), FormattingProgressCallback.EMPTY);
                result.formatWithoutRealModifications();
                FormatProcessor formatProcessor = result;
                if (formatProcessor == null) {
                    2.$$$reportNull$$$0(0);
                }
                return formatProcessor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl$2", "buildProcessor"));
            }
        };
        this.execute(task);
    }

    private void execute(@NotNull SequentialTask task) {
        if (task == null) {
            FormatterImpl.$$$reportNull$$$0(11);
        }
        Application application = ApplicationManager.getApplication();
        FormattingProgressCallback progressTask = this.myProgressTask.getAndSet(null);
        if (progressTask == null || !application.isDispatchThread() || application.isUnitTestMode()) {
            task.prepare();
            while (!task.isDone()) {
                task.iteration();
            }
        } else {
            progressTask.setTask(task);
            if (progressTask instanceof SequentialModalProgressTask) {
                ProgressManager.getInstance().run((Task)((SequentialModalProgressTask)progressTask));
            }
        }
    }

    @Override
    public void adjustLineIndentsForRange(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, TextRange rangeToAdjust) {
        try {
            FormatterImpl.validateModel(model);
            FormattingDocumentModel documentModel = model.getDocumentModel();
            Block block = model.getRootBlock();
            FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(documentModel, block, settings, indentOptions, new FormatTextRanges(rangeToAdjust, true));
            for (LeafBlockWrapper tokenBlock = processor.getFirstTokenBlock(); tokenBlock != null; tokenBlock = tokenBlock.getNextBlock()) {
                WhiteSpace whiteSpace = tokenBlock.getWhiteSpace();
                whiteSpace.setLineFeedsAreReadOnly(true);
                if (whiteSpace.containsLineFeeds()) continue;
                whiteSpace.setIsReadOnly(true);
            }
            processor.formatWithoutRealModifications();
            processor.performModifications(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)((Object)e));
        }
    }

    @Override
    public void formatAroundRange(FormattingModel model, CodeStyleSettings settings, PsiFile file, TextRange textRange) {
        try {
            FormatterImpl.validateModel(model);
            FormattingDocumentModel documentModel = model.getDocumentModel();
            Block block = model.getRootBlock();
            FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(documentModel, block, settings, settings.getIndentOptionsByFile(file), null);
            for (LeafBlockWrapper tokenBlock = processor.getFirstTokenBlock(); tokenBlock != null; tokenBlock = tokenBlock.getNextBlock()) {
                WhiteSpace whiteSpace = tokenBlock.getWhiteSpace();
                if (whiteSpace.getEndOffset() < textRange.getStartOffset() || whiteSpace.getEndOffset() > textRange.getEndOffset() + 1) {
                    whiteSpace.setIsReadOnly(true);
                    continue;
                }
                if (whiteSpace.getStartOffset() <= textRange.getStartOffset() || whiteSpace.getEndOffset() >= textRange.getEndOffset()) continue;
                if (whiteSpace.containsLineFeeds()) {
                    whiteSpace.setLineFeedsAreReadOnly(true);
                    continue;
                }
                whiteSpace.setIsReadOnly(true);
            }
            processor.formatWithoutRealModifications();
            processor.performModifications(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)((Object)e));
        }
    }

    @Override
    public int adjustLineIndent(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, int offset, TextRange affectedRange) throws IncorrectOperationException {
        try {
            FormatterImpl.validateModel(model);
            if (model instanceof PsiBasedFormattingModel) {
                ((PsiBasedFormattingModel)model).canModifyAllWhiteSpaces();
            }
            FormattingDocumentModel documentModel = model.getDocumentModel();
            FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(model, settings, indentOptions, affectedRange, offset);
            LeafBlockWrapper blockAfterOffset = processor.getBlockRangesMap().getBlockAtOrAfter(offset);
            if (blockAfterOffset != null && blockAfterOffset.contains(offset)) {
                return offset;
            }
            WhiteSpace whiteSpace = blockAfterOffset != null ? blockAfterOffset.getWhiteSpace() : processor.getLastWhiteSpace();
            return FormatterImpl.adjustLineIndent(offset, documentModel, processor, indentOptions, model, whiteSpace, blockAfterOffset != null ? blockAfterOffset.getNode() : null);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)((Object)e));
            return offset;
        }
    }

    @NotNull
    private static FormatProcessor buildProcessorAndWrapBlocks(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable TextRange affectedRange, int offset) {
        FormattingDocumentModel docModel = model.getDocumentModel();
        Block rootBlock = model.getRootBlock();
        FormatProcessor formatProcessor = FormatterImpl.buildProcessorAndWrapBlocks(docModel, rootBlock, settings, indentOptions, new FormatTextRanges(affectedRange, true), offset);
        if (formatProcessor == null) {
            FormatterImpl.$$$reportNull$$$0(12);
        }
        return formatProcessor;
    }

    private static FormatProcessor buildProcessorAndWrapBlocks(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges) {
        return FormatterImpl.buildProcessorAndWrapBlocks(docModel, rootBlock, settings, indentOptions, affectedRanges, -1);
    }

    private static FormatProcessor buildProcessorAndWrapBlocks(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges, int interestingOffset) {
        FormatProcessor.FormatOptions options = new FormatProcessor.FormatOptions(settings, indentOptions, affectedRanges, interestingOffset);
        FormatProcessor processor = new FormatProcessor(docModel, rootBlock, options, FormattingProgressCallback.EMPTY);
        while (!processor.iteration()) {
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int adjustLineIndent(int offset, FormattingDocumentModel documentModel, FormatProcessor processor, CommonCodeStyleSettings.IndentOptions indentOptions, FormattingModel model, WhiteSpace whiteSpace, ASTNode nodeAfter) {
        IndentInfo indent;
        boolean wsContainsCaret = whiteSpace.getStartOffset() <= offset && offset < whiteSpace.getEndOffset();
        int lineStartOffset = FormatterImpl.getLineStartOffset(offset, whiteSpace, documentModel);
        String newWS = whiteSpace.generateWhiteSpace(indentOptions, lineStartOffset, indent = FormatterImpl.calcIndent(offset, documentModel, processor, whiteSpace)).toString();
        if (!whiteSpace.equalsToString(newWS)) {
            try {
                if (model instanceof FormattingModelEx) {
                    ((FormattingModelEx)model).replaceWhiteSpace(whiteSpace.getTextRange(), nodeAfter, newWS);
                } else {
                    model.replaceWhiteSpace(whiteSpace.getTextRange(), newWS);
                }
            }
            finally {
                model.commitChanges();
            }
        }
        int defaultOffset = offset - whiteSpace.getLength() + newWS.length();
        if (wsContainsCaret) {
            int ws = whiteSpace.getStartOffset() + CharArrayUtil.shiftForward((CharSequence)newWS, (int)Math.max(0, lineStartOffset - whiteSpace.getStartOffset()), (String)" \t");
            return Math.max(defaultOffset, ws);
        }
        return defaultOffset;
    }

    private static boolean hasContentAfterLineBreak(FormattingDocumentModel documentModel, int offset, WhiteSpace whiteSpace) {
        return documentModel.getLineNumber(offset) == documentModel.getLineNumber(whiteSpace.getEndOffset()) && documentModel.getTextLength() != whiteSpace.getEndOffset();
    }

    @Override
    public String getLineIndent(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, int offset, TextRange affectedRange) {
        FormattingDocumentModel documentModel = model.getDocumentModel();
        Block block = model.getRootBlock();
        if (block.getTextRange().isEmpty()) {
            return null;
        }
        FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(model, settings, indentOptions, affectedRange, offset);
        return FormatterImpl.generateIndentWhitespace(processor, indentOptions, documentModel, offset);
    }

    @Override
    @NotNull
    public List<String> getLineIndents(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions) {
        FormattingDocumentModel documentModel = model.getDocumentModel();
        Block block = model.getRootBlock();
        if (block.getTextRange().isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                FormatterImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        Document document = model.getDocumentModel().getDocument();
        FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(model, settings, indentOptions, block.getTextRange(), 0);
        int lines = document.getLineCount();
        ArrayList<String> indents = new ArrayList<String>(lines);
        for (int i = 0; i < lines; ++i) {
            int offset = document.getLineStartOffset(i);
            String indent = FormatterImpl.generateIndentWhitespace(processor, indentOptions, documentModel, offset);
            indents.add(indent != null ? indent : "");
        }
        ArrayList<String> arrayList = indents;
        if (arrayList == null) {
            FormatterImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    private static String generateIndentWhitespace(FormatProcessor processor, CommonCodeStyleSettings.IndentOptions indentOptions, FormattingDocumentModel documentModel, int offset) {
        WhiteSpace whiteSpace = FormatterImpl.getWhiteSpaceAtOffset(offset, processor);
        if (whiteSpace != null) {
            IndentInfo indent = FormatterImpl.calcIndent(offset, documentModel, processor, whiteSpace);
            return indent.generateNewWhiteSpace(indentOptions);
        }
        return null;
    }

    @Nullable
    private static WhiteSpace getWhiteSpaceAtOffset(int offset, @NotNull FormatProcessor formatProcessor) {
        LeafBlockWrapper blockAfterOffset;
        if (formatProcessor == null) {
            FormatterImpl.$$$reportNull$$$0(15);
        }
        if ((blockAfterOffset = formatProcessor.getBlockRangesMap().getBlockAtOrAfter(offset)) != null) {
            if (!blockAfterOffset.contains(offset)) {
                return blockAfterOffset.getWhiteSpace();
            }
        } else if (offset >= formatProcessor.getLastWhiteSpace().getStartOffset()) {
            return formatProcessor.getLastWhiteSpace();
        }
        return null;
    }

    private static IndentInfo calcIndent(int offset, FormattingDocumentModel documentModel, FormatProcessor processor, WhiteSpace whiteSpace) {
        IndentInfo indent;
        processor.setAllWhiteSpacesAreReadOnly();
        whiteSpace.setLineFeedsAreReadOnly(true);
        if (FormatterImpl.hasContentAfterLineBreak(documentModel, offset, whiteSpace)) {
            whiteSpace.setReadOnly(false);
            processor.formatWithoutRealModifications();
            indent = new IndentInfo(0, whiteSpace.getIndentOffset(), whiteSpace.getSpaces());
        } else {
            indent = processor.getIndentAt(offset);
        }
        return indent;
    }

    public static String getText(FormattingDocumentModel documentModel) {
        return FormatterImpl.getCharSequence(documentModel).toString();
    }

    private static CharSequence getCharSequence(FormattingDocumentModel documentModel) {
        return documentModel.getText(new TextRange(0, documentModel.getTextLength()));
    }

    private static int getLineStartOffset(int offset, WhiteSpace whiteSpace, FormattingDocumentModel documentModel) {
        int lineStartOffset = offset;
        CharSequence text = FormatterImpl.getCharSequence(documentModel);
        lineStartOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)lineStartOffset, (String)" \t\n");
        if (lineStartOffset > whiteSpace.getStartOffset()) {
            int prevEnd;
            if (lineStartOffset >= text.length()) {
                lineStartOffset = text.length() - 1;
            }
            int wsStart = whiteSpace.getStartOffset();
            if (text.charAt(lineStartOffset) == '\n' && wsStart <= (prevEnd = documentModel.getLineStartOffset(documentModel.getLineNumber(lineStartOffset - 1))) && documentModel.getText(new TextRange(prevEnd, lineStartOffset)).toString().trim().isEmpty()) {
                --lineStartOffset;
            }
            if ((lineStartOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)lineStartOffset, (String)"\t ")) < 0) {
                lineStartOffset = 0;
            }
            if (lineStartOffset != offset && text.charAt(lineStartOffset) == '\n') {
                ++lineStartOffset;
            }
        }
        return lineStartOffset;
    }

    public FormattingModel createFormattingModelForPsiFile(@NotNull PsiFile file, @NotNull Block rootBlock, CodeStyleSettings settings) {
        if (file == null) {
            FormatterImpl.$$$reportNull$$$0(16);
        }
        if (rootBlock == null) {
            FormatterImpl.$$$reportNull$$$0(17);
        }
        return new PsiBasedFormattingModel(file, rootBlock, FormattingDocumentModelImpl.createOn(file));
    }

    public Indent getSpaceIndent(int spaces, boolean relative) {
        return this.getIndent(Indent.Type.SPACES, spaces, relative, false);
    }

    public Indent getIndent(@NotNull Indent.Type type, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        if (type == null) {
            FormatterImpl.$$$reportNull$$$0(18);
        }
        return this.getIndent(type, 0, relativeToDirectParent, enforceIndentToChildren);
    }

    public Indent getSmartIndent(@NotNull Indent.Type type) {
        if (type == null) {
            FormatterImpl.$$$reportNull$$$0(19);
        }
        return new ExpandableIndent(type);
    }

    public Indent getSmartIndent(@NotNull Indent.Type type, boolean relativeToDirectParent) {
        if (type == null) {
            FormatterImpl.$$$reportNull$$$0(20);
        }
        return new ExpandableIndent(type, relativeToDirectParent);
    }

    public Indent getIndent(@NotNull Indent.Type type, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        if (type == null) {
            FormatterImpl.$$$reportNull$$$0(21);
        }
        return new IndentImpl(type, false, spaces, relativeToDirectParent, enforceIndentToChildren);
    }

    @ApiStatus.Experimental
    public Indent getIndentEnforcedToChildrenToBeRelativeToMe(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Indent.Type type, int spaces) {
        if (type == null) {
            FormatterImpl.$$$reportNull$$$0(22);
        }
        return new IndentImpl(type, false, spaces, false, true, true);
    }

    public Indent getAbsoluteLabelIndent() {
        return this.myAbsoluteLabelIndent;
    }

    @NotNull
    public Spacing createSafeSpacing(boolean shouldKeepLineBreaks, int keepBlankLines) {
        SpacingImpl spacingImpl = this.getSpacingImpl(0, 0, 0, false, true, shouldKeepLineBreaks, keepBlankLines, false, 0);
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(23);
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing createKeepingFirstColumnSpacing(int minSpace, int maxSpace, boolean keepLineBreaks, int keepBlankLines) {
        SpacingImpl spacingImpl = this.getSpacingImpl(minSpace, maxSpace, -1, false, false, keepLineBreaks, keepBlankLines, true, 0);
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(24);
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines, int prefLineFeeds) {
        SpacingImpl spacingImpl = this.getSpacingImpl(minSpaces, maxSpaces, minLineFeeds, false, false, keepLineBreaks, keepBlankLines, false, prefLineFeeds);
        if (spacingImpl == null) {
            FormatterImpl.$$$reportNull$$$0(25);
        }
        return spacingImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpacingImpl getSpacingImpl(int minSpaces, int maxSpaces, int minLineFeeds, boolean readOnly, boolean safe, boolean keepLineBreaksFlag, int keepLineBreaks, boolean keepFirstColumn, int prefLineFeeds) {
        SpacingImpl spacingImpl = this.ourSharedSpacing;
        synchronized (spacingImpl) {
            this.ourSharedSpacing.init(minSpaces, maxSpaces, minLineFeeds, readOnly, safe, keepLineBreaksFlag, keepLineBreaks, keepFirstColumn, prefLineFeeds);
            SpacingImpl spacing = this.ourSharedProperties.get((Object)this.ourSharedSpacing);
            if (spacing == null) {
                spacing = new SpacingImpl(minSpaces, maxSpaces, minLineFeeds, readOnly, safe, keepLineBreaksFlag, keepLineBreaks, keepFirstColumn, prefLineFeeds);
                this.ourSharedProperties.put(spacing, spacing);
            }
            return spacing;
        }
    }

    public Indent getAbsoluteNoneIndent() {
        return this.myAbsoluteNoneIndent;
    }

    public Indent getLabelIndent() {
        return this.myLabelIndent;
    }

    public Indent getContinuationIndent(boolean relative) {
        return relative ? this.myContinuationIndentRelativeToDirectParent : this.myContinuationIndentNotRelativeToDirectParent;
    }

    public Indent getContinuationWithoutFirstIndent(boolean relative) {
        return relative ? this.myContinuationWithoutFirstIndentRelativeToDirectParent : this.myContinuationWithoutFirstIndentNotRelativeToDirectParent;
    }

    private static void validateModel(FormattingModel model) throws FormattingModelInconsistencyException {
        FormattingDocumentModel documentModel = model.getDocumentModel();
        Document document = documentModel.getDocument();
        Block rootBlock = model.getRootBlock();
        if (rootBlock instanceof ASTBlock) {
            PsiElement rootElement = ((ASTBlock)rootBlock).getNode().getPsi();
            if (!rootElement.isValid()) {
                throw new FormattingModelInconsistencyException("Invalid root block PSI element");
            }
            PsiFile file = rootElement.getContainingFile();
            Project project = file.getProject();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            if (documentManager.isUncommited(document)) {
                throw new FormattingModelInconsistencyException("Uncommitted document");
            }
            if (document.getTextLength() != file.getTextLength()) {
                Attachment documentAttachment = new Attachment("document.txt", document.getText());
                Attachment fileAttachment = new Attachment("file.txt", file.getText());
                throw new FormattingModelInconsistencyException("Document length " + document.getTextLength() + " doesn't match PSI file length " + file.getTextLength() + ", language: " + String.valueOf(file.getLanguage()), new Attachment[]{documentAttachment, fileAttachment});
            }
        }
    }

    @NotNull
    public FormattingModelBuilder createExternalFormattingModelBuilder(@NotNull PsiFile psiFile, @Nullable FormattingModelBuilder langBuilder) {
        if (psiFile == null) {
            FormatterImpl.$$$reportNull$$$0(26);
        }
        return new ExternalFormattingModelBuilderImpl(langBuilder);
    }

    @NotNull
    public FormattingModel createDummyFormattingModel(@NotNull PsiElement element) {
        if (element == null) {
            FormatterImpl.$$$reportNull$$$0(27);
        }
        return new DummyFormattingModel(element);
    }

    public boolean isEligibleForVirtualFormatting(@NotNull PsiElement context) {
        if (context == null) {
            FormatterImpl.$$$reportNull$$$0(28);
        }
        return VirtualFormattingImplKt.isEligibleForVirtualFormatting(context);
    }

    @Nullable
    public FormattingModelBuilder wrapForVirtualFormatting(@NotNull PsiElement context, @Nullable FormattingModelBuilder originalModel) {
        if (context == null) {
            FormatterImpl.$$$reportNull$$$0(29);
        }
        return VirtualFormattingImplKt.wrapForVirtualFormatting(context, originalModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 12, 13, 14, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/FormatterImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyRange";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentRegion";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatProcessor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootBlock";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/FormatterImpl";
                break;
            }
            case 4: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpacing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlySpacing";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressCallback";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildProcessorAndWrapBlocks";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineIndents";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createSafeSpacing";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeepingFirstColumnSpacing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAlignment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProgressTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBlockAtOffset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPreviousSibling";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDependentLFSpacing";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getWhiteSpaceAtOffset";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingModelForPsiFile";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSmartIndent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getIndentEnforcedToChildrenToBeRelativeToMe";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createExternalFormattingModelBuilder";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFormattingModel";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isEligibleForVirtualFormatting";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "wrapForVirtualFormatting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 12, 13, 14, 23, 24, 25 -> new IllegalStateException(string);
        };
    }

    private static final class FormattingModelInconsistencyException
    extends RuntimeExceptionWithAttachments {
        FormattingModelInconsistencyException(String message) {
            super(message, new Attachment[0]);
        }

        FormattingModelInconsistencyException(String message, Attachment[] attachments) {
            super(message, attachments);
        }
    }

    private static abstract class MyFormattingTask
    implements SequentialTask {
        private FormatProcessor myProcessor;
        private boolean myDone;

        private MyFormattingTask() {
        }

        public void prepare() {
            this.myProcessor = this.buildProcessor();
        }

        public boolean isDone() {
            return this.myDone;
        }

        public boolean iteration() {
            this.myDone = this.myProcessor.iteration();
            return this.myDone;
        }

        public void stop() {
            this.myProcessor.stopSequentialProcessing();
            this.myDone = true;
        }

        @NotNull
        protected abstract FormatProcessor buildProcessor();
    }
}

