/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FormattingServiceUtil {
    private static final Logger LOG = Logger.getInstance(FormattingServiceUtil.class);

    private FormattingServiceUtil() {
    }

    @NotNull
    public static FormattingService findService(@NotNull PsiFile file, boolean isExplicit, boolean isCompleteFile) {
        FormattingService formattingService;
        if (file == null) {
            FormattingServiceUtil.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((formattingService = (FormattingService)ContainerUtil.find((Iterable)FormattingService.EP_NAME.getExtensionList(), s -> !(!isExplicit && !s.getFeatures().contains(FormattingService.Feature.AD_HOC_FORMATTING) || !isCompleteFile && !s.getFeatures().contains(FormattingService.Feature.FORMAT_FRAGMENTS) || !s.canFormat(file)))) != null, (Object)("At least 1 formatting service which can handle PsiFile " + file.getName() + " should be registered."));
        FormattingService formattingService2 = formattingService;
        if (formattingService2 == null) {
            FormattingServiceUtil.$$$reportNull$$$0(1);
        }
        return formattingService2;
    }

    @Nullable
    public static FormattingService findService(Class<? extends FormattingService> serviceClass) {
        return (FormattingService)ContainerUtil.find((Iterable)FormattingService.EP_NAME.getExtensionList(), s -> s.getClass().equals(serviceClass));
    }

    @NotNull
    public static FormattingService findImportsOptimizingService(@NotNull PsiFile file) {
        FormattingService importsOptimizer;
        if (file == null) {
            FormattingServiceUtil.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((importsOptimizer = (FormattingService)ContainerUtil.find((Iterable)FormattingService.EP_NAME.getExtensionList(), s -> s.getFeatures().contains(FormattingService.Feature.OPTIMIZE_IMPORTS) && s.canFormat(file))) != null, (Object)("At least 1 formatting service which can optimize imports in PsiFile " + file.getName() + " should be registered."));
        FormattingService formattingService = importsOptimizer;
        if (formattingService == null) {
            FormattingServiceUtil.$$$reportNull$$$0(3);
        }
        return formattingService;
    }

    private static List<FormattingService> getChainedServices(@NotNull FormattingService formattingService) {
        if (formattingService == null) {
            FormattingServiceUtil.$$$reportNull$$$0(4);
        }
        ArrayList<FormattingService> serviceList = new ArrayList<FormattingService>();
        FormattingService currService = formattingService;
        while (currService != null && !serviceList.contains(currService)) {
            serviceList.add(0, currService);
            currService = (FormattingService)ObjectUtils.doIfNotNull((Object)currService.runAfter(), serviceClass -> FormattingServiceUtil.findService(serviceClass));
        }
        return serviceList;
    }

    @NotNull
    public static PsiElement formatElement(@NotNull PsiElement element, boolean canChangeWhiteSpaceOnly) {
        if (element == null) {
            FormattingServiceUtil.$$$reportNull$$$0(5);
        }
        PsiFile file = element.getContainingFile();
        PsiElement contextElement = element;
        FormattingService mainService = FormattingServiceUtil.findService(file, true, element.getTextRange().equals((Object)file.getTextRange()));
        for (FormattingService service : FormattingServiceUtil.getChainedServices(mainService)) {
            contextElement = service.formatElement(contextElement, canChangeWhiteSpaceOnly);
        }
        PsiElement psiElement = contextElement;
        if (psiElement == null) {
            FormattingServiceUtil.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement formatElement(@NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly) {
        if (element == null) {
            FormattingServiceUtil.$$$reportNull$$$0(7);
        }
        if (range == null) {
            FormattingServiceUtil.$$$reportNull$$$0(8);
        }
        return FormattingServiceUtil.formatElement(element, range, canChangeWhiteSpacesOnly, false);
    }

    public static void asyncFormatElement(@NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhitespaceOnly) {
        if (element == null) {
            FormattingServiceUtil.$$$reportNull$$$0(9);
        }
        if (range == null) {
            FormattingServiceUtil.$$$reportNull$$$0(10);
        }
        FormattingServiceUtil.formatElement(element, range, canChangeWhitespaceOnly, true);
    }

    @NotNull
    private static PsiElement formatElement(@NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly, boolean forceAsync) {
        if (element == null) {
            FormattingServiceUtil.$$$reportNull$$$0(11);
        }
        if (range == null) {
            FormattingServiceUtil.$$$reportNull$$$0(12);
        }
        PsiFile file = element.getContainingFile();
        boolean isFullRange = range.equals((Object)file.getTextRange());
        PsiElement contextElement = element;
        FormattingService mainService = FormattingServiceUtil.findService(element.getContainingFile(), true, isFullRange);
        if (isFullRange) {
            for (FormattingService service : FormattingServiceUtil.getChainedServices(mainService)) {
                contextElement = FormattingServiceUtil.formatElement(service, contextElement, range, canChangeWhiteSpacesOnly, forceAsync);
            }
            PsiElement psiElement = contextElement;
            if (psiElement == null) {
                FormattingServiceUtil.$$$reportNull$$$0(13);
            }
            return psiElement;
        }
        PsiElement psiElement = FormattingServiceUtil.formatElement(mainService, element, range, canChangeWhiteSpacesOnly, forceAsync);
        if (psiElement == null) {
            FormattingServiceUtil.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    private static PsiElement formatElement(@NotNull FormattingService service, @NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly, boolean forceAsync) {
        if (service == null) {
            FormattingServiceUtil.$$$reportNull$$$0(15);
        }
        if (element == null) {
            FormattingServiceUtil.$$$reportNull$$$0(16);
        }
        if (range == null) {
            FormattingServiceUtil.$$$reportNull$$$0(17);
        }
        if (forceAsync && service instanceof CoreFormattingService) {
            ((CoreFormattingService)service).asyncFormatElement(element, range, canChangeWhiteSpacesOnly);
            return element;
        }
        return service.formatElement(element, range, canChangeWhiteSpacesOnly);
    }

    public static void formatRanges(@NotNull PsiFile file, @NotNull FormatTextRanges ranges, boolean canChangeWhiteSpaceOnly, boolean isFullRange) {
        if (file == null) {
            FormattingServiceUtil.$$$reportNull$$$0(18);
        }
        if (ranges == null) {
            FormattingServiceUtil.$$$reportNull$$$0(19);
        }
        FormattingService mainService = FormattingServiceUtil.findService(file, true, isFullRange);
        if (isFullRange) {
            for (FormattingService service : FormattingServiceUtil.getChainedServices(mainService)) {
                service.formatRanges(file, (FormattingRangesInfo)ranges, canChangeWhiteSpaceOnly, false);
            }
        } else {
            mainService.formatRanges(file, (FormattingRangesInfo)ranges, canChangeWhiteSpaceOnly, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/service/FormattingServiceUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingService";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/service/FormattingServiceUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportsOptimizingService";
                break;
            }
            case 6: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findImportsOptimizingService";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChainedServices";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "asyncFormatElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 13, 14 -> new IllegalStateException(string);
        };
    }
}

