/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeFormattingData;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/formatting/service/AsyncFormattingService;", "", "<init>", "()V", "asyncFormatElement", "", "service", "Lcom/intellij/formatting/service/FormattingService;", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "canChangeWhitespaceOnly", "", "Companion", "intellij.platform.codeStyle.impl"})
@ApiStatus.Internal
public class AsyncFormattingService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void asyncFormatElement(@NotNull FormattingService service, @NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhitespaceOnly) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        PsiFile file = element.getContainingFile();
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ReadAction.nonBlocking(() -> AsyncFormattingService.asyncFormatElement$lambda$0(file, range)).withDocumentsCommitted(project2).expireWhen(() -> AsyncFormattingService.asyncFormatElement$lambda$1(project2, file)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> AsyncFormattingService.asyncFormatElement$lambda$3(arg_0 -> AsyncFormattingService.asyncFormatElement$lambda$2(service, element, range, canChangeWhitespaceOnly, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static final CodeFormattingData asyncFormatElement$lambda$0(PsiFile $file, TextRange $range) {
        return CodeFormattingData.prepare($file, CollectionsKt.listOf((Object)$range));
    }

    private static final boolean asyncFormatElement$lambda$1(Project $project, PsiFile $file) {
        return $project.isDisposed() || !$file.isValid();
    }

    private static final Unit asyncFormatElement$lambda$2(FormattingService $service, PsiElement $element, TextRange $range, boolean $canChangeWhitespaceOnly, CodeFormattingData codeFormattingData) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> AsyncFormattingService.asyncFormatElement$lambda$2$0($service, $element, $range, $canChangeWhitespaceOnly));
        return Unit.INSTANCE;
    }

    private static final void asyncFormatElement$lambda$2$0(FormattingService $service, PsiElement $element, TextRange $range, boolean $canChangeWhitespaceOnly) {
        WriteAction.run(() -> AsyncFormattingService.asyncFormatElement$lambda$2$0$0($service, $element, $range, $canChangeWhitespaceOnly));
    }

    private static final void asyncFormatElement$lambda$2$0$0(FormattingService $service, PsiElement $element, TextRange $range, boolean $canChangeWhitespaceOnly) {
        $service.formatElement($element, $range, $canChangeWhitespaceOnly);
    }

    private static final void asyncFormatElement$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final AsyncFormattingService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/formatting/service/AsyncFormattingService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/formatting/service/AsyncFormattingService;", "intellij.platform.codeStyle.impl"})
    @SourceDebugExtension(value={"SMAP\nAsyncFormatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncFormatService.kt\ncom/intellij/formatting/service/AsyncFormattingService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,40:1\n30#2,2:41\n*S KotlinDebug\n*F\n+ 1 AsyncFormatService.kt\ncom/intellij/formatting/service/AsyncFormattingService$Companion\n*L\n21#1:41,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AsyncFormattingService getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<AsyncFormattingService> serviceClass$iv = AsyncFormattingService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AsyncFormattingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

